/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.api.toolbar;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jd.controlling.downloadcontroller.DownloadController;
import jd.controlling.downloadcontroller.DownloadSession;
import jd.controlling.downloadcontroller.DownloadWatchDog;
import jd.controlling.linkchecker.LinkChecker;
import jd.controlling.linkchecker.LinkCheckerHandler;
import jd.controlling.linkcollector.LinkCollectingJob;
import jd.controlling.linkcollector.LinkCollector;
import jd.controlling.linkcollector.LinkOrigin;
import jd.controlling.linkcrawler.BrokenCrawlerHandler;
import jd.controlling.linkcrawler.CrawledLink;
import jd.controlling.linkcrawler.LinkCrawler;
import jd.controlling.linkcrawler.LinkCrawlerFilter;
import jd.controlling.linkcrawler.LinkCrawlerHandler;
import jd.controlling.linkcrawler.UnknownCrawledLinkHandler;
import jd.controlling.packagecontroller.AbstractPackageChildrenNodeFilter;
import jd.plugins.DownloadLink;
import jd.plugins.PluginForHost;
import org.appwork.exceptions.WTFException;
import org.appwork.remoteapi.RemoteAPIRequest;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.config.MinTimeWeakReference;
import org.appwork.utils.speedmeter.SpeedMeterInterface;
import org.appwork.utils.swing.dialog.AbstractDialog;
import org.appwork.utils.swing.dialog.Dialog;
import org.appwork.utils.swing.dialog.DialogCanceledException;
import org.appwork.utils.swing.dialog.DialogClosedException;
import org.jdownloader.api.toolbar.JDownloaderToolBarAPI;
import org.jdownloader.api.toolbar.LinkCheckLink;
import org.jdownloader.api.toolbar.LinkCheckResult;
import org.jdownloader.api.toolbar.LinkStatus;
import org.jdownloader.api.toolbar.specialurls.YouTubeSpecialUrlHandling;
import org.jdownloader.gui.views.linkgrabber.actions.AddLinksProgress;
import org.jdownloader.myjdownloader.client.json.JsonMap;
import org.jdownloader.plugins.FinalLinkState;
import org.jdownloader.settings.staticreferences.CFG_GENERAL;
import org.jdownloader.settings.staticreferences.CFG_GUI;
import org.jdownloader.settings.staticreferences.CFG_RECONNECT;
import org.jdownloader.updatev2.UpdateController;

public class JDownloaderToolBarAPIImpl
implements JDownloaderToolBarAPI {
    private HashMap<String, MinTimeWeakReference<ChunkedDom>> domSessions = new HashMap();
    private HashMap<String, CheckedDom> checkSessions = new HashMap();

    @Override
    public synchronized Object getStatus() {
        JsonMap ret = new JsonMap();
        int running = DownloadWatchDog.getInstance().getActiveDownloads();
        ret.put("state", DownloadWatchDog.getInstance().getStateMachine().getState().getLabel());
        ret.put("running", running > 0);
        ret.put("limit", CFG_GENERAL.DOWNLOAD_SPEED_LIMIT_ENABLED.isEnabled());
        if (CFG_GENERAL.DOWNLOAD_SPEED_LIMIT_ENABLED.isEnabled()) {
            ret.put("limitspeed", CFG_GENERAL.DOWNLOAD_SPEED_LIMIT.getValue());
        } else {
            ret.put("limitspeed", 0);
        }
        ret.put("reconnect", CFG_RECONNECT.AUTO_RECONNECT_ENABLED.isEnabled());
        ret.put("clipboard", CFG_GUI.CLIPBOARD_MONITORED.isEnabled());
        ret.put("stopafter", DownloadWatchDog.getInstance().getSession().isStopMarkSet());
        ret.put("premium", CFG_GENERAL.USE_AVAILABLE_ACCOUNTS.isEnabled());
        if (running == 0) {
            ret.put("speed", 0);
        } else {
            ret.put("speed", DownloadWatchDog.getInstance().getDownloadSpeedManager().getSpeedMeter().getValue(SpeedMeterInterface.Resolution.SECONDS));
        }
        ret.put("pause", DownloadWatchDog.getInstance().isPaused());
        List<DownloadLink> calc_progress = DownloadController.getInstance().getChildrenByFilter(new AbstractPackageChildrenNodeFilter<DownloadLink>(){

            @Override
            public int returnMaxResults() {
                return 0;
            }

            @Override
            public boolean acceptNode(DownloadLink node) {
                if (!node.isEnabled()) {
                    return false;
                }
                return !FinalLinkState.CheckFailed(node.getFinalLinkState());
            }
        });
        long todo = 0L;
        long done = 0L;
        for (DownloadLink link : calc_progress) {
            done += Math.max(0L, link.getView().getBytesLoaded());
            todo += Math.max(0L, link.getView().getBytesTotalEstimated());
        }
        ret.put("download_current", done);
        ret.put("download_complete", todo);
        return ret;
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public boolean startDownloads() {
        DownloadWatchDog.getInstance().startDownloads();
        return true;
    }

    @Override
    public boolean stopDownloads() {
        DownloadWatchDog.getInstance().stopDownloads();
        return true;
    }

    @Override
    public boolean toggleDownloadSpeedLimit() {
        CFG_GENERAL.DOWNLOAD_SPEED_LIMIT_ENABLED.toggle();
        return CFG_GENERAL.DOWNLOAD_SPEED_LIMIT_ENABLED.isEnabled();
    }

    @Override
    public boolean toggleClipboardMonitoring() {
        boolean b = CFG_GUI.CLIPBOARD_MONITORED.isEnabled();
        CFG_GUI.CLIPBOARD_MONITORED.setValue((Object)(!b ? 1 : 0));
        return !b;
    }

    @Override
    public boolean toggleAutomaticReconnect() {
        CFG_RECONNECT.AUTO_RECONNECT_ENABLED.toggle();
        return CFG_RECONNECT.AUTO_RECONNECT_ENABLED.isEnabled();
    }

    @Override
    public boolean toggleStopAfterCurrentDownload() {
        DownloadSession session = DownloadWatchDog.getInstance().getSession();
        session.toggleStopMark((Object)DownloadSession.STOPMARK.RANDOM);
        return session.isStopMarkSet();
    }

    @Override
    public boolean togglePremium() {
        CFG_GENERAL.USE_AVAILABLE_ACCOUNTS.toggle();
        return CFG_GENERAL.USE_AVAILABLE_ACCOUNTS.isEnabled();
    }

    @Override
    public Object addLinksFromDOM(RemoteAPIRequest request) {
        JsonMap ret = new JsonMap();
        try {
            ChunkedDom chunkedDom = this.getCompleteDOM(request);
            if (chunkedDom != null) {
                final String url = chunkedDom.URL;
                final String dom = chunkedDom.completeDOM;
                CrawledLink link = new CrawledLink(chunkedDom.URL);
                link.setUnknownHandler(new UnknownCrawledLinkHandler(){

                    @Override
                    public void unhandledCrawledLink(CrawledLink link, LinkCrawler lc) {
                        JDownloaderToolBarAPIImpl.this.addCompleteDom(url, dom, link);
                    }
                });
                link.setBrokenCrawlerHandler(new BrokenCrawlerHandler(){

                    @Override
                    public void brokenCrawler(CrawledLink link, LinkCrawler lc) {
                        JDownloaderToolBarAPIImpl.this.addCompleteDom(url, dom, link);
                    }
                });
                ArrayList<CrawledLink> links = new ArrayList<CrawledLink>();
                links.add(link);
                LinkCollector.getInstance().addCrawlerJob(links, null);
            }
            ret.put("status", true);
            ret.put("msg", null);
        }
        catch (Throwable e) {
            e.printStackTrace();
            ret.put("status", false);
            ret.put("msg", e.getMessage());
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChunkedDom getCompleteDOM(RemoteAPIRequest request) throws IOException {
        String index = request.getParameterbyKey("index");
        String data = request.getParameterbyKey("data");
        String sessionID = request.getParameterbyKey("sessionid");
        String url = request.getParameterbyKey("url");
        boolean lastChunk = "true".equalsIgnoreCase(request.getParameterbyKey("lastchunk"));
        boolean debug = "true".equalsIgnoreCase(request.getParameterbyKey("debug"));
        if (url == null) {
            throw new WTFException("No url?!");
        }
        if (sessionID == null) {
            throw new WTFException("No sessionID?!");
        }
        if (index == null) {
            throw new WTFException("No index?!");
        }
        if (data == null) {
            throw new WTFException("No data?!");
        }
        if (debug) {
            System.out.println("Session: " + sessionID + "|Chunk: " + index + "|URL: " + url + "|Data: " + data.length() + "|LastChunk: " + lastChunk);
        }
        ChunkedDom chunkedDom = null;
        HashMap<String, MinTimeWeakReference<ChunkedDom>> hashMap = this.domSessions;
        synchronized (hashMap) {
            Iterator<String> it = this.domSessions.keySet().iterator();
            while (it.hasNext()) {
                String sID = it.next();
                MinTimeWeakReference<ChunkedDom> tmp = this.domSessions.get(sID);
                if (tmp == null || tmp.superget() != null) continue;
                it.remove();
            }
            MinTimeWeakReference<ChunkedDom> tmp = this.domSessions.get(sessionID);
            if (tmp != null) {
                chunkedDom = (ChunkedDom)tmp.get();
            }
            if (chunkedDom == null) {
                chunkedDom = new ChunkedDom();
                chunkedDom.URL = url;
                this.domSessions.put(sessionID, (MinTimeWeakReference<ChunkedDom>)new MinTimeWeakReference((Object)chunkedDom, 60000L, sessionID));
            }
            if (chunkedDom.domChunks.put(Integer.parseInt(index), data) != null) {
                throw new WTFException("Replace existing Chunk?!");
            }
            if (lastChunk) {
                this.domSessions.remove(sessionID);
                StringBuilder sb = new StringBuilder();
                for (int chunkIndex = 0; chunkIndex < chunkedDom.domChunks.size(); ++chunkIndex) {
                    String chunk = chunkedDom.domChunks.get(chunkIndex);
                    if (chunk == null) {
                        throw new WTFException("Chunk " + chunkIndex + " missing!");
                    }
                    sb.append(chunk);
                }
                chunkedDom.domChunks.clear();
                chunkedDom.completeDOM = sb.toString();
                return chunkedDom;
            }
        }
        return null;
    }

    public void addCompleteDom(final String url, String dom, CrawledLink link) {
        final LinkCollectingJob job = new LinkCollectingJob(LinkOrigin.TOOLBAR.getLinkOriginDetails(), dom);
        job.setCustomSourceUrl(url);
        AddLinksProgress d = new AddLinksProgress(job){

            @Override
            protected String getSearchInText() {
                return url;
            }
        };
        if (d.isHiddenByDontShowAgain()) {
            Thread thread = new Thread("AddLinksDialog"){

                @Override
                public void run() {
                    LinkCrawler lc = LinkCollector.getInstance().addCrawlerJob(job);
                    if (lc != null) {
                        lc.waitForCrawling();
                        System.out.println("JOB DONE: " + lc.getCrawledLinksFoundCounter());
                    }
                }
            };
            thread.start();
        } else {
            try {
                Dialog.getInstance().showDialog((AbstractDialog)d);
            }
            catch (DialogClosedException e) {
                e.printStackTrace();
            }
            catch (DialogCanceledException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public boolean togglePauseDownloads() {
        boolean b = DownloadWatchDog.getInstance().isPaused();
        DownloadWatchDog.getInstance().pauseDownloadWatchDog(!b);
        return !b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object checkLinksFromDOM(RemoteAPIRequest request) {
        JsonMap ret = new JsonMap();
        ret.put("checkid", null);
        try {
            boolean hosterOnly = "true".equalsIgnoreCase(request.getParameterbyKey("hosteronly"));
            boolean map = "1".equals(request.getParameterbyKey("map"));
            ChunkedDom chunkedDom = this.getCompleteDOM(request);
            if (chunkedDom != null) {
                final CheckedDom checkSession = new CheckedDom(chunkedDom);
                HashMap<String, CheckedDom> hashMap = this.checkSessions;
                synchronized (hashMap) {
                    this.checkSessions.put(checkSession.ID, checkSession);
                }
                ret.put("checkid", checkSession.ID);
                checkSession.linkCrawler = LinkCrawler.newInstance();
                final LinkCrawlerHandler defaultHandler = checkSession.linkCrawler.getHandler();
                if (hosterOnly) {
                    checkSession.linkCrawler.setFilter(new LinkCrawlerFilter(){

                        @Override
                        public boolean dropByUrl(CrawledLink link) {
                            PluginForHost plugin = link.gethPlugin();
                            if (plugin == null) {
                                return true;
                            }
                            return "ftp".equalsIgnoreCase(plugin.getHost()) || "http links".equalsIgnoreCase(plugin.getHost());
                        }

                        @Override
                        public boolean dropByFileProperties(CrawledLink link) {
                            return false;
                        }
                    });
                }
                checkSession.linkChecker = new LinkChecker();
                checkSession.linkChecker.setLinkCheckHandler(new LinkCheckerHandler<CrawledLink>(){

                    @Override
                    public void linkCheckDone(CrawledLink link) {
                        defaultHandler.handleFinalLink(link);
                    }
                });
                checkSession.linkCrawler.setHandler(new LinkCrawlerHandler(){

                    @Override
                    public void handleFinalLink(CrawledLink link) {
                        checkSession.linkChecker.check(link);
                    }

                    @Override
                    public void handleFilteredLink(CrawledLink link) {
                        defaultHandler.handleFilteredLink(link);
                    }

                    @Override
                    public void handleBrokenLink(CrawledLink link) {
                    }

                    @Override
                    public void handleUnHandledLink(CrawledLink link) {
                    }
                });
                if (!map) {
                    checkSession.linkCrawler.crawl(checkSession.completeDOM);
                } else {
                    HashMap linkMap = (HashMap)JSonStorage.restoreFromString((String)checkSession.completeDOM, new HashMap().getClass());
                    ArrayList<CrawledLink> links2Check = new ArrayList<CrawledLink>();
                    for (Map.Entry next : linkMap.entrySet()) {
                        links2Check.add(new LinkCheckLink((String)next.getValue(), (String)next.getKey()));
                    }
                    checkSession.linkCrawler.crawl(links2Check);
                }
            }
            ret.put("status", true);
            ret.put("msg", null);
        }
        catch (Throwable e) {
            e.printStackTrace();
            ret.put("status", false);
            ret.put("msg", e.getMessage());
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LinkCheckResult pollCheckedLinksFromDOM(String checkID) {
        Object object;
        CheckedDom session = null;
        HashMap<String, CheckedDom> hashMap = this.checkSessions;
        synchronized (hashMap) {
            session = this.checkSessions.get(checkID);
            if (session != null && session.finished) {
                this.checkSessions.remove(checkID);
            }
        }
        LinkCheckResult result = new LinkCheckResult();
        boolean finished = false;
        if (session != null) {
            object = session;
            synchronized (object) {
                boolean stillRunning = session.linkChecker.isRunning() || session.linkCrawler.isRunning();
                ArrayList<CrawledLink> retL = null;
                List<CrawledLink> list = session.linkCrawler.getCrawledLinks();
                synchronized (list) {
                    retL = new ArrayList<CrawledLink>(session.linkCrawler.getCrawledLinks());
                    session.linkCrawler.getCrawledLinks().clear();
                }
                result.setStatus(LinkCheckResult.STATUS.PENDING);
                if (retL.size() > 0) {
                    ArrayList<LinkStatus> linkStats = new ArrayList<LinkStatus>();
                    for (CrawledLink link : retL) {
                        linkStats.add(new LinkStatus(link));
                    }
                    result.setLinks(linkStats);
                }
                if (!stillRunning && retL.size() == 0) {
                    session.finished = true;
                    result.setStatus(LinkCheckResult.STATUS.FINISHED);
                }
            }
        }
        if (finished) {
            object = this.checkSessions;
            synchronized (object) {
                this.checkSessions.remove(checkID);
            }
        }
        return result;
    }

    @Override
    public String specialURLHandling(String url) {
        if (url.contains("youtube.com")) {
            return "var jDownloaderObj = {statusCheck: function(){" + YouTubeSpecialUrlHandling.handle(url) + "}};jDownloaderObj.statusCheck();";
        }
        return "";
    }

    @Override
    public boolean triggerUpdate() {
        new Thread(){

            @Override
            public void run() {
                UpdateController.getInstance().setGuiVisible(false);
                UpdateController.getInstance().runUpdateChecker(true);
            }
        }.start();
        return true;
    }

    private class CheckedDom
    extends ChunkedDom {
        protected final String ID;
        protected LinkChecker<CrawledLink> linkChecker;
        protected LinkCrawler linkCrawler;
        boolean finished;

        protected CheckedDom(ChunkedDom dom) {
            this.finished = false;
            this.completeDOM = dom.completeDOM;
            this.URL = dom.URL;
            this.ID = "check" + System.nanoTime();
        }
    }

    private class ChunkedDom {
        protected HashMap<Integer, String> domChunks = new HashMap();
        protected String URL = null;
        protected String completeDOM = null;

        private ChunkedDom() {
        }
    }
}

