/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.api.useragent;

import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.appwork.remoteapi.RemoteAPIRequest;
import org.appwork.utils.StringUtils;
import org.jdownloader.api.myjdownloader.MyJDownloaderConnectThread;
import org.jdownloader.api.myjdownloader.MyJDownloaderController;
import org.jdownloader.api.myjdownloader.MyJDownloaderDirectHttpConnection;
import org.jdownloader.api.myjdownloader.MyJDownloaderHttpConnection;
import org.jdownloader.api.myjdownloader.api.MyJDownloaderAPI;
import org.jdownloader.api.useragent.UserAgentInfo;
import org.jdownloader.myjdownloader.client.json.SessionInfoResponse;

public class ConnectedDevice {
    public static final String FRONTEND_WEBINTERFACE = "Webinterface http://my.jdownloader.org by AppWork";
    public static final String FRONTEND_ANDROID_APP = "MyJDownloader by AppWork";
    public static final String FRONTEND_FIREFOX_EXTENSION = "Firefox Extension by AppWork";
    public static final String FRONTEND_CHROME_EXTENSION = "Chrome Extension by AppWork";
    private static final Pattern ANDROID_USERAGENT_PATTERN = Pattern.compile("MyJDownloader Android App \\(Version: (.+) \\/ (.+)\\) \\(Android (.+);(.+)\\/(.+)\\)");
    private static final Pattern WINMOB_FILERECON_USERAGENT_PATTERN = Pattern.compile("MyJDownloader file.recon App \\(Version: (.+) \\/ (.+)\\)");
    private static final Pattern WIN_UNIVERSAL_USERAGENT_PATTERN = Pattern.compile("MyJDownloader JD Universal App \\(Version: (.+) \\/ (.+)\\)");
    private RemoteAPIRequest latestRequest;
    private String token;
    private final AtomicReference<Object> appKey = new AtomicReference();
    private long lastPing;
    private UserAgentInfo info;
    private String id;
    private String deviceName = null;
    private String frontEnd = null;

    public String getConnectToken() {
        return this.token;
    }

    public void setConnectToken(String token) {
        this.token = token;
    }

    public UserAgentInfo getInfo() {
        return this.info;
    }

    public String getId() {
        return this.id;
    }

    public long getLastPing() {
        return this.lastPing;
    }

    public ConnectedDevice(String nuaID) {
        this.id = nuaID;
    }

    public String getAppKey() {
        Object appKey = this.appKey.get();
        if (appKey == this) {
            return "unknown";
        }
        if (appKey instanceof Thread) {
            return "unknown";
        }
        if (appKey instanceof String) {
            return appKey.toString();
        }
        Thread fetchAppKey = new Thread(){

            public SessionInfoResponse getSessionInfo(String queryToken) {
                MyJDownloaderConnectThread th = MyJDownloaderController.getInstance().getConnectThread();
                if (th == null || !th.isAlive()) {
                    return null;
                }
                try {
                    MyJDownloaderAPI api = th.getApi();
                    if (api != null && queryToken != null) {
                        return api.getSessionInfo(queryToken);
                    }
                }
                catch (Exception e) {
                    th.getLogger().log((Throwable)e);
                }
                return null;
            }

            @Override
            public void run() {
                try {
                    SessionInfoResponse sessionInfo = this.getSessionInfo(ConnectedDevice.this.token);
                    if (sessionInfo != null) {
                        ConnectedDevice.this.appKey.compareAndSet(Thread.currentThread(), sessionInfo.getAppKey());
                    }
                }
                finally {
                    ConnectedDevice.this.appKey.compareAndSet(Thread.currentThread(), ConnectedDevice.this);
                }
            }
        };
        if (this.appKey.compareAndSet(null, fetchAppKey)) {
            fetchAppKey.setDaemon(true);
            fetchAppKey.start();
        }
        return this.getAppKey();
    }

    public long getTimeout() {
        return 300000L;
    }

    public void setLatestRequest(RemoteAPIRequest request) {
        this.latestRequest = request;
        this.lastPing = System.currentTimeMillis();
        if (this.latestRequest.getRequestedPath().contains("anywhere")) {
            this.deviceName = "IPhone/IPad";
            this.frontEnd = "JDAnywhere";
        } else {
            this.deviceName = this._getDeviceName();
            this.frontEnd = this._getFrontendName();
        }
    }

    private String _getFrontendName() {
        String origin = this.latestRequest.getRequestHeaders().getValue("Origin");
        String referer = this.latestRequest.getRequestHeaders().getValue("Referer");
        if (StringUtils.startsWithCaseInsensitive((String)origin, (String)"http://my.jdownloader.org") || StringUtils.startsWithCaseInsensitive((String)origin, (String)"https://my.jdownloader.org")) {
            return FRONTEND_WEBINTERFACE;
        }
        if (StringUtils.startsWithCaseInsensitive((String)referer, (String)"http://my.jdownloader.org") || StringUtils.startsWithCaseInsensitive((String)referer, (String)"https://my.jdownloader.org")) {
            return FRONTEND_WEBINTERFACE;
        }
        if (StringUtils.startsWithCaseInsensitive((String)origin, (String)"chrome-extension://")) {
            return FRONTEND_CHROME_EXTENSION;
        }
        if (StringUtils.equals((String)origin, (String)"null")) {
            return FRONTEND_FIREFOX_EXTENSION;
        }
        if (ConnectedDevice.isAndroidApp(this.getUserAgentString())) {
            return FRONTEND_ANDROID_APP;
        }
        if (ConnectedDevice.isFileReconApp(this.getUserAgentString())) {
            return "file.recon by Pseudocode";
        }
        if (ConnectedDevice.isJDUniversalApp(this.getUserAgentString())) {
            return "JD Universal by Pseudocode";
        }
        if (StringUtils.isNotEmpty((String)origin) && !"null".equals(origin)) {
            return origin;
        }
        return this.getAppKey();
    }

    private String _getDeviceName() {
        String uA = this.getUserAgentString();
        if (ConnectedDevice.isAndroidApp(uA)) {
            Matcher matcher = ANDROID_USERAGENT_PATTERN.matcher(uA);
            if (matcher.matches()) {
                return matcher.group(4).replace(" ", "") + matcher.group(5).replace(" ", "") + "@Android" + matcher.group(3);
            }
            return "Android";
        }
        if (ConnectedDevice.isFileReconApp(uA)) {
            Matcher matcher = WINMOB_FILERECON_USERAGENT_PATTERN.matcher(uA);
            if (matcher.matches()) {
                return "file.recon" + matcher.group(1).replace(" ", "") + "(" + matcher.group(2).replace(" ", "") + ")@WindowsMobile";
            }
            return "file.recon@WindowsMobile";
        }
        if (ConnectedDevice.isJDUniversalApp(uA)) {
            Matcher matcher = WIN_UNIVERSAL_USERAGENT_PATTERN.matcher(uA);
            if (matcher.matches()) {
                return "JDUniversal" + matcher.group(1).replace(" ", "") + "(" + matcher.group(2).replace(" ", "") + ")@Win10";
            }
            return "JDUniversal@Win10";
        }
        if (this.info != null && !StringUtils.equals((String)this.info.getName(), (String)"unknown")) {
            return this.info.getName() + "@" + this.info.getOs();
        }
        return uA;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public String getUserAgentString() {
        return this.latestRequest.getRequestHeaders().getValue("User-Agent");
    }

    public void setInfo(UserAgentInfo info) {
        this.info = info;
    }

    public String getFrontendName() {
        return this.frontEnd;
    }

    public static boolean isAndroidApp(String userAgent) {
        return StringUtils.startsWithCaseInsensitive((String)userAgent, (String)"MyJDownloader Android App");
    }

    public static boolean isFileReconApp(String userAgent) {
        return StringUtils.startsWithCaseInsensitive((String)userAgent, (String)"MyJDownloader file.recon App");
    }

    public static boolean isJDUniversalApp(String userAgent) {
        return StringUtils.startsWithCaseInsensitive((String)userAgent, (String)"MyJDownloader JD Universal App");
    }

    public static boolean isApp(String userAgent) {
        return ConnectedDevice.isAndroidApp(userAgent) || ConnectedDevice.isFileReconApp(userAgent) || ConnectedDevice.isJDUniversalApp(userAgent);
    }

    public String getConnectionString() {
        List<MyJDownloaderHttpConnection> list = MyJDownloaderHttpConnection.getConnectionsByToken(this.getConnectToken());
        if (list == null || list.size() == 0) {
            return "0 Connections";
        }
        int remote = 0;
        int direct = 0;
        for (MyJDownloaderHttpConnection con : list) {
            if (con instanceof MyJDownloaderDirectHttpConnection) {
                ++direct;
                continue;
            }
            ++remote;
        }
        if (direct > 0 && remote > 0) {
            return direct + " Direct Connection(s) and " + remote + " Remote Connection(s)";
        }
        if (direct > 0) {
            return direct + " Direct Connection(s)";
        }
        if (remote > 0) {
            return remote + " Remote Connection(s)";
        }
        return "0 Connections";
    }

    public RemoteAPIRequest getLatestRequest() {
        return this.latestRequest;
    }
}

