/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.api.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jd.controlling.linkchecker.LinkChecker;
import jd.controlling.linkcrawler.CheckableLink;
import jd.controlling.packagecontroller.AbstractNode;
import jd.controlling.packagecontroller.AbstractPackageNode;
import org.appwork.remoteapi.exceptions.BadParameterException;
import org.jdownloader.controlling.DefaultDownloadLinkViewImpl;
import org.jdownloader.gui.views.SelectionInfo;
import org.jdownloader.gui.views.components.packagetable.LinkTreeUtils;
import org.jdownloader.myjdownloader.client.bindings.UrlDisplayTypeStorable;
import org.jdownloader.settings.UrlDisplayEntry;
import org.jdownloader.settings.UrlDisplayType;
import org.jdownloader.settings.staticreferences.CFG_GENERAL;

public class SelectionInfoUtils {
    public static void startOnlineStatusCheck(SelectionInfo<? extends AbstractPackageNode, ? extends AbstractNode> selectionInfo) throws BadParameterException {
        List<? extends AbstractNode> children = selectionInfo.getChildren();
        if (children.size() > 0) {
            ArrayList<CheckableLink> checkableLinks = new ArrayList<CheckableLink>(children.size());
            for (AbstractNode abstractNode : children) {
                if (!(abstractNode instanceof CheckableLink)) continue;
                checkableLinks.add((CheckableLink)((Object)abstractNode));
            }
            LinkChecker<ArrayList<CheckableLink>> linkChecker = new LinkChecker<ArrayList<CheckableLink>>(true);
            linkChecker.check(checkableLinks);
        }
    }

    public static List<UrlDisplayType> parse(UrlDisplayTypeStorable[] urlDisplayTypes) throws BadParameterException {
        ArrayList<UrlDisplayType> ret = new ArrayList<UrlDisplayType>();
        if (CFG_GENERAL.CFG.isUseUrlOrderForMyJD()) {
            DefaultDownloadLinkViewImpl.DISPLAY_URL_TYPE.getClass();
            UrlDisplayEntry[] newOrder = CFG_GENERAL.CFG.getUrlOrder();
            if (newOrder != null && newOrder.length > 0) {
                for (UrlDisplayEntry e : newOrder) {
                    try {
                        UrlDisplayType type = UrlDisplayType.valueOf(e.getType());
                        if (ret.contains((Object)type)) continue;
                        ret.add(type);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            } else {
                ret.addAll(Arrays.asList(UrlDisplayType.values()));
            }
        } else {
            for (UrlDisplayTypeStorable urlDisplayType : urlDisplayTypes) {
                try {
                    ret.add(UrlDisplayType.valueOf(urlDisplayType.name()));
                }
                catch (Exception e) {
                    throw new BadParameterException(e.getMessage());
                }
            }
        }
        return ret;
    }

    public static Map<String, List<Long>> getURLs(SelectionInfo<? extends AbstractPackageNode, ? extends AbstractNode> selectionInfo, List<UrlDisplayType> urlDisplayTypes) {
        List<? extends AbstractNode> children = selectionInfo.getChildren();
        HashMap<String, List<Long>> ret = new HashMap<String, List<Long>>();
        if (children.size() > 0) {
            boolean copySingleRealURL = CFG_GENERAL.CFG.isCopySingleRealURL() && children.size() == 1;
            block0: for (AbstractNode abstractNode : children) {
                for (UrlDisplayType urlDisplayType : urlDisplayTypes) {
                    String url = LinkTreeUtils.getUrlByType(urlDisplayType, abstractNode);
                    if (url == null && UrlDisplayType.CONTENT.equals((Object)urlDisplayType) && copySingleRealURL) {
                        Set<String> urls = LinkTreeUtils.getURLs(selectionInfo, false, true);
                        String string = url = urls.size() == 1 ? urls.iterator().next() : null;
                    }
                    if (url == null) continue;
                    List<Long> list = ret.get(url);
                    if (list == null) {
                        list = new ArrayList<Long>();
                        ret.put(url, list);
                    }
                    list.add(abstractNode.getUniqueID().getID());
                    continue block0;
                }
            }
        }
        return ret;
    }
}

