/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.captcha.blacklist;

import java.lang.ref.WeakReference;
import jd.controlling.captcha.SkipRequest;
import jd.controlling.linkcrawler.CrawledLink;
import jd.controlling.linkcrawler.LinkCrawler;
import jd.plugins.Plugin;
import jd.plugins.PluginForDecrypt;
import org.jdownloader.captcha.blacklist.BlacklistEntry;
import org.jdownloader.captcha.v2.Challenge;

public class BlockCrawlerCaptchasByPackage
implements BlacklistEntry {
    private final WeakReference<LinkCrawler> crawler;
    private final CrawledLink origin;

    public BlockCrawlerCaptchasByPackage(LinkCrawler crawler, CrawledLink link) {
        this.crawler = new WeakReference<LinkCrawler>(crawler);
        this.origin = link.getOriginLink();
    }

    @Override
    public boolean canCleanUp() {
        LinkCrawler lcrawler = this.getCrawler();
        return lcrawler == null || !lcrawler.isRunning();
    }

    public LinkCrawler getCrawler() {
        return (LinkCrawler)this.crawler.get();
    }

    public String toString() {
        LinkCrawler lcrawler = this.getCrawler();
        if (lcrawler != null) {
            return "BlockCrawlerCaptchasByPackage:" + lcrawler.getCreated() + ":" + (Object)((Object)this.origin.getUniqueID());
        }
        return "BlockCrawlerCaptchasByPackage:" + (Object)((Object)this.origin.getUniqueID());
    }

    public boolean matches(Challenge c) {
        Plugin plugin;
        LinkCrawler lcrawler = this.getCrawler();
        if (lcrawler != null && lcrawler.isRunning() && (plugin = c.getPlugin()) instanceof PluginForDecrypt) {
            PluginForDecrypt decrypt = (PluginForDecrypt)plugin;
            CrawledLink link = decrypt.getCurrentLink();
            return decrypt.getCrawler() == lcrawler && link != null && link.getOriginLink() == this.origin;
        }
        return false;
    }

    @Override
    public SkipRequest getSkipRequest() {
        return SkipRequest.BLOCK_PACKAGE;
    }
}

