/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.captcha.blacklist;

import java.lang.ref.WeakReference;
import jd.controlling.captcha.SkipRequest;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import org.jdownloader.captcha.blacklist.SessionBlackListEntry;
import org.jdownloader.captcha.v2.Challenge;

public class BlockDownloadCaptchasByPackage
implements SessionBlackListEntry<Object> {
    private final WeakReference<FilePackage> blockedPackage;

    public BlockDownloadCaptchasByPackage(FilePackage parentNode) {
        this.blockedPackage = FilePackage.isDefaultFilePackage(parentNode) ? new WeakReference<Object>(null) : new WeakReference<FilePackage>(parentNode);
    }

    @Override
    public boolean canCleanUp() {
        FilePackage filePackage = this.getFilePackage();
        return filePackage == null || filePackage.getControlledBy() == null;
    }

    public FilePackage getFilePackage() {
        return (FilePackage)this.blockedPackage.get();
    }

    public String toString() {
        FilePackage filePackage = this.getFilePackage();
        if (filePackage != null) {
            return "BlockDownloadCaptchasByPackage:" + (Object)((Object)filePackage.getUniqueID());
        }
        return "BlockDownloadCaptchasByPackage";
    }

    @Override
    public boolean matches(Challenge<Object> c) {
        FilePackage filePackage = this.getFilePackage();
        if (filePackage != null) {
            DownloadLink link = c.getDownloadLink();
            if (link == null) {
                return false;
            }
            FilePackage parent = link.getParentNode();
            return filePackage == parent;
        }
        return false;
    }

    @Override
    public SkipRequest getSkipRequest() {
        return SkipRequest.BLOCK_PACKAGE;
    }
}

