/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.captcha.v2;

import org.appwork.utils.logging2.extmanager.LoggerFactory;
import org.jdownloader.captcha.v2.Challenge;
import org.jdownloader.captcha.v2.ChallengeSolver;
import org.jdownloader.captcha.v2.ValidationResult;
import org.jdownloader.controlling.UniqueAlltimeID;

public class AbstractResponse<T> {
    private final UniqueAlltimeID id = new UniqueAlltimeID();
    private int priority;
    private ValidationResult validation = null;
    private String captchaSolverTaskID = null;
    private T value;
    private final Object solver;
    private final Challenge<T> challenge;

    public ValidationResult getValidation() {
        return this.validation;
    }

    public boolean setValidation(ValidationResult validation) {
        try {
            if (this.validation != null) {
                return false;
            }
            this.validation = validation;
            Object solver = this.getSolver();
            if (solver != null && solver instanceof ChallengeSolver) {
                Challenge<T> c = this.getChallenge();
                switch (validation) {
                    case INVALID: {
                        if (c != null) {
                            c.sendStatsValidation((ChallengeSolver)solver, "false");
                        }
                        return ((ChallengeSolver)solver).setInvalid(this);
                    }
                    case UNUSED: {
                        if (c != null) {
                            c.sendStatsValidation((ChallengeSolver)solver, "unused");
                        }
                        return ((ChallengeSolver)solver).setUnused(this);
                    }
                    case VALID: {
                        if (c != null) {
                            c.sendStatsValidation((ChallengeSolver)solver, "true");
                        }
                        return ((ChallengeSolver)solver).setValid(this);
                    }
                }
            }
            return true;
        }
        catch (Throwable e) {
            this.validation = null;
            LoggerFactory.getDefaultLogger().log(e);
            return false;
        }
    }

    public int getPriority() {
        return this.priority;
    }

    public UniqueAlltimeID getId() {
        return this.id;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public T getValue() {
        return this.value;
    }

    public void setValue(T value) {
        this.value = value;
    }

    public Object getSolver() {
        return this.solver;
    }

    public AbstractResponse(Challenge<T> challenge, Object solver, int priority, T responseData) {
        this.solver = solver;
        this.priority = priority;
        this.value = responseData;
        this.challenge = challenge;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": Value:" + this.value + " Priority: " + this.priority + " Solved By: " + this.solver;
    }

    public Challenge<T> getChallenge() {
        return this.challenge;
    }

    public String getCaptchaSolverTaskID() {
        return this.captchaSolverTaskID;
    }

    public void setCaptchaSolverTaskID(String captchaSolverTaskID) {
        this.captchaSolverTaskID = captchaSolverTaskID;
    }
}

