/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.captcha.v2;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import jd.controlling.AccountController;
import jd.controlling.AccountFilter;
import jd.controlling.captcha.CaptchaSettings;
import jd.controlling.captcha.SkipException;
import jd.controlling.captcha.SkipRequest;
import jd.plugins.Account;
import org.appwork.storage.config.JsonConfig;
import org.appwork.timetracker.TimeTracker;
import org.appwork.timetracker.TimeTrackerController;
import org.appwork.timetracker.TrackerRule;
import org.appwork.uio.ConfirmDialogInterface;
import org.appwork.uio.UIOManager;
import org.appwork.uio.UserIODefinition;
import org.appwork.utils.Application;
import org.appwork.utils.Time;
import org.appwork.utils.event.DefaultEvent;
import org.appwork.utils.formatter.TimeFormatter;
import org.appwork.utils.logging2.LogSource;
import org.appwork.utils.swing.dialog.ConfirmDialog;
import org.jdownloader.api.captcha.CaptchaAPISolver;
import org.jdownloader.captcha.blacklist.BlacklistEntry;
import org.jdownloader.captcha.blacklist.CaptchaBlackList;
import org.jdownloader.captcha.event.ChallengeResponseEvent;
import org.jdownloader.captcha.event.ChallengeResponseEventSender;
import org.jdownloader.captcha.v2.AbstractResponse;
import org.jdownloader.captcha.v2.CaptchaQualityEnsuranceRule;
import org.jdownloader.captcha.v2.Challenge;
import org.jdownloader.captcha.v2.ChallengeSolver;
import org.jdownloader.captcha.v2.PluginChallengeSolver;
import org.jdownloader.captcha.v2.SolverService;
import org.jdownloader.captcha.v2.challenge.cloudflareturnstile.CloudflareTurnstileChallenge;
import org.jdownloader.captcha.v2.challenge.cutcaptcha.CutCaptchaChallenge;
import org.jdownloader.captcha.v2.challenge.hcaptcha.HCaptchaChallenge;
import org.jdownloader.captcha.v2.challenge.oauth.AccountOAuthSolver;
import org.jdownloader.captcha.v2.challenge.oauth.OAuthDialogSolver;
import org.jdownloader.captcha.v2.challenge.recaptcha.v2.RecaptchaV2Challenge;
import org.jdownloader.captcha.v2.solver.CESChallengeSolver;
import org.jdownloader.captcha.v2.solver.antiCaptchaCom.AntiCaptchaComSolver;
import org.jdownloader.captcha.v2.solver.browser.AbstractBrowserChallenge;
import org.jdownloader.captcha.v2.solver.browser.BrowserSolver;
import org.jdownloader.captcha.v2.solver.cheapcaptcha.CheapCaptchaSolver;
import org.jdownloader.captcha.v2.solver.dbc.DeathByCaptchaSolver;
import org.jdownloader.captcha.v2.solver.endcaptcha.EndCaptchaSolver;
import org.jdownloader.captcha.v2.solver.gui.DialogBasicCaptchaSolver;
import org.jdownloader.captcha.v2.solver.gui.DialogClickCaptchaSolver;
import org.jdownloader.captcha.v2.solver.gui.DialogMultiClickCaptchaSolver;
import org.jdownloader.captcha.v2.solver.imagetyperz.ImageTyperzCaptchaSolver;
import org.jdownloader.captcha.v2.solver.jac.JACSolver;
import org.jdownloader.captcha.v2.solver.solver9kw.Captcha9kwSolver;
import org.jdownloader.captcha.v2.solver.solver9kw.Captcha9kwSolverClick;
import org.jdownloader.captcha.v2.solver.solver9kw.Captcha9kwSolverMultiClick;
import org.jdownloader.captcha.v2.solver.twocaptcha.TwoCaptchaSolver;
import org.jdownloader.captcha.v2.solverjob.ResponseList;
import org.jdownloader.captcha.v2.solverjob.SolverJob;
import org.jdownloader.controlling.UniqueAlltimeID;
import org.jdownloader.logging.LogController;
import org.jdownloader.plugins.components.captchasolver.abstractPluginForCaptchaSolver;
import org.jdownloader.plugins.controller.LazyPlugin;
import org.jdownloader.settings.staticreferences.CFG_CAPTCHA;
import org.jdownloader.updatev2.UpdateController;

public class ChallengeResponseController {
    private static final ChallengeResponseController INSTANCE = new ChallengeResponseController();
    protected static final CaptchaSettings CAPTCHA_SETTINGS = (CaptchaSettings)JsonConfig.create(CaptchaSettings.class);
    private ChallengeResponseEventSender eventSender;
    private LogSource logger;
    private TimeTrackerController trackerCache;
    private final AtomicBoolean init = new AtomicBoolean(false);
    private final HashMap<String, SolverService> solverMap = new HashMap();
    private final List<SolverService> serviceList = new CopyOnWriteArrayList<SolverService>();
    private final List<ChallengeSolver<?>> solverList = new CopyOnWriteArrayList();
    private final List<SolverJob<?>> activeJobs = new ArrayList();
    private final HashMap<UniqueAlltimeID, SolverJob<?>> challengeIDToJobMap = new HashMap();
    protected static final AtomicLong TIMESTAMP_NO_BROWSER_SOLVER_AVAILABLE_DIALOG_LAST_DISPLAYED = new AtomicLong(-1L);

    public static ChallengeResponseController getInstance() {
        return INSTANCE;
    }

    public ChallengeResponseEventSender getEventSender() {
        return this.eventSender;
    }

    private ChallengeResponseController() {
        this.logger = LogController.getInstance().getLogger(this.getClass().getName());
        this.eventSender = new ChallengeResponseEventSender(this.logger);
        this.trackerCache = new TimeTrackerController();
        HashMap<String, ArrayList<CaptchaQualityEnsuranceRule>> rules = CFG_CAPTCHA.CFG.getQualityEnsuranceRules();
        if (rules == null) {
            rules = new HashMap();
        }
        boolean save = false;
        save = this.addDefaultRules(rules, "recaptchav2", new CaptchaQualityEnsuranceRule(60, 600000), new CaptchaQualityEnsuranceRule(6, 60000), new CaptchaQualityEnsuranceRule(3, 30000), new CaptchaQualityEnsuranceRule(2, 10000)) || save;
        boolean bl = save = this.addDefaultRules(rules, HCaptchaChallenge.getChallengeType(), new CaptchaQualityEnsuranceRule(60, 600000), new CaptchaQualityEnsuranceRule(6, 60000), new CaptchaQualityEnsuranceRule(3, 30000), new CaptchaQualityEnsuranceRule(2, 10000)) || save;
        if (save) {
            CFG_CAPTCHA.CFG.setQualityEnsuranceRules(rules);
        }
        for (Map.Entry<String, ArrayList<CaptchaQualityEnsuranceRule>> es : rules.entrySet()) {
            ArrayList<CaptchaQualityEnsuranceRule> rc = es.getValue();
            TimeTracker tracker = this.trackerCache.getTracker(es.getKey());
            for (CaptchaQualityEnsuranceRule r : rc) {
                this.logger.info("Add Captcha Limit Rule for " + es.getKey() + " " + r.getLimit() + " Reqs in " + TimeFormatter.formatMilliSeconds((long)r.getInterval(), (int)0));
                tracker.addRule(new TrackerRule(r.getLimit(), r.getInterval()));
            }
        }
    }

    private boolean addDefaultRules(HashMap<String, ArrayList<CaptchaQualityEnsuranceRule>> rules, String key, CaptchaQualityEnsuranceRule ... defList) {
        ArrayList<CaptchaQualityEnsuranceRule> rc = rules.get(key);
        if (rc == null || rc.size() == 0) {
            rc = new ArrayList();
            for (CaptchaQualityEnsuranceRule r : defList) {
                rc.add(r);
            }
            rules.put(key, rc);
            return true;
        }
        return false;
    }

    public void init() {
        if (!this.init.compareAndSet(false, true)) {
            return;
        }
        this.addSolver(JACSolver.getInstance());
        this.addSolver(DeathByCaptchaSolver.getInstance());
        this.addSolver(ImageTyperzCaptchaSolver.getInstance());
        this.addSolver(CheapCaptchaSolver.getInstance());
        this.addSolver(TwoCaptchaSolver.getInstance());
        this.addSolver(AntiCaptchaComSolver.getInstance());
        this.addSolver(EndCaptchaSolver.getInstance());
        this.addSolver(Captcha9kwSolver.getInstance());
        this.addSolver(Captcha9kwSolverClick.getInstance());
        this.addSolver(Captcha9kwSolverMultiClick.getInstance());
        if (!Application.isHeadless()) {
            this.addSolver(DialogBasicCaptchaSolver.getInstance());
            this.addSolver(DialogClickCaptchaSolver.getInstance());
            this.addSolver(DialogMultiClickCaptchaSolver.getInstance());
            this.addSolver(BrowserSolver.getInstance());
            this.addSolver(OAuthDialogSolver.getInstance());
        }
        this.addSolver(AccountOAuthSolver.getInstance());
        this.addSolver(CaptchaAPISolver.getInstance());
    }

    public List<ChallengeSolver<?>> listSolvers() {
        return new ArrayList(this.solverList);
    }

    private synchronized boolean addSolver(ChallengeSolver<?> solver) {
        if (this.solverMap.put(solver.getService().getID(), solver.getService()) == null) {
            this.serviceList.add(solver.getService());
        }
        return this.solverList.add(solver);
    }

    public <E> void fireNewAnswerEvent(SolverJob<E> job, AbstractResponse<E> abstractResponse) {
        this.eventSender.fireEvent((DefaultEvent)new ChallengeResponseEvent(this, ChallengeResponseEvent.Type.JOB_ANSWER, abstractResponse, job));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SolverJob<?>> listJobs() {
        List<SolverJob<?>> list = this.activeJobs;
        synchronized (list) {
            return new ArrayList(this.activeJobs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasPendingJobs() {
        List<SolverJob<?>> list = this.activeJobs;
        synchronized (list) {
            return this.activeJobs.size() > 0;
        }
    }

    public void fireBeforeSolveEvent(SolverJob<?> job, ChallengeSolver<?> solver) {
        this.eventSender.fireEvent((DefaultEvent)new ChallengeResponseEvent(this, ChallengeResponseEvent.Type.SOLVER_START, solver, job));
    }

    public void fireAfterSolveEvent(SolverJob<?> job, ChallengeSolver<?> solver) {
        job.getLogger().info("Solver " + solver + " finished job " + job);
        job._notifyAll();
        this.eventSender.fireEvent((DefaultEvent)new ChallengeResponseEvent(this, ChallengeResponseEvent.Type.SOLVER_END, solver, job));
    }

    private void fireNewJobEvent(SolverJob<?> job) {
        this.eventSender.fireEvent((DefaultEvent)new ChallengeResponseEvent(this, ChallengeResponseEvent.Type.NEW_JOB, job));
    }

    private void fireJobDone(SolverJob<?> job) {
        this.eventSender.fireEvent((DefaultEvent)new ChallengeResponseEvent(this, ChallengeResponseEvent.Type.JOB_DONE, job));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSkipRequest(SkipRequest skipRequest, ChallengeSolver<?> solver, Challenge<?> sourceChallenge) {
        List<SolverJob<?>> list = this.activeJobs;
        synchronized (list) {
            for (SolverJob<?> job : this.activeJobs) {
                if (job.getChallenge() == sourceChallenge) {
                    job.setSkipRequest(skipRequest);
                    continue;
                }
                if (!job.getChallenge().canBeSkippedBy(skipRequest, solver, sourceChallenge)) continue;
                job.setSkipRequest(skipRequest);
            }
        }
    }

    public void keepAlivePendingChallenges(Challenge<?> c) {
        for (SolverJob<?> job : this.activeJobs) {
            job.getChallenge().keepAlive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> SolverJob<T> handle(Challenge<T> c) throws InterruptedException, SkipException {
        LogSource logger;
        if (c instanceof AbstractBrowserChallenge) {
            if (c instanceof RecaptchaV2Challenge) {
                UpdateController.getInstance().addFeedback(new String[]{"rc"});
            } else if (c instanceof HCaptchaChallenge) {
                UpdateController.getInstance().addFeedback(new String[]{"hc"});
            } else if (c instanceof CloudflareTurnstileChallenge) {
                UpdateController.getInstance().addFeedback(new String[]{"tc"});
            }
        }
        if ((logger = LogController.getInstance().getPreviousThreadLogSource()) == null) {
            logger = this.logger;
        }
        logger.info("Log to " + logger.getName());
        logger.info("Handle Challenge: " + c);
        List<ChallengeSolver<T>> solvers = this.createList(c);
        logger.info("Solver: " + solvers);
        if (solvers.size() == 0) {
            logger.info("No solver available!");
            if (c instanceof CloudflareTurnstileChallenge) {
                this.showNoBrowserSolverInfoDialog(c, "Cloudflare Turnstile");
            } else if (c instanceof CutCaptchaChallenge) {
                this.showNoBrowserSolverInfoDialog(c, "CutCaptcha");
            }
            throw new SkipException(c, SkipRequest.BLOCK_HOSTER, "No solver available!");
        }
        SolverJob<T> job = new SolverJob<T>(this, c, solvers);
        job.setLogger(logger);
        c.initController(job);
        UniqueAlltimeID challengeID = c.getId();
        List<SolverJob<?>> list = this.activeJobs;
        synchronized (list) {
            this.activeJobs.add(job);
            this.challengeIDToJobMap.put(challengeID, job);
        }
        try {
            for (ChallengeSolver challengeSolver : solvers) {
                logger.info("Send to solver: " + challengeSolver + " " + job);
                challengeSolver.enqueue(job);
            }
            logger.info("Fire New Job Event");
            this.fireNewJobEvent(job);
            logger.info("Wait");
            boolean timeout = false;
            while (!job.isSolved() && !job.isDone()) {
                BlacklistEntry blacklistEntry = CaptchaBlackList.getInstance().matches(c);
                Challenge<T> challenge = job.getChallenge();
                challenge.poll(job);
                if (job.isSolved() || job.isDone()) break;
                long validUntil = challenge.getValidUntil();
                if (validUntil != -1L && System.currentTimeMillis() > validUntil) {
                    timeout = true;
                    break;
                }
                job._wait(1000);
                if (blacklistEntry == null || !job.setSkipRequest(SkipRequest.SINGLE)) continue;
                break;
            }
            if (timeout && job.setSkipRequest(SkipRequest.TIMEOUT)) {
                Challenge<T> challenge = job.getChallenge();
                long expired = System.currentTimeMillis() - challenge.getCreated();
                int jobTimeout = challenge.getTimeout();
                logger.info("Challenge Timeout detected|Job:" + job + "|Expired:" + expired + "|Timeout:" + jobTimeout);
            }
            if (!SkipRequest.TIMEOUT.equals((Object)job.getSkipRequest())) {
                this.keepAlivePendingChallenges(c);
            }
            if (job.getSkipRequest() != null) {
                throw new SkipException(c, job.getSkipRequest());
            }
            ResponseList<T> responseList = job.getResponseAndKill();
            logger.info("All Responses: " + job.getResponses());
            logger.info("Solving Done. Result: " + responseList);
            SolverJob<T> solverJob = job;
            return solverJob;
        }
        catch (InterruptedException e) {
            job.kill();
            throw e;
        }
        finally {
            try {
                List<SolverJob<?>> list2 = this.activeJobs;
                synchronized (list2) {
                    this.activeJobs.remove(job);
                    this.challengeIDToJobMap.remove((Object)challengeID);
                }
            }
            finally {
                this.fireJobDone(job);
            }
            c.onHandled();
        }
    }

    public <T> Thread showNoBrowserSolverInfoDialog(Challenge<T> c, String captcha_challenge_type) {
        long lastDisplay;
        do {
            lastDisplay = TIMESTAMP_NO_BROWSER_SOLVER_AVAILABLE_DIALOG_LAST_DISPLAYED.get();
            if (Time.systemIndependentCurrentJVMTimeMillis() - lastDisplay >= TimeUnit.HOURS.toMillis(1L)) continue;
            return null;
        } while (!TIMESTAMP_NO_BROWSER_SOLVER_AVAILABLE_DIALOG_LAST_DISPLAYED.compareAndSet(lastDisplay, Time.systemIndependentCurrentJVMTimeMillis()));
        if (captcha_challenge_type == null) {
            captcha_challenge_type = c.getTypeID();
        }
        if (captcha_challenge_type != null && captcha_challenge_type.contains("turnstile")) {
            captcha_challenge_type = "Cloudflare Turnstile";
        }
        final String captcha_challenge_type_final = captcha_challenge_type;
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    String title;
                    String help_article_url = "https://support.jdownloader.org/knowledgebase/article/error-skipped-captcha-is-required";
                    String message = "<html>";
                    String lang = System.getProperty("user.language").toLowerCase();
                    if ("de".equals(lang)) {
                        title = "Externer Solver erforderlich f\u00fcr diese Captcha-Challenge";
                        message = message + "Die interaktive Art der Captcha-Herausforderung '" + captcha_challenge_type_final + "', die gel\u00f6st werden muss, kann derzeit nicht lokal in deinem Browser gel\u00f6st werden.<br><br>";
                        message = message + "Daher bleibt dir in JD nur die M\u00f6glichkeit, einen m\u00f6glicherweise kostenpflichtigen Captcha-L\u00f6sungsdienst zu nutzen, der diesen Captcha-Typ verarbeiten kann.<br><br>";
                        message = message + "JD unterst\u00fctzt verschiedene Captcha-L\u00f6sungsdienste, die im unten verlinkten Artikel aufgef\u00fchrt werden.<br><br>";
                        message = message + "F\u00fcr detailliertere Informationen lies bitte den folgenden Hilfe-Artikel:<br>";
                        message = message + "<a href=\"https://support.jdownloader.org/knowledgebase/article/error-skipped-captcha-is-required\">https://support.jdownloader.org/knowledgebase/article/error-skipped-captcha-is-required</a>";
                    } else if ("es".equals(lang)) {
                        title = "Se requiere un solucionador externo para este desaf\u00edo de CAPTCHA";
                        message = message + "El tipo interactivo de desaf\u00edo CAPTCHA '" + captcha_challenge_type_final + "' no puede resolverse actualmente de forma local en tu navegador.<br><br>";
                        message = message + "Por lo tanto, en JD solo tienes la opci\u00f3n de utilizar un servicio de resoluci\u00f3n de captchas posiblemente de pago que pueda manejar este tipo de CAPTCHA.<br><br>";
                        message = message + "JD es compatible con varios servicios de resoluci\u00f3n de CAPTCHA que se enumeran en el art\u00edculo enlazado a continuaci\u00f3n.<br><br>";
                        message = message + "Para obtener informaci\u00f3n m\u00e1s detallada, lee el siguiente art\u00edculo de ayuda:<br>";
                        message = message + "<a href=\"https://support.jdownloader.org/knowledgebase/article/error-skipped-captcha-is-required\">https://support.jdownloader.org/knowledgebase/article/error-skipped-captcha-is-required</a>";
                    } else if ("fr".equals(lang)) {
                        title = "Solveur externe requis pour ce d\u00e9fi CAPTCHA";
                        message = message + "Le type interactif de d\u00e9fi CAPTCHA '" + captcha_challenge_type_final + "' ne peut actuellement pas \u00eatre r\u00e9solu localement dans votre navigateur.<br><br>";
                        message = message + "Par cons\u00e9quent, dans JD, votre seule option est d\u2019utiliser un service de r\u00e9solution de CAPTCHA potentiellement payant capable de traiter ce type de CAPTCHA.<br><br>";
                        message = message + "JD prend en charge plusieurs services de r\u00e9solution de CAPTCHA list\u00e9s dans l\u2019article ci-dessous.<br><br>";
                        message = message + "Pour plus d\u2019informations d\u00e9taill\u00e9es, veuillez consulter l\u2019article d\u2019aide ci-dessous :<br>";
                        message = message + "<a href=\"https://support.jdownloader.org/knowledgebase/article/error-skipped-captcha-is-required\">https://support.jdownloader.org/knowledgebase/article/error-skipped-captcha-is-required</a>";
                    } else if ("hi".equals(lang)) {
                        title = "\u0907\u0938 CAPTCHA \u091a\u0941\u0928\u094c\u0924\u0940 \u0915\u0947 \u0932\u093f\u090f \u092c\u093e\u0939\u0930\u0940 \u0938\u0949\u0932\u094d\u0935\u0930 \u0906\u0935\u0936\u094d\u092f\u0915 \u0939\u0948";
                        message = message + "CAPTCHA \u091a\u0941\u0928\u094c\u0924\u0940 '" + captcha_challenge_type_final + "' \u0915\u0940 \u0907\u0902\u091f\u0930\u090f\u0915\u094d\u091f\u093f\u0935 \u092a\u094d\u0930\u0915\u0943\u0924\u093f \u0915\u094b \u0906\u092a\u0915\u0947 \u092c\u094d\u0930\u093e\u0909\u091c\u093c\u0930 \u092e\u0947\u0902 \u0935\u0930\u094d\u0924\u092e\u093e\u0928 \u092e\u0947\u0902 \u0938\u094d\u0925\u093e\u0928\u0940\u092f \u0930\u0942\u092a \u0938\u0947 \u0939\u0932 \u0928\u0939\u0940\u0902 \u0915\u093f\u092f\u093e \u091c\u093e \u0938\u0915\u0924\u093e\u0964<br><br>";
                        message = message + "\u0907\u0938\u0932\u093f\u090f JD \u092e\u0947\u0902 \u0906\u092a\u0915\u093e \u090f\u0915\u092e\u093e\u0924\u094d\u0930 \u0935\u093f\u0915\u0932\u094d\u092a \u090f\u0915 \u0938\u0902\u092d\u093e\u0935\u093f\u0924 \u0938\u0936\u0941\u0932\u094d\u0915 CAPTCHA \u0938\u092e\u093e\u0927\u093e\u0928 \u0938\u0947\u0935\u093e \u0915\u093e \u0909\u092a\u092f\u094b\u0917 \u0915\u0930\u0928\u093e \u0939\u0948 \u091c\u094b \u0907\u0938 \u092a\u094d\u0930\u0915\u093e\u0930 \u0915\u0947 CAPTCHA \u0915\u094b \u0938\u0902\u092d\u093e\u0932 \u0938\u0915\u0947\u0964<br><br>";
                        message = message + "JD \u0915\u0908 CAPTCHA \u0938\u092e\u093e\u0927\u093e\u0928 \u0938\u0947\u0935\u093e\u0913\u0902 \u0915\u093e \u0938\u092e\u0930\u094d\u0925\u0928 \u0915\u0930\u0924\u093e \u0939\u0948, \u091c\u093f\u0928\u094d\u0939\u0947\u0902 \u0928\u0940\u091a\u0947 \u0926\u093f\u090f \u0917\u090f \u0932\u0947\u0916 \u092e\u0947\u0902 \u0938\u0942\u091a\u0940\u092c\u0926\u094d\u0927 \u0915\u093f\u092f\u093e \u0917\u092f\u093e \u0939\u0948\u0964<br><br>";
                        message = message + "\u0905\u0927\u093f\u0915 \u0935\u093f\u0938\u094d\u0924\u0943\u0924 \u091c\u093e\u0928\u0915\u093e\u0930\u0940 \u0915\u0947 \u0932\u093f\u090f \u0915\u0943\u092a\u092f\u093e \u0928\u0940\u091a\u0947 \u0926\u093f\u092f\u093e \u0917\u092f\u093e \u0938\u0939\u093e\u092f\u0924\u093e \u0932\u0947\u0916 \u092a\u0922\u093c\u0947\u0902:<br>";
                        message = message + "<a href=\"https://support.jdownloader.org/knowledgebase/article/error-skipped-captcha-is-required\">https://support.jdownloader.org/knowledgebase/article/error-skipped-captcha-is-required</a>";
                    } else if ("zh".equals(lang) || "zh-cn".equals(lang)) {
                        title = "\u6b64\u9a8c\u8bc1\u7801\u6311\u6218\u9700\u8981\u5916\u90e8\u89e3\u7b54\u670d\u52a1";
                        message = message + "\u4ea4\u4e92\u5f0f\u9a8c\u8bc1\u7801\u6311\u6218 '" + captcha_challenge_type_final + "' \u5f53\u524d\u65e0\u6cd5\u5728\u60a8\u7684\u6d4f\u89c8\u5668\u4e2d\u672c\u5730\u5b8c\u6210\u3002<br><br>";
                        message = message + "\u56e0\u6b64\uff0c\u5728 JD \u4e2d\uff0c\u60a8\u53ea\u80fd\u4f7f\u7528\u80fd\u591f\u5904\u7406\u6b64\u7c7b\u9a8c\u8bc1\u7801\u7684\u53ef\u80fd\u9700\u8981\u4ed8\u8d39\u7684\u9a8c\u8bc1\u7801\u89e3\u7b54\u670d\u52a1\u3002<br><br>";
                        message = message + "JD \u652f\u6301\u591a\u4e2a\u9a8c\u8bc1\u7801\u89e3\u7b54\u670d\u52a1\uff0c\u5177\u4f53\u5217\u8868\u8bf7\u53c2\u9605\u4ee5\u4e0b\u6587\u7ae0\u3002<br><br>";
                        message = message + "\u6709\u5173\u66f4\u8be6\u7ec6\u7684\u4fe1\u606f\uff0c\u8bf7\u9605\u8bfb\u4ee5\u4e0b\u5e2e\u52a9\u6587\u7ae0\uff1a<br>";
                        message = message + "<a href=\"https://support.jdownloader.org/knowledgebase/article/error-skipped-captcha-is-required\">https://support.jdownloader.org/knowledgebase/article/error-skipped-captcha-is-required</a>";
                    } else {
                        title = "External solver required for this captcha challenge";
                        message = message + "The interactive type of captcha challenge '" + captcha_challenge_type_final + "' cannot currently be solved locally in your browser.<br><br>";
                        message = message + "Therefore, in JD your only option is to use a captcha solving service that may require payment and is capable of handling this type of captcha.<br><br>";
                        message = message + "JD supports various captcha solving services listed in the help article below.<br><br>";
                        message = message + "For more detailed information, please read the help article below:<br>";
                        message = message + "<a href=\"https://support.jdownloader.org/knowledgebase/article/error-skipped-captcha-is-required\">https://support.jdownloader.org/knowledgebase/article/error-skipped-captcha-is-required</a>";
                    }
                    message = message + "</html>";
                    ConfirmDialog dialog = new ConfirmDialog(148, title, message);
                    dialog.setTimeout((int)TimeUnit.MINUTES.toMillis(3L));
                    ((ConfirmDialogInterface)UIOManager.I().show(ConfirmDialogInterface.class, (UserIODefinition)dialog)).throwCloseExceptions();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        };
        thread.setDaemon(true);
        thread.start();
        return thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> List<ChallengeSolver<T>> createList(Challenge<T> c) {
        ArrayList<ChallengeSolver<T>> ret = new ArrayList<ChallengeSolver<T>>();
        for (ChallengeSolver<T> challengeSolver : this.solverList) {
            try {
                if (!challengeSolver.isEnabled() || !challengeSolver.validateLogins() || !challengeSolver.canHandle(c) || !challengeSolver.validateBlackWhite(c)) continue;
                ret.add(challengeSolver);
            }
            catch (Throwable e) {
                this.logger.log(e);
            }
        }
        AccountFilter af = new AccountFilter().setEnabled(true).setValid(true).setFeature(LazyPlugin.FEATURE.CAPTCHA_SOLVER);
        ArrayList<Account> arrayList = AccountController.getInstance().listAccounts(af);
        HashSet<String> unavailableSolverDomains = new HashSet<String>();
        for (Account solverAccount : arrayList) {
            boolean bl = false;
            try {
                PluginChallengeSolver<T> solver;
                abstractPluginForCaptchaSolver plugin = (abstractPluginForCaptchaSolver)solverAccount.getPlugin();
                if (!plugin.canHandle(c) || (solver = plugin.getPluginChallengeSolver(c, solverAccount)) == null) continue;
                ret.add(solver);
                bl = true;
            }
            catch (Throwable e) {
                this.logger.log(e);
                this.logger.warning("Exception happened during collecting fitting solver plugins");
            }
            finally {
                if (bl) {
                    unavailableSolverDomains.remove(solverAccount.getHoster());
                    continue;
                }
                unavailableSolverDomains.add(solverAccount.getHoster());
            }
        }
        this.logger.info("Solver accounts that cannot be used for this challenge: " + unavailableSolverDomains);
        if (c.isAccountLogin() && CAPTCHA_SETTINGS.isAvoidAutoSolverForLoginCaptchas()) {
            ArrayList<ChallengeSolver> manualSolvers = new ArrayList<ChallengeSolver>();
            for (ChallengeSolver challengeSolver : ret) {
                if (challengeSolver instanceof CESChallengeSolver) continue;
                manualSolvers.add(challengeSolver);
            }
            if (manualSolvers.size() != 0) {
                ret.clear();
                ret.addAll(manualSolvers);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SolverJob<?> getJobByChallengeId(long id) {
        HashMap<UniqueAlltimeID, SolverJob<?>> hashMap = this.challengeIDToJobMap;
        synchronized (hashMap) {
            return this.challengeIDToJobMap.get((Object)new UniqueAlltimeID(id));
        }
    }

    public List<SolverService> listServices() {
        return new ArrayList<SolverService>(this.serviceList);
    }

    public SolverService getServiceByID(String key) {
        for (SolverService service : this.serviceList) {
            if (!service.getID().equals(key)) continue;
            return service;
        }
        return null;
    }

    public void resetTiming() {
        HashSet<SolverService> dupe = new HashSet<SolverService>();
        for (ChallengeSolver<?> s : this.solverList) {
            if (!dupe.add(s.getService())) continue;
            s.getService().getConfig().setWaitForMap(null);
        }
    }

    public TimeTracker getTracker(String method) {
        return this.trackerCache.getTracker(method);
    }
}

