/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.captcha.v2;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import jd.controlling.captcha.SkipException;
import jd.plugins.Plugin;
import org.appwork.exceptions.WTFException;
import org.appwork.utils.StringUtils;
import org.jdownloader.captcha.v2.AbstractResponse;
import org.jdownloader.captcha.v2.Challenge;
import org.jdownloader.captcha.v2.JobRunnable;
import org.jdownloader.captcha.v2.SolverService;
import org.jdownloader.captcha.v2.solver.browser.AbstractBrowserChallenge;
import org.jdownloader.captcha.v2.solver.jac.SolverException;
import org.jdownloader.captcha.v2.solverjob.SolverJob;

public abstract class ChallengeSolver<T> {
    public static final ChallengeSolver EXTERN = new ChallengeSolver<Object>(){

        @Override
        public void solve(SolverJob<Object> solverJob) throws InterruptedException, SolverException, SkipException {
            throw new WTFException("Not Implemented");
        }
    };
    protected ThreadPoolExecutor threadPool;
    private Class<T> resultType;
    protected SolverService service;
    protected final WeakHashMap<SolverJob<T>, JobRunnable<T>> map = new WeakHashMap();
    private Map<String, Integer> waitForMap = null;

    protected ChallengeSolver() {
    }

    public boolean setInvalid(AbstractResponse<?> response) {
        return false;
    }

    public boolean setUnused(AbstractResponse<?> response) {
        return false;
    }

    public boolean setValid(AbstractResponse<?> response) {
        return false;
    }

    public ChallengeSolver(SolverService service, int i) {
        Type superClass;
        this.service = service;
        if (service == null) {
            this.service = (SolverService)((Object)this);
        }
        this.initThreadPool(i);
        Class cls = this.getClass();
        while (true) {
            if ((superClass = cls.getGenericSuperclass()) == null) {
                throw new IllegalArgumentException("Wrong Construct");
            }
            if (!(superClass instanceof Class)) break;
            cls = (Class)superClass;
        }
        if (!(superClass instanceof ParameterizedType)) {
            throw new IllegalArgumentException("Wrong Construct");
        }
        this.resultType = (Class)((ParameterizedType)superClass).getActualTypeArguments()[0];
    }

    public ChallengeSolver(int i) {
        this(null, i);
    }

    public SolverService getService() {
        return this.service;
    }

    protected boolean validateLogins() {
        return true;
    }

    public boolean isEnabled() {
        return this.getService().getConfig().isEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SolverJob<T>> listJobs() {
        WeakHashMap<SolverJob<T>, JobRunnable<T>> weakHashMap = this.map;
        synchronized (weakHashMap) {
            return new ArrayList<SolverJob<T>>(this.map.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasJobs() {
        WeakHashMap<SolverJob<T>, JobRunnable<T>> weakHashMap = this.map;
        synchronized (weakHashMap) {
            return this.map.size() > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isJobDone(SolverJob<?> job) {
        WeakHashMap<SolverJob<T>, JobRunnable<T>> weakHashMap = this.map;
        synchronized (weakHashMap) {
            return !this.map.containsKey(job);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueue(SolverJob<T> job) {
        JobRunnable<T> jr = new JobRunnable<T>(this, job);
        WeakHashMap<SolverJob<T>, JobRunnable<T>> weakHashMap = this.map;
        synchronized (weakHashMap) {
            this.map.put(job, jr);
            if (this.threadPool == null) {
                new Thread(jr, "ChallengeSolverThread").start();
            } else {
                this.threadPool.execute(jr);
            }
        }
    }

    protected static void checkInterruption() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kill(SolverJob<T> job) {
        if (job == null) {
            return;
        }
        WeakHashMap<SolverJob<T>, JobRunnable<T>> weakHashMap = this.map;
        synchronized (weakHashMap) {
            JobRunnable<T> jr = this.map.remove(job);
            if (jr != null) {
                job.getLogger().info("Cancel " + jr);
                jr.cancel();
            } else {
                job.getLogger().info("Could not kill " + job + " in " + this);
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    private void initThreadPool(int i) {
        if (i <= 0) {
            return;
        }
        this.threadPool = new ThreadPoolExecutor(i, i, 5000L, TimeUnit.MILLISECONDS, new LinkedBlockingDeque<Runnable>(), new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "SolverThread:" + ChallengeSolver.this.toString());
            }
        }, new ThreadPoolExecutor.AbortPolicy());
        this.threadPool.allowCoreThreadTimeOut(true);
    }

    public abstract void solve(SolverJob<T> var1) throws InterruptedException, SolverException, SkipException;

    public Class<T> getResultType() {
        return this.resultType;
    }

    protected boolean isChallengeSupported(Challenge<?> c) {
        return !(c instanceof AbstractBrowserChallenge);
    }

    public boolean canHandle(Challenge<?> c) {
        if (!this.isChallengeSupported(c)) {
            return false;
        }
        if (!this.getResultType().isAssignableFrom(c.getResultType())) {
            return false;
        }
        return this.validateBlackWhite(c);
    }

    public boolean validateBlackWhite(Challenge<?> c) {
        ArrayList<String> blackListEntries;
        if (!this.getService().getConfig().isBlackWhiteListingEnabled()) {
            return true;
        }
        HashSet<String> hosts = new HashSet<String>();
        hosts.add(c.getHost());
        Plugin plugin = c.getPlugin();
        String[] siteSupportedNames = plugin.siteSupportedNames();
        if (siteSupportedNames != null) {
            hosts.addAll(Arrays.asList(siteSupportedNames));
        }
        Boolean result = null;
        ArrayList<String> whiteListEntries = this.getService().getConfig().getWhitelistEntries();
        if (whiteListEntries != null && whiteListEntries.size() > 0) {
            block4: for (String whiteListEntry : whiteListEntries) {
                try {
                    Pattern whiteListPattern = Pattern.compile(whiteListEntry, 2);
                    for (String host : hosts) {
                        Boolean matches = this.match(c, host, whiteListPattern);
                        if (!Boolean.TRUE.equals(matches)) continue;
                        result = Boolean.TRUE;
                        break block4;
                    }
                }
                catch (Throwable e) {
                    c.getPlugin().getLogger().log(e);
                }
            }
        }
        if (result == null && (blackListEntries = this.getService().getConfig().getBlacklistEntries()) != null && blackListEntries.size() > 0) {
            block6: for (String blackListEntry : blackListEntries) {
                try {
                    Pattern blackListPattern = Pattern.compile(blackListEntry, 2);
                    for (String host : hosts) {
                        Boolean matches = this.match(c, host, blackListPattern);
                        if (!Boolean.TRUE.equals(matches)) continue;
                        result = Boolean.FALSE;
                        break block6;
                    }
                }
                catch (Throwable e) {
                    c.getPlugin().getLogger().log(e);
                }
            }
        }
        if (result == null) {
            return true;
        }
        if (result.booleanValue()) {
            plugin.getLogger().info(c + " is whitelisted for " + this);
        } else {
            plugin.getLogger().info(c + " is blacklisted for " + this);
        }
        return result;
    }

    private Boolean match(Challenge<?> c, String host, Pattern pattern) {
        if (!StringUtils.equalsIgnoreCase((String)host, (String)c.getTypeID())) {
            if (pattern.matcher(host + "-" + c.getTypeID()).matches()) {
                return true;
            }
            if (pattern.matcher(host).matches()) {
                return true;
            }
        }
        if (pattern.matcher(c.getTypeID()).matches()) {
            return true;
        }
        return null;
    }

    public long getTimeout() {
        return -1L;
    }

    public int getWaitForByID(String solverID) {
        Integer obj = this.getWaitForMap().get(solverID);
        return obj == null ? 0 : obj;
    }

    public synchronized Map<String, Integer> getWaitForMap() {
        if (this.waitForMap != null) {
            return this.waitForMap;
        }
        Map<String, Integer> map = this.getService().getConfig().getWaitForMap();
        if (map == null || map.size() == 0) {
            map = this.getService().getWaitForOthersDefaultMap();
            this.getService().getConfig().setWaitForMap(map);
        }
        this.waitForMap = Collections.synchronizedMap(map);
        return this.waitForMap;
    }
}

