/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.captcha.v2;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.ScheduledExecutorService;
import jd.controlling.captcha.SkipException;
import org.appwork.scheduler.DelayedRunnable;
import org.appwork.storage.JSonStorage;
import org.appwork.utils.formatter.TimeFormatter;
import org.jdownloader.captcha.v2.ChallengeResponseController;
import org.jdownloader.captcha.v2.ChallengeSolver;
import org.jdownloader.captcha.v2.SolverService;
import org.jdownloader.captcha.v2.solver.service.AbstractSolverService;
import org.jdownloader.captcha.v2.solverjob.SolverJob;

public class JobRunnable<T>
implements Runnable {
    private SolverJob<T> job;
    private ChallengeSolver<T> solver;
    private boolean canceled;
    public static final ScheduledExecutorService TIMINGQUEUE = DelayedRunnable.getNewScheduledExecutorService();
    private Thread thread;

    public JobRunnable(ChallengeSolver<T> challengeSolver, SolverJob<T> job) {
        this.job = job;
        this.solver = challengeSolver;
    }

    public SolverJob<T> getJob() {
        return this.job;
    }

    public void fireTimeoutEvent() {
        if (!this.job.isDone(this.solver)) {
            this.solver.kill(this.job);
            this.job.fireTimeoutEvent(this.solver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            JobRunnable jobRunnable = this;
            synchronized (jobRunnable) {
                block26: {
                    if (!this.canceled) break block26;
                    return;
                }
                this.getJob().getLogger().info(this.solver + " is Active.");
                this.thread = Thread.currentThread();
                this.thread.setName(this.solver + "-Thread");
            }
            this.fireBeforeSolveEvent();
            DelayedRunnable timeout = null;
            if (this.solver.getTimeout() > 0L) {
                timeout = new DelayedRunnable(TIMINGQUEUE, this.solver.getTimeout()){

                    public void delayedrun() {
                        System.out.println("Timeout!");
                        JobRunnable.this.fireTimeoutEvent();
                    }
                };
            }
            try {
                int waitForThisSolver;
                if (timeout != null) {
                    timeout.resetAndStart();
                }
                long startedWaiting = System.currentTimeMillis();
                for (ChallengeSolver<T> s : this.job.getSolverList()) {
                    if (s == this.solver || (waitForThisSolver = this.solver.getService().getWaitForByID(s.getService().getID())) <= 1000) continue;
                    this.job.getLogger().info(this.solver + " will wait up to " + TimeFormatter.formatMilliSeconds((long)waitForThisSolver, (int)0) + " for " + s);
                }
                System.out.println("Logged");
                for (ChallengeSolver<T> s : this.job.getSolverList()) {
                    if (s == this.solver) continue;
                    waitForThisSolver = this.solver.getService().getWaitForByID(s.getService().getID());
                    if ((waitForThisSolver = (int)((long)waitForThisSolver - (System.currentTimeMillis() - startedWaiting))) <= 0) continue;
                    ArrayList<SolverService> waitLoop = AbstractSolverService.validateWaittimeQueue(this.solver.getService(), s.getService());
                    if (waitLoop == null) {
                        if (waitForThisSolver <= 1000) continue;
                        long t = System.currentTimeMillis();
                        this.job.getLogger().info(this.solver + " now waits up to " + TimeFormatter.formatMilliSeconds((long)waitForThisSolver, (int)0) + " for " + s);
                        this.job.waitFor(waitForThisSolver, s);
                        this.job.getLogger().info(this.solver + " actually waited " + TimeFormatter.formatMilliSeconds((long)(System.currentTimeMillis() - t), (int)0) + " for " + s);
                        continue;
                    }
                    this.job.getLogger().info(this.solver + " wait VALIDATION FAILED!" + TimeFormatter.formatMilliSeconds((long)waitForThisSolver, (int)0) + " for " + s);
                    this.job.getLogger().info("Wait Loop- >" + waitLoop + "");
                    try {
                        SolverService lastService = null;
                        for (SolverService le : waitLoop) {
                            if (lastService != null) {
                                this.job.getLogger().info("Wait Loop- " + le.getName() + " waits " + le.getWaitForByID(lastService.getID()) + " for " + lastService.getName() + "");
                            }
                            lastService = le;
                        }
                        HashSet<SolverService> service = new HashSet<SolverService>();
                        for (ChallengeSolver<T> ss : this.job.getSolverList()) {
                            if (!service.add(ss.getService())) continue;
                            this.job.getLogger().info("Debug " + ss.getService().getName());
                            this.job.getLogger().info(ss.getService().getConfig() + "");
                            this.job.getLogger().info(JSonStorage.serializeToJson(ss.getService().getWaitForMapCopy()));
                        }
                    }
                    catch (Throwable e) {
                        this.job.getLogger().log(e);
                    }
                }
                this.job.getLogger().info("Solver Start: " + this.solver);
                this.solver.solve(this.job);
            }
            catch (SkipException e) {
                ChallengeResponseController.getInstance().setSkipRequest(e.getSkipRequest(), this.solver, this.job.getChallenge());
            }
            catch (Throwable e) {
                block28: {
                    this.getJob().getLogger().log(e);
                    if (timeout == null) break block28;
                    timeout.stop();
                }
                this.fireDoneAndAfterSolveEvents();
            }
            finally {
                if (timeout != null) {
                    timeout.stop();
                }
                this.fireDoneAndAfterSolveEvents();
            }
        }
        finally {
            this.thread = null;
        }
    }

    public void fireDoneAndAfterSolveEvents() {
        this.job.setSolverDone(this.solver);
        this.job.fireAfterSolveEvent(this.solver);
    }

    public void fireBeforeSolveEvent() {
        this.job.fireBeforeSolveEvent(this.solver);
    }

    public Thread getThread() {
        return this.thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        JobRunnable jobRunnable = this;
        synchronized (jobRunnable) {
            this.canceled = true;
            Thread locThread = this.thread;
            if (locThread != null && locThread != Thread.currentThread()) {
                this.getJob().getLogger().warning("Interrupt: " + this.solver + " : " + locThread);
                locThread.interrupt();
            } else if (locThread != Thread.currentThread()) {
                this.getJob().getLogger().warning("Could Not Interrupt: " + this.solver + " : " + locThread);
            }
        }
    }
}

