/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.captcha.v2;

import jd.controlling.captcha.SkipException;
import jd.plugins.Account;
import jd.plugins.PluginException;
import org.jdownloader.captcha.v2.AbstractResponse;
import org.jdownloader.captcha.v2.Challenge;
import org.jdownloader.captcha.v2.ChallengeSolver;
import org.jdownloader.captcha.v2.solver.CESSolverJob;
import org.jdownloader.captcha.v2.solver.jac.SolverException;
import org.jdownloader.captcha.v2.solverjob.SolverJob;
import org.jdownloader.plugins.components.captchasolver.PluginForCaptchaSolverSolverService;
import org.jdownloader.plugins.components.captchasolver.abstractPluginForCaptchaSolver;

public class PluginChallengeSolver<T>
extends ChallengeSolver<T> {
    protected final Account account;
    protected final abstractPluginForCaptchaSolver plugin;

    public PluginChallengeSolver(abstractPluginForCaptchaSolver plugin, Account account) {
        this.service = new PluginForCaptchaSolverSolverService(plugin);
        this.account = account;
        this.plugin = plugin;
    }

    public Account getAccount() {
        return this.account;
    }

    @Override
    protected boolean validateLogins() {
        return true;
    }

    @Override
    public boolean canHandle(Challenge<?> c) {
        return this.plugin.canHandle(c);
    }

    @Override
    public boolean setValid(AbstractResponse<?> response) {
        try {
            return this.plugin.setValid(response, this.account);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean setInvalid(AbstractResponse<?> response) {
        try {
            return this.plugin.setInvalid(response, this.account);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean setUnused(AbstractResponse<?> response) {
        try {
            return this.plugin.setUnused(response, this.account);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void solve(SolverJob<T> job) throws InterruptedException, SolverException, SkipException {
        CESSolverJob<T> cesJob = new CESSolverJob<T>(job);
        try {
            this.plugin.solve(cesJob, this.account);
        }
        catch (PluginException e) {
            this.plugin.handleAccountException(this.account, this.plugin.getLogger(), e);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            cesJob.hideBubble();
        }
    }
}

