/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.captcha.v2.challenge.geetest;

import java.io.IOException;
import java.net.URL;
import jd.plugins.Plugin;
import jd.plugins.PluginException;
import org.appwork.exceptions.WTFException;
import org.appwork.net.protocol.http.HTTPConstants;
import org.appwork.net.protocol.http.ResponseCodeInterface;
import org.appwork.remoteapi.exceptions.RemoteAPIException;
import org.appwork.utils.IO;
import org.appwork.utils.StringUtils;
import org.appwork.utils.net.HTTPHeader;
import org.appwork.utils.net.httpserver.requests.GetRequest;
import org.appwork.utils.net.httpserver.requests.HttpRequest;
import org.appwork.utils.net.httpserver.requests.PostRequest;
import org.appwork.utils.net.httpserver.responses.HttpResponse;
import org.jdownloader.captcha.v2.AbstractResponse;
import org.jdownloader.captcha.v2.solver.browser.AbstractBrowserChallenge;
import org.jdownloader.captcha.v2.solver.browser.BrowserReference;

public abstract class GeeTestChallenge
extends AbstractBrowserChallenge {
    private String siteKey;

    public String getSiteKey() {
        return this.siteKey;
    }

    public GeeTestChallenge(String siteKey, Plugin pluginForHost) throws PluginException {
        super("geetest", pluginForHost);
        this.siteKey = siteKey;
        if (siteKey == null || !siteKey.matches("^[a-f0-9]{32}$")) {
            throw new PluginException(0x400000, "Bad SiteKey:" + siteKey);
        }
    }

    @Override
    public boolean onGetRequest(BrowserReference browserReference, GetRequest request, HttpResponse response) throws IOException, RemoteAPIException {
        String parameter = request.getParameterbyKey("response");
        if (StringUtils.isNotEmpty((String)parameter)) {
            browserReference.onResponse(parameter);
            response.setResponseCode((ResponseCodeInterface)HTTPConstants.ResponseCode.SUCCESS_OK);
            response.getResponseHeaders().add(new HTTPHeader("Content-Type", "text/html; charset=utf-8"));
            response.getOutputStream(true).write("Please Close the Browser now".getBytes("UTF-8"));
            return true;
        }
        return super.onGetRequest(browserReference, request, response);
    }

    @Override
    public boolean onPostRequest(BrowserReference browserReference, PostRequest request, HttpResponse response) throws IOException, RemoteAPIException {
        return false;
    }

    @Override
    public String getHTML(HttpRequest request, String id) {
        try {
            URL url = GeeTestChallenge.class.getResource("geetestchallenge.html");
            String html = IO.readURLToString((URL)url);
            html = html.replace("%%%sitekey%%%", this.siteKey);
            return html;
        }
        catch (IOException e) {
            throw new WTFException((Throwable)e);
        }
    }

    @Override
    protected String getCaptchaNameSpace() {
        return "geetest";
    }

    @Override
    public boolean validateResponse(AbstractResponse<String> response) {
        return super.validateResponse(response) && this.isCaptchaResponseValid();
    }

    @Override
    public boolean isCaptchaResponseValid() {
        return super.isCaptchaResponseValid() && ((String)this.getResult().getValue()).matches("[\\w-]{30,}");
    }

    protected final String getChallengeID() {
        return null;
    }

    protected final String getSecret() {
        return null;
    }
}

