/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.captcha.v2.challenge.hcaptcha;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import jd.controlling.linkcrawler.CrawledLink;
import jd.http.Browser;
import jd.http.Request;
import jd.parser.html.Form;
import jd.plugins.DownloadLink;
import jd.plugins.Plugin;
import jd.plugins.PluginException;
import jd.plugins.PluginForDecrypt;
import jd.plugins.PluginForHost;
import org.appwork.utils.Regex;
import org.appwork.utils.StringUtils;
import org.appwork.utils.logging2.LogInterface;
import org.appwork.utils.net.httpconnection.HTTPConnection;
import org.jdownloader.captcha.v2.challenge.hcaptcha.HCaptchaChallenge;
import org.jdownloader.logging.LogController;

public class AbstractHCaptcha<T extends Plugin> {
    protected final T plugin;
    protected final LogInterface logger;
    protected final Browser br;
    protected String siteKey;
    private static final String apiKeyRegex = "[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}";
    private final String siteDomain;
    protected static final HashSet<String> INVALID_SITE_KEYS = new HashSet();

    public static boolean containsHCaptcha(Browser br) {
        return br != null && AbstractHCaptcha.containsHCaptcha(br.toString());
    }

    public static boolean containsHCaptcha(String string) {
        return string != null && (new Regex(string, "https?://(\\w+\\.)?hcaptcha\\.com/1/api.js").matches() || new Regex(string, "class\\s*=\\s*('|\")h-captcha(-response)?(\\1|\\s+)").matches());
    }

    public static boolean containsHCaptcha(Form form) {
        return form != null && AbstractHCaptcha.containsHCaptcha(form.getHtmlCode());
    }

    public static final boolean isValidSiteKey(String siteKey) {
        return siteKey != null && siteKey.matches("^[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}$");
    }

    public int getSolutionTimeout() {
        return 120000;
    }

    public String getSiteDomain() {
        return this.siteDomain;
    }

    public TYPE getType() {
        return this.getType(this.br != null ? this.br.toString() : null);
    }

    protected TYPE getType(String source) {
        String[] divs;
        if (source != null && (divs = this.getDIVs(source)) != null) {
            for (String div : divs) {
                boolean isInvisible;
                String siteKey;
                if (!new Regex(div, "class\\s*=\\s*('|\")(?:.*?\\s+)?(g-re|h-)captcha(-response)?(\\1|\\s+)").matches() || (siteKey = new Regex(div, "data-sitekey\\s*=\\s*('|\")\\s*([a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12})\\s*\\1").getMatch(1)) == null || !StringUtils.equals((String)siteKey, (String)this.getSiteKey()) || !(isInvisible = new Regex(div, "data-size\\s*=\\s*('|\")\\s*(invisible)\\s*\\1").matches())) continue;
                return TYPE.INVISIBLE;
            }
        }
        return TYPE.NORMAL;
    }

    protected String getSiteUrl() {
        String siteDomain = this.getSiteDomain();
        String url = null;
        Request request = this.br != null ? this.br.getRequest() : null;
        boolean canUseRequestURL = request != null && request.getHttpConnection() != null && HTTPConnection.RequestMethod.GET.equals((Object)request.getRequestMethod()) && StringUtils.containsIgnoreCase((String)request.getHttpConnection().getContentType(), (String)"html");
        boolean rewriteHost = true;
        String defaultProtocol = "http://";
        if (this.plugin != null) {
            CrawledLink crawledLink;
            if (((Plugin)this.plugin).getMatcher().pattern().pattern().matches(".*(https?).*")) {
                defaultProtocol = "https://";
            }
            if (this.plugin instanceof PluginForHost) {
                DownloadLink downloadLink = ((PluginForHost)this.plugin).getDownloadLink();
                if (downloadLink != null) {
                    url = downloadLink.getPluginPatternMatcher();
                }
            } else if (this.plugin instanceof PluginForDecrypt && (crawledLink = ((PluginForDecrypt)this.plugin).getCurrentLink()) != null) {
                url = crawledLink.getURL();
            }
            if (url != null && request != null) {
                String referer = request.getHeaders().getValue("Referer");
                if (referer != null && ((Plugin)this.plugin).canHandle(referer) && canUseRequestURL) {
                    rewriteHost = false;
                    url = request.getUrl();
                } else {
                    url = url.replaceAll("^(?i)(https?://)", request.getURL().getProtocol() + "://");
                }
            }
            if (StringUtils.equals((String)url, (String)siteDomain) || StringUtils.equals((String)url, (String)((Plugin)this.plugin).getHost())) {
                url = request != null ? request.getURL().getProtocol() + "://" + url : defaultProtocol + url;
            }
        }
        if (url == null && request != null && canUseRequestURL) {
            url = request.getUrl();
        }
        if (url != null) {
            url = url.replaceAll("(#.+)", "");
            String urlDomain = Browser.getHost((String)url, (boolean)true);
            if (rewriteHost && !StringUtils.equalsIgnoreCase((String)urlDomain, (String)siteDomain)) {
                url = url.replaceFirst(Pattern.quote(urlDomain), siteDomain);
            }
            return url;
        }
        if (request != null) {
            return request.getURL().getProtocol() + "://" + siteDomain;
        }
        return defaultProtocol + siteDomain;
    }

    public AbstractHCaptcha(T plugin, Browser br, String siteKey) {
        this.plugin = plugin;
        this.br = br.cloneBrowser();
        if (br.getRequest() == null) {
            throw new IllegalStateException("Browser.getRequest() == null!");
        }
        this.siteDomain = Browser.getHost((String)br.getURL(), (boolean)true);
        this.logger = this.createFallbackLogger(plugin);
        this.siteKey = siteKey;
    }

    protected LogInterface createFallbackLogger(T plugin) {
        LogInterface ret = null;
        if (plugin != null) {
            ret = ((Plugin)plugin).getLogger();
        }
        if (ret == null) {
            Class<?> cls = this.getClass();
            String name = cls.getSimpleName();
            while (StringUtils.isEmpty((String)name)) {
                cls = cls.getSuperclass();
                name = cls.getSimpleName();
            }
            ret = LogController.getInstance().getLogger(name);
        }
        return ret;
    }

    protected void runDdosPrevention() throws InterruptedException {
        if (this.plugin != null) {
            ((Plugin)this.plugin).runCaptchaDDosProtection(HCaptchaChallenge.getChallengeType());
        }
    }

    public T getPlugin() {
        return this.plugin;
    }

    public String getSiteKey() {
        return this.getSiteKey(this.br != null ? this.br.toString() : null);
    }

    protected String[] getDIVs(String source) {
        return new Regex(source, "<\\s*(div|button)(?:[^>]*>.*?</\\1>|[^>]*\\s*/\\s*>)").getColumn(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getSiteKey(String source) {
        String siteKey;
        if (this.siteKey != null) {
            return this.siteKey;
        }
        if (source == null) {
            return null;
        }
        String findNextSiteKeySource = source;
        HashSet<String> siteKeys = new HashSet<String>();
        while (StringUtils.isNotEmpty((String)findNextSiteKeySource) && (siteKey = this.findNextSiteKey(findNextSiteKeySource)) != null) {
            siteKeys.add(siteKey);
            findNextSiteKeySource = findNextSiteKeySource.replace(siteKey, "");
        }
        HashSet<String> hashSet = INVALID_SITE_KEYS;
        synchronized (hashSet) {
            this.logger.info("Auto siteKeys unfiltered:" + siteKeys);
            siteKeys.removeAll(INVALID_SITE_KEYS);
            this.logger.info("Auto siteKeys filtered:" + siteKeys);
        }
        this.siteKey = this.findCorrectSiteKeys(source, this.br, siteKeys);
        return this.siteKey;
    }

    protected String findCorrectSiteKeys(String source, Browser br, Set<String> siteKeys) {
        if (siteKeys.size() == 0) {
            this.logger.info("No siteKey found!");
            return null;
        }
        if (siteKeys.size() == 1) {
            String siteKey = siteKeys.iterator().next();
            this.logger.info("Auto single siteKey:" + siteKey);
            return siteKey;
        }
        this.logger.info("Auto multiple siteKeys:" + siteKeys);
        if (br == null) {
            String siteKey = siteKeys.iterator().next();
            this.logger.info("No browser available?! Use first known siteKey:" + siteKey);
            return siteKey;
        }
        this.logger.info("Could not auto find siteKey!");
        return null;
    }

    protected String findNextSiteKey(String source) {
        String jsSource;
        String siteKey;
        String[] scripts;
        String siteKey2;
        String[] divs = this.getDIVs(source);
        if (divs != null) {
            for (String div : divs) {
                if (!new Regex(div, "class\\s*=\\s*('|\")(?:.*?\\s+)?(g-re|h-)captcha(-response)?(\\1|\\s+)").matches() || (siteKey2 = new Regex(div, "data-sitekey\\s*=\\s*('|\")\\s*([a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12})\\s*\\1").getMatch(1)) == null) continue;
                return siteKey2;
            }
        }
        if ((scripts = new Regex(source, "<\\s*script\\s+(?:.*?<\\s*/\\s*script\\s*>|[^>]+\\s*/\\s*>)").getColumn(-1)) != null) {
            for (String script : scripts) {
                siteKey2 = new Regex(script, "data-sitekey\\s*=\\s*('|\")\\s*([a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12})\\s*\\1").getMatch(1);
                if (siteKey2 == null) continue;
                return siteKey2;
            }
        }
        if ((siteKey = new Regex(jsSource = new Regex(source, "hcaptcha\\.render\\s*\\(.*?,\\s*\\{(.*?)\\s*\\}\\s*\\)\\s*;").getMatch(0), "('|\"|)sitekey\\1\\s*:\\s*('|\"|)\\s*([a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12})\\s*\\2").getMatch(2)) != null) {
            return siteKey;
        }
        jsSource = new Regex(source, "hcaptcha\\.render\\s*\\(\\s*\\{(.*?)\\s*\\}\\s*\\)\\s*;").getMatch(0);
        siteKey = new Regex(jsSource, "('|\"|)sitekey\\1\\s*:\\s*('|\"|)\\s*([a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12})\\s*\\2").getMatch(2);
        if (siteKey != null) {
            return siteKey;
        }
        Form[] forms = Form.getForms(source);
        if (forms != null) {
            for (Form form : forms) {
                siteKey2 = new Regex(form.getHtmlCode(), "data-sitekey\\s*=\\s*('|\")\\s*([a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12})\\s*\\1").getMatch(1);
                if (siteKey2 == null) continue;
                return siteKey2;
            }
        }
        return null;
    }

    protected HCaptchaChallenge createChallenge() throws PluginException {
        return new HCaptchaChallenge(this.getSiteKey(), (Plugin)this.getPlugin(), this.br, this.getSiteDomain()){

            @Override
            public String getSiteUrl() {
                return AbstractHCaptcha.this.getSiteUrl();
            }

            public AbstractHCaptcha<T> getAbstractCaptchaHelperHCaptcha() {
                return AbstractHCaptcha.this;
            }

            @Override
            public String getType() {
                TYPE type = AbstractHCaptcha.this.getType();
                if (type != null) {
                    return type.name();
                }
                return TYPE.NORMAL.name();
            }

            @Override
            protected LogInterface getLogger() {
                return AbstractHCaptcha.this.logger;
            }
        };
    }

    public static enum TYPE {
        NORMAL,
        INVISIBLE;

    }
}

