/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.captcha.v2.challenge.recaptcha.v2;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import jd.controlling.linkcrawler.CrawledLink;
import jd.http.Browser;
import jd.http.Request;
import jd.parser.html.Form;
import jd.plugins.DownloadLink;
import jd.plugins.Plugin;
import jd.plugins.PluginException;
import jd.plugins.PluginForDecrypt;
import jd.plugins.PluginForHost;
import org.appwork.utils.Regex;
import org.appwork.utils.StringUtils;
import org.appwork.utils.encoding.Base64;
import org.appwork.utils.logging2.LogInterface;
import org.appwork.utils.net.httpconnection.HTTPConnection;
import org.jdownloader.captcha.v2.challenge.recaptcha.v2.RecaptchaV2Challenge;
import org.jdownloader.logging.LogController;

public abstract class AbstractRecaptchaV2<T extends Plugin> {
    protected final T plugin;
    protected final LogInterface logger;
    protected final Browser br;
    protected String siteKey;
    protected String secureToken;
    private final String siteDomain;
    public static final String apiKeyRegex = "6L[\\w-_]{14,}";
    protected static final HashMap<String, Set<String>> INVALID_SITE_KEYS = new HashMap();

    public String getSecureToken() {
        return this.getSecureToken(this.br != null ? this.br.toString() : null);
    }

    public static boolean containsSupportedRecaptcha(Browser br) {
        return br != null && (AbstractRecaptchaV2.containsRecaptchaV2Class(br) || AbstractRecaptchaV2.containsRecaptchaV3(br));
    }

    public static boolean containsSupportedRecaptcha(Form form) {
        return form != null && (AbstractRecaptchaV2.containsRecaptchaV2Class(form) || AbstractRecaptchaV2.containsRecaptchaV3(form));
    }

    public static boolean containsSupportedRecaptcha(String string) {
        return string != null && (AbstractRecaptchaV2.containsRecaptchaV2Class(string) || AbstractRecaptchaV2.containsRecaptchaV3(string));
    }

    public static boolean containsRecaptchaV2Class(Browser br) {
        return br != null && AbstractRecaptchaV2.containsRecaptchaV2Class(br.toString());
    }

    public static boolean containsRecaptchaV2Class(String string) {
        return string != null && (new Regex(string, "class\\s*=\\s*('|\")g-recaptcha(-response)?(\\1|\\s+)").patternFind() || new Regex(string, "document\\.getElementById\\(('|\")g-recaptcha(-response)?(\\1|\\s+)").patternFind());
    }

    public static boolean containsRecaptchaV3(Browser br) {
        return br != null && AbstractRecaptchaV2.containsRecaptchaV3(br.toString());
    }

    public static boolean containsRecaptchaV3(Form form) {
        return form != null && AbstractRecaptchaV2.containsRecaptchaV3(form.getHtmlCode());
    }

    public static boolean containsRecaptchaV3(String string) {
        return string != null && new Regex(string, "grecaptcha(?:\\.enterprise)?\\.execute\\s*\\(").matches();
    }

    public static boolean containsRecaptchaV2Class(Form form) {
        return form != null && AbstractRecaptchaV2.containsRecaptchaV2Class(form.getHtmlCode());
    }

    public int getSolutionTimeout() {
        return 60000;
    }

    protected final Map<String, Object> getV3Action() {
        return this.getV3Action(this.br != null ? this.br.toString() : null);
    }

    public final VERSION getVersion() {
        return this.getVersion(this.br != null ? this.br.toString() : null);
    }

    protected VERSION getVersion(String source) {
        if (this.getV3Action(source) != null) {
            return VERSION.V3;
        }
        return VERSION.V2;
    }

    protected Map<String, Object> getV3Action(String source) {
        if (source == null) {
            return null;
        }
        String actionJson = new Regex(source, "grecaptcha(?:\\.enterprise)?\\.execute\\s*\\([^{]*,\\s*(\\{.*?\\}\\s*)").getMatch(0);
        String action = null;
        action = actionJson != null ? new Regex(actionJson, "action(?:\"|')?\\s*:\\s*(?:\"|')(.*?)(\"|')").getMatch(0) : this.getAlternativeV3Action(source);
        if (action != null) {
            HashMap<String, Object> ret = new HashMap<String, Object>();
            ret.put("action", action);
            return ret;
        }
        return null;
    }

    protected String getAlternativeV3Action(String source) {
        if (source == null) {
            return null;
        }
        String[] divs = this.getDIVs(source);
        if (divs == null || divs.length == 0) {
            return null;
        }
        for (String div : divs) {
            String action;
            String siteKey;
            if (!new Regex(div, "class\\s*=\\s*('|\")(?:.*?\\s+)?g-recaptcha(-response)?(\\1|\\s+)").patternFind() || (siteKey = new Regex(div, "data-sitekey\\s*=\\s*('|\")\\s*(6L[\\w-_]{14,})\\s*\\1").getMatch(1)) == null || !StringUtils.equals((String)siteKey, (String)this.getSiteKey()) || (action = new Regex(div, "data-action\\s*=\\s*('|\")\\s*(.*?)\\s*\\1").getMatch(1)) == null) continue;
            return action;
        }
        return null;
    }

    protected boolean isEnterprise() {
        return this.isEnterprise(this.br != null ? this.br.toString() : null);
    }

    protected boolean isEnterprise(String source) {
        return StringUtils.contains((String)source, (String)"/recaptcha/enterprise.js") || StringUtils.contains((String)source, (String)"grecaptcha.enterprise.");
    }

    protected String getSecureToken(String source) {
        if (this.secureToken == null) {
            this.secureToken = new Regex(source, "&stoken=([^\"]+)").getMatch(0);
            if (this.secureToken == null) {
                this.secureToken = new Regex(source, "data-stoken\\s*=\\s*\"\\s*([^\"]+)").getMatch(0);
            }
        }
        return this.secureToken;
    }

    public TYPE getType() {
        return this.getType(this.br != null ? this.br.toString() : null);
    }

    protected TYPE getType(String source) {
        if (source == null) {
            return null;
        }
        if (this.getV3Action(source) != null) {
            return TYPE.INVISIBLE;
        }
        String[] divs = this.getDIVs(source);
        if (divs == null || divs.length == 0) {
            return null;
        }
        for (String div : divs) {
            boolean isInvisible;
            String siteKey;
            if (!new Regex(div, "class\\s*=\\s*('|\")(?:.*?\\s+)?g-recaptcha(-response)?(\\1|\\s+)").matches() || (siteKey = new Regex(div, "data-sitekey\\s*=\\s*('|\")\\s*(6L[\\w-_]{14,})\\s*\\1").getMatch(1)) == null || !StringUtils.equals((String)siteKey, (String)this.getSiteKey()) || !(isInvisible = new Regex(div, "data-size\\s*=\\s*('|\")\\s*(invisible)\\s*\\1").matches())) continue;
            return TYPE.INVISIBLE;
        }
        return TYPE.NORMAL;
    }

    public void setSecureToken(String secureToken) {
        this.secureToken = secureToken;
    }

    public String getSiteDomain() {
        return this.siteDomain;
    }

    protected String getSiteUrl() {
        String siteDomain = this.getSiteDomain();
        String url = null;
        Request request = this.br != null ? this.br.getRequest() : null;
        boolean canUseRequestURL = request != null && request.getHttpConnection() != null && HTTPConnection.RequestMethod.GET.equals((Object)request.getRequestMethod()) && StringUtils.containsIgnoreCase((String)request.getHttpConnection().getContentType(), (String)"html");
        boolean rewriteHost = true;
        String defaultProtocol = "http://";
        if (this.plugin != null) {
            CrawledLink crawledLink;
            if (((Plugin)this.plugin).getMatcher().pattern().pattern().matches(".*(https?).*")) {
                defaultProtocol = "https://";
            }
            if (this.plugin instanceof PluginForHost) {
                DownloadLink downloadLink = ((PluginForHost)this.plugin).getDownloadLink();
                if (downloadLink != null) {
                    url = downloadLink.getPluginPatternMatcher();
                }
            } else if (this.plugin instanceof PluginForDecrypt && (crawledLink = ((PluginForDecrypt)this.plugin).getCurrentLink()) != null) {
                url = crawledLink.getURL();
            }
            if (url != null && request != null) {
                String referer = request.getHeaders().getValue("Referer");
                if (referer != null && ((Plugin)this.plugin).canHandle(referer) && canUseRequestURL) {
                    rewriteHost = false;
                    url = request.getUrl();
                } else {
                    url = url.replaceAll("^(?i)(https?://)", request.getURL().getProtocol() + "://");
                }
            }
            if (StringUtils.equals((String)url, (String)siteDomain) || StringUtils.equals((String)url, (String)((Plugin)this.plugin).getHost())) {
                url = request != null ? request.getURL().getProtocol() + "://" + url : defaultProtocol + url;
            }
        }
        if (url == null && request != null && canUseRequestURL) {
            url = request.getUrl();
        }
        if (url != null) {
            url = url.replaceAll("(#.+)", "");
            String urlDomain = Browser.getHost((String)url, (boolean)true);
            if (rewriteHost && !StringUtils.equalsIgnoreCase((String)urlDomain, (String)siteDomain)) {
                url = url.replaceFirst(Pattern.quote(urlDomain), siteDomain);
            }
            return url;
        }
        if (request != null) {
            return request.getURL().getProtocol() + "://" + siteDomain;
        }
        return defaultProtocol + siteDomain;
    }

    public Double getMinScore() {
        return null;
    }

    public AbstractRecaptchaV2(T plugin, Browser br, String siteKey, String secureToken, boolean boundToDomain) {
        this.plugin = plugin;
        this.br = br.cloneBrowser();
        if (br.getRequest() == null) {
            throw new IllegalStateException("Browser.getRequest() == null!");
        }
        this.siteDomain = Browser.getHost((String)br.getURL(), (boolean)true);
        this.logger = this.createFallbackLogger(plugin);
        this.siteKey = siteKey;
        this.secureToken = secureToken;
    }

    protected LogInterface createFallbackLogger(T plugin) {
        LogInterface ret = null;
        if (plugin != null) {
            ret = ((Plugin)plugin).getLogger();
        }
        if (ret == null) {
            Class<?> cls = this.getClass();
            String name = cls.getSimpleName();
            while (StringUtils.isEmpty((String)name)) {
                cls = cls.getSuperclass();
                name = cls.getSimpleName();
            }
            ret = LogController.getInstance().getLogger(name);
        }
        return ret;
    }

    protected void runDdosPrevention() throws InterruptedException {
        if (this.plugin != null) {
            ((Plugin)this.plugin).runCaptchaDDosProtection("recaptchav2");
        }
    }

    public T getPlugin() {
        return this.plugin;
    }

    public String getSiteKey() {
        return this.getSiteKey(this.br != null ? this.br.toString() : null);
    }

    public static final boolean isValidSiteKey(String siteKey) {
        return siteKey != null && siteKey.matches("(?i)^6L[\\w-_]{14,}$");
    }

    protected String[] getDIVs(String source) {
        return new Regex(source, "<\\s*(div|button)(?:[^>]*>.*?</\\1>|[^>]*\\s*/\\s*>)").getColumn(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getSiteKey(String source) {
        String siteKey;
        if (this.siteKey != null) {
            return this.siteKey;
        }
        if (source == null) {
            return null;
        }
        String findNextSiteKeySource = source;
        HashSet<String> siteKeys = new HashSet<String>();
        while (StringUtils.isNotEmpty((String)findNextSiteKeySource) && (siteKey = this.findNextSiteKey(findNextSiteKeySource)) != null) {
            siteKeys.add(siteKey);
            findNextSiteKeySource = findNextSiteKeySource.replace(siteKey, "");
        }
        HashMap<String, Set<String>> hashMap = INVALID_SITE_KEYS;
        synchronized (hashMap) {
            this.logger.info("Auto siteKeys unfiltered:" + siteKeys);
            Set<String> invalidSiteKeys = INVALID_SITE_KEYS.get(((Plugin)this.getPlugin()).getHost());
            if (invalidSiteKeys != null) {
                siteKeys.removeAll(invalidSiteKeys);
            }
            this.logger.info("Auto siteKeys filtered:" + siteKeys);
        }
        this.siteKey = this.findCorrectSiteKeys(source, this.br, siteKeys);
        return this.siteKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String findCorrectSiteKeys(String source, Browser br, Set<String> siteKeys) {
        if (siteKeys.size() == 0) {
            this.logger.info("No siteKey found!");
            return null;
        }
        if (siteKeys.size() == 1) {
            String siteKey = siteKeys.iterator().next();
            this.logger.info("Auto single siteKey:" + siteKey);
            return siteKey;
        }
        this.logger.info("Auto multiple siteKeys:" + siteKeys);
        if (br == null) {
            String siteKey = siteKeys.iterator().next();
            this.logger.info("No browser available?! Use first known siteKey:" + siteKey);
            return siteKey;
        }
        URL url = br._getURL();
        String co = Base64.encode((String)(url.getProtocol() + "://" + url.getHost() + ":" + (url.getPort() == -1 ? url.getDefaultPort() : url.getPort()))).replace("=", ".");
        Iterator<String> it = siteKeys.iterator();
        while (it.hasNext()) {
            Browser brc = br.cloneBrowser();
            String siteKey = it.next();
            try {
                brc.getPage("https://www.google.com/recaptcha/api2/anchor?k=" + siteKey + "&co=" + co);
                if (brc.containsHTML("Invalid site key")) {
                    HashMap<String, Set<String>> hashMap = INVALID_SITE_KEYS;
                    synchronized (hashMap) {
                        Set<String> invalidSiteKeys = INVALID_SITE_KEYS.get(((Plugin)this.getPlugin()).getHost());
                        if (invalidSiteKeys == null) {
                            invalidSiteKeys = new HashSet<String>();
                            INVALID_SITE_KEYS.put(((Plugin)this.getPlugin()).getHost(), invalidSiteKeys);
                        }
                        invalidSiteKeys.add(siteKey);
                    }
                    this.logger.info("SiteKey:" + siteKey + " seems to be invalid!");
                    it.remove();
                    continue;
                }
                this.logger.info("SiteKey:" + siteKey + " seems to be valid!");
                return siteKey;
            }
            catch (IOException e) {
                this.logger.log((Throwable)e);
            }
        }
        this.logger.info("Could not auto find siteKey!");
        return null;
    }

    protected String findNextSiteKey(String source) {
        String jsSource;
        String siteKey;
        String[] iframes;
        String[] scripts;
        String siteKey2;
        String[] divs = this.getDIVs(source);
        if (divs != null) {
            for (String div : divs) {
                if (!new Regex(div, "class\\s*=\\s*('|\")(?:.*?\\s+)?g-recaptcha(-response)?(\\1|\\s+)").matches() && !new Regex(div, "class\\s*=\\s*('|\")(?:.*?\\s+)?recaptcha-submit(\\1|\\s+)").matches() || (siteKey2 = new Regex(div, "data-sitekey\\s*=\\s*('|\")\\s*(6L[\\w-_]{14,})\\s*\\1").getMatch(1)) == null) continue;
                return siteKey2;
            }
        }
        if ((scripts = new Regex(source, "<\\s*script\\s+(?:.*?<\\s*/\\s*script\\s*>|[^>]+\\s*/\\s*>)").getColumn(-1)) != null) {
            for (String script : scripts) {
                siteKey2 = new Regex(script, "data-sitekey\\s*=\\s*('|\")\\s*(6L[\\w-_]{14,})\\s*\\1").getMatch(1);
                if (siteKey2 != null) {
                    return siteKey2;
                }
                siteKey2 = new Regex(script, "google\\.\\w+/recaptcha/(?:enterprise|api)\\.js\\?render=(6L[\\w-_]{14,})").getMatch(0);
                if (siteKey2 == null) continue;
                return siteKey2;
            }
        }
        if ((iframes = new Regex(source, "<\\s*iframe\\s+(?:.*?<\\s*/\\s*iframe\\s*>|[^>]+\\s*/\\s*>)").getColumn(-1)) != null) {
            for (String iframe : iframes) {
                siteKey2 = new Regex(iframe, "google\\.com/recaptcha/(?:api|enterprise)/fallback\\?k=(6L[\\w-_]{14,})").getMatch(0);
                if (siteKey2 == null) continue;
                return siteKey2;
            }
        }
        if ((siteKey = new Regex(jsSource = new Regex(source, "recaptcha(?:\\.enterprise)?\\.render\\s*\\(.*?,\\s*\\{(.*?)\\s*\\}\\s*\\)\\s*;").getMatch(0), "('|\"|)sitekey\\1\\s*:\\s*('|\"|)\\s*(6L[\\w-_]{14,})\\s*\\2").getMatch(2)) != null) {
            return siteKey;
        }
        jsSource = new Regex(source, "recaptcha(?:\\.enterprise)?\\.render\\s*\\(\\s*\\{(.*?)\\s*\\}\\s*\\)\\s*;").getMatch(0);
        siteKey = new Regex(jsSource, "('|\"|)sitekey\\1\\s*:\\s*('|\"|)\\s*(6L[\\w-_]{14,})\\s*\\2").getMatch(2);
        if (siteKey != null) {
            return siteKey;
        }
        String siteKey3 = new Regex(source, "grecaptcha(?:\\.enterprise)?\\.execute\\s*\\(\\s*('|\")\\s*(6L[\\w-_]{14,})\\s*\\1").getMatch(1);
        if (siteKey3 != null) {
            return siteKey3;
        }
        Form[] forms = Form.getForms(source);
        if (forms != null) {
            for (Form form : forms) {
                siteKey2 = new Regex(form.getHtmlCode(), "data-sitekey\\s*=\\s*('|\")\\s*(6L[\\w-_]{14,})\\s*\\1").getMatch(1);
                if (siteKey2 == null) continue;
                return siteKey2;
            }
        }
        return null;
    }

    protected RecaptchaV2Challenge createChallenge() throws PluginException {
        return new RecaptchaV2Challenge(this.getSiteKey(), this.getSecureToken(), (Plugin)this.getPlugin(), this.br, this.getSiteDomain()){

            @Override
            public boolean isEnterprise() {
                return AbstractRecaptchaV2.this.isEnterprise();
            }

            @Override
            public boolean isV3() {
                return VERSION.V3.equals((Object)AbstractRecaptchaV2.this.getVersion());
            }

            @Override
            public Double getMinScore() {
                return AbstractRecaptchaV2.this.getMinScore();
            }

            @Override
            public String getSiteUrl() {
                return AbstractRecaptchaV2.this.getSiteUrl();
            }

            public AbstractRecaptchaV2<T> getAbstractCaptchaHelperRecaptchaV2() {
                return AbstractRecaptchaV2.this;
            }

            @Override
            public Map<String, Object> getV3Action() {
                return AbstractRecaptchaV2.this.getV3Action();
            }

            @Override
            public String getType() {
                TYPE type = AbstractRecaptchaV2.this.getType();
                if (type != null) {
                    return type.name();
                }
                return TYPE.NORMAL.name();
            }

            @Override
            protected LogInterface getLogger() {
                return AbstractRecaptchaV2.this.logger;
            }
        };
    }

    public static enum VERSION {
        V2,
        V3;

    }

    public static enum TYPE {
        NORMAL,
        INVISIBLE;

    }
}

