/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.captcha.v2.challenge.recaptcha.v2;

import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import jd.http.Browser;
import jd.http.Request;
import jd.nutils.encoding.Encoding;
import jd.nutils.encoding.HTMLEntities;
import jd.plugins.Plugin;
import jd.plugins.PluginException;
import org.appwork.exceptions.WTFException;
import org.appwork.net.protocol.http.HTTPConstants;
import org.appwork.net.protocol.http.ResponseCodeInterface;
import org.appwork.remoteapi.exceptions.RemoteAPIException;
import org.appwork.storage.SimpleMapper;
import org.appwork.storage.Storable;
import org.appwork.utils.Application;
import org.appwork.utils.Hash;
import org.appwork.utils.IO;
import org.appwork.utils.Regex;
import org.appwork.utils.StringUtils;
import org.appwork.utils.logging2.LogInterface;
import org.appwork.utils.net.HTTPHeader;
import org.appwork.utils.net.httpserver.requests.GetRequest;
import org.appwork.utils.net.httpserver.requests.HttpRequest;
import org.appwork.utils.net.httpserver.requests.KeyValuePair;
import org.appwork.utils.net.httpserver.requests.PostRequest;
import org.appwork.utils.net.httpserver.responses.HttpResponse;
import org.appwork.utils.parser.UrlQuery;
import org.jdownloader.captcha.v2.AbstractResponse;
import org.jdownloader.captcha.v2.ChallengeSolver;
import org.jdownloader.captcha.v2.challenge.recaptcha.v2.AbstractRecaptchaV2;
import org.jdownloader.captcha.v2.challenge.recaptcha.v2.Recaptcha2BrowserViewport;
import org.jdownloader.captcha.v2.challenge.stringcaptcha.BasicCaptchaChallenge;
import org.jdownloader.captcha.v2.challenge.stringcaptcha.CaptchaResponse;
import org.jdownloader.captcha.v2.solver.browser.AbstractBrowserChallenge;
import org.jdownloader.captcha.v2.solver.browser.BrowserReference;
import org.jdownloader.captcha.v2.solver.browser.BrowserViewport;
import org.jdownloader.captcha.v2.solver.browser.BrowserWindow;
import org.jdownloader.captcha.v2.solver.service.BrowserSolverService;
import org.jdownloader.gui.translate._GUI;

public abstract class RecaptchaV2Challenge
extends AbstractBrowserChallenge {
    public static final String RAWTOKEN = "rawtoken";
    public static final String RECAPTCHAV2 = "recaptchav2";
    private final String siteKey;
    private volatile BasicCaptchaChallenge basicChallenge;
    private final String siteDomain;
    private final String secureToken;
    private final boolean localhost = true;
    private Browser br;

    public String getSiteKey() {
        return this.siteKey;
    }

    @Override
    public AbstractResponse<String> parseAPIAnswer(String result, String resultFormat, ChallengeSolver<?> solver) {
        BasicCaptchaChallenge basic;
        if (RAWTOKEN.equals(resultFormat) || "extension".equals(resultFormat)) {
            return new CaptchaResponse(this, solver, result, 100);
        }
        if (this.hasBasicCaptchaChallenge() && (basic = this.createBasicCaptchaChallenge(false)) != null) {
            return basic.parseAPIAnswer(result, resultFormat, solver);
        }
        return super.parseAPIAnswer(result, resultFormat, solver);
    }

    @Override
    public Object getAPIStorable(String format) throws Exception {
        if (RAWTOKEN.equals(format)) {
            RecaptchaV2APIStorable ret = new RecaptchaV2APIStorable();
            ret.setSiteKey(this.getSiteKey());
            String siteUrl = this.getSiteUrl();
            String protocol = StringUtils.startsWithCaseInsensitive((String)"https://", (String)siteUrl) ? "https://" : "http://";
            ret.setEnterprise(this.isEnterprise());
            ret.setContextUrl(protocol + this.getSiteDomain());
            ret.setSiteUrl(siteUrl);
            ret.setStoken(this.getSecureToken());
            Map<String, Object> v3Action = this.getV3Action();
            if (v3Action != null) {
                ret.setV3Action(new SimpleMapper().setPrettyPrintEnabled(false).objectToString(v3Action));
            }
            ret.setType(this.getType());
            return ret;
        }
        BasicCaptchaChallenge basic = this.createBasicCaptchaChallenge(true);
        if (basic != null) {
            return basic.getAPIStorable(format);
        }
        return super.getAPIStorable(format);
    }

    @Override
    public BrowserViewport getBrowserViewport(BrowserWindow screenResource, Rectangle elementBounds) {
        Rectangle rect = null;
        int sleep = 500;
        for (int i = 0; i < 3; ++i) {
            try {
                Thread.sleep(sleep);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            rect = screenResource.getRectangleByColor(0xFF9900, 0, 0, 50.0, elementBounds.x, elementBounds.y);
            if (rect != null) break;
            sleep *= 2;
        }
        if (rect != null) {
            return new Recaptcha2BrowserViewport(screenResource, rect, elementBounds){

                @Override
                protected LogInterface getLogger() {
                    return RecaptchaV2Challenge.this.getLogger();
                }
            };
        }
        return null;
    }

    @Override
    public void cleanup() {
        super.cleanup();
        BasicCaptchaChallenge basicChallenge = this.basicChallenge;
        if (basicChallenge != null) {
            basicChallenge.cleanup();
        }
    }

    public RecaptchaV2Challenge(String siteKey, String secureToken, Plugin pluginForHost, Browser br, String siteDomain) throws PluginException {
        super(RECAPTCHAV2, pluginForHost, br);
        this.secureToken = secureToken;
        this.siteKey = siteKey;
        this.siteDomain = siteDomain;
        if (!AbstractRecaptchaV2.isValidSiteKey(siteKey)) {
            throw new PluginException(0x400000, "Bad SiteKey:" + siteKey);
        }
    }

    public abstract Double getMinScore();

    public abstract boolean isV3();

    public abstract boolean isEnterprise();

    public AbstractRecaptchaV2<?> getAbstractCaptchaHelperRecaptchaV2() {
        return null;
    }

    public boolean isInvisible() {
        return AbstractRecaptchaV2.TYPE.INVISIBLE.name().equals(this.getType());
    }

    public abstract String getType();

    public String getSiteUrl() {
        return null;
    }

    public String getSecureToken() {
        return this.secureToken;
    }

    public String getSiteDomain() {
        return this.siteDomain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onPostRequest(final BrowserReference brRef, final PostRequest request, HttpResponse response) throws IOException, RemoteAPIException {
        RecaptchaV2Challenge recaptchaV2Challenge = this;
        synchronized (recaptchaV2Challenge) {
            String pDo = request.getParameterbyKey("do");
            String refOrg = request.getRequestHeaders().get("Referer").getValue();
            String ref = UrlQuery.parse((String)refOrg).getDecoded("do");
            if (StringUtils.isEmpty((String)ref)) {
                ref = "http://" + this.getSiteDomain();
            }
            if (pDo.startsWith("/recaptcha/api2/reload?")) {
                this.ensureBrowser();
                String rawPost = IO.readInputStreamToString((InputStream)request.getInputStream());
                this.br.setKeepResponseContentBytes(true);
                jd.http.requests.PostRequest r = this.br.createPostRequest("https://www.google.com" + pDo, new ArrayList(), null);
                r.setPostDataString(rawPost);
                r.getHeaders().put("Referer", ref);
                this.forward((HttpRequest)request, response, this.br, (Request)r, new Modifier(){

                    @Override
                    public byte[] onData(byte[] bytes) {
                        try {
                            String str = new String(bytes, "UTF-8");
                            str = RecaptchaV2Challenge.this.replace(brRef, str);
                            return str.getBytes("UTF-8");
                        }
                        catch (UnsupportedEncodingException e) {
                            throw new WTFException((Throwable)e);
                        }
                    }
                });
                return true;
            }
            if (pDo.startsWith("/recaptcha/api2/replaceimage?")) {
                this.ensureBrowser();
                String rawPost = IO.readInputStreamToString((InputStream)request.getInputStream());
                this.br.setKeepResponseContentBytes(true);
                jd.http.requests.PostRequest r = this.br.createPostRequest("https://www.google.com" + pDo, new ArrayList(), null);
                r.setPostDataString(rawPost);
                r.getHeaders().put("Referer", ref);
                this.forward((HttpRequest)request, response, this.br, (Request)r, new Modifier(){

                    @Override
                    public byte[] onData(byte[] bytes) {
                        try {
                            String str = new String(bytes, "UTF-8");
                            str = RecaptchaV2Challenge.this.replace(brRef, str);
                            return str.getBytes("UTF-8");
                        }
                        catch (UnsupportedEncodingException e) {
                            throw new WTFException((Throwable)e);
                        }
                    }
                });
                return true;
            }
            if (pDo.startsWith("/recaptcha/api2/userverify?")) {
                this.ensureBrowser();
                String rawPost = IO.readInputStreamToString((InputStream)request.getInputStream());
                this.br.setKeepResponseContentBytes(true);
                jd.http.requests.PostRequest r = this.br.createPostRequest("https://www.google.com" + pDo, new ArrayList(), null);
                System.out.println("Verify: " + rawPost);
                r.setPostDataString(rawPost);
                r.getHeaders().put("Referer", ref);
                this.forward((HttpRequest)request, response, this.br, (Request)r, new Modifier(){

                    @Override
                    public byte[] onData(byte[] bytes) {
                        try {
                            String str = new String(bytes, "UTF-8");
                            System.out.println(str);
                            str = str.replaceAll(Pattern.quote(RecaptchaV2Challenge.this.getSiteDomain()) + "(:\\d+)?", request.getRequestHeaders().getValue("Host"));
                            str = RecaptchaV2Challenge.this.replace(brRef, str);
                            return str.getBytes("UTF-8");
                        }
                        catch (UnsupportedEncodingException e) {
                            throw new WTFException((Throwable)e);
                        }
                    }
                });
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onGetRequest(final BrowserReference brRef, final GetRequest request, HttpResponse response) throws IOException, RemoteAPIException {
        RecaptchaV2Challenge recaptchaV2Challenge = this;
        synchronized (recaptchaV2Challenge) {
            jd.http.requests.GetRequest r;
            String refOrg;
            String pDo = request.getParameterbyKey("do");
            HTTPHeader referer = request.getRequestHeaders().get("Referer");
            String ref = "http://" + this.getSiteDomain();
            if (referer != null && StringUtils.isEmpty((String)(ref = UrlQuery.parse((String)(refOrg = referer.getValue())).getDecoded("do")))) {
                ref = "http://" + this.getSiteDomain();
            }
            if ("/recaptcha/api.js".equals(pDo)) {
                this.ensureBrowser();
                String url = "https://www.google.com" + pDo;
                for (int i = 2; i < request.getRequestedURLParameters().size(); ++i) {
                    url = url + (i == 2 ? "?" : "&");
                    url = url + ((KeyValuePair)request.getRequestedURLParameters().get((int)i)).key + "=" + Encoding.urlEncode((String)((KeyValuePair)request.getRequestedURLParameters().get((int)i)).value);
                }
                jd.http.requests.GetRequest r2 = new jd.http.requests.GetRequest(url);
                r2.getHeaders().put("Referer", ref);
                this.forward((HttpRequest)request, response, this.br, (Request)r2, new Modifier(){

                    @Override
                    public byte[] onData(byte[] bytes) {
                        try {
                            String str = new String(bytes, "UTF-8");
                            return str.getBytes("UTF-8");
                        }
                        catch (UnsupportedEncodingException e) {
                            throw new WTFException((Throwable)e);
                        }
                    }
                });
                return true;
            }
            if (pDo.startsWith("https://www.google.com/recaptcha/api2/frame?")) {
                this.ensureBrowser();
                r = new jd.http.requests.GetRequest(pDo);
                r.getHeaders().put("Referer", ref);
                this.forward((HttpRequest)request, response, this.br, (Request)r, new Modifier(){

                    @Override
                    public byte[] onData(byte[] bytes) {
                        try {
                            String str = new String(bytes, "UTF-8");
                            str = str.replaceAll(Pattern.quote(RecaptchaV2Challenge.this.getSiteDomain()) + "(:\\d+)?", request.getRequestHeaders().getValue("Host"));
                            str = RecaptchaV2Challenge.this.replace(brRef, str);
                            return str.getBytes("UTF-8");
                        }
                        catch (UnsupportedEncodingException e) {
                            throw new WTFException((Throwable)e);
                        }
                    }
                });
                return true;
            }
            if (pDo.startsWith("https://www.google.com/recaptcha/api2/payload?")) {
                this.ensureBrowser();
                r = new jd.http.requests.GetRequest(pDo);
                r.getHeaders().put("Referer", ref);
                this.forwardHeader("User-Agent", (Request)r, (HttpRequest)request);
                this.forwardHeader("Accept-Language", (Request)r, (HttpRequest)request);
                this.forwardHeader("User-Agent", (Request)r, (HttpRequest)request);
                r.setKeepByteArray(true);
                this.br.setKeepResponseContentBytes(true);
                this.br.getPage((Request)r);
                byte[] bytes = r.getResponseBytes();
                this.saveTile(bytes, pDo);
                response.setResponseCode((ResponseCodeInterface)HTTPConstants.ResponseCode.SUCCESS_OK);
                this.forwardHeader("Expires", (Request)r, response);
                this.forwardHeader("Date", (Request)r, response);
                this.forwardHeader("Cache-Control", (Request)r, response);
                this.forwardHeader("Content-Type", (Request)r, response);
                this.forwardHeader("Server", (Request)r, response);
                response.getResponseHeaders().add(new HTTPHeader("Content-Length", bytes.length + ""));
                response.getOutputStream(true).write(bytes);
                return true;
            }
            if (pDo.startsWith("https://www.google.com/recaptcha/api2/anchor?")) {
                this.ensureBrowser();
                r = new jd.http.requests.GetRequest(pDo);
                r.getHeaders().put("Referer", ref);
                this.forward((HttpRequest)request, response, this.br, (Request)r, new Modifier(){

                    @Override
                    public byte[] onData(byte[] bytes) {
                        try {
                            String str = new String(bytes, "UTF-8");
                            str = str.replaceAll(Pattern.quote(RecaptchaV2Challenge.this.getSiteDomain()) + "(:\\d+)?", request.getRequestHeaders().getValue("Host"));
                            str = RecaptchaV2Challenge.this.replace(brRef, str);
                            String anchorJS = IO.readURLToString((URL)RecaptchaV2Challenge.class.getResource("recaptchaAnchor.js"));
                            str = str.replace("</script></body></html>", anchorJS + "</script></body></html>");
                            return str.getBytes("UTF-8");
                        }
                        catch (Throwable e) {
                            throw new WTFException(e);
                        }
                    }
                });
                return true;
            }
            if (pDo.startsWith("https://www.google.com/recaptcha/api2/webworker.js?")) {
                this.ensureBrowser();
                r = new jd.http.requests.GetRequest(pDo);
                r.getHeaders().put("Referer", ref);
                this.forward((HttpRequest)request, response, this.br, (Request)r, new Modifier(){

                    @Override
                    public byte[] onData(byte[] bytes) {
                        try {
                            String str = new String(bytes, "UTF-8");
                            str = RecaptchaV2Challenge.this.replace(brRef, str);
                            return str.getBytes("UTF-8");
                        }
                        catch (UnsupportedEncodingException e) {
                            throw new WTFException((Throwable)e);
                        }
                    }
                });
                return true;
            }
            if (Pattern.compile("https?\\:\\/\\/www\\.gstatic\\.com/recaptcha/api2/r(\\d+)/recaptcha__([a-zA-Z_]+).js", 2).matcher(pDo).matches()) {
                this.ensureBrowser();
                r = new jd.http.requests.GetRequest(pDo);
                r.getHeaders().put("Referer", ref);
                this.forward((HttpRequest)request, response, this.br, (Request)r, new Modifier(){

                    @Override
                    public byte[] onData(byte[] bytes) {
                        try {
                            String str = new String(bytes, "UTF-8");
                            str = RecaptchaV2Challenge.this.modifyRecaptchaJS(brRef, str);
                            str = RecaptchaV2Challenge.this.replace(brRef, str);
                            return str.getBytes("UTF-8");
                        }
                        catch (UnsupportedEncodingException e) {
                            throw new WTFException((Throwable)e);
                        }
                    }
                });
                return true;
            }
            if (pDo.startsWith("https://www.google.com/recaptcha/api2/bframe?")) {
                this.ensureBrowser();
                r = new jd.http.requests.GetRequest(pDo);
                r.getHeaders().put("Referer", ref);
                this.forward((HttpRequest)request, response, this.br, (Request)r, new Modifier(){

                    @Override
                    public byte[] onData(byte[] bytes) {
                        try {
                            String str = new String(bytes, "UTF-8");
                            str = str.replaceAll(Pattern.quote(RecaptchaV2Challenge.this.getSiteDomain()) + "(:\\d+)?", request.getRequestHeaders().getValue("Host"));
                            str = RecaptchaV2Challenge.this.modifyRecaptchaJS(brRef, str);
                            str = RecaptchaV2Challenge.this.replace(brRef, str);
                            return str.getBytes("UTF-8");
                        }
                        catch (UnsupportedEncodingException e) {
                            throw new WTFException((Throwable)e);
                        }
                    }
                });
                return true;
            }
            if ("solve".equals(pDo)) {
                String responsetoken = request.getParameterbyKey("response");
                brRef.onResponse(responsetoken);
                response.setResponseCode((ResponseCodeInterface)HTTPConstants.ResponseCode.SUCCESS_OK);
                response.getResponseHeaders().add(new HTTPHeader("Content-Type", "text/html; charset=utf-8"));
                response.getOutputStream(true).write("Please Close the Browser now".getBytes("UTF-8"));
                return true;
            }
            return false;
        }
    }

    protected String modifyRecaptchaJS(BrowserReference brRef, String js2) {
        try {
            this.check("(([a-zA-Z0-9]+)=([a-zA-Z0-9]+)\\[3\\]==([a-zA-Z0-9]+)\\[3\\]&&([a-zA-Z0-9]+)\\[1\\]==([a-zA-Z0-9]+)\\[1\\]&&([a-zA-Z0-9]+)\\[4\\]==([a-zA-Z0-9]+)\\[4\\])", js2);
            this.check("(var ([a-zA-Z0-9]+)=[a-zA-Z0-9]+\\(\"anchor\"\\);)([a-zA-Z0-9]+\\.[a-zA-Z0-9]+\\.anchor=)", js2);
            this.check("([a-zA-Z0-9]+\\.prototype\\.send=function\\([a-zA-Z0-9]+,[a-zA-Z0-9]+,[a-zA-Z0-9]+\\)\\{([a-zA-Z0-9]+)=this\\.[a-zA-Z0-9]+\\[[a-zA-Z0-9]+\\];)", js2);
            this.check("var ([a-zA-z0-9]+)\\s*=\\s*new ([a-zA-z0-9]+)\\(window\\.location\\)\\;", js2);
            this.check("([a-zA-z0-9]+\\.prototype\\.toString=function\\(\\)\\{var [a-zA-z0-9]+=\\[\\]\\,[a-zA-z0-9]+=this.[a-zA-z0-9]+\\;.*[a-zA-z0-9]+\\.push.*?[a-zA-z0-9]+\\.push.*?[a-zA-z0-9]+\\.push.*?[a-zA-z0-9]+\\.push.*?[a-zA-z0-9]+\\.push.*?[a-zA-z0-9]+\\.push.*?[a-zA-z0-9]+\\.push.*?[a-zA-z0-9]+\\.push.*?[a-zA-z0-9]+\\.push.*?;)return ([a-zA-z0-9]+)\\.join\\(\"\"\\)\\}", js2);
            String js = js2.replaceAll("(([a-zA-Z0-9]+)=([a-zA-Z0-9]+)\\[3\\]==([a-zA-Z0-9]+)\\[3\\]&&([a-zA-Z0-9]+)\\[1\\]==([a-zA-Z0-9]+)\\[1\\]&&([a-zA-Z0-9]+)\\[4\\]==([a-zA-Z0-9]+)\\[4\\])", "$2=$3;$1");
            js = js.replaceAll("(var ([a-zA-Z0-9]+)=[a-zA-Z0-9]+\\(\"anchor\"\\);)([a-zA-Z0-9]+\\.[a-zA-Z0-9]+\\.anchor=)", "$1$2=\"%%%baseUrl%%%/proxy\";$3");
            js = js.replaceAll("([a-zA-Z0-9]+\\.prototype\\.send=function\\([a-zA-Z0-9]+,[a-zA-Z0-9]+,[a-zA-Z0-9]+\\)\\{([a-zA-Z0-9]+)=this\\.[a-zA-Z0-9]+\\[[a-zA-Z0-9]+\\];)", "$0$2.path=\"*\";");
            js = js.replaceAll("var ([a-zA-z0-9]+)\\s*=\\s*new ([a-zA-z0-9]+)\\(window\\.location\\)\\;", "function LWindow(url){this.url=url;}LWindow.prototype.toString=function(){return this.url;};var $1= new $2(new LWindow(\"http://" + this.getSiteDomain() + "\"));");
            js = js.replaceAll("([a-zA-z0-9]+\\.prototype\\.toString=function\\(\\)\\{var [a-zA-z0-9]+=\\[\\]\\,[a-zA-z0-9]+=this.[a-zA-z0-9]+\\;.*[a-zA-z0-9]+\\.push.*?[a-zA-z0-9]+\\.push.*?[a-zA-z0-9]+\\.push.*?[a-zA-z0-9]+\\.push.*?[a-zA-z0-9]+\\.push.*?[a-zA-z0-9]+\\.push.*?[a-zA-z0-9]+\\.push.*?[a-zA-z0-9]+\\.push.*?[a-zA-z0-9]+\\.push.*?;)return ([a-zA-z0-9]+)\\.join\\(\"\"\\)\\}", "$1 return \"%%%baseUrl%%%/?id=%%%session%%%&do=\"+encodeURIComponent($2.join(\"\"));}");
            return js;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    private void check(String string, String js2) {
        if (js2.replaceAll(string, "AFFENKOPF").equals(js2)) {
            System.out.println("DOES NOT MATCH: " + string);
        }
    }

    protected void saveTile(byte[] bytes, String url) throws IOException {
        int i = 0;
        File file = null;
        do {
            file = Application.getResource((String)("tmp/rc2/" + (UrlQuery.parse((String)url).get("id") == null ? "grid" : "tile") + "/" + i + "_" + Hash.getMD5((byte[])bytes) + ".png"));
            ++i;
        } while (file.exists());
        file.getParentFile().mkdirs();
        IO.writeToFile((File)file, (byte[])bytes);
    }

    private void ensureBrowser() {
        if (this.br == null) {
            this.br = new Browser();
            BrowserSolverService.fillCookies(this.br);
        }
    }

    private void forward(HttpRequest request, HttpResponse response, Browser br, Request r, Modifier modifier) throws IOException {
        this.forwardHeader("User-Agent", r, request);
        this.forwardHeader("Accept-Language", r, request);
        this.forwardHeader("User-Agent", r, request);
        r.setKeepByteArray(true);
        br.setKeepResponseContentBytes(true);
        br.getPage(r);
        byte[] bytes = r.getResponseBytes();
        if (modifier != null) {
            bytes = modifier.onData(bytes);
        }
        response.setResponseCode((ResponseCodeInterface)HTTPConstants.ResponseCode.SUCCESS_OK);
        this.forwardHeader("Expires", r, response);
        this.forwardHeader("Date", r, response);
        this.forwardHeader("Cache-Control", r, response);
        this.forwardHeader("Content-Type", r, response);
        this.forwardHeader("Server", r, response);
        response.getResponseHeaders().add(new HTTPHeader("Content-Length", bytes.length + ""));
        response.getOutputStream(true).write(bytes);
    }

    private void forwardHeader(String header, Request r, HttpRequest request) {
        String h = request.getRequestHeaders().getValue(header);
        if (StringUtils.isNotEmpty((String)h)) {
            r.getHeaders().put(new HTTPHeader(header, h));
        }
    }

    private void forwardHeader(String header, Request r, HttpResponse response) {
        String h = r.getResponseHeader(header);
        if (StringUtils.isNotEmpty((String)h)) {
            response.getResponseHeaders().add(new HTTPHeader(header, h));
        }
    }

    private String replace(BrowserReference browserReference, String js) {
        String regex = "(https\\:\\/\\/www\\.gstatic\\.com\\/recaptcha\\/api2\\/r\\d+/recaptcha__[a-zA-Z]+\\.js)";
        String actualUrl = new Regex(js, "(https\\:\\/\\/www\\.gstatic\\.com\\/recaptcha\\/api2\\/r\\d+/recaptcha__[a-zA-Z]+\\.js)").getMatch(0);
        js = js.replaceAll(regex, "?id=" + browserReference.getId().getID() + "&do=" + Encoding.urlEncode((String)actualUrl));
        js = js.replace("%%%session%%%", String.valueOf(browserReference.getId().getID()));
        js = js.replace("%%%siteDomain%%%", this.getSiteDomain());
        js = js.replace("%%%baseUrl%%%", browserReference.getBase());
        try {
            js = js.replace("%%%baseHost%%%", new URL(browserReference.getBase()).getHost());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        js = js.replace("%%%basePort%%%", browserReference.getBasePort() + "");
        return js;
    }

    protected String getChallengeType() {
        String ret = null;
        for (Class<?> cls = this.getClass(); cls != null && StringUtils.isEmpty(ret); cls = cls.getSuperclass()) {
            ret = cls.getSimpleName();
        }
        return ret;
    }

    @Override
    public String getHTML(HttpRequest request, String id) {
        try {
            String userAgent = request.getRequestHeaders().getValue("User-Agent");
            boolean isSafari = userAgent != null && userAgent.toLowerCase(Locale.ENGLISH).matches("(?s).*^((?!chrome|android|crios|fxios).)*safari.*");
            boolean isEdge = userAgent != null && userAgent.toLowerCase(Locale.ENGLISH).matches(".*edge\\/.*");
            URL url = RecaptchaV2Challenge.class.getResource("recaptcha.html");
            String html = IO.readURLToString((URL)url);
            html = html.replace("%%%challengeType%%%", this.getChallengeType());
            html = html.replace("%%%headTitle%%%", _GUI.T.recaptchav2_head_title());
            html = html.replace("%%%headDescription%%%", _GUI.T.recaptchav2_head_description());
            html = html.replace("%%%captchaHeader%%%", _GUI.T.recaptchav2_header());
            html = html.replace("%%%unsupportedBrowserHeader%%%", _GUI.T.extension_unsupported_browser_header());
            html = html.replace("%%%unsupportedBrowserDescription%%%", _GUI.T.extension_unsupported_browser_description());
            html = html.replace("%%%helpHeader%%%", _GUI.T.extension_help_header());
            html = html.replace("%%%helpDescription%%%", _GUI.T.extension_help_description());
            html = html.replace("%%%helpDescriptionLinkTitle%%%", _GUI.T.extension_help_description_link_title());
            html = html.replace("%%%extensionSupportHeader%%%", _GUI.T.extension_support_header());
            html = html.replace("%%%extensionSupportDescription%%%", _GUI.T.extension_support_description());
            html = html.replace("%%%extensionSupportLinkTitle%%%", _GUI.T.extension_support_link_title());
            html = html.replace("%%%siteUrl%%%", StringUtils.valueOrEmpty((String)this.getSiteUrl()));
            html = html.replace("%%%siteDomain%%%", this.getSiteDomain());
            html = html.replace("%%%sitekey%%%", this.getSiteKey());
            html = html.replace("%%%sitekeyType%%%", this.getType());
            html = html.replace("%%%enterprise%%%", String.valueOf(this.isEnterprise()));
            Map<String, Object> v3Action = this.getV3Action();
            if (v3Action == null) {
                html = html.replace("%%%v3action%%%", "");
            } else {
                String v3ActionString = new SimpleMapper().setPrettyPrintEnabled(false).objectToString(v3Action);
                v3ActionString = HTMLEntities.htmlDoubleQuotes((String)v3ActionString);
                html = html.replace("%%%v3action%%%", v3ActionString);
            }
            html = html.replace("%%%unsupportedBrowser%%%", isSafari || isEdge ? "block" : "none");
            html = html.replace("%%%display%%%", "none");
            html = html.replace("%%%noExtensionHeader%%%", _GUI.T.extension_required_header());
            html = html.replace("%%%noExtensionDescription%%%", _GUI.T.extension_required_description());
            html = html.replace("%%%noExtensionLinkTitle%%%", _GUI.T.extension_required_link_title());
            html = html.replace("%%%installExtensionHeader%%%", _GUI.T.install_extension_header());
            html = html.replace("%%%installExtensionDone%%%", _GUI.T.install_extension_done());
            html = html.replace("%%%installExtensionUsingOtherBrowser%%%", _GUI.T.install_extension_using_other_browser());
            html = html.replace("%%%installExtensionShowAllBrowsers%%%", _GUI.T.install_extension_show_all_browsers_link());
            html = html.replace("%%%chromeExtensionHeader%%%", _GUI.T.install_chrome_extension_header());
            html = html.replace("%%%chromeExtensionDescription%%%", _GUI.T.install_chrome_extension_description());
            html = html.replace("%%%chromeExtensionLinkTitle%%%", _GUI.T.install_chrome_extension_link_title());
            html = html.replace("%%%firefoxExtensionHeader%%%", _GUI.T.install_firefox_extension_header());
            html = html.replace("%%%firefoxExtensionDescription%%%", _GUI.T.install_firefox_extension_description());
            html = html.replace("%%%firefoxExtensionLinkTitle%%%", _GUI.T.install_firefox_extension_link_title());
            html = html.replace("%%%operaExtensionHeader%%%", _GUI.T.install_opera_extension_header());
            html = html.replace("%%%operaExtensionDescription%%%", _GUI.T.install_opera_extension_description());
            html = html.replace("%%%operaExtensionLinkTitle%%%", _GUI.T.install_opera_extension_link_title());
            html = html.replace("%%%findMoreAppsLinkTitle%%%", _GUI.T.find_more_apps_link_title());
            html = html.replace("%%%findMoreAppsDescription%%%", _GUI.T.find_more_apps_description());
            html = html.replace("%%%session%%%", id);
            html = html.replace("%%%challengeId%%%", Long.toString(this.getId().getID()));
            html = html.replace("%%%namespace%%%", this.getHttpPath());
            html = html.replace("%%%boundToDomain%%%", String.valueOf(true));
            html = html.replace("%%%sameOrigin%%%", String.valueOf(true));
            String stoken = this.getSecureToken();
            if (StringUtils.isNotEmpty((String)stoken)) {
                html = html.replace("%%%sToken%%%", stoken);
                html = html.replace("%%%optionals%%%", "data-stoken=\"" + stoken + "\"");
            } else {
                html = html.replace("%%%sToken%%%", "");
                html = html.replace("%%%optionals%%%", "");
            }
            return html;
        }
        catch (IOException e) {
            throw new WTFException((Throwable)e);
        }
    }

    @Override
    protected String getHttpPath() {
        if (this.plugin != null) {
            return "captcha/" + this.getCaptchaNameSpace() + "/" + this.getSiteDomain();
        }
        return super.getHttpPath();
    }

    @Override
    protected String getCaptchaNameSpace() {
        if (this.getV3Action() != null || this.isV3()) {
            return "recaptchav3";
        }
        return RECAPTCHAV2;
    }

    @Override
    public boolean isCaptchaResponseValid() {
        return super.isCaptchaResponseValid() && this.isValidResponseToken((String)this.getResult().getValue());
    }

    protected boolean isValidResponseToken(String v) {
        return v != null && v.matches("^[\\w-_]{30,}");
    }

    @Override
    public boolean validateResponse(AbstractResponse<String> response) {
        return super.validateResponse(response) && this.isValidResponseToken(response.getValue());
    }

    @Override
    public void onHandled() {
        super.onHandled();
        BasicCaptchaChallenge basicChallenge = this.basicChallenge;
        if (basicChallenge != null) {
            basicChallenge.onHandled();
        }
    }

    public synchronized boolean hasBasicCaptchaChallenge() {
        return this.basicChallenge != null;
    }

    public synchronized BasicCaptchaChallenge createBasicCaptchaChallenge(boolean showInstallDialog) {
        return this.basicChallenge;
    }

    public Map<String, Object> getV3Action() {
        return null;
    }

    private static interface Modifier {
        public byte[] onData(byte[] var1);
    }

    public static class RecaptchaV2APIStorable
    implements Storable,
    AbstractBrowserChallenge.AbstractBrowserChallengeAPIStorable {
        private String stoken;
        private String type;
        private String v3Action;
        private boolean enterprise = false;
        private String siteKey;
        private String contextUrl;
        private String siteUrl;

        public boolean isEnterprise() {
            return this.enterprise;
        }

        public void setEnterprise(boolean enterprise) {
            this.enterprise = enterprise;
        }

        public String getV3Action() {
            return this.v3Action;
        }

        public void setV3Action(String v3Action) {
            this.v3Action = v3Action;
        }

        @Override
        public String getType() {
            if (this.type == null) {
                return AbstractRecaptchaV2.TYPE.NORMAL.name();
            }
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getStoken() {
            return this.stoken;
        }

        public void setStoken(String stoken) {
            this.stoken = stoken;
        }

        @Override
        public String getSiteKey() {
            return this.siteKey;
        }

        public void setSiteKey(String siteKey) {
            this.siteKey = siteKey;
        }

        @Override
        public String getContextUrl() {
            return this.contextUrl;
        }

        public void setContextUrl(String contextUrl) {
            this.contextUrl = contextUrl;
        }

        @Override
        public String getSiteUrl() {
            return this.siteUrl;
        }

        public void setSiteUrl(String siteUrl) {
            this.siteUrl = siteUrl;
        }

        public boolean isSameOrigin() {
            return true;
        }

        public void setSameOrigin(boolean sameOrigin) {
        }

        public boolean isBoundToDomain() {
            return true;
        }

        public void setBoundToDomain(boolean boundToDomain) {
        }
    }
}

