/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.captcha.v2.solver;

import java.util.EventListener;
import jd.SecondLevelLaunch;
import jd.gui.swing.jdgui.components.premiumbar.ServicePanel;
import jd.http.Browser;
import jd.plugins.Plugin;
import org.appwork.storage.config.ValidationException;
import org.appwork.storage.config.events.GenericConfigEventListener;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.utils.Application;
import org.appwork.utils.logging2.LogInterface;
import org.appwork.utils.logging2.LogSource;
import org.jdownloader.captcha.v2.Challenge;
import org.jdownloader.captcha.v2.ChallengeSolver;
import org.jdownloader.captcha.v2.SolverService;
import org.jdownloader.captcha.v2.challenge.recaptcha.v2.RecaptchaV2Challenge;
import org.jdownloader.captcha.v2.challenge.stringcaptcha.BasicCaptchaChallenge;
import org.jdownloader.captcha.v2.solver.CESSolverJob;
import org.jdownloader.captcha.v2.solver.jac.SolverException;
import org.jdownloader.captcha.v2.solverjob.SolverJob;
import org.jdownloader.plugins.SkipReason;

public abstract class CESChallengeSolver<T>
extends ChallengeSolver<T> {
    protected int getDefaultWaitForOthersTimeout() {
        return 60000;
    }

    public CESChallengeSolver(int threadCount) {
        super(null, threadCount);
    }

    public CESChallengeSolver(SolverService service, int threadCount) {
        super(service, threadCount);
    }

    protected abstract LogSource getLogger();

    @Override
    public final void solve(SolverJob<T> job) throws InterruptedException, SolverException {
        if (!this.validateLogins()) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        if (!this.canHandle(job.getChallenge())) {
            return;
        }
        CESChallengeSolver.checkInterruption();
        CESSolverJob<T> cesJob = new CESSolverJob<T>(job);
        try {
            this.solveCES(cesJob);
        }
        finally {
            cesJob.hideBubble();
        }
    }

    protected Browser createNewBrowserInstance(Challenge<?> challenge) {
        Plugin plugin;
        Browser br = new Browser();
        LogSource logger = null;
        if (challenge != null && (plugin = challenge.getPlugin()) != null) {
            logger = plugin.getLogger();
        }
        if (logger == null) {
            logger = this.getLogger();
        }
        if (logger != null) {
            br.setLogger((LogInterface)logger);
        }
        br.setDebug(true);
        br.setVerbose(true);
        return br;
    }

    protected void solveCES(CESSolverJob<T> job) throws InterruptedException, SolverException {
        BasicCaptchaChallenge challenge = job.getChallenge();
        if (challenge instanceof RecaptchaV2Challenge && (challenge = ((RecaptchaV2Challenge)((Object)challenge)).createBasicCaptchaChallenge(true)) == null) {
            throw new SolverException(SkipReason.PHANTOM_JS_MISSING.getExplanation(null));
        }
        this.solveBasicCaptchaChallenge(job, challenge);
    }

    protected abstract void solveBasicCaptchaChallenge(CESSolverJob<T> var1, BasicCaptchaChallenge var2) throws InterruptedException, SolverException;

    @Override
    protected boolean validateLogins() {
        return false;
    }

    protected void initServicePanel(final KeyHandler ... handlers) {
        if (Application.isHeadless()) {
            return;
        }
        SecondLevelLaunch.GUI_COMPLETE.executeWhenReached(new Runnable(){

            @Override
            public void run() {
                for (KeyHandler k : handlers) {
                    k.getEventSender().addListener((EventListener)new GenericConfigEventListener<Object>(){

                        public void onConfigValidatorError(KeyHandler<Object> keyHandler, Object invalidValue, ValidationException validateException) {
                        }

                        public void onConfigValueModified(KeyHandler<Object> keyHandler, Object newValue) {
                            ServicePanel.getInstance().requestUpdate(true);
                        }
                    });
                }
            }
        });
    }

    public String getAccountStatusString() {
        return null;
    }

    protected boolean looksLikeValidAPIKey(String str) {
        return false;
    }
}

