/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.captcha.v2.solver;

import javax.swing.Icon;
import org.appwork.utils.Application;
import org.appwork.utils.logging2.LogSource;
import org.jdownloader.captcha.v2.AbstractResponse;
import org.jdownloader.captcha.v2.Challenge;
import org.jdownloader.captcha.v2.ChallengeSolver;
import org.jdownloader.captcha.v2.SolverStatus;
import org.jdownloader.captcha.v2.solver.CESChallengeSolver;
import org.jdownloader.captcha.v2.solverjob.SolverJob;
import org.jdownloader.gui.notify.captcha.CESBubble;
import org.jdownloader.gui.notify.captcha.CESBubbleSupport;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.images.NewTheme;
import org.jdownloader.settings.staticreferences.CFG_CAPTCHA;

public class CESSolverJob<T> {
    private final SolverJob<T> job;
    private volatile SolverStatus status;
    private CESBubble bubble;
    private volatile boolean answered;

    public SolverJob<T> getJob() {
        return this.job;
    }

    public CESSolverJob(SolverJob<T> job) {
        this.job = job;
    }

    public Challenge<T> getChallenge() {
        return this.job.getChallenge();
    }

    public void waitFor(int timeout, ChallengeSolver<?> ... instances) throws InterruptedException {
        this.job.waitFor(timeout, instances);
    }

    public LogSource getLogger() {
        return this.job.getLogger();
    }

    public void setStatus(SolverStatus solverStatus) {
        this.status = solverStatus;
    }

    public SolverStatus getStatus() {
        return this.status;
    }

    public void setStatus(String label, Icon icon) {
        this.setStatus(new SolverStatus(label, icon));
        if (this.bubble != null) {
            this.bubble.update();
        }
    }

    public void showBubble(CESChallengeSolver<T> cbSolver) throws InterruptedException {
        if (!Application.isHeadless()) {
            this.showBubble(cbSolver, CFG_CAPTCHA.CFG.getCaptchaExchangeChanceToSkipBubbleTimeout());
        }
    }

    public void showBubble(CESChallengeSolver<T> cbSolver, int timeout) throws InterruptedException {
        if (!Application.isHeadless()) {
            this.bubble = CESBubbleSupport.getInstance().show(cbSolver, this, timeout);
        }
    }

    public void setAnswer(AbstractResponse<?> abstractResponse) {
        if (this.job.addAnswer(abstractResponse)) {
            this.answered = true;
            this.setStatus(_GUI.T.DeathByCaptchaSolver_solveBasicCaptchaChallenge_answer(this.abrev(abstractResponse.getValue() + "")), NewTheme.I().getIcon("ok", 20));
        } else {
            this.setStatus(_GUI.T.DeathByCaptchaSolver_solveBasicCaptchaChallenge_answer_bad(this.abrev(abstractResponse.getValue() + "")), NewTheme.I().getIcon("bad", 20));
        }
    }

    private String abrev(String string) {
        if (string.length() <= 10) {
            return string;
        }
        return string.substring(0, 10) + "...";
    }

    public void hideBubble() {
        if (!this.answered) {
            this.setStatus(SolverStatus.UNSOLVED);
            if (this.bubble != null) {
                this.bubble.update();
            }
        }
        if (this.bubble != null) {
            this.bubble.hideBubble(5000);
        }
    }
}

