/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.captcha.v2.solver.cheapcaptcha;

import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.imageio.ImageIO;
import jd.http.Browser;
import jd.http.Request;
import jd.http.URLConnectionAdapter;
import jd.http.requests.FormData;
import jd.http.requests.PostFormDataRequest;
import jd.nutils.encoding.Encoding;
import org.appwork.storage.config.JsonConfig;
import org.appwork.utils.ImageProvider.ImageProvider;
import org.appwork.utils.Regex;
import org.appwork.utils.StringUtils;
import org.appwork.utils.encoding.Base64;
import org.appwork.utils.logging2.LogSource;
import org.appwork.utils.parser.UrlQuery;
import org.jdownloader.captcha.v2.AbstractResponse;
import org.jdownloader.captcha.v2.Challenge;
import org.jdownloader.captcha.v2.SolverStatus;
import org.jdownloader.captcha.v2.challenge.stringcaptcha.BasicCaptchaChallenge;
import org.jdownloader.captcha.v2.solver.CESChallengeSolver;
import org.jdownloader.captcha.v2.solver.CESSolverJob;
import org.jdownloader.captcha.v2.solver.cheapcaptcha.CheapCaptchaAccount;
import org.jdownloader.captcha.v2.solver.cheapcaptcha.CheapCaptchaConfigInterface;
import org.jdownloader.captcha.v2.solver.cheapcaptcha.CheapCaptchaResponse;
import org.jdownloader.captcha.v2.solver.cheapcaptcha.CheapCaptchaSolverService;
import org.jdownloader.captcha.v2.solver.jac.SolverException;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.images.NewTheme;
import org.jdownloader.logging.LogController;
import org.jdownloader.settings.staticreferences.CFG_CHEAP_CAPTCHA;
import org.seamless.util.io.IO;

public class CheapCaptchaSolver
extends CESChallengeSolver<String> {
    private CheapCaptchaConfigInterface config;
    private static final CheapCaptchaSolver INSTANCE = new CheapCaptchaSolver();
    private ThreadPoolExecutor threadPool = new ThreadPoolExecutor(0, 1, 30000L, TimeUnit.MILLISECONDS, new LinkedBlockingDeque<Runnable>(), Executors.defaultThreadFactory());
    private LogSource logger;

    public static CheapCaptchaSolver getInstance() {
        return INSTANCE;
    }

    @Override
    public Class<String> getResultType() {
        return String.class;
    }

    @Override
    public CheapCaptchaSolverService getService() {
        return (CheapCaptchaSolverService)super.getService();
    }

    private CheapCaptchaSolver() {
        super(new CheapCaptchaSolverService(), Math.max(1, Math.min(25, ((CheapCaptchaConfigInterface)JsonConfig.create(CheapCaptchaConfigInterface.class)).getThreadpoolSize())));
        this.getService().setSolver(this);
        this.config = (CheapCaptchaConfigInterface)JsonConfig.create(CheapCaptchaConfigInterface.class);
        this.logger = LogController.getInstance().getLogger(CheapCaptchaSolver.class.getName());
        this.threadPool.allowCoreThreadTimeOut(true);
    }

    @Override
    protected LogSource getLogger() {
        return this.logger;
    }

    @Override
    protected boolean isChallengeSupported(Challenge<?> c) {
        return c instanceof BasicCaptchaChallenge;
    }

    @Override
    protected void solveBasicCaptchaChallenge(CESSolverJob<String> job, BasicCaptchaChallenge challenge) throws InterruptedException, SolverException {
        job.showBubble(this);
        CheapCaptchaSolver.checkInterruption();
        try {
            job.getChallenge().sendStatsSolving(this);
            Browser br = this.createNewBrowserInstance(challenge);
            br.setReadTimeout(300000);
            job.setStatus(SolverStatus.SOLVING);
            long startTime = System.currentTimeMillis();
            PostFormDataRequest r = new PostFormDataRequest("http://api.cheapcaptcha.com/api/captcha");
            r.addFormData(new FormData("username", this.config.getUserName()));
            r.addFormData(new FormData("password", this.config.getPassword()));
            byte[] data = IO.readBytes((File)challenge.getImageFile());
            boolean mode = false;
            switch (0) {
                case 0: {
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    ImageProvider.writeImage((RenderedImage)ImageIO.read(new ByteArrayInputStream(data)), (String)"jpg", (OutputStream)bos);
                    r.addFormData(new FormData("captchafile", "image.jpg", "image/jpg", bos.toByteArray()));
                    break;
                }
                case 1: {
                    r.addFormData(new FormData("captchafile", "base64:" + Base64.encodeToString((byte[])data)));
                    break;
                }
                default: {
                    r.addFormData(new FormData("captchafile", "ByteData.captcha", data));
                }
            }
            URLConnectionAdapter conn = br.openRequestConnection((Request)r);
            conn.setAllowedResponseCodes(new int[]{conn.getResponseCode()});
            br.loadConnection(conn);
            if (conn.getResponseCode() == 403) {
                CheapCaptchaAccount acc = this.loadAccount();
                if (acc.isValid()) {
                    throw new SolverException("No Credits");
                }
                throw new SolverException("Wrong Logins");
            }
            if (conn.getResponseCode() == 503) {
                throw new SolverException("Server Overload");
            }
            String checkUrl = br.getRedirectLocation();
            String id = new Regex(checkUrl, ".*/(\\d+)$").getMatch(0);
            if (null != checkUrl) {
                job.setStatus(new SolverStatus(_GUI.T.DeathByCaptchaSolver_solveBasicCaptchaChallenge_solving(), NewTheme.I().getIcon("wait", 20)));
                while (true) {
                    UrlQuery pollResponse = Request.parseQuery((String)br.getPage(checkUrl));
                    String txt = Encoding.urlDecode((String)pollResponse.get("text"), (boolean)false);
                    boolean solved = StringUtils.isNotEmpty((String)txt);
                    if (!"1".equals(pollResponse.get("is_correct"))) {
                        job.getLogger().info("Failed solving CAPTCHA");
                        throw new SolverException("Failed:" + id);
                    }
                    job.getLogger().info(br.toString());
                    if (solved) {
                        job.getLogger().info("CAPTCHA " + challenge.getImageFile() + " solved: " + pollResponse.get("text"));
                        job.setAnswer(new CheapCaptchaResponse(challenge, this, id, txt));
                        return;
                    }
                    Thread.sleep(1000L);
                }
            }
        }
        catch (Exception e) {
            job.getChallenge().sendStatsError(this, e);
            job.getLogger().log((Throwable)e);
        }
    }

    @Override
    protected boolean validateLogins() {
        if (!CFG_CHEAP_CAPTCHA.ENABLED.isEnabled()) {
            return false;
        }
        if (StringUtils.isEmpty((String)CFG_CHEAP_CAPTCHA.USER_NAME.getValue())) {
            return false;
        }
        return !StringUtils.isEmpty((String)CFG_CHEAP_CAPTCHA.PASSWORD.getValue());
    }

    @Override
    public boolean setInvalid(final AbstractResponse<?> response) {
        if (this.config.isFeedBackSendingEnabled() && response instanceof CheapCaptchaResponse) {
            this.threadPool.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        String captcha = ((CheapCaptchaResponse)response).getCaptchaID();
                        Challenge challenge = response.getChallenge();
                        if (challenge instanceof BasicCaptchaChallenge) {
                            Browser br = CheapCaptchaSolver.this.createNewBrowserInstance(challenge);
                            PostFormDataRequest r = new PostFormDataRequest(" http://api.cheapcaptcha.com/api/captcha/" + captcha + "/report");
                            r.addFormData(new FormData("username", CheapCaptchaSolver.this.config.getUserName()));
                            r.addFormData(new FormData("password", CheapCaptchaSolver.this.config.getPassword()));
                            URLConnectionAdapter conn = br.openRequestConnection((Request)r);
                            br.loadConnection(conn);
                            System.out.println(conn);
                        }
                    }
                    catch (Throwable e) {
                        CheapCaptchaSolver.this.logger.log(e);
                    }
                }
            });
            return true;
        }
        return false;
    }

    public CheapCaptchaAccount loadAccount() {
        CheapCaptchaAccount ret = new CheapCaptchaAccount();
        try {
            Browser br = this.createNewBrowserInstance(null);
            PostFormDataRequest r = new PostFormDataRequest("http://api.cheapcaptcha.com/api/user");
            r.addFormData(new FormData("username", this.config.getUserName()));
            r.addFormData(new FormData("password", this.config.getPassword()));
            URLConnectionAdapter conn = br.openRequestConnection((Request)r);
            br.loadConnection(conn);
            if (br.getRequest().getHttpConnection().getResponseCode() != 200) {
                throw new SolverException(br.toString());
            }
            UrlQuery response = Request.parseQuery((String)br.toString());
            ret.setUserName(response.get("user") + " (" + this.config.getUserName() + ")");
            ret.setBalance(Double.parseDouble(response.get("balance")) / 100.0);
        }
        catch (Exception e) {
            this.logger.log((Throwable)e);
            ret.setError(e.getMessage());
        }
        return ret;
    }
}

