/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.captcha.v2.solver.dbc;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import jd.gui.swing.jdgui.components.premiumbar.ServiceCollection;
import jd.gui.swing.jdgui.components.premiumbar.ServicePanel;
import jd.gui.swing.jdgui.components.premiumbar.ServicePanelExtender;
import jd.gui.swing.jdgui.views.settings.components.Checkbox;
import jd.gui.swing.jdgui.views.settings.components.PasswordInput;
import jd.gui.swing.jdgui.views.settings.components.SettingsButton;
import jd.gui.swing.jdgui.views.settings.components.SettingsComponent;
import jd.gui.swing.jdgui.views.settings.components.TextInput;
import jd.gui.swing.jdgui.views.settings.panels.anticaptcha.AbstractCaptchaSolverConfigPanel;
import org.appwork.storage.config.JsonConfig;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.swing.components.tooltips.ExtTooltip;
import org.appwork.utils.Application;
import org.appwork.utils.os.CrossSystem;
import org.jdownloader.DomainInfo;
import org.jdownloader.actions.AppAction;
import org.jdownloader.captcha.v2.ChallengeSolverConfig;
import org.jdownloader.captcha.v2.solver.dbc.DeathByCaptchaSettings;
import org.jdownloader.captcha.v2.solver.dbc.DeathByCaptchaSolver;
import org.jdownloader.captcha.v2.solver.dbc.ServicePanelDBCTooltip;
import org.jdownloader.captcha.v2.solver.service.AbstractSolverService;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.images.NewTheme;
import org.jdownloader.settings.advanced.AdvancedConfigManager;
import org.jdownloader.settings.staticreferences.CFG_DBC;

public class DeathByCaptchaSolverService
extends AbstractSolverService
implements ServicePanelExtender {
    private DeathByCaptchaSettings config;
    private DeathByCaptchaSolver solver;
    private final DomainInfo info = DomainInfo.getInstance("deathbycaptcha.com");
    public static final String ID = "dbc";

    public DeathByCaptchaSolverService() {
        this.config = (DeathByCaptchaSettings)JsonConfig.create(DeathByCaptchaSettings.class);
        AdvancedConfigManager.getInstance().register(this.config);
        if (!Application.isHeadless()) {
            ServicePanel.getInstance().addExtender((ServicePanelExtender)this);
            this.initServicePanel(new KeyHandler[]{CFG_DBC.USER_NAME, CFG_DBC.PASSWORD, CFG_DBC.ENABLED});
        }
    }

    @Override
    public String getType() {
        return _GUI.T.CaptchaSolver_Type_paid_online();
    }

    @Override
    public Icon getIcon(int size) {
        return NewTheme.I().getIcon("logo/dbc", size);
    }

    @Override
    public AbstractCaptchaSolverConfigPanel getConfigPanel() {
        AbstractCaptchaSolverConfigPanel ret = new AbstractCaptchaSolverConfigPanel(){
            private TextInput username;
            private PasswordInput password;
            {
                this.addHeader(this.getTitle(), NewTheme.I().getIcon("logo/dbc", 32));
                this.addDescription(_GUI.T.AntiCaptchaConfigPanel_onShow_description_paid_service());
                this.add((Component)new SettingsButton(new AppAction(){
                    {
                        this.setName(_GUI.T.lit_open_website());
                    }

                    public void actionPerformed(ActionEvent e) {
                        CrossSystem.openURL((String)"https://deathbycaptcha.com/?refid=1235181816");
                    }
                }), "gapleft 37,spanx,pushx,growx");
                this.username = new TextInput(CFG_DBC.USER_NAME);
                this.password = new PasswordInput(CFG_DBC.PASSWORD);
                this.addHeader(_GUI.T.MyJDownloaderSettingsPanel_MyJDownloaderSettingsPanel_logins_(), NewTheme.I().getIcon("logins", 32));
                this.addDescriptionPlain(_GUI.T.captchasolver_configpanel_my_account_description(DeathByCaptchaSolverService.this.getName()));
                this.addDescriptionPlain(_GUI.T.captchasolver_configpanel_my_account_token_description(DeathByCaptchaSolverService.this.getName()));
                this.addPair(_GUI.T.captchasolver_configpanel_enabled(DeathByCaptchaSolverService.this.getName()), null, (SettingsComponent)new Checkbox(CFG_DBC.ENABLED, new JComponent[]{this.username, this.password}));
                this.addPair(_GUI.T.captchabrotherhoodService_createPanel_username(), null, (SettingsComponent)this.username);
                this.addPair(_GUI.T.captchabrotherhoodService_createPanel_password(), null, (SettingsComponent)this.password);
                this.addPair(_GUI.T.DeatchbyCaptcha_Service_createPanel_feedback(), null, (SettingsComponent)new Checkbox(CFG_DBC.FEED_BACK_SENDING_ENABLED, new JComponent[0]));
                this.addBlackWhiteList(DeathByCaptchaSolverService.this.config);
            }

            public String getPanelID() {
                return "CES_" + this.getTitle();
            }

            public void save() {
            }

            public void updateContents() {
            }

            public Icon getIcon() {
                return DeathByCaptchaSolverService.this.getIcon(32);
            }

            public String getTitle() {
                return DeathByCaptchaSolverService.this.info.getDomain();
            }
        };
        return ret;
    }

    @Override
    public boolean hasConfigPanel() {
        return true;
    }

    @Override
    public String getName() {
        return _GUI.T.DeathByCaptchaSolver_gettypeName_();
    }

    @Override
    public ChallengeSolverConfig getConfig() {
        return this.config;
    }

    public void extendServicePabel(List<ServiceCollection<?>> services) {
        if (this.solver.validateLogins()) {
            services.add(new ServiceCollection<DeathByCaptchaSolver>(){

                public Icon getIcon() {
                    return DeathByCaptchaSolverService.this.info;
                }

                public boolean isEnabled() {
                    return DeathByCaptchaSolverService.this.config.isEnabled();
                }

                protected long getLastActiveTimestamp() {
                    return System.currentTimeMillis();
                }

                protected String getName() {
                    return DeathByCaptchaSolverService.this.info.getDomain();
                }

                public ExtTooltip createTooltip(ServicePanel owner) {
                    return new ServicePanelDBCTooltip(owner, DeathByCaptchaSolverService.this.solver);
                }
            });
        }
    }

    @Override
    public Map<String, Integer> getWaitForOthersDefaultMap() {
        HashMap<String, Integer> ret = new HashMap<String, Integer>();
        ret.put("jac", 30000);
        ret.put("9kw", 120000);
        ret.put("imagetyperz", 60000);
        ret.put("2captcha", 60000);
        return ret;
    }

    @Override
    public String getID() {
        return ID;
    }

    public void setSolver(DeathByCaptchaSolver deathByCaptchaSolver) {
        this.solver = deathByCaptchaSolver;
    }
}

