/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.captcha.v2.solver.endcaptcha;

import java.io.File;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import jd.http.Browser;
import jd.http.Request;
import jd.http.URLConnectionAdapter;
import jd.http.requests.FormData;
import jd.http.requests.PostFormDataRequest;
import org.appwork.storage.config.JsonConfig;
import org.appwork.utils.StringUtils;
import org.appwork.utils.logging2.LogSource;
import org.jdownloader.captcha.v2.AbstractResponse;
import org.jdownloader.captcha.v2.Challenge;
import org.jdownloader.captcha.v2.SolverStatus;
import org.jdownloader.captcha.v2.challenge.stringcaptcha.BasicCaptchaChallenge;
import org.jdownloader.captcha.v2.solver.CESChallengeSolver;
import org.jdownloader.captcha.v2.solver.CESSolverJob;
import org.jdownloader.captcha.v2.solver.endcaptcha.EndCaptchaAccount;
import org.jdownloader.captcha.v2.solver.endcaptcha.EndCaptchaConfigInterface;
import org.jdownloader.captcha.v2.solver.endcaptcha.EndCaptchaResponse;
import org.jdownloader.captcha.v2.solver.endcaptcha.EndCaptchaSolverService;
import org.jdownloader.captcha.v2.solver.jac.SolverException;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.images.NewTheme;
import org.jdownloader.logging.LogController;
import org.jdownloader.settings.staticreferences.CFG_END_CAPTCHA;
import org.seamless.util.io.IO;

public class EndCaptchaSolver
extends CESChallengeSolver<String> {
    private final EndCaptchaConfigInterface config;
    private static final EndCaptchaSolver INSTANCE = new EndCaptchaSolver();
    private final ThreadPoolExecutor threadPool = new ThreadPoolExecutor(0, 1, 30000L, TimeUnit.MILLISECONDS, new LinkedBlockingDeque<Runnable>(), Executors.defaultThreadFactory());
    private final LogSource logger;

    public static EndCaptchaSolver getInstance() {
        return INSTANCE;
    }

    @Override
    public Class<String> getResultType() {
        return String.class;
    }

    @Override
    public EndCaptchaSolverService getService() {
        return (EndCaptchaSolverService)super.getService();
    }

    @Override
    protected LogSource getLogger() {
        return this.logger;
    }

    private EndCaptchaSolver() {
        super(new EndCaptchaSolverService(), Math.max(1, Math.min(25, ((EndCaptchaConfigInterface)JsonConfig.create(EndCaptchaConfigInterface.class)).getThreadpoolSize())));
        this.getService().setSolver(this);
        this.config = (EndCaptchaConfigInterface)JsonConfig.create(EndCaptchaConfigInterface.class);
        this.logger = LogController.getInstance().getLogger(EndCaptchaSolver.class.getName());
        this.threadPool.allowCoreThreadTimeOut(true);
    }

    @Override
    protected boolean isChallengeSupported(Challenge<?> c) {
        return c instanceof BasicCaptchaChallenge;
    }

    private void errorHandling(Browser br) throws Exception {
        if (br.containsHTML("ERROR:NOT AUTHENTICATED")) {
            throw new SolverException("Wrong Logins");
        }
        if (br.containsHTML("ERROR:NOT ENOUGH BALANCE")) {
            throw new SolverException("No Credits");
        }
        if (br.containsHTML("ERROR:NOT A VALID CAPTCHA")) {
            throw new SolverException("Bad Captcha Image");
        }
        if (br.containsHTML("ERROR:SERVICE EXTREMELY LOADED")) {
            throw new SolverException("Service Overloaded");
        }
        if (br.containsHTML("ERROR:UNSUCCESSFUL UPLOAD")) {
            throw new SolverException("Upload error");
        }
        if (br.containsHTML("ERROR:INCORRECT CAPTCHA ID")) {
            throw new SolverException("Bad Captcha ID");
        }
        if (br.containsHTML("ERROR:")) {
            throw new SolverException("Unknown Error:" + br.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void solveBasicCaptchaChallenge(CESSolverJob<String> job, BasicCaptchaChallenge challenge) throws InterruptedException, SolverException {
        job.showBubble(this);
        EndCaptchaSolver.checkInterruption();
        job.getChallenge().sendStatsSolving(this);
        URLConnectionAdapter conn = null;
        try {
            Browser br = this.createNewBrowserInstance(challenge);
            br.setReadTimeout(300000);
            job.setStatus(SolverStatus.SOLVING);
            PostFormDataRequest r = new PostFormDataRequest("http://api.endcaptcha.com/upload");
            r.addFormData(new FormData("username", this.config.getUserName()));
            r.addFormData(new FormData("password", this.config.getPassword()));
            byte[] data = IO.readBytes((File)challenge.getImageFile());
            r.addFormData(new FormData("image", "ByteData.captcha", data));
            conn = br.openRequestConnection((Request)r);
            br.loadConnection(conn);
            String pollID = null;
            if (!br.containsHTML("UNSOLVED_YET:/poll/")) {
                this.errorHandling(br);
                job.getLogger().info("CAPTCHA " + challenge.getImageFile() + " solved: " + br.toString());
                job.setAnswer(new EndCaptchaResponse(challenge, this, pollID, br.toString()));
                return;
            }
            pollID = br.getRegex("/poll/(.+)").getMatch(0);
            if (pollID == null) throw new SolverException("Unknown Error:" + br.toString());
            job.setStatus(new SolverStatus(_GUI.T.DeathByCaptchaSolver_solveBasicCaptchaChallenge_solving(), NewTheme.I().getIcon("wait", 20)));
            while (pollID != null) {
                Thread.sleep(3000L);
                PostFormDataRequest poll = new PostFormDataRequest("http://api.endcaptcha.com/poll/" + pollID);
                r.addFormData(new FormData("username", this.config.getUserName()));
                r.addFormData(new FormData("password", this.config.getPassword()));
                conn = br.openRequestConnection((Request)poll);
                br.loadConnection(conn);
                if (!br.containsHTML("UNSOLVED_YET:/poll/")) {
                    this.errorHandling(br);
                    job.getLogger().info("CAPTCHA " + challenge.getImageFile() + " solved: " + br.toString());
                    job.setAnswer(new EndCaptchaResponse(challenge, this, pollID, br.toString()));
                    return;
                }
                pollID = br.getRegex("/poll/(.+)").getMatch(0);
            }
            throw new SolverException("Unknown Error:" + br.toString());
        }
        catch (Exception e) {
            job.getChallenge().sendStatsError(this, e);
            job.getLogger().log((Throwable)e);
            return;
        }
        finally {
            try {
                if (conn != null) {
                    conn.disconnect();
                }
            }
            catch (Throwable throwable) {}
        }
    }

    @Override
    protected boolean validateLogins() {
        if (!CFG_END_CAPTCHA.ENABLED.isEnabled()) {
            return false;
        }
        if (StringUtils.isEmpty((String)CFG_END_CAPTCHA.USER_NAME.getValue())) {
            return false;
        }
        return !StringUtils.isEmpty((String)CFG_END_CAPTCHA.PASSWORD.getValue());
    }

    @Override
    public boolean setInvalid(final AbstractResponse<?> response) {
        if (this.config.isFeedBackSendingEnabled() && response instanceof EndCaptchaResponse) {
            this.threadPool.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    URLConnectionAdapter conn = null;
                    try {
                        String captcha = ((EndCaptchaResponse)response).getCaptchaID();
                        Challenge challenge = response.getChallenge();
                        if (challenge instanceof BasicCaptchaChallenge) {
                            Browser br = EndCaptchaSolver.this.createNewBrowserInstance(challenge);
                            PostFormDataRequest r = new PostFormDataRequest(" http://api.endcaptcha.com/api/captcha/" + captcha + "/report");
                            r.addFormData(new FormData("username", EndCaptchaSolver.this.config.getUserName()));
                            r.addFormData(new FormData("password", EndCaptchaSolver.this.config.getPassword()));
                            conn = br.openRequestConnection((Request)r);
                            br.loadConnection(conn);
                        }
                    }
                    catch (Throwable e) {
                        EndCaptchaSolver.this.logger.log(e);
                    }
                    finally {
                        try {
                            if (conn != null) {
                                conn.disconnect();
                            }
                        }
                        catch (Throwable captcha) {}
                    }
                }
            });
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EndCaptchaAccount loadAccount() {
        EndCaptchaAccount ret = new EndCaptchaAccount();
        Browser br = this.createNewBrowserInstance(null);
        URLConnectionAdapter conn = null;
        try {
            PostFormDataRequest r = new PostFormDataRequest("http://api.endcaptcha.com/balance");
            r.addFormData(new FormData("username", this.config.getUserName()));
            r.addFormData(new FormData("password", this.config.getPassword()));
            conn = br.openRequestConnection((Request)r);
            br.loadConnection(conn);
            this.errorHandling(br);
            if (br.getRequest().getHttpConnection().getResponseCode() != 200) {
                throw new SolverException(br.toString());
            }
            ret.setUserName(this.config.getUserName());
            ret.setBalance(Double.parseDouble(br.toString()) / 100.0);
        }
        catch (Exception e) {
            this.logger.log((Throwable)e);
            ret.setError(br.toString());
        }
        finally {
            try {
                if (conn != null) {
                    conn.disconnect();
                }
            }
            catch (Throwable throwable) {}
        }
        return ret;
    }
}

