/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.captcha.v2.solver.gui;

import jd.controlling.captcha.BasicCaptchaDialogHandler;
import jd.controlling.captcha.CaptchaSettings;
import jd.controlling.captcha.SkipException;
import org.appwork.storage.config.JsonConfig;
import org.jdownloader.captcha.v2.AbstractResponse;
import org.jdownloader.captcha.v2.Challenge;
import org.jdownloader.captcha.v2.ChallengeSolver;
import org.jdownloader.captcha.v2.challenge.stringcaptcha.BasicCaptchaChallenge;
import org.jdownloader.captcha.v2.challenge.stringcaptcha.CaptchaResponse;
import org.jdownloader.captcha.v2.solver.gui.AbstractDialogSolver;
import org.jdownloader.captcha.v2.solver.gui.DialogCaptchaSolverConfig;
import org.jdownloader.captcha.v2.solver.jac.JACSolver;
import org.jdownloader.captcha.v2.solverjob.ChallengeSolverJobListener;
import org.jdownloader.captcha.v2.solverjob.ResponseList;
import org.jdownloader.captcha.v2.solverjob.SolverJob;
import org.jdownloader.settings.advanced.AdvancedConfigManager;

public class DialogBasicCaptchaSolver
extends AbstractDialogSolver<String> {
    private CaptchaSettings config = (CaptchaSettings)JsonConfig.create(CaptchaSettings.class);
    private BasicCaptchaDialogHandler handler;
    private Thread waitingThread;
    private boolean focusRequested;
    private static final DialogBasicCaptchaSolver INSTANCE = new DialogBasicCaptchaSolver();

    public static DialogBasicCaptchaSolver getInstance() {
        return INSTANCE;
    }

    @Override
    public Class<String> getResultType() {
        return String.class;
    }

    @Override
    protected boolean isChallengeSupported(Challenge<?> c) {
        return c instanceof BasicCaptchaChallenge;
    }

    private DialogBasicCaptchaSolver() {
        super(1);
        AdvancedConfigManager.getInstance().register(JsonConfig.create(DialogCaptchaSolverConfig.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void solve(SolverJob<String> job) throws InterruptedException, SkipException {
        DialogBasicCaptchaSolver dialogBasicCaptchaSolver = this;
        synchronized (dialogBasicCaptchaSolver) {
            BasicCaptchaChallenge captchaChallenge;
            String result;
            if (job.isDone()) {
                return;
            }
            if (job.getChallenge() instanceof BasicCaptchaChallenge && (result = this.solveBasicCaptchaChallenge(job, captchaChallenge = (BasicCaptchaChallenge)job.getChallenge())) != null) {
                job.addAnswer(new CaptchaResponse(captchaChallenge, (Object)this, result, 100));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String solveBasicCaptchaChallenge(final SolverJob<String> job, BasicCaptchaChallenge captchaChallenge) throws InterruptedException, SkipException {
        job.getLogger().info("Waiting for Other Solvers");
        try {
            this.focusRequested = false;
            this.waitingThread = Thread.currentThread();
            job.waitFor(9, JACSolver.getInstance());
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            if (!this.focusRequested) {
                throw e;
            }
        }
        finally {
            this.waitingThread = null;
            this.focusRequested = false;
        }
        DialogBasicCaptchaSolver.checkInterruption();
        job.getLogger().info("Waits are done. Response so far: " + job.getResponse());
        ChallengeSolverJobListener jacListener = null;
        this.checkSilentMode(job);
        this.handler = new BasicCaptchaDialogHandler(captchaChallenge);
        jacListener = new ChallengeSolverJobListener(){

            @Override
            public void onSolverTimedOut(ChallengeSolver<?> parameter) {
            }

            @Override
            public void onSolverStarts(ChallengeSolver<?> parameter) {
            }

            @Override
            public void onSolverJobReceivedNewResponse(AbstractResponse<?> response) {
                ResponseList resp = job.getResponse();
                DialogBasicCaptchaSolver.this.handler.setSuggest((String)resp.getValue());
                job.getLogger().info("Received Suggestion: " + resp);
            }

            @Override
            public void onSolverDone(ChallengeSolver<?> solver) {
            }
        };
        job.getEventSender().addListener(jacListener);
        try {
            ResponseList<String> resp = job.getResponse();
            if (resp != null) {
                this.handler.setSuggest(resp.getValue());
            }
            DialogBasicCaptchaSolver.checkInterruption();
            if (!captchaChallenge.getImageFile().exists()) {
                job.getLogger().info("Cannot solve. image does not exist");
                String string = null;
                return string;
            }
            this.handler.run();
            String string = (String)this.handler.getResult();
            return string;
        }
        finally {
            job.getLogger().info("Dialog closed. Response far: " + job.getResponse());
            if (jacListener != null) {
                job.getEventSender().removeListener(jacListener);
            }
            this.handler = null;
        }
    }

    public void requestFocus(Challenge<?> challenge) {
        BasicCaptchaDialogHandler hndlr;
        if (this.waitingThread != null) {
            this.focusRequested = true;
            this.waitingThread.interrupt();
        }
        if ((hndlr = this.handler) != null) {
            hndlr.requestFocus();
        }
    }
}

