/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.captcha.v2.solver.solver9kw;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import jd.http.Browser;
import org.appwork.utils.IO;
import org.appwork.utils.parser.UrlQuery;
import org.jdownloader.captcha.v2.AbstractResponse;
import org.jdownloader.captcha.v2.Challenge;
import org.jdownloader.captcha.v2.challenge.hcaptcha.HCaptchaChallenge;
import org.jdownloader.captcha.v2.challenge.recaptcha.v2.RecaptchaV2Challenge;
import org.jdownloader.captcha.v2.challenge.stringcaptcha.BasicCaptchaChallenge;
import org.jdownloader.captcha.v2.challenge.stringcaptcha.ImageCaptchaChallenge;
import org.jdownloader.captcha.v2.solver.CESSolverJob;
import org.jdownloader.captcha.v2.solver.jac.SolverException;
import org.jdownloader.captcha.v2.solver.solver9kw.AbstractCaptcha9kwSolver;
import org.jdownloader.captcha.v2.solver.solver9kw.Captcha9kwResponse;
import org.jdownloader.captcha.v2.solver.solver9kw.NineKwSolverService;
import org.jdownloader.captcha.v2.solver.solver9kw.RequestOptions;

public class Captcha9kwSolver
extends AbstractCaptcha9kwSolver<String> {
    private static final Captcha9kwSolver INSTANCE = new Captcha9kwSolver();

    public static Captcha9kwSolver getInstance() {
        return INSTANCE;
    }

    @Override
    public Class<String> getResultType() {
        return String.class;
    }

    private Captcha9kwSolver() {
        NineKwSolverService.getInstance().setTextSolver(this);
    }

    @Override
    protected boolean isChallengeSupported(Challenge<?> c) {
        return c instanceof HCaptchaChallenge || c instanceof RecaptchaV2Challenge || c instanceof BasicCaptchaChallenge;
    }

    @Override
    public boolean canHandle(Challenge<?> c) {
        if (c instanceof HCaptchaChallenge) {
            try {
                this.checkForEnoughCredits();
            }
            catch (SolverException e) {
                return false;
            }
        }
        if (c instanceof RecaptchaV2Challenge) {
            try {
                this.checkForEnoughCredits();
            }
            catch (SolverException e) {
                return false;
            }
        }
        if (c instanceof BasicCaptchaChallenge) {
            try {
                this.checkForEnoughCredits();
            }
            catch (SolverException e) {
                return false;
            }
        }
        return super.canHandle(c);
    }

    @Override
    protected void solveCES(CESSolverJob<String> solverJob) throws InterruptedException, SolverException {
        Challenge captchaChallenge = this.getChallenge(solverJob);
        if (captchaChallenge instanceof HCaptchaChallenge) {
            this.handleHCaptcha(solverJob);
        } else if (captchaChallenge instanceof RecaptchaV2Challenge) {
            this.handleRecaptchaV2(solverJob);
        } else {
            this.handleImageCaptcha(solverJob);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleImageCaptcha(CESSolverJob<String> solverJob) throws InterruptedException, SolverException {
        Captcha9kwSolver.checkInterruption();
        RequestOptions options = this.prepare(solverJob);
        if (options.getMoreoptions().containsKey("userconfirm")) {
            options.getMoreoptions().remove("userconfirm");
        } else {
            options.setConfirm(this.config.isconfirm());
        }
        try {
            Challenge captchaChallenge = this.getChallenge(solverJob);
            byte[] data = IO.readFile((File)((ImageCaptchaChallenge)captchaChallenge).getImageFile());
            UrlQuery qi = this.createQueryForUpload(solverJob, options, data);
            UrlQuery queryPoll = this.createQueryForPolling();
            Browser br = this.createNewBrowserInstance(captchaChallenge);
            br.setAllowedResponseCodes(new int[]{500});
            String captchaID = this.upload(br, solverJob, qi);
            this.poll(br, options, solverJob, captchaID, queryPoll);
        }
        catch (IOException e) {
            solverJob.getChallenge().sendStatsError(this, e);
            this.setdebug(solverJob, "Interrupted: " + e);
            this.counterInterrupted.incrementAndGet();
            solverJob.getLogger().log((Throwable)e);
        }
        finally {
            System.out.println(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleHCaptcha(CESSolverJob<String> solverJob) throws InterruptedException, SolverException {
        Captcha9kwSolver.checkInterruption();
        RequestOptions options = this.prepare(solverJob);
        if (options.getMoreoptions().containsKey("userconfirm")) {
            options.getMoreoptions().remove("userconfirm");
        } else {
            options.setConfirm(this.config.isconfirm());
        }
        try {
            HCaptchaChallenge hCaptcha = (HCaptchaChallenge)this.getChallenge(solverJob);
            UrlQuery qi = new UrlQuery();
            qi.appendEncoded("action", "usercaptchaupload");
            qi.appendEncoded("jd", "2");
            qi.appendEncoded("source", "jd2");
            qi.appendEncoded("captchaperhour", options.getCph() + "");
            qi.appendEncoded("captchapermin", options.getCpm() + "");
            qi.appendEncoded("prio", options.getPriothing() + "");
            qi.appendEncoded("selfsolve", options.isSelfsolve() + "");
            qi.appendEncoded("proxy", options.getproxyhostport() + "");
            qi.appendEncoded("proxytype", options.getproxytype() + "");
            qi.appendEncoded("confirm", "false");
            qi.appendEncoded("maxtimeout", options.getTimeoutthing() + "");
            qi.addAll(options.getMoreoptions().list());
            qi.appendEncoded("apikey", this.config.getApiKey() + "");
            qi.appendEncoded("captchaSource", "jdPlugin");
            qi.appendEncoded("version", "1.2");
            qi.appendEncoded("data-sitekey", hCaptcha.getSiteKey());
            qi.appendEncoded("pageurl", hCaptcha.getSiteUrl());
            qi.appendEncoded("oldsource", "hcaptcha");
            qi.appendEncoded("captchachoice", "hcaptcha");
            qi.appendEncoded("interactive", "1");
            UrlQuery queryPoll = this.createQueryForPolling();
            Browser br = this.createNewBrowserInstance(hCaptcha);
            br.setAllowedResponseCodes(new int[]{500});
            String captchaID = this.upload(br, solverJob, qi);
            this.poll(br, options, solverJob, captchaID, queryPoll);
        }
        catch (IOException e) {
            solverJob.getChallenge().sendStatsError(this, e);
            this.setdebug(solverJob, "Interrupted: " + e);
            this.counterInterrupted.incrementAndGet();
            solverJob.getLogger().log((Throwable)e);
        }
        finally {
            System.out.println(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRecaptchaV2(CESSolverJob<String> solverJob) throws InterruptedException, SolverException {
        Captcha9kwSolver.checkInterruption();
        RequestOptions options = this.prepare(solverJob);
        if (options.getMoreoptions().containsKey("userconfirm")) {
            options.getMoreoptions().remove("userconfirm");
        } else {
            options.setConfirm(this.config.isconfirm());
        }
        try {
            RecaptchaV2Challenge rcChallenge = (RecaptchaV2Challenge)this.getChallenge(solverJob);
            UrlQuery qi = new UrlQuery();
            qi.appendEncoded("action", "usercaptchaupload");
            qi.appendEncoded("jd", "2");
            qi.appendEncoded("source", "jd2");
            qi.appendEncoded("captchaperhour", options.getCph() + "");
            qi.appendEncoded("captchapermin", options.getCpm() + "");
            qi.appendEncoded("prio", options.getPriothing() + "");
            qi.appendEncoded("selfsolve", options.isSelfsolve() + "");
            qi.appendEncoded("proxy", options.getproxyhostport() + "");
            qi.appendEncoded("proxytype", options.getproxytype() + "");
            qi.appendEncoded("confirm", "false");
            qi.appendEncoded("maxtimeout", options.getTimeoutthing() + "");
            qi.addAll(options.getMoreoptions().list());
            qi.appendEncoded("apikey", this.config.getApiKey() + "");
            qi.appendEncoded("captchaSource", "jdPlugin");
            qi.appendEncoded("version", "1.2");
            qi.appendEncoded("data-sitekey", rcChallenge.getSiteKey());
            qi.appendEncoded("oldsource", rcChallenge.getTypeID() + "");
            qi.appendEncoded("isInvisible", rcChallenge.getType() + "");
            Map<String, Object> v3action = rcChallenge.getV3Action();
            if (v3action != null) {
                qi.appendEncoded("pageurl", rcChallenge.getSiteUrl());
                qi.appendEncoded("captchachoice", "recaptchav3");
                qi.appendEncoded("actionname", (String)v3action.get("action"));
                qi.appendEncoded("min_score", "0.3");
            } else {
                if (options.isSiteDomain()) {
                    qi.appendEncoded("pageurl", rcChallenge.getSiteDomain());
                } else {
                    qi.appendEncoded("pageurl", rcChallenge.getSiteUrl());
                }
                qi.appendEncoded("captchachoice", "recaptchav2");
            }
            qi.appendEncoded("securetoken", rcChallenge.getSecureToken());
            qi.appendEncoded("interactive", "1");
            UrlQuery queryPoll = this.createQueryForPolling();
            Browser br = this.createNewBrowserInstance(rcChallenge);
            br.setAllowedResponseCodes(new int[]{500});
            String captchaID = this.upload(br, solverJob, qi);
            this.poll(br, options, solverJob, captchaID, queryPoll);
        }
        catch (IOException e) {
            solverJob.getChallenge().sendStatsError(this, e);
            this.setdebug(solverJob, "Interrupted: " + e);
            this.counterInterrupted.incrementAndGet();
            solverJob.getLogger().log((Throwable)e);
        }
        finally {
            System.out.println(1);
        }
    }

    @Override
    protected void parseResponse(CESSolverJob<String> solverJob, Challenge<String> captchaChallenge, String captchaID, String ret) {
        AbstractResponse<String> answer = captchaChallenge.parseAPIAnswer(ret, captchaChallenge instanceof RecaptchaV2Challenge || captchaChallenge instanceof HCaptchaChallenge ? "rawtoken" : null, this);
        solverJob.setAnswer(new Captcha9kwResponse(captchaChallenge, this, answer.getValue(), answer.getPriority(), captchaID));
    }
}

