/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.captcha.v2.solver.solver9kw;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import jd.http.Browser;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.TypeRef;
import org.appwork.utils.Files;
import org.appwork.utils.IO;
import org.appwork.utils.ImageProvider.ImageProvider;
import org.appwork.utils.StringUtils;
import org.appwork.utils.parser.UrlQuery;
import org.jdownloader.captcha.v2.Challenge;
import org.jdownloader.captcha.v2.challenge.multiclickcaptcha.MultiClickCaptchaChallenge;
import org.jdownloader.captcha.v2.challenge.multiclickcaptcha.MultiClickedPoint;
import org.jdownloader.captcha.v2.solver.CESSolverJob;
import org.jdownloader.captcha.v2.solver.jac.SolverException;
import org.jdownloader.captcha.v2.solver.solver9kw.AbstractCaptcha9kwSolver;
import org.jdownloader.captcha.v2.solver.solver9kw.Captcha9kwMultiClickResponse;
import org.jdownloader.captcha.v2.solver.solver9kw.NineKwSolverService;
import org.jdownloader.captcha.v2.solver.solver9kw.RequestOptions;

public class Captcha9kwSolverMultiClick
extends AbstractCaptcha9kwSolver<MultiClickedPoint> {
    private static final Captcha9kwSolverMultiClick INSTANCE = new Captcha9kwSolverMultiClick();
    private double base_workaround = 2.0;

    public static Captcha9kwSolverMultiClick getInstance() {
        return INSTANCE;
    }

    @Override
    public Class<MultiClickedPoint> getResultType() {
        return MultiClickedPoint.class;
    }

    private Captcha9kwSolverMultiClick() {
        NineKwSolverService.getInstance().setMultiClickSolver(this);
    }

    @Override
    public boolean isEnabled() {
        return this.config.ismouse() && this.config.isEnabledGlobally();
    }

    @Override
    protected boolean isChallengeSupported(Challenge<?> c) {
        return c instanceof MultiClickCaptchaChallenge;
    }

    @Override
    protected void solveCES(CESSolverJob<MultiClickedPoint> solverJob) throws InterruptedException, SolverException {
        Captcha9kwSolverMultiClick.checkInterruption();
        MultiClickCaptchaChallenge captchaChallenge = (MultiClickCaptchaChallenge)solverJob.getChallenge();
        RequestOptions options = this.prepare(solverJob);
        if (options.getMoreoptions().containsKey("userconfirm")) {
            options.getMoreoptions().remove("userconfirm");
        } else {
            options.setConfirm(this.config.ismouseconfirm());
        }
        try {
            byte[] data = null;
            String ext = Files.getExtension((String)captchaChallenge.getImageFile().getName());
            boolean gifok = false;
            if (ext.equalsIgnoreCase("png") || ext.equalsIgnoreCase("jpg") || gifok) {
                BufferedImage image = ImageProvider.read((File)captchaChallenge.getImageFile());
                double size = image.getWidth() + image.getHeight();
                int basevalue = 800;
                double round_width = 0.0;
                double round_height = 0.0;
                for (int i = 0; i < 300; ++i) {
                    double toobig_size;
                    this.base_workaround = toobig_size = size / (double)(basevalue - i);
                    round_width = (double)image.getWidth() / toobig_size;
                    round_height = (double)image.getHeight() / toobig_size;
                    if (round_width < 620.0 && round_height < 600.0 && round_height + round_width < 800.0) break;
                }
                image = (BufferedImage)ImageProvider.scaleBufferedImage((BufferedImage)image, (int)((int)Math.round(round_width)), (int)((int)Math.round(round_height)));
                data = Captcha9kwSolverMultiClick.toByteArrayCaptcha(image, ext);
            } else {
                data = IO.readFile((File)captchaChallenge.getImageFile());
            }
            UrlQuery qi = this.createQueryForUpload(solverJob, options, data).appendEncoded("multimouse", "1").appendEncoded("textinstructions", captchaChallenge.getExplain());
            UrlQuery queryPoll = this.createQueryForPolling().appendEncoded("multimouse", "1");
            Browser br = this.createNewBrowserInstance(captchaChallenge);
            br.setAllowedResponseCodes(new int[]{500});
            String captchaID = this.upload(br, solverJob, qi);
            this.poll(br, options, solverJob, captchaID, queryPoll);
        }
        catch (IOException e) {
            solverJob.getChallenge().sendStatsError(this, e);
            this.setdebug(solverJob, "Interrupted: " + e);
            this.counterInterrupted.incrementAndGet();
            solverJob.getLogger().log((Throwable)e);
        }
    }

    protected static byte[] toByteArrayCaptcha(BufferedImage image, String type) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ImageProvider.writeImage((RenderedImage)image, (String)type, (OutputStream)out);
        return out.toByteArray();
    }

    @Override
    protected boolean validateLogins() {
        return StringUtils.isNotEmpty((String)this.config.getApiKey()) && this.config.ismouse();
    }

    @Override
    protected void parseResponse(CESSolverJob<MultiClickedPoint> solverJob, Challenge<MultiClickedPoint> captchaChallenge, String captchaID, String antwort) {
        String jsonX = "";
        String jsonY = "";
        String[] splitResult = antwort.split(";");
        for (int i = 0; i < splitResult.length; ++i) {
            String[] splitResultx = splitResult[i].split("x");
            if (!jsonX.isEmpty()) {
                jsonX = jsonX + ",";
            }
            jsonX = solverJob.getChallenge().getTypeID() == "kissanime.to" ? jsonX + "" + (int)Math.round((double)Integer.parseInt(splitResultx[0]) * this.base_workaround) : jsonX + splitResultx[0];
            if (!jsonY.isEmpty()) {
                jsonY = jsonY + ",";
            }
            if (solverJob.getChallenge().getTypeID() == "kissanime.to") {
                jsonX = jsonX + "" + (int)Math.round((double)Integer.parseInt(splitResultx[1]) * this.base_workaround);
                continue;
            }
            jsonY = jsonY + splitResultx[1];
        }
        String jsonInString = "{\"x\":[],\"y\":[]}";
        MultiClickedPoint res = (MultiClickedPoint)JSonStorage.restoreFromString((String)jsonInString, (TypeRef)new TypeRef<MultiClickedPoint>(){});
        solverJob.setAnswer(new Captcha9kwMultiClickResponse(captchaChallenge, this, res, 100, captchaID));
    }
}

