/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.captcha.v2.solver.solver9kw;

import java.io.IOException;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import jd.SecondLevelLaunch;
import jd.gui.swing.jdgui.components.premiumbar.ServiceCollection;
import jd.gui.swing.jdgui.components.premiumbar.ServicePanel;
import jd.gui.swing.jdgui.components.premiumbar.ServicePanelExtender;
import jd.gui.swing.jdgui.views.settings.panels.anticaptcha.AbstractCaptchaSolverConfigPanel;
import jd.http.Browser;
import jd.nutils.encoding.Encoding;
import org.appwork.storage.config.JsonConfig;
import org.appwork.storage.config.ValidationException;
import org.appwork.storage.config.events.GenericConfigEventListener;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.swing.components.tooltips.ExtTooltip;
import org.appwork.utils.Application;
import org.appwork.utils.Regex;
import org.appwork.utils.StringUtils;
import org.appwork.utils.logging2.extmanager.LoggerFactory;
import org.jdownloader.captcha.v2.solver.service.AbstractSolverService;
import org.jdownloader.captcha.v2.solver.solver9kw.Captcha9kwSettings;
import org.jdownloader.captcha.v2.solver.solver9kw.Captcha9kwSolver;
import org.jdownloader.captcha.v2.solver.solver9kw.Captcha9kwSolverClick;
import org.jdownloader.captcha.v2.solver.solver9kw.Captcha9kwSolverMultiClick;
import org.jdownloader.captcha.v2.solver.solver9kw.NineKWAccount;
import org.jdownloader.captcha.v2.solver.solver9kw.NineKwConfigPanel;
import org.jdownloader.captcha.v2.solver.solver9kw.ServicePanel9kwTooltip;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.settings.advanced.AdvancedConfigManager;
import org.jdownloader.settings.staticreferences.CFG_9KWCAPTCHA;

public class NineKwSolverService
extends AbstractSolverService
implements ServicePanelExtender {
    private static final NineKwSolverService INSTANCE = new NineKwSolverService();
    public static final String ID = "9kw";
    private Captcha9kwSettings config = (Captcha9kwSettings)JsonConfig.create(Captcha9kwSettings.class);
    private Captcha9kwSolver textSolver;
    private Captcha9kwSolverClick clickSolver;
    private Captcha9kwSolverMultiClick multiclickSolver;

    public static NineKwSolverService getInstance() {
        return INSTANCE;
    }

    public void extendServicePabel(List<ServiceCollection<?>> services) {
        if (StringUtils.isNotEmpty((String)this.config.getApiKey()) && this.isEnabled()) {
            services.add(new ServiceCollection<Captcha9kwSolver>(){
                private static final long serialVersionUID = 5569965026755271172L;

                public Icon getIcon() {
                    return new AbstractIcon("logo/9kw", 18);
                }

                public boolean isEnabled() {
                    return NineKwSolverService.this.config.isEnabledGlobally() && (NineKwSolverService.this.config.isEnabled() || NineKwSolverService.this.config.ismouse() || NineKwSolverService.this.config.ispuzzle());
                }

                protected long getLastActiveTimestamp() {
                    return System.currentTimeMillis();
                }

                protected String getName() {
                    return "9kw.eu";
                }

                public ExtTooltip createTooltip(ServicePanel owner) {
                    return new ServicePanel9kwTooltip(owner, NineKwSolverService.this);
                }
            });
        }
    }

    public String getAPIROOT() {
        if (this.config.ishttps()) {
            return "https://www.9kw.eu/";
        }
        return "http://www.9kw.eu/";
    }

    public NineKWAccount loadAccount() throws IOException {
        Browser br = new Browser();
        NineKWAccount ret = new NineKWAccount();
        ret.setRequests(this.textSolver.counter.get() + this.clickSolver.counter.get());
        ret.setSkipped(this.textSolver.counterInterrupted.get() + this.clickSolver.counterInterrupted.get());
        ret.setSolved(this.textSolver.counterSolved.get() + this.clickSolver.counterSolved.get());
        ret.setSend(this.textSolver.counterSend.get() + this.clickSolver.counterSend.get());
        ret.setSendError(this.textSolver.counterSendError.get() + this.clickSolver.counterSendError.get());
        ret.setOK(this.textSolver.counterOK.get() + this.clickSolver.counterOK.get());
        ret.setNotOK(this.textSolver.counterNotOK.get() + this.clickSolver.counterNotOK.get());
        ret.setUnused(this.textSolver.counterUnused.get() + this.clickSolver.counterUnused.get());
        try {
            String servercheck = br.getPage(this.getAPIROOT() + "grafik/servercheck.txt");
            LoggerFactory.getDefaultLogger().info("\r\n" + br.getRequest());
            ret.setWorker(Integer.parseInt(new Regex(servercheck, "worker=(\\d+)").getMatch(0)));
            ret.setAvgSolvtime(Integer.parseInt(new Regex(servercheck, "avg1h=(\\d+)").getMatch(0)));
            ret.setQueue(Integer.parseInt(new Regex(servercheck, "queue=(\\d+)").getMatch(0)));
            ret.setQueue1(Integer.parseInt(new Regex(servercheck, "queue1=(\\d+)").getMatch(0)));
            ret.setQueue2(Integer.parseInt(new Regex(servercheck, "queue2=(\\d+)").getMatch(0)));
            ret.setInWork(Integer.parseInt(new Regex(servercheck, "inwork=(\\d+)").getMatch(0)));
            ret.setWorkerMouse(Integer.parseInt(new Regex(servercheck, "workermouse=(\\d+)").getMatch(0)));
            ret.setWorkerMultiMouse(Integer.parseInt(new Regex(servercheck, "workermultimouse=(\\d+)").getMatch(0)));
            ret.setWorkerConfirm(Integer.parseInt(new Regex(servercheck, "workerconfirm=(\\d+)").getMatch(0)));
            ret.setWorkerText(Integer.parseInt(new Regex(servercheck, "workertext=(\\d+)").getMatch(0)));
            ret.setWorkerTextOnly(Integer.parseInt(new Regex(servercheck, "workertextonly=(\\d+)").getMatch(0)));
            ret.setWorkerPuzzle(Integer.parseInt(new Regex(servercheck, "workerpuzzle=(\\d+)").getMatch(0)));
            ret.setWorkerRotate(Integer.parseInt(new Regex(servercheck, "workerrotate=(\\d+)").getMatch(0)));
            ret.setWorkerAudio(Integer.parseInt(new Regex(servercheck, "workeraudio=(\\d+)").getMatch(0)));
            ret.setWorkerSpecial(Integer.parseInt(new Regex(servercheck, "workerinteractive=(\\d+)").getMatch(0)));
        }
        catch (NumberFormatException e) {
            ret.setError("API Error!");
        }
        if (!this.config.getApiKey().matches("^[a-zA-Z0-9]+$")) {
            ret.setError("API Key is not correct!");
        } else {
            String credits = br.getPage(this.getAPIROOT() + "index.cgi?action=usercaptchaguthaben&apikey=" + Encoding.urlEncode((String)this.config.getApiKey()));
            LoggerFactory.getDefaultLogger().info("\r\n" + br.getRequest());
            try {
                ret.setCreditBalance(Integer.parseInt(credits.trim()));
                String userhistory1 = br.getPage(this.getAPIROOT() + "index.cgi?action=userhistory&short=1&apikey=" + Encoding.urlEncode((String)this.config.getApiKey()));
                String userhistory2 = br.getPage(this.getAPIROOT() + "index.cgi?action=userhistory2&short=1&apikey=" + Encoding.urlEncode((String)this.config.getApiKey()));
                ret.setAnswered9kw(Integer.parseInt(Regex.getLines((String)userhistory2)[0]));
                ret.setSolved9kw(Integer.parseInt(Regex.getLines((String)userhistory1)[0]));
            }
            catch (NumberFormatException e) {
                ret.setError(credits);
            }
        }
        return ret;
    }

    @Override
    public String getType() {
        return _GUI.T.Captcha9kwSolver_getName_();
    }

    @Override
    public boolean isEnabled() {
        return this.config.isEnabledGlobally() && (this.config.ispuzzle() || this.config.ismouse() || this.config.isEnabled());
    }

    @Override
    public void setEnabled(boolean b) {
        if (b) {
            this.config.setEnabledGlobally(true);
            if (!this.config.isEnabled() || this.config.ispuzzle() || this.config.ismouse()) {
                this.config.setEnabled(b);
                this.config.setmouse(b);
                this.config.setpuzzle(b);
            }
        } else {
            this.config.setEnabledGlobally(false);
        }
    }

    private void updateServicePanel(boolean b) {
        if (!Application.isHeadless()) {
            ServicePanel.getInstance().requestUpdate(b);
        }
    }

    private NineKwSolverService() {
        AdvancedConfigManager.getInstance().register(this.config);
        if (!Application.isHeadless()) {
            SecondLevelLaunch.GUI_COMPLETE.executeWhenReached(new Runnable(){

                @Override
                public void run() {
                    ServicePanel.getInstance().addExtender((ServicePanelExtender)NineKwSolverService.this);
                    CFG_9KWCAPTCHA.API_KEY.getEventSender().addListener((EventListener)new GenericConfigEventListener<String>(){

                        public void onConfigValueModified(KeyHandler<String> keyHandler, String newValue) {
                            NineKwSolverService.this.updateServicePanel(true);
                        }

                        public void onConfigValidatorError(KeyHandler<String> keyHandler, String invalidValue, ValidationException validateException) {
                        }
                    });
                    CFG_9KWCAPTCHA.ENABLED_GLOBALLY.getEventSender().addListener((EventListener)new GenericConfigEventListener<Boolean>(){

                        public void onConfigValidatorError(KeyHandler<Boolean> keyHandler, Boolean invalidValue, ValidationException validateException) {
                        }

                        public void onConfigValueModified(KeyHandler<Boolean> keyHandler, Boolean newValue) {
                            NineKwSolverService.this.updateServicePanel(true);
                        }
                    });
                    CFG_9KWCAPTCHA.ENABLED.getEventSender().addListener((EventListener)new GenericConfigEventListener<Boolean>(){

                        public void onConfigValidatorError(KeyHandler<Boolean> keyHandler, Boolean invalidValue, ValidationException validateException) {
                        }

                        public void onConfigValueModified(KeyHandler<Boolean> keyHandler, Boolean newValue) {
                            NineKwSolverService.this.updateServicePanel(true);
                        }
                    });
                    CFG_9KWCAPTCHA.MOUSE.getEventSender().addListener((EventListener)new GenericConfigEventListener<Boolean>(){

                        public void onConfigValidatorError(KeyHandler<Boolean> keyHandler, Boolean invalidValue, ValidationException validateException) {
                        }

                        public void onConfigValueModified(KeyHandler<Boolean> keyHandler, Boolean newValue) {
                            NineKwSolverService.this.updateServicePanel(true);
                        }
                    });
                    CFG_9KWCAPTCHA.PUZZLE.getEventSender().addListener((EventListener)new GenericConfigEventListener<Boolean>(){

                        public void onConfigValidatorError(KeyHandler<Boolean> keyHandler, Boolean invalidValue, ValidationException validateException) {
                        }

                        public void onConfigValueModified(KeyHandler<Boolean> keyHandler, Boolean newValue) {
                            NineKwSolverService.this.updateServicePanel(true);
                        }
                    });
                }
            });
        }
    }

    @Override
    public Map<String, Integer> getWaitForOthersDefaultMap() {
        HashMap<String, Integer> ret = new HashMap<String, Integer>();
        ret.put("jac", 30000);
        return ret;
    }

    @Override
    public Icon getIcon(int size) {
        return new AbstractIcon("logo/9kw", size);
    }

    @Override
    public AbstractCaptchaSolverConfigPanel getConfigPanel() {
        return new NineKwConfigPanel(this);
    }

    @Override
    public boolean hasConfigPanel() {
        return true;
    }

    @Override
    public String getName() {
        return _GUI.T.Captcha9kwSolver_gettypeName_();
    }

    @Override
    public Captcha9kwSettings getConfig() {
        return this.config;
    }

    @Override
    public String getID() {
        return ID;
    }

    public void setTextSolver(Captcha9kwSolver captcha9kwSolver) {
        this.textSolver = captcha9kwSolver;
    }

    public void setClickSolver(Captcha9kwSolverClick captcha9kwSolverClick) {
        this.clickSolver = captcha9kwSolverClick;
    }

    public void setMultiClickSolver(Captcha9kwSolverMultiClick captcha9kwSolverMultiClick) {
        this.multiclickSolver = captcha9kwSolverMultiClick;
    }
}

