/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.captcha.v2.solver.twocaptcha;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import jd.http.Browser;
import jd.http.Request;
import jd.http.requests.PostRequest;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.Storable;
import org.appwork.storage.TypeRef;
import org.appwork.storage.config.JsonConfig;
import org.appwork.utils.IO;
import org.appwork.utils.StringUtils;
import org.appwork.utils.encoding.Base64;
import org.appwork.utils.logging2.LogSource;
import org.jdownloader.captcha.v2.AbstractResponse;
import org.jdownloader.captcha.v2.Challenge;
import org.jdownloader.captcha.v2.SolverStatus;
import org.jdownloader.captcha.v2.challenge.cloudflareturnstile.CloudflareTurnstileChallenge;
import org.jdownloader.captcha.v2.challenge.cutcaptcha.CutCaptchaChallenge;
import org.jdownloader.captcha.v2.challenge.hcaptcha.AbstractHCaptcha;
import org.jdownloader.captcha.v2.challenge.hcaptcha.HCaptchaChallenge;
import org.jdownloader.captcha.v2.challenge.recaptcha.v2.AbstractRecaptchaV2;
import org.jdownloader.captcha.v2.challenge.recaptcha.v2.RecaptchaV2Challenge;
import org.jdownloader.captcha.v2.challenge.stringcaptcha.BasicCaptchaChallenge;
import org.jdownloader.captcha.v2.challenge.stringcaptcha.ImageCaptchaChallenge;
import org.jdownloader.captcha.v2.solver.CESChallengeSolver;
import org.jdownloader.captcha.v2.solver.CESSolverJob;
import org.jdownloader.captcha.v2.solver.jac.SolverException;
import org.jdownloader.captcha.v2.solver.twocaptcha.TwoCaptchaAccount;
import org.jdownloader.captcha.v2.solver.twocaptcha.TwoCaptchaConfigInterface;
import org.jdownloader.captcha.v2.solver.twocaptcha.TwoCaptchaResponse;
import org.jdownloader.captcha.v2.solver.twocaptcha.TwoCaptchaSolverService;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.images.NewTheme;
import org.jdownloader.logging.LogController;
import org.jdownloader.settings.staticreferences.CFG_TWO_CAPTCHA;

public class TwoCaptchaSolver
extends CESChallengeSolver<String> {
    private static final TwoCaptchaSolver INSTANCE = new TwoCaptchaSolver();
    private String accountStatusString;
    protected final TwoCaptchaConfigInterface config;
    AtomicInteger counter = new AtomicInteger();
    AtomicInteger counterInterrupted = new AtomicInteger();
    AtomicInteger counterNotOK = new AtomicInteger();
    AtomicInteger counterOK = new AtomicInteger();
    AtomicInteger counterSend = new AtomicInteger();
    AtomicInteger counterSendError = new AtomicInteger();
    AtomicInteger counterSolved = new AtomicInteger();
    AtomicInteger counterUnused = new AtomicInteger();
    protected final LogSource logger;

    public static TwoCaptchaSolver getInstance() {
        return INSTANCE;
    }

    @Override
    public Class<String> getResultType() {
        return String.class;
    }

    @Override
    public TwoCaptchaSolverService getService() {
        return (TwoCaptchaSolverService)super.getService();
    }

    private TwoCaptchaSolver() {
        super(new TwoCaptchaSolverService(), Math.max(1, Math.min(25, ((TwoCaptchaConfigInterface)JsonConfig.create(TwoCaptchaConfigInterface.class)).getThreadpoolSize())));
        this.config = (TwoCaptchaConfigInterface)JsonConfig.create(TwoCaptchaConfigInterface.class);
        this.logger = LogController.getInstance().getLogger(TwoCaptchaSolver.class.getName());
        this.threadPool.allowCoreThreadTimeOut(true);
        this.getService().setSolver(this);
    }

    @Override
    protected LogSource getLogger() {
        return this.logger;
    }

    @Override
    public String getAccountStatusString() {
        return this.accountStatusString;
    }

    @Override
    protected void solveBasicCaptchaChallenge(CESSolverJob<String> job, BasicCaptchaChallenge challenge) throws SolverException {
    }

    protected String getApiBaseV2() {
        return "https://api.2captcha.com";
    }

    @Override
    protected boolean isChallengeSupported(Challenge<?> c) {
        if (c instanceof RecaptchaV2Challenge || c instanceof BasicCaptchaChallenge) {
            return true;
        }
        if (c instanceof CutCaptchaChallenge) {
            return true;
        }
        return c instanceof CloudflareTurnstileChallenge;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void solveCES(CESSolverJob<String> job) throws InterruptedException, SolverException {
        Challenge<String> captchaChallenge = job.getChallenge();
        try {
            Challenge challenge;
            HashMap<String, Object> postdata = new HashMap<String, Object>();
            postdata.put("clientKey", this.config.getApiKey());
            HashMap<String, Object> task = new HashMap<String, Object>();
            if (captchaChallenge instanceof RecaptchaV2Challenge) {
                challenge = (RecaptchaV2Challenge)job.getChallenge();
                task.put("type", "RecaptchaV2TaskProxyless");
                task.put("websiteKey", ((RecaptchaV2Challenge)challenge).getSiteKey());
                task.put("websiteURL", ((RecaptchaV2Challenge)challenge).getSiteUrl());
                Map<String, Object> action = ((RecaptchaV2Challenge)challenge).getV3Action();
                if (((RecaptchaV2Challenge)challenge).isV3() || action != null) {
                    task.put("type", "RecaptchaV3TaskProxyless");
                    task.put("isEnterprise", ((RecaptchaV2Challenge)challenge).isEnterprise());
                } else if (((RecaptchaV2Challenge)challenge).isEnterprise()) {
                    task.put("type", "RecaptchaV2EnterpriseTaskProxyless");
                }
                if (action != null) {
                    task.put("pageAction", action.get("action"));
                }
                task.put("isInvisible", AbstractRecaptchaV2.TYPE.INVISIBLE.equals(((RecaptchaV2Challenge)challenge).getType()));
                Double minScore = ((RecaptchaV2Challenge)challenge).getMinScore();
                if (minScore != null) {
                    task.put("minScore", minScore);
                }
                if (((RecaptchaV2Challenge)challenge).isEnterprise() && StringUtils.containsIgnoreCase((String)((RecaptchaV2Challenge)challenge).getSiteUrl(), (String)"filer.net")) {
                    task.put("type", "RecaptchaV2EnterpriseTaskProxyless");
                }
            } else if (captchaChallenge instanceof HCaptchaChallenge) {
                challenge = (HCaptchaChallenge)job.getChallenge();
                task.put("type", "HCaptchaTaskProxyless");
                task.put("websiteURL", ((HCaptchaChallenge)challenge).getSiteUrl());
                task.put("websiteKey", ((HCaptchaChallenge)challenge).getSiteKey());
                AbstractHCaptcha<?> hCaptcha = ((HCaptchaChallenge)challenge).getAbstractCaptchaHelperHCaptcha();
                if (hCaptcha != null && AbstractHCaptcha.TYPE.INVISIBLE.equals((Object)hCaptcha.getType())) {
                    task.put("isInvisible", true);
                }
            } else if (captchaChallenge instanceof CutCaptchaChallenge) {
                challenge = (CutCaptchaChallenge)job.getChallenge();
                challenge.sendStatsSolving(this);
                task.put("type", "CutCaptchaTaskProxyless");
                task.put("miseryKey", ((CutCaptchaChallenge)challenge).getSiteKey());
                task.put("apiKey", ((CutCaptchaChallenge)challenge).getApiKey());
                task.put("websiteURL", ((CutCaptchaChallenge)challenge).getSiteUrl());
            } else if (captchaChallenge instanceof CloudflareTurnstileChallenge) {
                challenge = (CloudflareTurnstileChallenge)job.getChallenge();
                challenge.sendStatsSolving(this);
                task.put("type", "TurnstileTaskProxyless");
                task.put("websiteURL", ((CloudflareTurnstileChallenge)challenge).getSiteUrl());
                task.put("websiteKey", ((CloudflareTurnstileChallenge)challenge).getSiteKey());
            } else {
                challenge = (ImageCaptchaChallenge)job.getChallenge();
                byte[] data = IO.readFile((File)((ImageCaptchaChallenge)challenge).getImageFile());
                task.put("type", "ImageToTextTask");
                task.put("body", Base64.encodeToString((byte[])data, (boolean)false));
                task.put("comment", challenge.getExplain());
            }
            postdata.put("task", task);
            job.showBubble(this);
            TwoCaptchaSolver.checkInterruption();
            job.getChallenge().sendStatsSolving(this);
            job.setStatus(SolverStatus.SOLVING);
            Browser br = this.createNewBrowserInstance(captchaChallenge);
            PostRequest req_createTask = br.createJSonPostRequest(this.getApiBaseV2() + "/createTask", postdata);
            br.getPage((Request)req_createTask);
            BalanceResponse resp_createTask = (BalanceResponse)JSonStorage.restoreFromString((String)br.getRequest().getHtmlCode(), (TypeRef)new TypeRef<BalanceResponse>(){});
            if (resp_createTask.getErrorId() != 0) {
                throw new IOException("Captcha image upload failure, status: " + resp_createTask.getStatus());
            }
            String id = resp_createTask.getTaskId();
            HashMap<String, String> postdata_getTaskResult = new HashMap<String, String>();
            postdata_getTaskResult.put("clientKey", this.config.getApiKey());
            postdata_getTaskResult.put("taskId", id);
            job.setStatus(new SolverStatus(_GUI.T.DeathByCaptchaSolver_solveBasicCaptchaChallenge_solving(), NewTheme.I().getIcon("wait", 10)));
            while (job.getJob().isAlive() && !job.getJob().isSolved()) {
                TwoCaptchaSolver.checkInterruption();
                PostRequest req_getTaskResult = br.createJSonPostRequest(this.getApiBaseV2() + "/getTaskResult", postdata_getTaskResult);
                br.getPage((Request)req_getTaskResult);
                BalanceResponse resp_getTaskResult = (BalanceResponse)JSonStorage.restoreFromString((String)br.getRequest().getHtmlCode(), (TypeRef)new TypeRef<BalanceResponse>(){});
                String status = resp_getTaskResult.getStatus();
                if (status.equals("processing")) {
                    Thread.sleep(5000L);
                    continue;
                }
                if (status.equals("ready")) {
                    Solution solution = resp_getTaskResult.getSolution();
                    String resultText = solution.getgRecaptchaResponse() != null ? solution.getgRecaptchaResponse() : (solution.getToken() != null ? solution.getToken() : (solution.getCorrdinates() != null && solution.getCorrdinates().size() > 0 ? "TODO_IMPLEMENT_CLICK_CAPTCHA" : solution.getText()));
                    job.setAnswer(new TwoCaptchaResponse(captchaChallenge, this, id, resultText));
                    return;
                }
                throw new IOException("Captcha task polling failure, status: " + status);
            }
        }
        catch (IOException e) {
            job.getChallenge().sendStatsError(this, e);
            job.getLogger().log((Throwable)e);
        }
        finally {
            System.out.println(1);
        }
    }

    @Override
    protected boolean validateLogins() {
        if (!CFG_TWO_CAPTCHA.ENABLED.isEnabled()) {
            return false;
        }
        return this.looksLikeValidAPIKey(CFG_TWO_CAPTCHA.API_KEY.getValue());
    }

    @Override
    protected boolean looksLikeValidAPIKey(String str) {
        if (str == null) {
            return false;
        }
        return str.matches("[a-f0-9]{32}");
    }

    @Override
    public boolean setInvalid(AbstractResponse<?> response) {
        return this.sendCaptchaFeedback(response, false);
    }

    @Override
    public boolean setValid(AbstractResponse<?> response) {
        return this.sendCaptchaFeedback(response, true);
    }

    private final boolean sendCaptchaFeedback(AbstractResponse<?> response, boolean positiveFeedback) {
        if (!this.config.isFeedBackSendingEnabled()) {
            return false;
        }
        TwoCaptchaResponse twocaptcharesponse = (TwoCaptchaResponse)response;
        String captchaID = twocaptcharesponse.getCaptchaID();
        Browser br = this.createNewBrowserInstance(null);
        try {
            String url = positiveFeedback ? "/reportCorrect" : "/reportIncorrect";
            HashMap<String, String> postdata = new HashMap<String, String>();
            postdata.put("clientKey", this.config.getApiKey());
            postdata.put("taskId", captchaID);
            PostRequest req = br.createJSonPostRequest(this.getApiBaseV2() + url, postdata);
            br.getPage((Request)req);
            BalanceResponse resp = (BalanceResponse)JSonStorage.restoreFromString((String)br.getRequest().getHtmlCode(), (TypeRef)new TypeRef<BalanceResponse>(){});
            return "success".equalsIgnoreCase(resp.getStatus());
        }
        catch (Throwable e) {
            e.printStackTrace();
            return false;
        }
    }

    public TwoCaptchaAccount loadAccount() {
        TwoCaptchaAccount ret = new TwoCaptchaAccount();
        try {
            Browser br = this.createNewBrowserInstance(null);
            HashMap<String, String> postdata = new HashMap<String, String>();
            postdata.put("clientKey", this.config.getApiKey());
            PostRequest req = br.createJSonPostRequest(this.getApiBaseV2() + "/getBalance", postdata);
            String json = br.getPage((Request)req);
            BalanceResponse response = (BalanceResponse)JSonStorage.restoreFromString((String)json, (TypeRef)new TypeRef<BalanceResponse>(){});
            if (response.getErrorId() != 0) {
                ret.setError("Error code " + response.getErrorId() + ": " + response.getErrorDescription());
                return ret;
            }
            ret.setBalance(response.getBalance());
            ret.setUserName(this.config.getApiKey());
        }
        catch (Exception e) {
            this.logger.log((Throwable)e);
            ret.setError(e.getMessage());
        }
        return ret;
    }

    public static class Coordinates
    implements Storable {
        private int x;
        private int y;

        public int getX() {
            return this.x;
        }

        public void setX(int x) {
            this.x = x;
        }

        public int getY() {
            return this.y;
        }

        public void setY(int y) {
            this.y = y;
        }
    }

    public static class Solution
    implements Storable {
        private String gRecaptchaResponse;
        private String token;
        private String text;
        private List<Coordinates> corrdinates;

        public String getgRecaptchaResponse() {
            return this.gRecaptchaResponse;
        }

        public void setgRecaptchaResponse(String gRecaptchaResponse) {
            this.gRecaptchaResponse = gRecaptchaResponse;
        }

        public String getToken() {
            return this.token;
        }

        public void setToken(String token) {
            this.token = token;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }

        public List<Coordinates> getCorrdinates() {
            return this.corrdinates;
        }

        public void setCorrdinates(List<Coordinates> corrdinates) {
            this.corrdinates = corrdinates;
        }
    }

    public static class BalanceResponse
    implements Storable {
        private int errorId;
        private String taskId;
        private Double balance;
        private String cost;
        private String status;
        private Solution solution;
        private String errorCode;
        private String errorDescription;

        public int getErrorId() {
            return this.errorId;
        }

        public void setErrorId(int errorId) {
            this.errorId = errorId;
        }

        public Double getBalance() {
            return this.balance;
        }

        public void setBalance(Double balance) {
            this.balance = balance;
        }

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public String getCost() {
            return this.cost;
        }

        public void setCost(String cost) {
            this.cost = cost;
        }

        public Solution getSolution() {
            return this.solution;
        }

        public void setSolution(Solution solution) {
            this.solution = solution;
        }

        public String getTaskId() {
            return this.taskId;
        }

        public void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public String getErrorDescription() {
            return this.errorDescription;
        }

        public void setErrorDescription(String errorDescription) {
            this.errorDescription = errorDescription;
        }
    }
}

