/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.controlling;

import java.io.File;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class FileStateManager {
    private static final FileStateManager INSTANCE = new FileStateManager();
    private final HashMap<File, ArrayList<FileStateOwner>> fileStates = new HashMap();

    public static final FileStateManager getInstance() {
        return INSTANCE;
    }

    private FileStateManager() {
    }

    public synchronized void requestFileState(File file, FILESTATE fileState, Object owner) {
        if (file != null && fileState != null && owner != null) {
            ArrayList<FileStateOwner> fileStateList = this.fileStates.get(file);
            if (fileStateList == null) {
                fileStateList = new ArrayList();
                this.fileStates.put(file, fileStateList);
            }
            fileStateList.add(new FileStateOwner(fileState, owner));
        }
    }

    public synchronized void releaseFileState(File file, Object owner) {
        this.releaseFileState(file, null, owner);
    }

    public synchronized boolean hasFileState(File file, FILESTATE fileState) {
        ArrayList<FileStateOwner> fileStateList;
        if (file != null && fileState != null && (fileStateList = this.fileStates.get(file)) != null) {
            for (FileStateOwner fileStateOwner : fileStateList) {
                if (fileStateOwner.getOwner() == null || !fileState.equals((Object)fileStateOwner.getFileState())) continue;
                return true;
            }
        }
        return false;
    }

    public synchronized void releaseFileState(File file, FILESTATE fileState, Object owner) {
        ArrayList<FileStateOwner> fileStateList;
        if (file != null && owner != null && (fileStateList = this.fileStates.get(file)) != null) {
            Iterator<FileStateOwner> it = fileStateList.iterator();
            while (it.hasNext()) {
                FileStateOwner next = it.next();
                Object nextOwner = next.getOwner();
                if (nextOwner == null) {
                    it.remove();
                    continue;
                }
                if (owner != nextOwner || fileState != null && !fileState.equals((Object)next.getFileState())) continue;
                it.remove();
            }
            if (fileStateList.size() == 0) {
                this.fileStates.remove(file);
            }
        }
    }

    private static class FileStateOwner {
        private final FILESTATE fileState;
        private final WeakReference<Object> owner;

        private final FILESTATE getFileState() {
            return this.fileState;
        }

        private final Object getOwner() {
            return this.owner.get();
        }

        private FileStateOwner(FILESTATE fileState, Object owner) {
            this.fileState = fileState;
            this.owner = new WeakReference<Object>(owner);
        }
    }

    public static enum FILESTATE {
        WRITE_EXCLUSIVE;

    }
}

