/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.controlling.contextmenu;

import java.awt.Window;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ScheduledExecutorService;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import jd.SecondLevelLaunch;
import jd.controlling.packagecontroller.AbstractPackageChildrenNode;
import jd.controlling.packagecontroller.AbstractPackageNode;
import org.appwork.scheduler.DelayedRunnable;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.TypeRef;
import org.appwork.storage.config.JsonConfig;
import org.appwork.uio.UIOManager;
import org.appwork.uio.UserIODefinition;
import org.appwork.utils.Application;
import org.appwork.utils.IO;
import org.appwork.utils.StringUtils;
import org.appwork.utils.logging2.LogSource;
import org.appwork.utils.swing.EDTHelper;
import org.appwork.utils.swing.EDTRunner;
import org.appwork.utils.swing.dialog.Dialog;
import org.appwork.utils.swing.windowmanager.WindowManager;
import org.jdownloader.controlling.contextmenu.ActionData;
import org.jdownloader.controlling.contextmenu.ContextMenuConfigInterface;
import org.jdownloader.controlling.contextmenu.MenuContainer;
import org.jdownloader.controlling.contextmenu.MenuContainerRoot;
import org.jdownloader.controlling.contextmenu.MenuExtenderHandler;
import org.jdownloader.controlling.contextmenu.MenuItemData;
import org.jdownloader.controlling.contextmenu.MenuLink;
import org.jdownloader.controlling.contextmenu.MenuStructure;
import org.jdownloader.controlling.contextmenu.SeparatorData;
import org.jdownloader.controlling.contextmenu.gui.ExtPopupMenu;
import org.jdownloader.controlling.contextmenu.gui.MenuBuilder;
import org.jdownloader.controlling.contextmenu.gui.MenuManagerDialog;
import org.jdownloader.controlling.contextmenu.gui.MenuManagerDialogInterface;
import org.jdownloader.logging.LogController;

public abstract class ContextMenuManager<PackageType extends AbstractPackageNode<ChildrenType, PackageType>, ChildrenType extends AbstractPackageChildrenNode<PackageType>> {
    protected final DelayedRunnable updateDelayer;
    private static final ScheduledExecutorService SERVICE = DelayedRunnable.getNewScheduledExecutorService();
    private boolean managerVisible = false;
    protected MenuManagerDialog dialogFrame;
    private volatile MenuContainerRoot menuData;
    ContextMenuConfigInterface config;
    LogSource logger;
    private final CopyOnWriteArraySet<MenuExtenderHandler> extender = new CopyOnWriteArraySet();
    private Runnable afterInitCallback;

    public ContextMenuManager() {
        if (Application.isHeadless()) {
            this.updateDelayer = null;
            return;
        }
        this.config = (ContextMenuConfigInterface)JsonConfig.create((File)Application.getResource((String)("cfg/menus_v2/" + this.getStorageKey())), ContextMenuConfigInterface.class);
        this.logger = LogController.getInstance().getLogger(this.getClass().getName());
        this.updateDelayer = new DelayedRunnable(SERVICE, 1000L, 2000L){

            public String getID() {
                return "MenuManager-" + ContextMenuManager.this.getClass();
            }

            public void delayedrun() {
                ContextMenuManager.this.updateGui();
            }
        };
    }

    public void exportTo(File saveTo) throws UnsupportedEncodingException, IOException {
        File file = null;
        int i = 1;
        while (file == null || file.exists()) {
            file = new File(saveTo, this.getStorageKey() + "_" + i + this.getFileExtension());
            ++i;
        }
        this.saveTo(this.config.getMenu(), file);
    }

    protected abstract String getStorageKey();

    protected static MenuItemData setAccelerator(MenuItemData menuItemData, KeyStroke keyStroke) {
        menuItemData.setShortcut(keyStroke == null ? null : keyStroke.toString());
        return menuItemData;
    }

    protected static ActionData setName(ActionData actionData, String name) {
        if (StringUtils.isEmpty((String)name)) {
            name = "<EMPTY>";
        }
        actionData.setName(name);
        return actionData;
    }

    protected static ActionData setTooltip(ActionData actionData, String tooltip) {
        if (StringUtils.isEmpty((String)tooltip)) {
            tooltip = "<EMPTY>";
        }
        actionData.setTooltip(tooltip);
        return actionData;
    }

    protected static MenuItemData setOptional(Class<?> class1) {
        return ContextMenuManager.setOptional(new MenuItemData(new ActionData(class1)));
    }

    protected static MenuItemData setOptional(MenuItemData menuItemData) {
        menuItemData.setVisible(false);
        return menuItemData;
    }

    protected static ActionData setIconKey(ActionData putSetup, String KEY2) {
        putSetup.setIconKey(KEY2);
        return putSetup;
    }

    protected abstract void updateGui();

    public JPopupMenu build(MouseEvent ev) {
        ExtPopupMenu root = new ExtPopupMenu();
        MenuContainerRoot md = this.getMenuData();
        new MenuBuilder(this, root, md).setHideOnClick(!ev.isShiftDown()).run();
        return root;
    }

    public void openGui() {
        new Thread("Manager"){

            @Override
            public void run() {
                if (ContextMenuManager.this.managerVisible) {
                    new EDTRunner(){

                        protected void runInEDT() {
                            WindowManager.getInstance().setZState((Window)ContextMenuManager.this.dialogFrame.getDialog(), WindowManager.FrameState.TO_FRONT_FOCUSED);
                        }
                    };
                    return;
                }
                ContextMenuManager.this.managerVisible = true;
                try {
                    ContextMenuManager.this.dialogFrame = new MenuManagerDialog(ContextMenuManager.this);
                    UIOManager.I().show(MenuManagerDialogInterface.class, (UserIODefinition)ContextMenuManager.this.dialogFrame);
                }
                finally {
                    ContextMenuManager.this.managerVisible = false;
                }
            }
        }.start();
    }

    public LogSource getLogger() {
        return this.logger;
    }

    public List<Object> list() {
        ArrayList<Object> ret = new ArrayList<Object>();
        ret.add(new SeparatorData());
        for (MenuItemData mid : this.setupDefaultStructure().list()) {
            if (mid instanceof MenuContainerRoot) continue;
            if (MenuContainer.class.isAssignableFrom(mid.getClass().getSuperclass())) {
                if (StringUtils.isEmpty((String)mid.getName()) || mid.getClass() == MenuContainer.class) continue;
                ret.add(mid);
                continue;
            }
            if (mid instanceof MenuLink) {
                ret.add(mid);
                continue;
            }
            if (mid instanceof MenuLink || mid.getActionData() == null || !mid.getActionData()._isValidDataForCreatingAnAction()) continue;
            ret.add(mid.getActionData());
        }
        return ret;
    }

    public MenuContainerRoot getMenuData() {
        if (!SecondLevelLaunch.EXTENSIONS_LOADED.isReached()) {
            return new MenuContainerRoot();
        }
        return (MenuContainerRoot)new EDTHelper<MenuContainerRoot>(){

            public MenuContainerRoot edtRun() {
                long t = System.currentTimeMillis();
                if (ContextMenuManager.this.menuData != null) {
                    return ContextMenuManager.this.menuData;
                }
                try {
                    ContextMenuManager.this.convertOldFiles();
                    MenuContainerRoot ret = ContextMenuManager.this.config.getMenu();
                    MenuContainerRoot defaultMenu = ContextMenuManager.this.setupDefaultStructure();
                    if (ret == null) {
                        ret = defaultMenu;
                    } else {
                        ret._setOwner(ContextMenuManager.this);
                        ret.validate();
                        List<MenuItemData> allItemsInMenu = ret.list();
                        List<MenuItemData> allItemsInDefaultMenu = defaultMenu.list();
                        HashMap<String, MenuItemData> itemsIdsInMenu = new HashMap<String, MenuItemData>();
                        HashMap<String, MenuItemData> itemsInDefaultMenu = new HashMap<String, MenuItemData>();
                        for (MenuItemData d : allItemsInDefaultMenu) {
                            itemsInDefaultMenu.put(d._getIdentifier(), d);
                        }
                        for (MenuItemData d : allItemsInMenu) {
                            itemsIdsInMenu.put(d._getIdentifier(), d);
                        }
                        ArrayList<String> unused = ContextMenuManager.this.config.getUnusedItems();
                        if (unused == null) {
                            unused = new ArrayList();
                        }
                        ArrayList newActions = new ArrayList();
                        HashSet<String> idsInUnusedList = new HashSet<String>(unused);
                        for (Map.Entry e : itemsInDefaultMenu.entrySet()) {
                            if (idsInUnusedList.contains(e.getKey()) || itemsIdsInMenu.containsKey(e.getKey())) continue;
                            newActions.add(e.getValue());
                        }
                        if (newActions.size() > 0) {
                            List<List<MenuItemData>> paths = defaultMenu.listPaths();
                            HashSet<String> itemsInSubmenuItems = new HashSet<String>();
                            for (MenuItemData ad : newActions) {
                                if (ad.getItems() == null) continue;
                                for (MenuItemData menuItemData : ad.list()) {
                                    if (menuItemData == ad) continue;
                                    itemsInSubmenuItems.add(menuItemData._getIdentifier());
                                }
                            }
                            for (MenuItemData ad : newActions) {
                                if (itemsInSubmenuItems.contains(ad._getIdentifier())) continue;
                                for (List list : paths) {
                                    if (!StringUtils.equals((String)((MenuItemData)list.get(list.size() - 1))._getIdentifier(), (String)ad._getIdentifier())) continue;
                                    try {
                                        ret.add(list);
                                    }
                                    catch (Throwable e) {
                                        ContextMenuManager.this.logger.log(e);
                                    }
                                }
                            }
                        }
                    }
                    ret._setOwner(ContextMenuManager.this);
                    ret.validate();
                    ContextMenuManager.this.menuData = ret;
                    ContextMenuManager.this.onSetupMenuData(ContextMenuManager.this.menuData);
                    return ret;
                }
                catch (Exception e) {
                    ContextMenuManager.this.logger.log((Throwable)e);
                    try {
                        ContextMenuManager.this.menuData = ContextMenuManager.this.setupDefaultStructure();
                        ContextMenuManager.this.menuData.validate();
                        ContextMenuManager.this.onSetupMenuData(ContextMenuManager.this.menuData);
                        return ContextMenuManager.this.menuData;
                    }
                    catch (Exception e1) {
                        ContextMenuManager.this.logger.log((Throwable)e1);
                        ContextMenuManager.this.menuData = new MenuContainerRoot();
                        ContextMenuManager.this.menuData._setOwner(ContextMenuManager.this);
                        ContextMenuManager.this.menuData.validate();
                        ContextMenuManager.this.onSetupMenuData(ContextMenuManager.this.menuData);
                        return ContextMenuManager.this.menuData;
                    }
                }
            }
        }.getReturnValue();
    }

    protected void onSetupMenuData(MenuContainerRoot menuData) {
    }

    private void convertOldFiles() {
    }

    public abstract MenuContainerRoot createDefaultStructure();

    public MenuContainerRoot setupDefaultStructure() {
        MenuContainerRoot ret = this.createDefaultStructure();
        ret._setOwner(this);
        for (MenuExtenderHandler exHandler : this.extender) {
            try {
                MenuItemData r = exHandler.updateMenuModel(this, ret);
                if (r == null) continue;
                ret.addBranch(ret, r);
            }
            catch (Throwable e) {
                this.getLogger().log(e);
            }
        }
        return ret;
    }

    public void setMenuData(MenuContainerRoot root) {
        String rootString = JSonStorage.serializeToJson((Object)root);
        String orgDefString = JSonStorage.serializeToJson((Object)this.setupDefaultStructure());
        MenuContainerRoot def = (MenuContainerRoot)JSonStorage.restoreFromString((String)orgDefString, (TypeRef)new TypeRef<MenuContainerRoot>(){});
        def._setRoot(root);
        def._setOwner(root._getOwner());
        def.validate();
        String defaultString = JSonStorage.serializeToJson((Object)def);
        if (rootString.equals(defaultString)) {
            root = null;
        }
        if (root == null) {
            this.config.setMenu(null);
            this.config.setUnusedItems(null);
            this.menuData = this.setupDefaultStructure();
            this.menuData.validate();
        } else {
            this.menuData = root;
            this.config.setMenu(root);
            this.config.setUnusedItems(this.getUnused(root));
        }
        this.updateGui();
    }

    private ArrayList<String> getUnused(MenuContainerRoot root) {
        ArrayList<String> list = new ArrayList<String>();
        List<MenuItemData> allItemsInMenu = root.list();
        HashSet<String> actionClassesInMenu = new HashSet<String>();
        for (MenuItemData d : allItemsInMenu) {
            actionClassesInMenu.add(d._getIdentifier());
        }
        for (MenuItemData e : this.setupDefaultStructure().list()) {
            if (!actionClassesInMenu.add(e._getIdentifier())) continue;
            list.add(e._getIdentifier());
        }
        return list;
    }

    public void saveTo(MenuContainerRoot root, File saveTo) throws UnsupportedEncodingException, IOException {
        if (root == null) {
            Dialog.getInstance().showErrorDialog("Cannot export '" + this.getName() + "', because there is no custom menu");
        } else {
            IO.secureWrite((File)saveTo, (byte[])JSonStorage.serializeToJson((Object)new MenuStructure(root, this.getUnused(root))).getBytes("UTF-8"));
        }
    }

    public void importFrom(File f) throws IOException {
        MenuStructure data = this.readFrom(f);
        data.getRoot().validateFull();
        this.setMenuData(data.getRoot());
        Dialog.getInstance().showMessageDialog("Imported '" + this.getName() + "");
    }

    public MenuStructure readFrom(File file) throws IOException {
        return (MenuStructure)JSonStorage.restoreFromString((String)IO.readFileToString((File)file), (TypeRef)new TypeRef<MenuStructure>(){});
    }

    public void registerExtender(MenuExtenderHandler handler) {
        if (!Application.isHeadless() && this.extender.add(handler)) {
            new EDTRunner(){

                protected void runInEDT() {
                    ContextMenuManager.this.menuData = null;
                }
            };
            this.delayUpdate();
        }
    }

    public void refresh() {
        this.delayUpdate();
    }

    public void unregisterExtender(MenuExtenderHandler handler) {
        if (!Application.isHeadless() && this.extender.remove(handler)) {
            new EDTRunner(){

                protected void runInEDT() {
                    ContextMenuManager.this.menuData = null;
                }
            };
            this.delayUpdate();
        }
    }

    private void delayUpdate() {
        if (Application.isHeadless()) {
            new Exception("Headless!").printStackTrace();
            return;
        }
        if (!SecondLevelLaunch.EXTENSIONS_LOADED.isReached()) {
            if (this.afterInitCallback != null) {
                return;
            }
            this.afterInitCallback = new Runnable(){

                @Override
                public void run() {
                    ContextMenuManager.this.updateDelayer.resetAndStart();
                }
            };
            SecondLevelLaunch.EXTENSIONS_LOADED.executeWhenReached(this.afterInitCallback);
        } else {
            this.afterInitCallback = null;
            this.updateDelayer.resetAndStart();
        }
    }

    public ArrayList<MenuExtenderHandler> listExtender() {
        return new ArrayList<MenuExtenderHandler>(this.extender);
    }

    public abstract String getFileExtension();

    public abstract String getName();

    public boolean isAcceleratorsEnabled() {
        return false;
    }
}

