/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.controlling.contextmenu;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import org.appwork.swing.action.BasicAction;
import org.appwork.swing.components.CheckBoxIcon;
import org.appwork.swing.components.ExtMergedIcon;
import org.appwork.utils.DebugMode;
import org.appwork.utils.GetterSetter;
import org.appwork.utils.ReflectionUtils;
import org.appwork.utils.StringUtils;
import org.appwork.utils.images.IconIO;
import org.appwork.utils.images.TransparentIcon;
import org.appwork.utils.reflection.Clazz;
import org.appwork.utils.swing.EDTRunner;
import org.jdownloader.actions.AppAction;
import org.jdownloader.controlling.contextmenu.ActionContext;
import org.jdownloader.controlling.contextmenu.ActionData;
import org.jdownloader.controlling.contextmenu.ContextMenuManager;
import org.jdownloader.controlling.contextmenu.Customizer;
import org.jdownloader.controlling.contextmenu.MenuContainerRoot;
import org.jdownloader.controlling.contextmenu.MenuItemData;
import org.jdownloader.gui.views.downloads.action.Modifier;
import org.jdownloader.gui.views.linkgrabber.bottombar.IncludedSelectionSetup;
import org.jdownloader.images.NewTheme;

public abstract class CustomizableAppAction
extends AppAction {
    private MenuItemData menuItemData;
    private ArrayList<ActionContext> setupObjects;
    private long lastRequestUpdate;

    public MenuItemData getMenuItemData() {
        return this.menuItemData;
    }

    public List<ActionContext> getSetupObjects() {
        ArrayList<ActionContext> setupObjects = this.setupObjects;
        if (setupObjects != null) {
            return new ArrayList<ActionContext>(setupObjects);
        }
        return null;
    }

    protected ContextMenuManager _getOwner() {
        MenuItemData menuData = this.getMenuItemData();
        if (menuData == null) {
            return null;
        }
        MenuContainerRoot root = menuData._getRoot();
        if (root == null) {
            return null;
        }
        return root._getOwner();
    }

    protected static Icon getCheckBoxedIcon(String string, boolean selected, boolean enabled) {
        return new ExtMergedIcon(NewTheme.I().getIcon(string, 18), -2, -2).add((Icon)new TransparentIcon((Icon)new CheckBoxIcon(14, selected, enabled), 0.75f), 6, 6);
    }

    public boolean removeContextSetup(ActionContext contextSetup) {
        ArrayList<ActionContext> setupObjects = this.setupObjects;
        if (setupObjects != null) {
            return setupObjects.remove(contextSetup);
        }
        return false;
    }

    public void addContextSetup(ActionContext contextSetup) {
        this.addContextSetup(-1, contextSetup);
    }

    public void addContextSetup(int index, ActionContext contextSetup) {
        ArrayList<ActionContext> setupObjects = this.setupObjects;
        if (setupObjects == null) {
            this.setupObjects = new ArrayList();
            setupObjects = this.setupObjects;
        }
        if (index < 0) {
            if (!setupObjects.contains(contextSetup)) {
                setupObjects.add(contextSetup);
            }
        } else {
            int exist = setupObjects.indexOf(contextSetup);
            if (exist != -1 && exist != index) {
                setupObjects.remove(exist);
                setupObjects.add(index, contextSetup);
            } else if (exist == -1) {
                setupObjects.add(index, contextSetup);
            }
        }
    }

    public void loadContextSetups() {
        ArrayList<ActionContext> setupObjects = this.setupObjects;
        if (setupObjects != null) {
            this.fill(setupObjects);
        }
    }

    private void fill(List<ActionContext> setupObjects2) {
        if (setupObjects2 != null && this.menuItemData != null) {
            for (ActionContext setupObject : setupObjects2) {
                for (GetterSetter f : ReflectionUtils.getGettersSetteres(setupObject.getClass())) {
                    try {
                        if (f.getAnnotation(Customizer.class) == null) continue;
                        Class type = (Class)f.getType();
                        Object v = this.menuItemData.getActionData().fetchSetup(f.getKey());
                        if (v == null) continue;
                        if (Clazz.isEnum((Type)type)) {
                            if ((v = ReflectionUtils.getEnumValueOf((Class)type, (String)v.toString())) == null) {
                                continue;
                            }
                        } else if (f.getType() == Modifier.class) {
                            v = Modifier.create((String)v);
                        } else if (Clazz.isNumberType((Type)type)) {
                            v = ReflectionUtils.castNumber((Number)((Number)v), (Class)type);
                        }
                        f.set((Object)setupObject, v);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (!(setupObject instanceof IncludedSelectionSetup)) continue;
                ((IncludedSelectionSetup)setupObject).updateListeners();
            }
        }
    }

    public void requestUpdate(Object requestor) {
        this.lastRequestUpdate = System.currentTimeMillis();
        this.fill(this.setupObjects);
    }

    public void setName(String name) {
        String actualName = name;
        if (this.menuItemData != null) {
            ActionData actionData = this.menuItemData.getActionData();
            if (StringUtils.isNotEmpty((String)actionData.getName())) {
                name = actionData.getName();
            }
            if (StringUtils.isNotEmpty((String)this.menuItemData.getName())) {
                name = this.menuItemData.getName();
            }
        }
        if (MenuItemData.isEmptyValue(name)) {
            name = "";
        }
        if (StringUtils.isEmpty((String)actualName)) {
            actualName = this.getName();
        }
        if (StringUtils.isEmpty((String)this.getTooltipText()) && StringUtils.isEmpty((String)name) && StringUtils.isNotEmpty((String)actualName)) {
            this.setTooltipText(actualName);
        }
        super.setName(name);
    }

    public BasicAction setAccelerator(KeyStroke stroke) {
        if (this.menuItemData != null && StringUtils.isNotEmpty((String)this.menuItemData.getShortcut())) {
            stroke = KeyStroke.getKeyStroke(this.menuItemData.getShortcut());
        }
        if (stroke == null) {
            return this;
        }
        return super.setAccelerator(stroke);
    }

    public CustomizableAppAction() {
        if (this instanceof ActionContext) {
            this.addContextSetup((ActionContext)((Object)this));
        } else if (DebugMode.TRUE_IN_IDE_ELSE_FALSE) {
            for (Method method : ((Object)((Object)this)).getClass().getMethods()) {
                if (method.getAnnotation(Customizer.class) == null) continue;
                System.out.println(((Object)((Object)this)).getClass());
            }
        }
    }

    public void initContextDefaults() {
    }

    @Override
    public Object getValue(String key) {
        Object ret;
        if ("MnemonicKey" == key && System.currentTimeMillis() - this.lastRequestUpdate > 1000L) {
            System.out.println("Bad Action Usage!");
            new Exception().printStackTrace();
            this.requestUpdate(null);
        }
        if (this.iconKey != null && "SwingLargeIconKey".equalsIgnoreCase(key)) {
            if (MenuItemData.isEmptyValue(this.iconKey)) {
                return null;
            }
            return NewTheme.I().getIcon(this.iconKey, this.size);
        }
        if (this.iconKey != null && "SmallIcon".equalsIgnoreCase(key)) {
            if (MenuItemData.isEmptyValue(this.iconKey)) {
                return null;
            }
            return NewTheme.I().getIcon(this.iconKey, this.size);
        }
        if ("SwingLargeIconKey".equalsIgnoreCase(key)) {
            Object ret2 = super.getValue(key);
            if (ret2 != null && ret2 instanceof Icon && (((Icon)ret2).getIconWidth() > this.size || ((Icon)ret2).getIconHeight() > this.size)) {
                return IconIO.getScaledInstance((Icon)((Icon)ret2), (int)this.size, (int)this.size);
            }
        } else if ("SmallIcon".equalsIgnoreCase(key) && (ret = super.getValue(key)) != null && ret instanceof Icon && (((Icon)ret).getIconWidth() > this.size || ((Icon)ret).getIconHeight() > this.size)) {
            return IconIO.getScaledInstance((Icon)((Icon)ret), (int)this.size, (int)this.size);
        }
        return super.getValue(key);
    }

    public void setMenuItemData(MenuItemData data) {
        this.menuItemData = data;
        this.fill(this.setupObjects);
    }

    @Override
    public void setIconKey(String iconKey) {
        if (this.menuItemData != null) {
            ActionData actionData = this.menuItemData.getActionData();
            if (StringUtils.isNotEmpty((String)actionData.getIconKey())) {
                iconKey = actionData.getIconKey();
            }
            if (StringUtils.isNotEmpty((String)this.menuItemData.getIconKey())) {
                iconKey = this.menuItemData.getIconKey();
            }
        }
        super.setIconKey(iconKey);
    }

    public void applyMenuItemData() {
        if (this.menuItemData == null) {
            return;
        }
        new EDTRunner(){

            protected void runInEDT() {
                CustomizableAppAction.this.setName(CustomizableAppAction.this.getName());
                CustomizableAppAction.this.setIconKey(CustomizableAppAction.this.getIconKey());
                CustomizableAppAction.this.setAccelerator(null);
            }
        }.getReturnValue();
    }

    public List<KeyStroke> getAdditionalShortcuts(KeyStroke keystroke) {
        return null;
    }
}

