/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.controlling.contextmenu;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.Storable;
import org.appwork.storage.TypeRef;
import org.appwork.utils.Application;
import org.appwork.utils.StringUtils;
import org.jdownloader.controlling.contextmenu.ClassCurrentlyNotAvailableException;
import org.jdownloader.controlling.contextmenu.ContextMenuManager;
import org.jdownloader.controlling.contextmenu.MenuContainer;
import org.jdownloader.controlling.contextmenu.MenuItemData;
import org.jdownloader.controlling.contextmenu.MenuLink;
import org.jdownloader.controlling.contextmenu.SeparatorData;
import org.jdownloader.extensions.ExtensionNotLoadedException;
import org.jdownloader.logging.LogController;

public class MenuContainerRoot
extends MenuContainer
implements Storable {
    private ContextMenuManager owner = null;

    public ContextMenuManager _getOwner() {
        return this.owner;
    }

    public void _setOwner(ContextMenuManager owner) {
        this.owner = owner;
    }

    public void validateFull() {
        this.validate(this, true);
    }

    public void validate() {
        this.validate(this, false);
    }

    public MenuContainerRoot clone() {
        String str = JSonStorage.serializeToJson((Object)this);
        MenuContainerRoot menuContainerRoot2 = (MenuContainerRoot)JSonStorage.restoreFromString((String)str, (TypeRef)new TypeRef<MenuContainerRoot>(){});
        menuContainerRoot2._setRoot(this._getRoot());
        menuContainerRoot2._setOwner(this._getOwner());
        menuContainerRoot2.validateFull();
        return menuContainerRoot2;
    }

    private boolean validate(MenuItemData container, boolean full) {
        if (container instanceof MenuContainerRoot && ((MenuContainerRoot)container)._getOwner() == null && !Application.isJared(null)) {
            return false;
        }
        container._setValidated(true);
        boolean ret = true;
        container._setRoot(this._getRoot());
        if (!container.isVisible() && !full) {
            return true;
        }
        block4: while (container.getItems() != null) {
            MenuItemData mid;
            int i;
            HashMap<MenuItemData, MenuItemData> replaceMap = new HashMap<MenuItemData, MenuItemData>();
            MenuItemData last = null;
            for (i = 0; i < container.getItems().size(); ++i) {
                mid = container.getItems().get(i);
                mid._setRoot(this._getRoot());
                if (!mid.isVisible() && !full) continue;
                mid._setValidateException(null);
                MenuItemData lr = null;
                try {
                    try {
                        lr = mid.createValidatedItem();
                        if (!lr.isVisible() && !full) continue;
                        if (lr.getActionData() != null && lr.getActionData()._isValidDataForCreatingAnAction() && !(lr instanceof MenuLink)) {
                            lr.createAction();
                        }
                    }
                    catch (ClassCurrentlyNotAvailableException e) {
                        LogController.CL().log((Throwable)e);
                        mid._setValidateException(e);
                        lr = mid;
                    }
                    lr._setRoot(this._getRoot());
                    if (lr instanceof SeparatorData && (i == 0 || i == container.getItems().size() - 1)) {
                        container.getItems().remove(i);
                        ret = false;
                        continue block4;
                    }
                    if (lr instanceof SeparatorData && last instanceof SeparatorData) {
                        container.getItems().remove(i);
                        ret = false;
                        continue block4;
                    }
                    if (lr != mid) {
                        replaceMap.put(mid, lr);
                    }
                    last = lr;
                    continue;
                }
                catch (Throwable e) {
                    LogController.CL().log(e);
                    container.getItems().remove(i);
                    ret = false;
                    continue block4;
                }
            }
            for (i = 0; i < container.getItems().size(); ++i) {
                mid = container.getItems().get(i);
                mid._setRoot(this._getRoot());
                MenuItemData rep = (MenuItemData)replaceMap.remove(mid);
                if (rep != null) {
                    container.getItems().set(i, rep);
                    mid = rep;
                }
                ret &= this.validate(mid, full);
            }
        }
        return ret;
    }

    @Override
    public MenuContainerRoot _getRoot() {
        return this;
    }

    public void addBranch(MenuItemData parent, MenuItemData nodeToAdd) {
        if (nodeToAdd instanceof MenuContainerRoot) {
            for (MenuItemData mu : nodeToAdd.getItems()) {
                this.addBranch(parent, mu);
            }
        } else {
            boolean added = false;
            if (parent == null) {
                parent = this;
            }
            for (MenuItemData mu : parent.getItems()) {
                if (mu.getActionData() != null && mu.getActionData()._isValidDataForCreatingAnAction() || !StringUtils.equals((String)mu.getClassName(), (String)nodeToAdd.getClassName())) continue;
                if (nodeToAdd.getItems() != null && nodeToAdd.getItems().size() > 0) {
                    for (MenuItemData item : nodeToAdd.getItems()) {
                        this.addBranch(mu, item);
                    }
                    added = true;
                    continue;
                }
                return;
            }
            if (!added) {
                parent.getItems().add(nodeToAdd);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(List<MenuItemData> path) throws InstantiationException, IllegalAccessException, ClassNotFoundException, ExtensionNotLoadedException {
        MenuItemData addAt = this;
        MenuItemData parent = null;
        block6: for (int i = 0; i < path.size(); ++i) {
            MenuItemData c = path.get(i);
            try {
                if (c instanceof MenuContainerRoot) continue;
                Collection<String> ids = addAt._getItemIdentifiers();
                if (c.getType() == MenuItemData.Type.CONTAINER) {
                    for (MenuItemData mu : addAt.getItems()) {
                        if (!StringUtils.equals((String)mu._getIdentifier(), (String)c._getIdentifier())) continue;
                        addAt = mu;
                        continue block6;
                    }
                } else if (ids.contains(c._getIdentifier())) break;
                int index = parent.getItems().indexOf(c);
                MenuItemData newItem = this.createInstance(c);
                if (i < path.size() - 1) {
                    newItem.setItems(new ArrayList<MenuItemData>());
                }
                List<MenuItemData> above = parent.getItems().subList(0, index);
                List<MenuItemData> below = parent.getItems().subList(index + 1, parent.getItems().size());
                index = this.searchBestPosition(addAt.getItems(), above, below);
                addAt.getItems().add(index, newItem);
                if (newItem.getType() != MenuItemData.Type.CONTAINER) continue;
                addAt = newItem;
                continue;
            }
            finally {
                parent = c;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int searchBestPosition(ArrayList<MenuItemData> items, List<MenuItemData> above, List<MenuItemData> below) {
        ArrayList<String> identList = new ArrayList<String>();
        for (int i = 0; i < items.size(); ++i) {
            identList.add(items.get(i)._getIdentifier());
        }
        int bestMatch = Integer.MAX_VALUE;
        int bestIndex = -1;
        if (above.size() == 0 && below.size() == 0) {
            return 0;
        }
        if (above.size() == 0) {
            for (int b = 0; b < below.size(); ++b) {
                MenuItemData bN = below.get(b);
                int bIndex = identList.indexOf(bN._getIdentifier());
                if (bIndex < 0) continue;
                return bIndex;
            }
        } else if (below.size() == 0) {
            for (int a = above.size() - 1; a >= 0; --a) {
                MenuItemData aN = above.get(a);
                int aIndex = identList.indexOf(aN._getIdentifier());
                if (aIndex < 0) continue;
                return aIndex + 1;
            }
        }
        boolean lastAWasSep = false;
        boolean lastBwasSep = false;
        block10: for (int a = above.size() - 1; a >= 0; --a) {
            MenuItemData aN = above.get(a);
            if (aN instanceof SeparatorData) {
                lastAWasSep = true;
                continue;
            }
            try {
                for (int b = 0; b < below.size(); ++b) {
                    if (bestMatch <= 1 + a + b) break block10;
                    MenuItemData bN = below.get(b);
                    if (bN instanceof SeparatorData) {
                        lastBwasSep = true;
                        continue;
                    }
                    try {
                        int dist;
                        int aIndex = identList.indexOf(aN._getIdentifier());
                        int bIndex = identList.indexOf(bN._getIdentifier());
                        if (lastAWasSep && aIndex >= 0) {
                            ++aIndex;
                        }
                        if (lastBwasSep && bIndex > 0) {
                            --bIndex;
                        }
                        if (aIndex >= 0 && bIndex >= 0) {
                            dist = Math.abs(bIndex - aIndex) + a + b;
                            if (dist >= bestMatch) continue;
                            bestMatch = dist;
                            bestIndex = Math.min(aIndex, bIndex) + 1;
                            continue;
                        }
                        if (aIndex >= 0) {
                            dist = 1000 + a + b;
                            if (dist >= bestMatch) continue;
                            bestMatch = dist;
                            bestIndex = aIndex + 1;
                            continue;
                        }
                        if (bIndex < 0 || (dist = 1000 + a + b) >= bestMatch) continue;
                        bestMatch = dist;
                        bestIndex = bIndex;
                        continue;
                    }
                    finally {
                        lastBwasSep = false;
                    }
                }
                continue;
            }
            finally {
                lastAWasSep = false;
            }
        }
        if (bestIndex < 0) {
            bestIndex = items.size();
        }
        return bestIndex;
    }
}

