/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.controlling.contextmenu;

import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.Timer;
import jd.controlling.TaskQueue;
import org.appwork.exceptions.WTFException;
import org.appwork.storage.Storable;
import org.appwork.utils.StringUtils;
import org.appwork.utils.event.queue.QueueAction;
import org.jdownloader.actions.AppAction;
import org.jdownloader.actions.ComponentProviderInterface;
import org.jdownloader.controlling.contextmenu.ActionData;
import org.jdownloader.controlling.contextmenu.CustomizableAppAction;
import org.jdownloader.controlling.contextmenu.MenuContainer;
import org.jdownloader.controlling.contextmenu.MenuContainerRoot;
import org.jdownloader.controlling.contextmenu.SeparatorData;
import org.jdownloader.controlling.contextmenu.gui.MenuBuilder;
import org.jdownloader.extensions.AbstractExtension;
import org.jdownloader.extensions.ExtensionController;
import org.jdownloader.extensions.ExtensionNotLoadedException;
import org.jdownloader.images.NewTheme;

public class MenuItemData
implements Storable {
    public static final String EMPTY = "<EMPTY>";
    private static final String EMPTY_NAME = "<NO NAME>";
    private ArrayList<MenuItemData> items;
    private String name;
    private String iconKey;
    private String className;
    private ActionData actionData = new ActionData();
    private Type type = Type.ACTION;
    private boolean validated;
    private Exception validateException;
    private MenuContainerRoot root;
    private String mnemonic;
    private String shortcut;
    private boolean visible = true;
    protected WeakReference<Constructor<?>> weakConstructor = new WeakReference<Object>(null);

    public String _getIdentifier() {
        ActionData actionData = this.getActionData();
        if (actionData._isValidDataForCreatingAnAction()) {
            if (actionData.getData() != null) {
                return actionData.getClazzName() + ":" + actionData.getData() + ":" + actionData.getSetup();
            }
            return actionData.getClazzName() + ":" + actionData.getSetup();
        }
        if (this.getClass() != MenuContainer.class && this.getClass() != MenuItemData.class) {
            return this.getClass().getName();
        }
        if (StringUtils.isNotEmpty((String)this.className)) {
            return this.className;
        }
        return this.getIconKey() + ":" + this.getName();
    }

    public static boolean isEmptyValue(String value) {
        if (StringUtils.equals((String)EMPTY, (String)value)) {
            return true;
        }
        return StringUtils.equals((String)EMPTY_NAME, (String)value);
    }

    public String toString() {
        return this._getIdentifier() + "";
    }

    public ActionData getActionData() {
        return this.actionData;
    }

    public void setActionData(ActionData actionData) {
        if (actionData == null) {
            actionData = new ActionData();
        }
        this.actionData = actionData;
    }

    public String getClassName() {
        if (StringUtils.isNotEmpty((String)this.className)) {
            return this.className;
        }
        if (this.getClass() == MenuItemData.class) {
            return null;
        }
        return this.getClass().getName();
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void setMnemonic(String mnemonic) {
        this.mnemonic = mnemonic;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public MenuItemData() {
        this.items = new ArrayList();
    }

    public ArrayList<MenuItemData> getItems() {
        return this.items;
    }

    public void setItems(ArrayList<MenuItemData> items) {
        this.items = items;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getIconKey() {
        return this.iconKey;
    }

    public void setIconKey(String iconKey) {
        this.iconKey = iconKey;
    }

    public void add(MenuItemData child) {
        this.items.add(child);
    }

    public MenuItemData(ActionData actionData) {
        this();
        this.setActionData(actionData);
    }

    public MenuItemData(Class<? extends AppAction> class1) {
        this(new ActionData(class1));
    }

    public MenuItemData createValidatedItem() throws InstantiationException, IllegalAccessException, ClassNotFoundException, ExtensionNotLoadedException {
        if (this.className == null || this.getClass().getName().equals(this.className)) {
            this._setValidated(true);
            return this;
        }
        MenuItemData ret = this.createInstance(this);
        ret._setValidated(true);
        ret._setRoot(this._getRoot());
        return ret;
    }

    protected MenuItemData createInstance(MenuItemData menuItemData) throws InstantiationException, IllegalAccessException, ClassNotFoundException, ExtensionNotLoadedException {
        if (menuItemData.getClassName() == null) {
            return menuItemData;
        }
        MenuItemData ret = null;
        String packageName = AbstractExtension.class.getPackage().getName();
        if (menuItemData.getClassName().startsWith(packageName)) {
            ret = (MenuItemData)ExtensionController.getInstance().loadClass(menuItemData.getClassName()).newInstance();
        } else {
            if ("org.jdownloader.controlling.contextmenu.SeperatorData".equals(menuItemData.getClassName())) {
                menuItemData.setClassName(SeparatorData.class.getName());
                menuItemData.setName("Separator");
            }
            ret = (MenuItemData)Class.forName(menuItemData.getClassName()).newInstance();
        }
        ret.setVisible(menuItemData.isVisible());
        if (this.getActionData() != null) {
            ret.setActionData(this.getActionData());
        }
        ret.setIconKey(menuItemData.getIconKey());
        ret.setName(menuItemData.getName());
        ret.setItems(menuItemData.getItems());
        ret.setType(menuItemData.getType());
        return ret;
    }

    public JComponent createItem(MenuBuilder menuBuilder) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, ClassNotFoundException, NoSuchMethodException, SecurityException, ExtensionNotLoadedException {
        if (this.getActionData() == null) {
            throw new WTFException("No action:" + this);
        }
        if (!this.getActionData()._isValidDataForCreatingAnAction()) {
            throw new WTFException("No valid action:" + this);
        }
        CustomizableAppAction action = this.createAction();
        action.requestUpdate(this);
        if (!this.isVisible()) {
            return null;
        }
        if (!action.isVisible()) {
            return null;
        }
        if (action instanceof ComponentProviderInterface) {
            JComponent ret = ((ComponentProviderInterface)((Object)action)).createComponent(this);
            if (ret != null) {
                action.addVisibilityPropertyChangeListener(ret);
            }
            return ret;
        }
        JMenuItem ret = this.createMenuItem(action, menuBuilder);
        action.addVisibilityPropertyChangeListener(ret);
        if (StringUtils.isNotEmpty((String)this.name)) {
            ret.setText(this.name);
        }
        if (StringUtils.isNotEmpty((String)this.iconKey)) {
            ret.setIcon(MenuItemData.getIcon(this.iconKey, 20));
        }
        return ret;
    }

    protected boolean processHideOnClickMouseEvent(final JMenuItem item, boolean hideOnClick, final MouseEvent ev) {
        if (!hideOnClick && ev.getID() == 502) {
            item.setSelected(!item.isSelected());
            for (ActionListener al : item.getActionListeners()) {
                int modifiers = 0;
                AWTEvent currentEvent = EventQueue.getCurrentEvent();
                if (currentEvent instanceof InputEvent) {
                    modifiers = ((InputEvent)currentEvent).getModifiers();
                } else if (currentEvent instanceof ActionEvent) {
                    modifiers = ((ActionEvent)currentEvent).getModifiers();
                }
                al.actionPerformed(new ActionEvent(this, 1001, item.getActionCommand(), EventQueue.getMostRecentEventTime(), modifiers));
                final Action action = item.getAction();
                if (!(action instanceof CustomizableAppAction)) continue;
                TaskQueue.getQueue().add((QueueAction)new QueueAction<Void, RuntimeException>(){

                    protected Void run() throws RuntimeException {
                        new Timer(1000, new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                if (item.isVisible()) {
                                    ((CustomizableAppAction)((Object)action)).requestUpdate(ev);
                                }
                            }
                        }).start();
                        return null;
                    }
                });
            }
            return true;
        }
        return false;
    }

    protected JMenuItem createMenuItem(CustomizableAppAction action, final MenuBuilder menuBuilder) {
        JMenuItem ret = action.isToggle() ? new JCheckBoxMenuItem((Action)((Object)action)){

            @Override
            protected void processMouseEvent(MouseEvent e) {
                if (!MenuItemData.this.processHideOnClickMouseEvent(this, menuBuilder == null || menuBuilder.isHideOnClick(), e)) {
                    super.processMouseEvent(e);
                }
            }
        } : new JMenuItem((Action)((Object)action)){

            @Override
            protected void processMouseEvent(MouseEvent e) {
                if (!MenuItemData.this.processHideOnClickMouseEvent(this, menuBuilder == null || menuBuilder.isHideOnClick(), e)) {
                    super.processMouseEvent(e);
                }
            }
        };
        ret.getAccessibleContext().setAccessibleName(action.getName());
        ret.getAccessibleContext().setAccessibleDescription(action.getTooltipText());
        return ret;
    }

    public CustomizableAppAction createAction() throws ClassNotFoundException, NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, ExtensionNotLoadedException {
        if (!this.validated) {
            throw new WTFException();
        }
        if (this.actionData == null) {
            throw new WTFException("No ACTION");
        }
        Constructor<?> c = (Constructor<?>)this.weakConstructor.get();
        if (c == null) {
            Class<?> clazz = this.actionData._getClazz();
            c = clazz.getConstructor(new Class[0]);
            this.weakConstructor = new WeakReference(c);
        }
        CustomizableAppAction ret = (CustomizableAppAction)((Object)c.newInstance(new Object[0]));
        ret.setMenuItemData(this);
        ret.applyMenuItemData();
        ret.initContextDefaults();
        ret.loadContextSetups();
        return ret;
    }

    public JComponent addTo(JComponent root, MenuBuilder menuBuilder) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, ClassNotFoundException, NoSuchMethodException, SecurityException, ExtensionNotLoadedException {
        if (!this.isVisible()) {
            return null;
        }
        JComponent it = this.createItem(menuBuilder);
        if (it == null) {
            return null;
        }
        root.add(it);
        return it;
    }

    public List<MenuItemData> list() {
        ArrayList<MenuItemData> set = new ArrayList<MenuItemData>();
        set.add(this);
        if (this.getItems() != null) {
            for (MenuItemData d : this.getItems()) {
                set.addAll(d.list());
            }
        }
        return set;
    }

    public List<List<MenuItemData>> listPaths() {
        ArrayList<List<MenuItemData>> set = new ArrayList<List<MenuItemData>>();
        ArrayList<MenuItemData> newPath = new ArrayList<MenuItemData>();
        newPath.add(this);
        set.add(newPath);
        if (this.getItems() != null) {
            for (MenuItemData d : this.getItems()) {
                for (List<MenuItemData> p : d.listPaths()) {
                    newPath = new ArrayList();
                    newPath.add(this);
                    newPath.addAll(p);
                    set.add(newPath);
                }
            }
        }
        return set;
    }

    public String _getDescription() {
        if (this.getActionData()._isValidDataForCreatingAnAction()) {
            try {
                return this.createAction().getTooltipText();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public String getMnemonic() {
        return this.mnemonic;
    }

    public Collection<String> _getItemIdentifiers() {
        HashSet<String> ret = new HashSet<String>();
        for (MenuItemData mid : this.getItems()) {
            ret.add(mid._getIdentifier());
        }
        return ret;
    }

    public void _setValidated(boolean b) {
        this.validated = true;
    }

    public boolean _isValidated() {
        return this.validated;
    }

    public void _setValidateException(Exception e) {
        this.validateException = e;
    }

    public Exception _getValidateException() {
        return this.validateException;
    }

    public MenuContainerRoot _getRoot() {
        return this.root;
    }

    public void _setRoot(MenuContainerRoot root) {
        this.root = root;
    }

    public String getShortcut() {
        return this.shortcut;
    }

    public void setShortcut(String shortcut) {
        this.shortcut = shortcut;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean b) {
        this.visible = b;
    }

    public static Icon getIcon(String key, int size) {
        if (StringUtils.isEmpty((String)key)) {
            return null;
        }
        if (MenuItemData.isEmptyValue(key)) {
            return null;
        }
        return NewTheme.I().getIcon(key, size);
    }

    public static enum Type {
        ACTION,
        CONTAINER;

    }
}

