/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.controlling.contextmenu.gui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.TreePath;
import jd.gui.swing.jdgui.JDGui;
import jd.gui.swing.jdgui.WarnLevel;
import org.appwork.swing.MigPanel;
import org.appwork.swing.components.ExtButton;
import org.appwork.utils.logging2.LogSource;
import org.appwork.utils.swing.dialog.AbstractDialog;
import org.appwork.utils.swing.dialog.DefaultButtonPanel;
import org.appwork.utils.swing.dialog.Dialog;
import org.appwork.utils.swing.dialog.DialogCanceledException;
import org.appwork.utils.swing.dialog.DialogClosedException;
import org.appwork.utils.swing.dialog.ExtFileChooserDialog;
import org.appwork.utils.swing.dialog.FileChooserSelectionMode;
import org.appwork.utils.swing.dialog.FileChooserType;
import org.appwork.utils.swing.dialog.dimensor.DialogDimensor;
import org.appwork.utils.swing.dialog.dimensor.RememberLastDialogDimension;
import org.appwork.utils.swing.dialog.locator.DialogLocator;
import org.appwork.utils.swing.dialog.locator.RememberAbsoluteDialogLocator;
import org.appwork.utils.swing.windowmanager.WindowManager;
import org.jdownloader.actions.AppAction;
import org.jdownloader.controlling.contextmenu.ActionData;
import org.jdownloader.controlling.contextmenu.ContextMenuManager;
import org.jdownloader.controlling.contextmenu.MenuContainerRoot;
import org.jdownloader.controlling.contextmenu.MenuItemData;
import org.jdownloader.controlling.contextmenu.MenuStructure;
import org.jdownloader.controlling.contextmenu.gui.AddSpecialAction;
import org.jdownloader.controlling.contextmenu.gui.AddSubMenuAction;
import org.jdownloader.controlling.contextmenu.gui.InfoPanel;
import org.jdownloader.controlling.contextmenu.gui.ManagerTreeModel;
import org.jdownloader.controlling.contextmenu.gui.MenuManagerDialogInterface;
import org.jdownloader.controlling.contextmenu.gui.MenuManagerTree;
import org.jdownloader.controlling.contextmenu.gui.OptionsPaneHeader;
import org.jdownloader.controlling.contextmenu.gui.RemoveAction;
import org.jdownloader.controlling.contextmenu.gui.TreeHeader;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.gui.views.components.HeaderScrollPane;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.images.NewTheme;
import org.jdownloader.logging.LogController;
import org.jdownloader.updatev2.gui.LAFOptions;

public class MenuManagerDialog
extends AbstractDialog<Object>
implements TreeSelectionListener,
MenuManagerDialogInterface {
    private InfoPanel infoPanel;
    private ContextMenuManager<?, ?> manager;
    private ManagerTreeModel model;
    private MenuManagerTree tree;
    private LogSource logger;
    private String ext = ".jdDlMenu";

    public MenuManagerDialog(ContextMenuManager<?, ?> manager) {
        super(24, _GUI.T.ManagerFrame_ManagerFrame_title(manager.getName()), null, null, null);
        this.manager = manager;
        this.ext = manager.getFileExtension();
        this.setLocator((DialogLocator)new RememberAbsoluteDialogLocator("dialogframe-" + manager.getClass().getName()));
        this.setDimensor((DialogDimensor)new RememberLastDialogDimension("dialogframe-" + manager.getClass().getName()));
        this.logger = LogController.getInstance().getLogger(MenuManagerDialog.class.getName());
    }

    protected WindowManager.FrameState getWindowStateOnVisible() {
        return WindowManager.FrameState.TO_FRONT_FOCUSED;
    }

    public Dialog.ModalityType getModalityType() {
        return Dialog.ModalityType.MODELESS;
    }

    protected MigPanel createBottomPanel() {
        MigPanel ret = new MigPanel("ins 0", "[]20[grow,fill][]", "[][]");
        MigPanel topline = new MigPanel("ins 0", "[][][grow,fill][][][][]", "[]");
        topline.setOpaque(false);
        ExtButton addSubmenu = new ExtButton((AbstractAction)((Object)new AddSubMenuAction(this))){

            public int getTooltipDelay(Point mousePositionOnScreen) {
                return 500;
            }
        };
        ExtButton add = new ExtButton((AbstractAction)((Object)new AddSpecialAction(this))){

            public int getTooltipDelay(Point mousePositionOnScreen) {
                return 500;
            }
        };
        ExtButton export = new ExtButton((AbstractAction)((Object)new AppAction(){
            {
                this.setIconKey("export");
                this.setTooltipText(_GUI.T.lit_export());
            }

            public void actionPerformed(ActionEvent e) {
                ExtFileChooserDialog d = new ExtFileChooserDialog(0, _GUI.T.ManagerFrame_actionPerformed_export_title(), null, null);
                d.setFileFilter(new FileFilter[]{new FileFilter(){

                    @Override
                    public String getDescription() {
                        return "*" + MenuManagerDialog.this.ext;
                    }

                    @Override
                    public boolean accept(File f) {
                        return f.isDirectory() || f.getName().endsWith(MenuManagerDialog.this.ext);
                    }
                }});
                d.setFileSelectionMode(FileChooserSelectionMode.FILES_AND_DIRECTORIES);
                d.setMultiSelection(false);
                d.setStorageID(MenuManagerDialog.this.ext);
                d.setType(FileChooserType.SAVE_DIALOG);
                try {
                    Dialog.getInstance().showDialog((AbstractDialog)d);
                    File saveTo = d.getSelectedFile();
                    if (!saveTo.getName().endsWith(MenuManagerDialog.this.ext)) {
                        saveTo = new File(saveTo.getAbsolutePath() + MenuManagerDialog.this.ext);
                    }
                    MenuManagerDialog.this.manager.saveTo((MenuContainerRoot)MenuManagerDialog.this.model.getRoot(), saveTo);
                }
                catch (DialogClosedException e1) {
                    e1.printStackTrace();
                }
                catch (DialogCanceledException e1) {
                    e1.printStackTrace();
                }
                catch (UnsupportedEncodingException e1) {
                    Dialog.getInstance().showExceptionDialog(_GUI.T.lit_error_occured(), e1.getMessage(), (Throwable)e1);
                }
                catch (IOException e1) {
                    Dialog.getInstance().showExceptionDialog(_GUI.T.lit_error_occured(), e1.getMessage(), (Throwable)e1);
                }
            }
        })){

            public int getTooltipDelay(Point mousePositionOnScreen) {
                return 500;
            }
        };
        ExtButton importButton = new ExtButton((AbstractAction)((Object)new AppAction(){
            {
                this.setIconKey("import");
                this.setTooltipText(_GUI.T.lit_import());
            }

            public void actionPerformed(ActionEvent e) {
                try {
                    ExtFileChooserDialog d = new ExtFileChooserDialog(0, _GUI.T.ManagerFrame_actionPerformed_import_title(), null, null);
                    d.setFileFilter(new FileFilter[]{new FileFilter(){

                        @Override
                        public String getDescription() {
                            return "*" + MenuManagerDialog.this.ext;
                        }

                        @Override
                        public boolean accept(File f) {
                            return f.isDirectory() || f.getName().endsWith(MenuManagerDialog.this.ext);
                        }
                    }});
                    d.setFileSelectionMode(FileChooserSelectionMode.FILES_AND_DIRECTORIES);
                    d.setMultiSelection(false);
                    d.setStorageID(MenuManagerDialog.this.ext);
                    d.setType(FileChooserType.OPEN_DIALOG);
                    Dialog.getInstance().showDialog((AbstractDialog)d);
                    File selected = d.getSelectedFile();
                    if (selected.exists() && selected.getName().endsWith(MenuManagerDialog.this.ext)) {
                        MenuStructure data = MenuManagerDialog.this.manager.readFrom(selected);
                        MenuManagerDialog.this.model.set(data.getRoot());
                    }
                }
                catch (DialogClosedException e1) {
                    e1.printStackTrace();
                }
                catch (DialogCanceledException e1) {
                    e1.printStackTrace();
                }
                catch (IOException e1) {
                    Dialog.getInstance().showExceptionDialog(_GUI.T.lit_error_occured(), e1.getMessage(), (Throwable)e1);
                }
            }
        })){

            public int getTooltipDelay(Point mousePositionOnScreen) {
                return 500;
            }
        };
        ExtButton reset = new ExtButton((AbstractAction)((Object)new AppAction(){
            {
                this.setTooltipText(_GUI.T.ManagerFrame_layoutPanel_resettodefault());
                this.setSmallIcon(new AbstractIcon("undo", 20));
            }

            public void actionPerformed(ActionEvent e) {
                try {
                    if (JDGui.bugme((WarnLevel)WarnLevel.NORMAL)) {
                        Dialog.getInstance().showConfirmDialog(544, _GUI.T.MenuManagerDialog_actionPerformed_title(), _GUI.T.lit_are_you_sure());
                    }
                    MenuContainerRoot data = MenuManagerDialog.this.manager.setupDefaultStructure();
                    data.validateFull();
                    MenuManagerDialog.this.model.set(data);
                    if (MenuManagerDialog.this.tree.getRowCount() > 0) {
                        MenuManagerDialog.this.tree.setSelectionRow(0);
                    }
                }
                catch (DialogClosedException e1) {
                    e1.printStackTrace();
                }
                catch (DialogCanceledException e1) {
                    e1.printStackTrace();
                }
            }
        })){

            public int getTooltipDelay(Point mousePositionOnScreen) {
                return 500;
            }
        };
        ExtButton remove = new ExtButton((AbstractAction)((Object)new RemoveAction(this)));
        add.setText(null);
        addSubmenu.setText(null);
        remove.setText(null);
        topline.add((Component)add, (Object)"height 24!");
        topline.add((Component)addSubmenu, (Object)"height 24!");
        topline.add((Component)Box.createHorizontalBox());
        topline.add((Component)remove, (Object)"height 24!");
        topline.add((Component)reset, (Object)"height 24!");
        topline.add((Component)importButton, (Object)"height 24!");
        topline.add((Component)export, (Object)"height 24!");
        ret.add((Component)topline, (Object)"wrap,spanx");
        return ret;
    }

    protected DefaultButtonPanel getDefaultButtonPanel() {
        DefaultButtonPanel bottom = new DefaultButtonPanel("ins 0", "[grow,fill][][]", "[]");
        ExtButton save = new ExtButton((AbstractAction)((Object)new AppAction(){
            {
                this.setName(_GUI.T.lit_save());
                this.setSmallIcon(new AbstractIcon("save", 20));
            }

            public void actionPerformed(ActionEvent e) {
                MenuContainerRoot data = ((MenuContainerRoot)MenuManagerDialog.this.model.getRoot()).clone();
                MenuManagerDialog.this.manager.setMenuData(data);
                MenuManagerDialog.this.setReturnmask(true);
                MenuManagerDialog.this.dispose();
            }
        }));
        ExtButton cancel = new ExtButton((AbstractAction)((Object)new AppAction(){
            {
                this.setName(_GUI.T.lit_cancel());
                this.setSmallIcon(new AbstractIcon("cancel", 20));
            }

            public void actionPerformed(ActionEvent e) {
                MenuManagerDialog.this.setReturnmask(false);
                MenuManagerDialog.this.dispose();
            }
        }));
        ExtButton apply = new ExtButton((AbstractAction)((Object)new AppAction(){
            {
                this.setSmallIcon(NewTheme.I().getIcon("true", 20));
                this.setName(_GUI.T.lit_apply());
            }

            public void actionPerformed(ActionEvent e) {
                MenuContainerRoot data = ((MenuContainerRoot)MenuManagerDialog.this.model.getRoot()).clone();
                MenuManagerDialog.this.manager.setMenuData(data);
                data = MenuManagerDialog.this.manager.getMenuData();
                int[] rows = MenuManagerDialog.this.tree.getSelectionRows();
                MenuManagerDialog.this.model.set(data);
                if (rows != null && rows.length > 0) {
                    MenuManagerDialog.this.tree.setSelectionRows(rows);
                } else if (MenuManagerDialog.this.tree.getRowCount() > 0) {
                    MenuManagerDialog.this.tree.setSelectionRow(0);
                }
            }
        }));
        bottom.add((Component)save, (Object)"tag ok,height 24!");
        bottom.add((Component)cancel, (Object)"tag cancel,height 24!");
        bottom.add((Component)apply, (Object)"tag apply,height 24!");
        bottom.setOpaque(false);
        return bottom;
    }

    protected boolean isResizable() {
        return true;
    }

    protected int getPreferredHeight() {
        return 550;
    }

    protected int getPreferredWidth() {
        return 800;
    }

    public JComponent layoutDialogContent() {
        this.setMinimumSize(new Dimension(550, 400));
        MigPanel panel = new MigPanel("ins 2,wrap 2", "[grow,fill][fill]", "[grow,fill][]");
        panel.setOpaque(false);
        LAFOptions.getInstance().applyPanelBackground((JComponent)this.getDialog().getContentPane());
        LAFOptions.getInstance().applyPanelBackground((JComponent)panel);
        this.model = new ManagerTreeModel();
        this.tree = new MenuManagerTree(this);
        this.tree.getSelectionModel().addTreeSelectionListener(this);
        LAFOptions.getInstance().applyPanelBackground((JComponent)this.tree);
        HeaderScrollPane sp = new HeaderScrollPane(this.tree){

            @Override
            public Dimension getPreferredSize() {
                Dimension pref = MenuManagerDialog.this.tree.getPreferredSize();
                pref.width = 100;
                return pref;
            }
        };
        sp.setColumnHeaderView((Component)((Object)new TreeHeader()));
        panel.add((Component)sp);
        this.infoPanel = new InfoPanel(this);
        LAFOptions.getInstance().applyPanelBackground((JComponent)((Object)this.infoPanel));
        sp = new HeaderScrollPane((JComponent)((Object)this.infoPanel));
        sp.setVerticalScrollBarPolicy(22);
        sp.setColumnHeaderView((Component)((Object)new OptionsPaneHeader()));
        panel.add((Component)sp);
        LAFOptions.getInstance().applyPanelBackground((JComponent)sp);
        if (this.tree.getRowCount() > 0) {
            this.tree.setSelectionRow(0);
        }
        return panel;
    }

    public ManagerTreeModel getModel() {
        return this.model;
    }

    public ContextMenuManager getManager() {
        return this.manager;
    }

    public void addAction(ActionData action) {
        TreePath sel = this.model.addAction(this.tree.getSelectionPath(), new MenuItemData(action));
        this.tree.setSelectionPath(sel);
    }

    public void addMenuItem(MenuItemData action) {
        TreePath sel = this.model.addAction(this.tree.getSelectionPath(), action);
        this.tree.setSelectionPath(sel);
    }

    public void deleteSelection() {
        int[] rows = this.tree.getSelectionRows();
        this.model.remove(this.tree.getSelectionPath());
        if (rows != null && rows.length > 0) {
            if (this.tree.getRowCount() <= rows[0]) {
                rows[0] = rows[0] - 1;
            }
            if (rows[0] >= 0) {
                this.tree.setSelectionRows(rows);
            }
        }
    }

    public void setVisible(boolean b) {
        super.setVisible(b);
        MenuContainerRoot md = this.manager.getMenuData();
        long t = System.currentTimeMillis();
        md.validateFull();
        System.out.println("Validate: " + (System.currentTimeMillis() - t));
        this.model.set(md);
        if (this.tree.getRowCount() > 0) {
            this.tree.setSelectionRow(0);
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        TreePath sel = this.tree.getSelectionPath();
        if (sel == null) {
            this.infoPanel.updateInfo(null);
        } else {
            this.infoPanel.updateInfo((MenuItemData)sel.getLastPathComponent());
        }
    }

    public void fireUpdate() {
        this.tree.getSelectionModel().removeTreeSelectionListener(this);
        TreePath[] sel = this.tree.getSelectionPaths();
        this.model.fireUpdate();
        if (sel != null) {
            this.tree.setSelectionPaths(sel);
        }
        this.tree.getSelectionModel().addTreeSelectionListener(this);
    }

    public TreePath getSelectionPath() {
        TreePath ret = this.tree.getSelectionPath();
        if (ret == null) {
            ret = new TreePath(this.model.getRoot());
        }
        return ret;
    }

    protected Object createReturnValue() {
        return null;
    }

    public void repaint() {
        this.fireUpdate();
    }

    public LogSource getLogger() {
        return this.logger;
    }
}

