/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.controlling.contextmenu.gui;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.datatransfer.Transferable;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Action;
import javax.swing.DropMode;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.plaf.TreeUI;
import javax.swing.tree.TreePath;
import org.appwork.utils.os.CrossSystem;
import org.appwork.utils.swing.dialog.Dialog;
import org.jdownloader.controlling.contextmenu.MenuItemData;
import org.jdownloader.controlling.contextmenu.SeparatorData;
import org.jdownloader.controlling.contextmenu.gui.AddGenericItem;
import org.jdownloader.controlling.contextmenu.gui.AddSpecialAction;
import org.jdownloader.controlling.contextmenu.gui.AddSubMenuAction;
import org.jdownloader.controlling.contextmenu.gui.ManagerTreeModel;
import org.jdownloader.controlling.contextmenu.gui.MenuItemTransferAble;
import org.jdownloader.controlling.contextmenu.gui.MenuManagerDialog;
import org.jdownloader.controlling.contextmenu.gui.RemoveAction;
import org.jdownloader.controlling.contextmenu.gui.Renderer;

public class MenuManagerTree
extends JTree {
    private ManagerTreeModel model;
    private MenuManagerDialog managerFrame;

    public void expandAll() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            this.expandRow(i);
        }
    }

    @Override
    public TreeUI getUI() {
        return (TreeUI)this.ui;
    }

    public MenuManagerTree(MenuManagerDialog mf) {
        super(mf.getModel());
        this.model = mf.getModel();
        this.model.setTree(this);
        this.model.addTreeModelListener(new TreeModelListener(){

            @Override
            public void treeStructureChanged(TreeModelEvent e) {
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent e) {
            }

            @Override
            public void treeNodesInserted(TreeModelEvent e) {
            }

            @Override
            public void treeNodesChanged(TreeModelEvent e) {
            }
        });
        this.expandAll();
        this.managerFrame = mf;
        this.getSelectionModel().setSelectionMode(1);
        this.setOpaque(true);
        this.setCellRenderer(new Renderer());
        this.setRootVisible(false);
        this.setRowHeight(20);
        this.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (CrossSystem.isDeleteSelectionTrigger((KeyEvent)e)) {
                    new RemoveAction(MenuManagerTree.this.managerFrame).actionPerformed(null);
                }
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }
        });
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                MenuManagerTree.this.setSelectionRow(MenuManagerTree.this.getRowForLocation(e.getX(), e.getY()));
                MenuManagerTree.this.expandPath(MenuManagerTree.this.getPathForLocation(e.getX(), e.getY()));
                if (e.isPopupTrigger() || e.getButton() == 3) {
                    JPopupMenu popup = new JPopupMenu();
                    popup.add((Action)((Object)new AddSubMenuAction(MenuManagerTree.this.managerFrame)));
                    popup.add((Action)((Object)new AddSpecialAction(MenuManagerTree.this.managerFrame)));
                    popup.add((Action)((Object)new AddGenericItem(MenuManagerTree.this.managerFrame, new SeparatorData())));
                    popup.add((Action)((Object)new RemoveAction(MenuManagerTree.this.managerFrame)));
                    popup.show(MenuManagerTree.this, e.getPoint().x, e.getPoint().y);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
            }
        });
        this.setDragEnabled(true);
        this.setDropMode(DropMode.INSERT);
        this.setTransferHandler(new TransferHandler(){

            @Override
            public boolean canImport(TransferHandler.TransferSupport support) {
                if (!support.isDataFlavorSupported(MenuItemTransferAble.NODE_FLAVOR) || !support.isDrop()) {
                    return false;
                }
                JTree.DropLocation dropLocation = (JTree.DropLocation)support.getDropLocation();
                Transferable transferable = support.getTransferable();
                try {
                    TreePath path = dropLocation.getPath();
                    TreePath data = (TreePath)transferable.getTransferData(MenuItemTransferAble.NODE_FLAVOR);
                    MenuItemData oldParent = (MenuItemData)data.getParentPath().getLastPathComponent();
                    MenuItemData item = (MenuItemData)data.getLastPathComponent();
                    MenuItemData parent = (MenuItemData)path.getLastPathComponent();
                    if (data.isDescendant(path)) {
                        return false;
                    }
                    if (parent == item) {
                        return false;
                    }
                    int childIndex = dropLocation.getChildIndex();
                    if (item instanceof SeparatorData) {
                        if (childIndex == 0) {
                            return false;
                        }
                        return childIndex != parent.getItems().size();
                    }
                    if (oldParent == parent) {
                        return true;
                    }
                    return true;
                }
                catch (Exception exception) {
                    return false;
                }
            }

            @Override
            public int getSourceActions(JComponent c) {
                return 2;
            }

            @Override
            protected Transferable createTransferable(JComponent c) {
                return new MenuItemTransferAble(MenuManagerTree.this.getSelectionPath());
            }

            @Override
            protected void exportDone(JComponent c, Transferable t, int action) {
                if (action == 2) {
                    // empty if block
                }
            }

            @Override
            public boolean importData(TransferHandler.TransferSupport support) {
                if (!this.canImport(support)) {
                    return false;
                }
                JTree.DropLocation dropLocation = (JTree.DropLocation)support.getDropLocation();
                TreePath path = dropLocation.getPath();
                Transferable transferable = support.getTransferable();
                try {
                    TreePath data = (TreePath)transferable.getTransferData(MenuItemTransferAble.NODE_FLAVOR);
                    int childIndex = dropLocation.getChildIndex();
                    MenuManagerTree.this.model.moveTo(data, (MenuItemData)path.getLastPathComponent(), childIndex);
                    TreePath newPath = path.pathByAddingChild(data.getLastPathComponent());
                    MenuManagerTree.this.setSelectionPath(newPath);
                }
                catch (Exception e) {
                    Dialog.getInstance().showExceptionDialog("Error", e.getMessage(), (Throwable)e);
                    e.printStackTrace();
                }
                return true;
            }
        });
    }

    @Override
    protected TreeModelListener createTreeModelListener() {
        return new JTree.TreeModelHandler(){

            @Override
            public void treeStructureChanged(TreeModelEvent e) {
                super.treeStructureChanged(e);
                if (MenuManagerTree.this.getSelectionCount() <= 0) {
                    MenuManagerTree.this.setSelectionRow(0);
                }
            }
        };
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Composite com = ((Graphics2D)g).getComposite();
        try {
            ((Graphics2D)g).setComposite(AlphaComposite.getInstance(3, 0.03f));
            for (int i = 0; i < this.getHeight() / this.getRowHeight(); ++i) {
                g.setColor(Color.BLACK);
                g.fillRect(0, i * 2 * this.getRowHeight(), this.getWidth(), this.getRowHeight());
            }
        }
        finally {
            ((Graphics2D)g).setComposite(com);
        }
    }
}

