/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.controlling.ffmpeg;

import java.io.File;
import java.util.Map;
import org.appwork.storage.config.ConfigInterface;
import org.appwork.storage.config.ValidationException;
import org.appwork.storage.config.annotations.AboutConfig;
import org.appwork.storage.config.annotations.AbstractValidator;
import org.appwork.storage.config.annotations.DefaultFactory;
import org.appwork.storage.config.annotations.DefaultStringArrayValue;
import org.appwork.storage.config.annotations.DescriptionForConfigEntry;
import org.appwork.storage.config.annotations.ValidatorFactory;
import org.appwork.storage.config.defaults.AbstractDefaultFactory;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.utils.StringUtils;
import org.appwork.utils.os.CrossSystem;
import org.jdownloader.controlling.ffmpeg.FFmpegBinaryValueEditor;
import org.jdownloader.settings.advanced.AdvancedValueEditorFactory;

public interface FFmpegSetup
extends ConfigInterface {
    @AboutConfig
    @ValidatorFactory(value=BinayPathValidator.class)
    @DefaultFactory(value=DefaultFFMpegBinary.class)
    @AdvancedValueEditorFactory(value=FFmpegBinaryValueEditor.class)
    @DescriptionForConfigEntry(value="full path (including binary filename) to ffmpeg")
    public String getBinaryPath();

    public void setBinaryPath(String var1);

    @AboutConfig
    @ValidatorFactory(value=BinayPathValidator.class)
    @DefaultFactory(value=DefaultFFProbeBinary.class)
    @AdvancedValueEditorFactory(value=FFmpegBinaryValueEditor.class)
    @DescriptionForConfigEntry(value="full path (including binary filename) to ffprobe")
    public String getBinaryPathProbe();

    public void setBinaryPathProbe(String var1);

    @AboutConfig
    @DefaultStringArrayValue(value={"-i", "%video", "-i", "%audio", "-map", "0:0", "-c:v", "copy", "-map", "1:0", "-c:a", "copy", "-f", "mp4", "%out", "-y"})
    public String[] getMuxToMp4Command();

    public void setMuxToMp4Command(String[] var1);

    @AboutConfig
    @DefaultStringArrayValue(value={"-i", "%video", "-i", "%audio", "-map", "0:0", "-c:v", "copy", "-map", "1:0", "-c:a", "copy", "-f", "matroska", "%out", "-y"})
    public String[] getMuxToMkvCommand();

    public void setMuxToMkvCommand(String[] var1);

    @AboutConfig
    @DefaultStringArrayValue(value={"-i", "%audio", "-f", "mp4", "-c:a", "copy", "%out", "-y"})
    public String[] getDash2M4aCommand();

    public void setDash2M4aCommand(String[] var1);

    @AboutConfig
    @DefaultStringArrayValue(value={"-i", "%audio", "-f", "adts", "-c:a", "copy", "%out", "-y"})
    public String[] getDash2AacCommand();

    public void setDash2AacCommand(String[] var1);

    @AboutConfig
    @DefaultStringArrayValue(value={"-i", "%audio", "-vn", "-f", "adts", "-c:a", "copy", "%out", "-y"})
    public String[] getDemux2AacCommand();

    public void setDemux2AacCommand(String[] var1);

    @AboutConfig
    @DefaultStringArrayValue(value={"-i", "%audio", "-vn", "-f", "mp4", "-c:a", "copy", "%out", "-y"})
    public String[] getDemux2M4aCommand();

    public void setDemux2M4aCommand(String[] var1);

    @AboutConfig
    @DefaultStringArrayValue(value={"-i", "%audio", "-vn", "-f", "mp3", "-c:a", "copy", "%out", "-y"})
    public String[] getDemux2Mp3Command();

    public void setDemux2Mp3Command(String[] var1);

    @AboutConfig
    @DefaultStringArrayValue(value={"-i", "%audio", "-vn", "-f", "ogg", "-acodec", "libvorbis", "-aq", "4", "%out", "-y"})
    public String[] getDemuxAndConvert2Ogg();

    public void setDemuxAndConvert2Ogg(String[] var1);

    @AboutConfig
    @DefaultStringArrayValue(value={"-i", "%audio", "%map", "-acodec", "copy", "-vn", "%out", "-y"})
    public String[] getDemuxGenericCommand();

    public void setDemuxGenericCommand(String[] var1);

    @AboutConfig
    public Map<String, String> getExtensionToFormatMap();

    public void setExtensionToFormatMap(Map<String, String> var1);

    @AboutConfig
    @DefaultStringArrayValue(value={"-i", "%video", "-i", "%audio", "-map", "0:0", "-c:v", "copy", "-map", "1:0", "-c:a", "copy", "-f", "webm", "%out", "-y"})
    public String[] getMuxToWebmCommand();

    public void setMuxToWebmCommand(String[] var1);

    @AboutConfig
    @DefaultStringArrayValue(value={"-i", "%audio", "-f", "opus", "-c:a", "copy", "%out", "-y"})
    public String[] getDash2OpusAudioCommand();

    public void setDash2OpusAudioCommand(String[] var1);

    @AboutConfig
    @DefaultStringArrayValue(value={"-i", "%audio", "-f", "ogg", "-c:a", "copy", "%out", "-y"})
    public String[] getDash2OggAudioCommand();

    public void setDash2OggAudioCommand(String[] var1);

    @AboutConfig
    @DefaultStringArrayValue(value={"-i", "%audio", "-f", "matroska", "-c:a", "copy", "%out", "-y"})
    public String[] getDash2MkvAudioCommand();

    public void setDash2MkvAudioCommand(String[] var1);

    public static class DefaultFFProbeBinary
    extends AbstractDefaultFactory<String> {
        final String binary = "ffprobe";

        public String getDefaultValue(KeyHandler<String> keyHandler) {
            if (CrossSystem.isLinux() || CrossSystem.isMac()) {
                BinayPathValidator binaryPathValidator = new BinayPathValidator();
                for (String path : new String[]{"/usr/bin/", "/usr/local/bin/"}) {
                    try {
                        String binaryPath = path + "ffprobe";
                        binaryPathValidator.validate(keyHandler, binaryPath);
                        return binaryPath;
                    }
                    catch (ValidationException validationException) {
                    }
                }
            }
            return null;
        }
    }

    public static class DefaultFFMpegBinary
    extends AbstractDefaultFactory<String> {
        final String binary = "ffmpeg";

        public String getDefaultValue(KeyHandler<String> keyHandler) {
            if (CrossSystem.isLinux() || CrossSystem.isMac()) {
                BinayPathValidator binaryPathValidator = new BinayPathValidator();
                for (String path : new String[]{"/usr/bin/", "/usr/local/bin/"}) {
                    try {
                        String binaryPath = path + "ffmpeg";
                        binaryPathValidator.validate(keyHandler, binaryPath);
                        return binaryPath;
                    }
                    catch (ValidationException validationException) {
                    }
                }
            }
            return null;
        }
    }

    public static class BinayPathValidator
    extends AbstractValidator<String> {
        public void validate(KeyHandler<String> keyHandler, String binaryPath) throws ValidationException {
            if (StringUtils.isNotEmpty((String)binaryPath)) {
                File file = new File(binaryPath);
                if (!file.exists()) {
                    throw new ValidationException("Binary '" + binaryPath + "' does not exist!");
                }
                if (file.isDirectory()) {
                    throw new ValidationException("Binary '" + binaryPath + "' must be a file!");
                }
                if (CrossSystem.isUnix() && !file.canExecute()) {
                    throw new ValidationException("Binary '" + binaryPath + "' is not executable!");
                }
                if (CrossSystem.isWindows() && !StringUtils.endsWithCaseInsensitive((String)file.getName(), (String)".exe")) {
                    throw new ValidationException("Binary '" + binaryPath + "' is not executable!");
                }
            }
        }
    }
}

