/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.controlling.ffmpeg.json;

import org.appwork.storage.Storable;
import org.appwork.utils.logging2.LogSource;
import org.jdownloader.controlling.ffmpeg.json.StreamTags;
import org.jdownloader.logging.LogController;

public class Stream
implements Storable {
    private static final LogSource LOGGER = LogController.getInstance().getLogger(Stream.class.getName());
    private int channels;
    private StreamTags tags;
    private String codec_name;
    private String codec_long_name;
    private String sample_aspect_ratio;
    private String codec_time_base;
    private String codec_tag_string;
    private String is_avc;
    private int level;
    private String r_frame_rate;
    private String avg_frame_rate;
    private String display_aspect_ratio;
    private String profile;
    private int index;
    private int width;
    private int height;
    private String codec_type;
    private String sample_rate;
    private String duration;
    private String bit_rate;

    public StreamTags getTags() {
        return this.tags;
    }

    public void setTags(StreamTags tags) {
        this.tags = tags;
    }

    public int getChannels() {
        return this.channels;
    }

    public void setChannels(int channels) {
        this.channels = channels;
    }

    public String getCodec_long_name() {
        return this.codec_long_name;
    }

    public void setCodec_long_name(String codec_long_name) {
        this.codec_long_name = codec_long_name;
    }

    public String getCodec_name() {
        return this.codec_name;
    }

    public void setCodec_name(String codec_name) {
        this.codec_name = codec_name;
    }

    public String getSample_aspect_ratio() {
        return this.sample_aspect_ratio;
    }

    public void setSample_aspect_ratio(String sample_aspect_ratio) {
        this.sample_aspect_ratio = sample_aspect_ratio;
    }

    public String getCodec_time_base() {
        return this.codec_time_base;
    }

    public void setCodec_time_base(String codec_time_base) {
        this.codec_time_base = codec_time_base;
    }

    public String getIs_avc() {
        return this.is_avc;
    }

    public void setIs_avc(String is_avc) {
        this.is_avc = is_avc;
    }

    public String getCodec_tag_string() {
        return this.codec_tag_string;
    }

    public void setCodec_tag_string(String codec_tag_string) {
        this.codec_tag_string = codec_tag_string;
    }

    public int getIndex() {
        return this.index;
    }

    public int getLevel() {
        return this.level;
    }

    public String getR_frame_rate() {
        return this.r_frame_rate;
    }

    public void setR_frame_rate(String r_frame_rate) {
        this.r_frame_rate = r_frame_rate;
    }

    public String getAvg_frame_rate() {
        return this.avg_frame_rate;
    }

    public void setAvg_frame_rate(String avg_frame_rate) {
        this.avg_frame_rate = avg_frame_rate;
    }

    public String getDisplay_aspect_ratio() {
        return this.display_aspect_ratio;
    }

    public void setDisplay_aspect_ratio(String display_aspect_ratio) {
        this.display_aspect_ratio = display_aspect_ratio;
    }

    public String getProfile() {
        return this.profile;
    }

    public void setProfile(String profile) {
        this.profile = profile;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public String getCodec_type() {
        return this.codec_type;
    }

    public void setCodec_type(String codec_type) {
        this.codec_type = codec_type;
    }

    public String getDuration() {
        return this.duration;
    }

    public void setDuration(String duration) {
        this.duration = duration;
    }

    public String getBit_rate() {
        return this.bit_rate;
    }

    public void setBit_rate(String bit_rate) {
        this.bit_rate = bit_rate;
    }

    public String getSample_rate() {
        return this.sample_rate;
    }

    public void setSample_rate(String sample_rate) {
        this.sample_rate = sample_rate;
    }

    public int parseDuration() {
        try {
            if (this.duration == null) {
                return -1;
            }
            return (int)Double.parseDouble(this.getDuration());
        }
        catch (Throwable e) {
            LOGGER.info(this.getDuration());
            LOGGER.log(e);
            return -1;
        }
    }

    public int parseBitrate() {
        try {
            if (this.bit_rate == null) {
                return -1;
            }
            return Integer.parseInt(this.getBit_rate());
        }
        catch (Throwable e) {
            LOGGER.info(this.getBit_rate());
            LOGGER.log(e);
            return -1;
        }
    }

    public int parseSamplingRate() {
        try {
            if (this.sample_rate == null) {
                return -1;
            }
            return Integer.parseInt(this.getSample_rate());
        }
        catch (Throwable e) {
            LOGGER.info(this.getSample_rate());
            LOGGER.log(e);
            return -1;
        }
    }

    public int[] parseFrameRate() {
        try {
            if (this.avg_frame_rate == null) {
                return null;
            }
            String[] sp = this.avg_frame_rate.split("/");
            if (sp.length == 2) {
                return new int[]{Integer.parseInt(sp[0]), Integer.parseInt(sp[1])};
            }
            return new int[]{Integer.parseInt(sp[0]), 1};
        }
        catch (Throwable e) {
            LOGGER.info(this.avg_frame_rate);
            LOGGER.log(e);
            return null;
        }
    }

    public int[] parsePixelAspectRatio() {
        try {
            if (this.sample_aspect_ratio == null) {
                return null;
            }
            String[] sp = this.sample_aspect_ratio.split(":");
            if (sp.length == 2) {
                return new int[]{Integer.parseInt(sp[0]), Integer.parseInt(sp[1])};
            }
            return new int[]{Integer.parseInt(sp[0]), 1};
        }
        catch (Throwable e) {
            LOGGER.info(this.sample_aspect_ratio);
            LOGGER.log(e);
            return null;
        }
    }
}

