/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.controlling.filter;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jd.plugins.LinkInfo;
import org.appwork.utils.ByteArrayUtils;
import org.appwork.utils.StringUtils;
import org.appwork.utils.logging2.extmanager.LoggerFactory;
import org.jdownloader.controlling.filter.FiletypeFilter;
import org.jdownloader.controlling.filter.LinkgrabberFilterRuleWrapper;
import org.jdownloader.controlling.filter.RuleWrapper;
import org.jdownloader.gui.translate._GUI;

public class CompiledFiletypeFilter {
    private final Pattern[] list;
    private final ExtensionsFilterInterface[] filterInterfaces;
    private final FiletypeFilter.TypeMatchType matchType;
    private static List<CompiledFiletypeExtension> EXTENSIONSFILTERINTERFACES = CompiledFiletypeFilter.init();

    public FiletypeFilter.TypeMatchType getMatchType() {
        return this.matchType;
    }

    private static List<CompiledFiletypeExtension> init() {
        ArrayList<CompiledFiletypeExtension> ret = new ArrayList<CompiledFiletypeExtension>();
        ret.addAll(Arrays.asList(VideoExtensions.values()));
        ret.addAll(Arrays.asList(AudioExtensions.values()));
        ret.addAll(Arrays.asList(ExecutableExtensions.values()));
        ret.addAll(Arrays.asList(HashExtensions.values()));
        ret.addAll(Arrays.asList(DocumentExtensions.values()));
        ret.addAll(Arrays.asList(ImageExtensions.values()));
        ret.addAll(Arrays.asList(SubtitleExtensions.values()));
        ret.addAll(Arrays.asList(ArchiveExtensions.values()));
        return ret;
    }

    public static CompiledFiletypeExtension getExtensionsFilterInterface(String fileExtension) {
        if (fileExtension == null) {
            return null;
        }
        if (fileExtension.startsWith(".")) {
            fileExtension = fileExtension.substring(1);
        }
        for (CompiledFiletypeExtension extension : EXTENSIONSFILTERINTERFACES) {
            Pattern pattern = extension.getPattern();
            if (pattern == null || !pattern.matcher(fileExtension).matches()) continue;
            return extension;
        }
        return null;
    }

    public static List<CompiledFiletypeExtension> getByMimeType(final String mimeType) {
        if (mimeType == null) {
            return null;
        }
        ArrayList<CompiledFiletypeExtension> retMatches = new ArrayList<CompiledFiletypeExtension>();
        ArrayList<CompiledFiletypeExtension> retContains = new ArrayList<CompiledFiletypeExtension>();
        for (CompiledFiletypeExtension extension : EXTENSIONSFILTERINTERFACES) {
            int matches = extension.matchesMimeType(mimeType);
            if (matches > 0) {
                retMatches.add(extension);
                continue;
            }
            if (matches >= 0) continue;
            retContains.add(extension);
        }
        ArrayList<CompiledFiletypeExtension> ret = retMatches.size() > 0 ? retMatches : retContains;
        Collections.sort(ret, new Comparator<CompiledFiletypeExtension>(){

            @Override
            private int compare(int x, int y) {
                return x < y ? -1 : (x == y ? 0 : 1);
            }

            @Override
            public int compare(CompiledFiletypeExtension o1, CompiledFiletypeExtension o2) {
                return this.compare(Math.abs(o1.matchesMimeType(mimeType)), Math.abs(o2.matchesMimeType(mimeType)));
            }
        });
        return ret;
    }

    private static String getExtensionFromMimeType(String mimeType, CompiledFiletypeExtension fileTypeExtension) {
        return fileTypeExtension.matchesMimeType(mimeType) > 0 ? fileTypeExtension.name().toLowerCase(Locale.ENGLISH) : null;
    }

    private static Boolean isValidExtension(String extension, CompiledFiletypeExtension fileTypeExtension) {
        if (extension != null) {
            return fileTypeExtension.getPattern().matcher(extension).matches();
        }
        return null;
    }

    private static Pattern compileAllPattern(ExtensionsFilterInterface[] filters) {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        boolean or = false;
        for (ExtensionsFilterInterface value : filters) {
            Pattern pattern;
            if (or) {
                sb.append("|");
            }
            if ((pattern = value.getPattern()) != null) {
                sb.append(pattern);
            }
            or = true;
        }
        sb.append(")");
        return Pattern.compile(sb.toString(), 34);
    }

    protected static int matchesMimeType(Pattern pattern, String mimeType) {
        Matcher matcher = pattern.matcher(mimeType);
        if (!matcher.find()) {
            Matcher contains = Pattern.compile(Pattern.quote(mimeType), 2).matcher(pattern.pattern());
            if (!contains.find()) {
                return 0;
            }
            return -(contains.end() - contains.start());
        }
        return matcher.end() - matcher.start();
    }

    public CompiledFiletypeFilter(FiletypeFilter filetypeFilter) {
        ArrayList<Pattern> list = new ArrayList<Pattern>();
        ArrayList<Enum> filterInterfaces = new ArrayList<Enum>();
        if (filetypeFilter.isArchivesEnabled()) {
            filterInterfaces.add(ArchiveExtensions.ACE);
        }
        if (filetypeFilter.isHashEnabled()) {
            filterInterfaces.add(HashExtensions.MD5);
        }
        if (filetypeFilter.isAudioFilesEnabled()) {
            filterInterfaces.add(AudioExtensions.AAC);
        }
        if (filetypeFilter.isImagesEnabled()) {
            filterInterfaces.add(ImageExtensions.BMP);
        }
        if (filetypeFilter.isVideoFilesEnabled()) {
            filterInterfaces.add(VideoExtensions.ASF);
        }
        if (filetypeFilter.isDocFilesEnabled()) {
            filterInterfaces.add(DocumentExtensions.TXT);
        }
        if (filetypeFilter.isSubFilesEnabled()) {
            filterInterfaces.add(SubtitleExtensions.SRT);
        }
        if (filetypeFilter.isExeFilesEnabled()) {
            filterInterfaces.add(ExecutableExtensions.EXE);
        }
        this.matchType = filetypeFilter.getMatchType();
        try {
            if (filetypeFilter.getCustoms() != null) {
                if (filetypeFilter.isUseRegex()) {
                    list.add(Pattern.compile(filetypeFilter.getCustoms(), 34));
                } else {
                    for (String s : filetypeFilter.getCustoms().split("\\,")) {
                        list.add(LinkgrabberFilterRuleWrapper.createPattern(s, false, RuleWrapper.AUTO_PATTERN_MODE.MATCHES));
                    }
                }
            }
        }
        catch (Throwable e) {
            LoggerFactory.getDefaultLogger().log(e);
        }
        this.list = list.toArray(new Pattern[list.size()]);
        this.filterInterfaces = filterInterfaces.toArray(new ExtensionsFilterInterface[filterInterfaces.size()]);
    }

    public boolean matches(String extension, LinkInfo linkInfo) {
        boolean matches = false;
        String ext = StringUtils.isNotEmpty((String)extension) ? extension : linkInfo.getExtension().name();
        block8: for (ExtensionsFilterInterface filterInterfaces : this.filterInterfaces) {
            if (matches) break;
            if (linkInfo.getExtension().isSameExtensionGroup(filterInterfaces)) {
                matches = true;
                break;
            }
            for (ExtensionsFilterInterface filterInterface : filterInterfaces.listSameGroup()) {
                Pattern pattern = filterInterface.getPattern();
                try {
                    if (pattern == null || !pattern.matcher(ext).matches()) continue;
                    matches = true;
                    continue block8;
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }
        if (!matches) {
            for (Pattern pattern : this.list) {
                try {
                    if (pattern == null || !pattern.matcher(ext).matches()) continue;
                    matches = true;
                    break;
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }
        switch (this.matchType) {
            case IS: {
                return matches;
            }
            case IS_NOT: {
                return !matches;
            }
        }
        return false;
    }

    public Pattern[] getList() {
        ArrayList<Pattern> ret = new ArrayList<Pattern>();
        ret.addAll(Arrays.asList(this.list));
        for (ExtensionsFilterInterface filterInterfaces : this.filterInterfaces) {
            for (ExtensionsFilterInterface filterInterface : filterInterfaces.listSameGroup()) {
                Pattern pattern = filterInterface.getPattern();
                if (pattern == null) continue;
                ret.add(pattern);
            }
        }
        return ret.toArray(new Pattern[ret.size()]);
    }

    public static enum ImageExtensions implements CompiledFiletypeExtension
    {
        JXL{
            private final Pattern pattern = Pattern.compile("(?i)image/jxl");

            @Override
            public int matchesMimeType(String mimeType) {
                return CompiledFiletypeFilter.matchesMimeType(this.pattern, mimeType);
            }
        }
        ,
        JPG("(jpe|jpe?g|jfif)"){
            private final Pattern pattern = Pattern.compile("(?i)image/jpe?g");

            @Override
            public boolean matchesMagic(InputStream inputStream) throws IOException {
                byte[] read = new byte[3];
                new DataInputStream(inputStream).readFully(read);
                return ByteArrayUtils.contains((byte[])read, (byte[])new byte[]{-1, -40, -1});
            }

            @Override
            public int matchesMimeType(String mimeType) {
                return CompiledFiletypeFilter.matchesMimeType(this.pattern, mimeType);
            }
        }
        ,
        JP2("(jp2|j2k|jpf|jpg2|jpx|jpm|mj2|mjp2)"),
        AVIF{
            private final Pattern pattern = Pattern.compile("(?i)image/avif");

            @Override
            public int matchesMimeType(String mimeType) {
                return CompiledFiletypeFilter.matchesMimeType(this.pattern, mimeType);
            }
        }
        ,
        GIF{
            private final Pattern pattern = Pattern.compile("(?i)image/gif");

            @Override
            public boolean matchesMagic(InputStream inputStream) throws IOException {
                byte[] read = new byte[6];
                new DataInputStream(inputStream).readFully(read);
                return ByteArrayUtils.contains((byte[])read, (byte[])new byte[]{71, 73, 70, 56, 55, 97}) || ByteArrayUtils.contains((byte[])read, (byte[])new byte[]{71, 73, 70, 56, 57, 97});
            }

            @Override
            public int matchesMimeType(String mimeType) {
                return CompiledFiletypeFilter.matchesMimeType(this.pattern, mimeType);
            }
        }
        ,
        DNG,
        GPR,
        EPS{
            private final Pattern pattern = Pattern.compile("(?i)application/postscript");

            @Override
            public int matchesMimeType(String mimeType) {
                return CompiledFiletypeFilter.matchesMimeType(this.pattern, mimeType);
            }
        }
        ,
        PNG{
            private final Pattern pattern = Pattern.compile("(?i)image/png");

            @Override
            public boolean matchesMagic(InputStream inputStream) throws IOException {
                byte[] read = new byte[4];
                new DataInputStream(inputStream).readFully(read);
                return ByteArrayUtils.contains((byte[])read, (byte[])new byte[]{-119, 80, 78, 71});
            }

            @Override
            public int matchesMimeType(String mimeType) {
                return CompiledFiletypeFilter.matchesMimeType(this.pattern, mimeType);
            }
        }
        ,
        BMP{
            private final Pattern pattern = Pattern.compile("(?i)image/(bmp|x-bmp)");

            @Override
            public int matchesMimeType(String mimeType) {
                return CompiledFiletypeFilter.matchesMimeType(this.pattern, mimeType);
            }
        }
        ,
        TIFF("tiff?"){
            private final Pattern pattern = Pattern.compile("(?i)image/tiff");

            @Override
            public int matchesMimeType(String mimeType) {
                return CompiledFiletypeFilter.matchesMimeType(this.pattern, mimeType);
            }
        }
        ,
        RAW,
        SVG{
            private final Pattern pattern = Pattern.compile("(?i)image/svg\\+xml");

            @Override
            public boolean matchesMagic(InputStream inputStream) throws IOException {
                byte[] read = new byte[4];
                new DataInputStream(inputStream).readFully(read);
                return ByteArrayUtils.contains((byte[])read, (byte[])new byte[]{60, 115, 118, 103});
            }

            @Override
            public int matchesMimeType(String mimeType) {
                return CompiledFiletypeFilter.matchesMimeType(this.pattern, mimeType);
            }
        }
        ,
        ICO{
            private final Pattern pattern = Pattern.compile("(?i)image/x-icon");

            @Override
            public boolean matchesMagic(InputStream inputStream) throws IOException {
                byte[] read = new byte[4];
                new DataInputStream(inputStream).readFully(read);
                return ByteArrayUtils.contains((byte[])read, (byte[])new byte[]{0, 0, 1, 0});
            }

            @Override
            public int matchesMimeType(String mimeType) {
                return CompiledFiletypeFilter.matchesMimeType(this.pattern, mimeType);
            }
        }
        ,
        CUR,
        WEBP{
            private final Pattern pattern = Pattern.compile("(?i)image/webp");

            @Override
            public int matchesMimeType(String mimeType) {
                return CompiledFiletypeFilter.matchesMimeType(this.pattern, mimeType);
            }
        }
        ,
        MVIEW;

        private final Pattern pattern;
        private static Pattern allPattern;

        @Override
        public Pattern getPattern() {
            return this.pattern;
        }

        private ImageExtensions() {
            this.pattern = Pattern.compile(this.name(), 34);
        }

        private ImageExtensions(String id) {
            this.pattern = Pattern.compile(id, 34);
        }

        @Override
        public String getDesc() {
            return _GUI.T.FilterRuleDialog_createTypeFilter_mime_images();
        }

        @Override
        public ExtensionsFilterInterface getSource() {
            return this;
        }

        @Override
        public boolean isValidExtension(String extension) {
            return CompiledFiletypeFilter.isValidExtension(extension, this);
        }

        @Override
        public Pattern compiledAllPattern() {
            if (allPattern == null) {
                allPattern = CompiledFiletypeFilter.compileAllPattern(ImageExtensions.values());
            }
            return allPattern;
        }

        @Override
        public ExtensionsFilterInterface[] listSameGroup() {
            return ImageExtensions.values();
        }

        @Override
        public boolean isSameExtensionGroup(ExtensionsFilterInterface extension) {
            return extension != null && extension instanceof ImageExtensions;
        }

        @Override
        public String getIconID() {
            return "image";
        }

        @Override
        public int matchesMimeType(String mimeType) {
            return 0;
        }

        @Override
        public String getExtensionFromMimeType(String mimeType) {
            return CompiledFiletypeFilter.getExtensionFromMimeType(mimeType, this);
        }

        @Override
        public boolean matchesMagic(InputStream inputStream) throws IOException {
            return false;
        }
    }

    public static enum ArchiveExtensions implements CompiledFiletypeExtension
    {
        REV,
        RAR{
            private final Pattern pattern = Pattern.compile("(?i)application/x-rar-compressed");

            @Override
            public int matchesMimeType(String mimeType) {
                return CompiledFiletypeFilter.matchesMimeType(this.pattern, mimeType);
            }

            @Override
            public String getExtensionFromMimeType(String mimeType) {
                return this.matchesMimeType(mimeType) > 0 ? "rar" : null;
            }
        }
        ,
        ZIP{
            private final Pattern pattern = Pattern.compile("(?i)application/zip");

            @Override
            public int matchesMimeType(String mimeType) {
                return CompiledFiletypeFilter.matchesMimeType(this.pattern, mimeType);
            }
        }
        ,
        R_NUM("[r-z]\\d{2}"),
        NUM("\\d{1,4}"),
        MultiZip("z\\d{1,4}"),
        ACE("(ace|c\\d{2,4})"){
            private final Pattern pattern = Pattern.compile("(?i)application/x-ace-compressed");

            @Override
            public int matchesMimeType(String mimeType) {
                return CompiledFiletypeFilter.matchesMimeType(this.pattern, mimeType);
            }

            @Override
            public String getExtensionFromMimeType(String mimeType) {
                return this.matchesMimeType(mimeType) > 0 ? "ace" : null;
            }
        }
        ,
        TAR{
            private final Pattern pattern = Pattern.compile("(?i)application/x-tar");

            @Override
            public int matchesMimeType(String mimeType) {
                return CompiledFiletypeFilter.matchesMimeType(this.pattern, mimeType);
            }
        }
        ,
        GZ{
            private final Pattern pattern = Pattern.compile("(?i)application/gzip");

            @Override
            public int matchesMimeType(String mimeType) {
                return CompiledFiletypeFilter.matchesMimeType(this.pattern, mimeType);
            }
        }
        ,
        AR,
        BZ{
            private final Pattern pattern = Pattern.compile("(?i)application/x-bzip");

            @Override
            public int matchesMimeType(String mimeType) {
                return CompiledFiletypeFilter.matchesMimeType(this.pattern, mimeType);
            }
        }
        ,
        BZ2{
            private final Pattern pattern = Pattern.compile("(?i)application/x-bzip2");

            @Override
            public int matchesMimeType(String mimeType) {
                return CompiledFiletypeFilter.matchesMimeType(this.pattern, mimeType);
            }
        }
        ,
        ARJ,
        CPIO,
        SevenZ("(7z|7zip)"){
            private final Pattern pattern = Pattern.compile("(?i)application/x-7z-compressed");

            @Override
            public int matchesMimeType(String mimeType) {
                return CompiledFiletypeFilter.matchesMimeType(this.pattern, mimeType);
            }

            @Override
            public String getExtensionFromMimeType(String mimeType) {
                return this.matchesMimeType(mimeType) > 0 ? "7z" : null;
            }
        }
        ,
        S7Z,
        DMG,
        SFX,
        XZ{
            private final Pattern pattern = Pattern.compile("(?i)application/x-xz");

            @Override
            public int matchesMimeType(String mimeType) {
                return CompiledFiletypeFilter.matchesMimeType(this.pattern, mimeType);
            }
        }
        ,
        TXZ,
        TGZ,
        LZH,
        LHA,
        AA("[a-z]{2}");

        private final Pattern pattern;
        private static Pattern allPattern;

        @Override
        public Pattern getPattern() {
            return this.pattern;
        }

        @Override
        public ExtensionsFilterInterface getSource() {
            return this;
        }

        private ArchiveExtensions() {
            this.pattern = Pattern.compile(this.name(), 34);
        }

        private ArchiveExtensions(String id) {
            this.pattern = Pattern.compile(id, 34);
        }

        @Override
        public boolean isValidExtension(String extension) {
            return CompiledFiletypeFilter.isValidExtension(extension, this);
        }

        @Override
        public String getDesc() {
            return _GUI.T.FilterRuleDialog_createTypeFilter_mime_archives();
        }

        @Override
        public Pattern compiledAllPattern() {
            if (allPattern == null) {
                allPattern = CompiledFiletypeFilter.compileAllPattern(ArchiveExtensions.values());
            }
            return allPattern;
        }

        @Override
        public ExtensionsFilterInterface[] listSameGroup() {
            return ArchiveExtensions.values();
        }

        @Override
        public boolean isSameExtensionGroup(ExtensionsFilterInterface extension) {
            return extension != null && extension instanceof ArchiveExtensions;
        }

        @Override
        public String getIconID() {
            return "extract";
        }

        @Override
        public int matchesMimeType(String mimeType) {
            return 0;
        }

        @Override
        public String getExtensionFromMimeType(String mimeType) {
            return CompiledFiletypeFilter.getExtensionFromMimeType(mimeType, this);
        }

        @Override
        public boolean matchesMagic(InputStream inputStream) throws IOException {
            return false;
        }
    }

    public static enum VideoExtensions implements CompiledFiletypeExtension
    {
        ThreeGP("3GP"){
            private final Pattern pattern = Pattern.compile("(?i)(video|audio)/3gpp");

            @Override
            public int matchesMimeType(String mimeType) {
                return CompiledFiletypeFilter.matchesMimeType(this.pattern, mimeType);
            }

            @Override
            public String getExtensionFromMimeType(String mimeType) {
                return this.matchesMimeType(mimeType) > 0 ? "3gp" : null;
            }
        }
        ,
        ASF,
        AVI,
        DIVX,
        XVID,
        FLV,
        MP4{
            private final Pattern pattern = Pattern.compile("(?i)video/mp4");

            @Override
            public int matchesMimeType(String mimeType) {
                return CompiledFiletypeFilter.matchesMimeType(this.pattern, mimeType);
            }
        }
        ,
        H264,
        H265,
        M2TS("m2ts|m2t|mts"),
        MP2T("tsv|tsa|ts"),
        M4U,
        M4V,
        MOV,
        MKV,
        MPEG,
        MPEG4,
        MPG,
        OGM,
        OGV,
        VOB,
        WMV{
            private final Pattern pattern = Pattern.compile("(?i)video/x-ms-wmv");

            @Override
            public int matchesMimeType(String mimeType) {
                return CompiledFiletypeFilter.matchesMimeType(this.pattern, mimeType);
            }
        }
        ,
        GP3,
        WEBM{
            private final Pattern pattern = Pattern.compile("(?i)video/webm");

            @Override
            public int matchesMimeType(String mimeType) {
                return CompiledFiletypeFilter.matchesMimeType(this.pattern, mimeType);
            }
        }
        ,
        APNG{
            private final Pattern pattern = Pattern.compile("(?i)image/apng");

            @Override
            public int matchesMimeType(String mimeType) {
                return CompiledFiletypeFilter.matchesMimeType(this.pattern, mimeType);
            }
        };

        private final Pattern pattern;
        private static Pattern allPattern;

        private VideoExtensions() {
            this.pattern = Pattern.compile(this.name(), 34);
        }

        @Override
        public Pattern getPattern() {
            return this.pattern;
        }

        @Override
        public ExtensionsFilterInterface getSource() {
            return this;
        }

        @Override
        public boolean isSameExtensionGroup(ExtensionsFilterInterface extension) {
            return extension != null && extension instanceof VideoExtensions;
        }

        @Override
        public boolean isValidExtension(String extension) {
            return CompiledFiletypeFilter.isValidExtension(extension, this);
        }

        private VideoExtensions(String id) {
            this.pattern = Pattern.compile(id, 34);
        }

        @Override
        public String getDesc() {
            return _GUI.T.FilterRuleDialog_createTypeFilter_mime_video();
        }

        @Override
        public Pattern compiledAllPattern() {
            if (allPattern == null) {
                allPattern = CompiledFiletypeFilter.compileAllPattern(VideoExtensions.values());
            }
            return allPattern;
        }

        @Override
        public String getIconID() {
            return "video";
        }

        @Override
        public ExtensionsFilterInterface[] listSameGroup() {
            return VideoExtensions.values();
        }

        @Override
        public int matchesMimeType(String mimeType) {
            return 0;
        }

        @Override
        public String getExtensionFromMimeType(String mimeType) {
            return CompiledFiletypeFilter.getExtensionFromMimeType(mimeType, this);
        }

        @Override
        public boolean matchesMagic(InputStream inputStream) throws IOException {
            return false;
        }
    }

    public static enum AudioExtensions implements CompiledFiletypeExtension
    {
        DTSHD{
            private final Pattern pattern = Pattern.compile("(?i)audio/vnd\\.dts\\.hd");

            @Override
            public int matchesMimeType(String mimeType) {
                return CompiledFiletypeFilter.matchesMimeType(this.pattern, mimeType);
            }
        }
        ,
        DTS{
            private final Pattern pattern = Pattern.compile("(?i)audio/vnd\\.dts");

            @Override
            public int matchesMimeType(String mimeType) {
                return CompiledFiletypeFilter.matchesMimeType(this.pattern, mimeType);
            }
        }
        ,
        AC3,
        MP3{
            private final Pattern pattern = Pattern.compile("(?i)audio/(mpeg|mp3)");

            @Override
            public int matchesMimeType(String mimeType) {
                return CompiledFiletypeFilter.matchesMimeType(this.pattern, mimeType);
            }
        }
        ,
        MO3,
        WMA{
            private final Pattern pattern = Pattern.compile("(?i)audio/x-ms-wma");

            @Override
            public int matchesMimeType(String mimeType) {
                return CompiledFiletypeFilter.matchesMimeType(this.pattern, mimeType);
            }
        }
        ,
        AAC,
        WAV{
            private final Pattern pattern = Pattern.compile("(?i)audio/wav");

            @Override
            public int matchesMimeType(String mimeType) {
                return CompiledFiletypeFilter.matchesMimeType(this.pattern, mimeType);
            }
        }
        ,
        FLAC{
            private final Pattern pattern = Pattern.compile("(?i)audio/x-flac");

            @Override
            public int matchesMimeType(String mimeType) {
                return CompiledFiletypeFilter.matchesMimeType(this.pattern, mimeType);
            }
        }
        ,
        MID,
        MOD,
        OGG{
            private final Pattern pattern = Pattern.compile("(?i)audio/ogg");

            @Override
            public int matchesMimeType(String mimeType) {
                return CompiledFiletypeFilter.matchesMimeType(this.pattern, mimeType);
            }

            @Override
            public boolean isValidExtension(String extension) {
                return super.isValidExtension(extension) || CompiledFiletypeFilter.isValidExtension(extension, 7.OGA) != false;
            }
        }
        ,
        OGA{
            private final Pattern pattern = Pattern.compile("(?i)audio/ogg");

            @Override
            public int matchesMimeType(String mimeType) {
                return CompiledFiletypeFilter.matchesMimeType(this.pattern, mimeType);
            }

            @Override
            public boolean isValidExtension(String extension) {
                return super.isValidExtension(extension) || CompiledFiletypeFilter.isValidExtension(extension, 8.OGG) != false;
            }
        }
        ,
        OPUS{
            private final Pattern pattern = Pattern.compile("(?i)audio/opus");

            @Override
            public int matchesMimeType(String mimeType) {
                return CompiledFiletypeFilter.matchesMimeType(this.pattern, mimeType);
            }
        }
        ,
        S3M,
        FourMP("4MP"),
        AIF,
        AIFF,
        AU,
        M3U,
        M4a{
            private final Pattern pattern = Pattern.compile("(?i)audio/(mp4|x-m4a)");

            @Override
            public int matchesMimeType(String mimeType) {
                return CompiledFiletypeFilter.matchesMimeType(this.pattern, mimeType);
            }
        }
        ,
        M4b,
        M4s,
        M4P,
        MKA,
        MP1,
        MP2,
        MPA,
        MIDI("midi?"),
        MMP("mmpz?"),
        OMG,
        OMF,
        SND,
        SPX,
        NSF;

        private final Pattern pattern;
        private static Pattern allPattern;

        @Override
        public Pattern getPattern() {
            return this.pattern;
        }

        @Override
        public ExtensionsFilterInterface getSource() {
            return this;
        }

        private AudioExtensions() {
            this.pattern = Pattern.compile(this.name(), 34);
        }

        private AudioExtensions(String id) {
            this.pattern = Pattern.compile(id, 34);
        }

        @Override
        public String getDesc() {
            return _GUI.T.FilterRuleDialog_createTypeFilter_mime_audio();
        }

        @Override
        public String getIconID() {
            return "audio";
        }

        @Override
        public boolean isValidExtension(String extension) {
            return CompiledFiletypeFilter.isValidExtension(extension, this);
        }

        @Override
        public Pattern compiledAllPattern() {
            if (allPattern == null) {
                allPattern = CompiledFiletypeFilter.compileAllPattern(AudioExtensions.values());
            }
            return allPattern;
        }

        @Override
        public boolean isSameExtensionGroup(ExtensionsFilterInterface extension) {
            return extension != null && extension instanceof AudioExtensions;
        }

        @Override
        public ExtensionsFilterInterface[] listSameGroup() {
            return AudioExtensions.values();
        }

        @Override
        public int matchesMimeType(String mimeType) {
            return 0;
        }

        @Override
        public String getExtensionFromMimeType(String mimeType) {
            return CompiledFiletypeFilter.getExtensionFromMimeType(mimeType, this);
        }

        @Override
        public boolean matchesMagic(InputStream inputStream) throws IOException {
            return false;
        }
    }

    public static enum DocumentExtensions implements CompiledFiletypeExtension
    {
        CSS{
            private final Pattern pattern = Pattern.compile("(?i)text/css");

            @Override
            public int matchesMimeType(String mimeType) {
                return CompiledFiletypeFilter.matchesMimeType(this.pattern, mimeType);
            }
        }
        ,
        TXT{
            private final Pattern pattern = Pattern.compile("(?i)text/plain");

            @Override
            public int matchesMimeType(String mimeType) {
                return CompiledFiletypeFilter.matchesMimeType(this.pattern, mimeType);
            }
        }
        ,
        LOG,
        HTML("(html?)"){
            private final Pattern pattern = Pattern.compile("(?i)text/html");

            @Override
            public int matchesMimeType(String mimeType) {
                return CompiledFiletypeFilter.matchesMimeType(this.pattern, mimeType);
            }
        }
        ,
        PHP,
        JSP,
        JAVA,
        JS{
            private final Pattern pattern = Pattern.compile("(?i)text/javascript");

            @Override
            public int matchesMimeType(String mimeType) {
                return CompiledFiletypeFilter.matchesMimeType(this.pattern, mimeType);
            }
        }
        ,
        JSON{
            private final Pattern pattern = Pattern.compile("(?i)application/json");

            @Override
            public int matchesMimeType(String mimeType) {
                return CompiledFiletypeFilter.matchesMimeType(this.pattern, mimeType);
            }
        }
        ,
        DOC{
            private final Pattern pattern = Pattern.compile("(?i)application/msword");

            @Override
            public int matchesMimeType(String mimeType) {
                return CompiledFiletypeFilter.matchesMimeType(this.pattern, mimeType);
            }
        }
        ,
        DOCX{
            private final Pattern pattern = Pattern.compile("(?i)application/vnd.openxmlformats-officedocument.wordprocessingml.document");

            @Override
            public int matchesMimeType(String mimeType) {
                return CompiledFiletypeFilter.matchesMimeType(this.pattern, mimeType);
            }
        }
        ,
        DOCM{
            private final Pattern pattern = Pattern.compile("(?i)application/vnd.ms-word.document.macroEnabled.12");

            @Override
            public int matchesMimeType(String mimeType) {
                return CompiledFiletypeFilter.matchesMimeType(this.pattern, mimeType);
            }

            @Override
            public boolean isValidExtension(String extension) {
                return super.isValidExtension(extension) || CompiledFiletypeFilter.isValidExtension(extension, 8.DOC) != false;
            }
        }
        ,
        DOT{
            private final Pattern pattern = Pattern.compile("(?i)application/msword");

            @Override
            public int matchesMimeType(String mimeType) {
                return CompiledFiletypeFilter.matchesMimeType(this.pattern, mimeType);
            }
        }
        ,
        DOTX{
            private final Pattern pattern = Pattern.compile("(?i)application/vnd.openxmlformats-officedocument.wordprocessingml.template");

            @Override
            public int matchesMimeType(String mimeType) {
                return CompiledFiletypeFilter.matchesMimeType(this.pattern, mimeType);
            }

            @Override
            public boolean isValidExtension(String extension) {
                return super.isValidExtension(extension) || CompiledFiletypeFilter.isValidExtension(extension, 10.DOC) != false;
            }
        }
        ,
        DOCT{
            private final Pattern pattern = Pattern.compile("(?i)application/vnd.ms-word.template.macroEnabled.12");

            @Override
            public int matchesMimeType(String mimeType) {
                return CompiledFiletypeFilter.matchesMimeType(this.pattern, mimeType);
            }
        }
        ,
        EPUB{
            private final Pattern pattern = Pattern.compile("(?i)application/epub+zip");

            @Override
            public int matchesMimeType(String mimeType) {
                return CompiledFiletypeFilter.matchesMimeType(this.pattern, mimeType);
            }
        }
        ,
        PDB,
        README,
        MOBI("mobi|prc"),
        XML{
            private final Pattern pattern = Pattern.compile("(?i)(text/xml|application/xml)");

            @Override
            public int matchesMimeType(String mimeType) {
                return CompiledFiletypeFilter.matchesMimeType(this.pattern, mimeType);
            }
        }
        ,
        XLSX{
            private final Pattern pattern = Pattern.compile("(?i)application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");

            @Override
            public int matchesMimeType(String mimeType) {
                return CompiledFiletypeFilter.matchesMimeType(this.pattern, mimeType);
            }
        }
        ,
        XLTX{
            private final Pattern pattern = Pattern.compile("(?i)application/vnd.openxmlformats-officedocument.spreadsheetml.template");

            @Override
            public int matchesMimeType(String mimeType) {
                return CompiledFiletypeFilter.matchesMimeType(this.pattern, mimeType);
            }
        }
        ,
        XLS{
            private final Pattern pattern = Pattern.compile("(?i)application/vnd.ms-excel");

            @Override
            public int matchesMimeType(String mimeType) {
                return CompiledFiletypeFilter.matchesMimeType(this.pattern, mimeType);
            }
        }
        ,
        XLSM{
            private final Pattern pattern = Pattern.compile("(?i)application/vnd.ms-excel.sheet.macroEnabled.12");

            @Override
            public int matchesMimeType(String mimeType) {
                return CompiledFiletypeFilter.matchesMimeType(this.pattern, mimeType);
            }
        }
        ,
        XLT{
            private final Pattern pattern = Pattern.compile("(?i)application/vnd.ms-excel");

            @Override
            public int matchesMimeType(String mimeType) {
                return CompiledFiletypeFilter.matchesMimeType(this.pattern, mimeType);
            }
        }
        ,
        XLTM{
            private final Pattern pattern = Pattern.compile("(?i)application/vnd.ms-excel.template.macroEnabled.12");

            @Override
            public int matchesMimeType(String mimeType) {
                return CompiledFiletypeFilter.matchesMimeType(this.pattern, mimeType);
            }
        }
        ,
        XLA{
            private final Pattern pattern = Pattern.compile("(?i)application/vnd.ms-excel");

            @Override
            public int matchesMimeType(String mimeType) {
                return CompiledFiletypeFilter.matchesMimeType(this.pattern, mimeType);
            }
        }
        ,
        XLAM{
            private final Pattern pattern = Pattern.compile("(?i)application/vnd.ms-excel.addin.macroEnabled.12");

            @Override
            public int matchesMimeType(String mimeType) {
                return CompiledFiletypeFilter.matchesMimeType(this.pattern, mimeType);
            }
        }
        ,
        XLSB{
            private final Pattern pattern = Pattern.compile("(?i)application/vnd.ms-excel.sheet.binary.macroEnabled.12");

            @Override
            public int matchesMimeType(String mimeType) {
                return CompiledFiletypeFilter.matchesMimeType(this.pattern, mimeType);
            }
        }
        ,
        CHM,
        CSV,
        RTF,
        PDF{
            private final Pattern pattern = Pattern.compile("(?i)application/pdf");

            @Override
            public int matchesMimeType(String mimeType) {
                return CompiledFiletypeFilter.matchesMimeType(this.pattern, mimeType);
            }
        }
        ,
        NFO,
        USF;

        private final Pattern pattern;
        private static Pattern allPattern;

        @Override
        public Pattern getPattern() {
            return this.pattern;
        }

        @Override
        public ExtensionsFilterInterface getSource() {
            return this;
        }

        private DocumentExtensions() {
            this.pattern = Pattern.compile(this.name(), 34);
        }

        private DocumentExtensions(String id) {
            this.pattern = Pattern.compile(id, 34);
        }

        @Override
        public String getDesc() {
            return _GUI.T.FilterRuleDialog_createTypeFilter_mime_document();
        }

        @Override
        public String getIconID() {
            return "text";
        }

        @Override
        public boolean isValidExtension(String extension) {
            return CompiledFiletypeFilter.isValidExtension(extension, this);
        }

        @Override
        public Pattern compiledAllPattern() {
            if (allPattern == null) {
                allPattern = CompiledFiletypeFilter.compileAllPattern(DocumentExtensions.values());
            }
            return allPattern;
        }

        @Override
        public boolean isSameExtensionGroup(ExtensionsFilterInterface extension) {
            return extension != null && extension instanceof DocumentExtensions;
        }

        @Override
        public ExtensionsFilterInterface[] listSameGroup() {
            return DocumentExtensions.values();
        }

        @Override
        public int matchesMimeType(String mimeType) {
            return 0;
        }

        @Override
        public String getExtensionFromMimeType(String mimeType) {
            return CompiledFiletypeFilter.getExtensionFromMimeType(mimeType, this);
        }

        @Override
        public boolean matchesMagic(InputStream inputStream) throws IOException {
            return false;
        }
    }

    public static enum SubtitleExtensions implements CompiledFiletypeExtension
    {
        SRT,
        SSF,
        SSA,
        ASS,
        IDX,
        TTXT,
        TTML,
        SMI,
        VTT,
        SUB;

        private final Pattern pattern;
        private static Pattern allPattern;

        @Override
        public Pattern getPattern() {
            return this.pattern;
        }

        @Override
        public ExtensionsFilterInterface getSource() {
            return this;
        }

        private SubtitleExtensions() {
            this.pattern = Pattern.compile(this.name(), 34);
        }

        private SubtitleExtensions(String id) {
            this.pattern = Pattern.compile(id, 34);
        }

        @Override
        public String getDesc() {
            return _GUI.T.FilterRuleDialog_createTypeFilter_mime_subtitle();
        }

        @Override
        public String getIconID() {
            return "language";
        }

        @Override
        public Pattern compiledAllPattern() {
            if (allPattern == null) {
                allPattern = CompiledFiletypeFilter.compileAllPattern(SubtitleExtensions.values());
            }
            return allPattern;
        }

        @Override
        public boolean isValidExtension(String extension) {
            return CompiledFiletypeFilter.isValidExtension(extension, this);
        }

        @Override
        public boolean isSameExtensionGroup(ExtensionsFilterInterface extension) {
            return extension != null && extension instanceof SubtitleExtensions;
        }

        @Override
        public ExtensionsFilterInterface[] listSameGroup() {
            return SubtitleExtensions.values();
        }

        @Override
        public int matchesMimeType(String mimeType) {
            return 0;
        }

        @Override
        public String getExtensionFromMimeType(String mimeType) {
            return CompiledFiletypeFilter.getExtensionFromMimeType(mimeType, this);
        }

        @Override
        public boolean matchesMagic(InputStream inputStream) throws IOException {
            return false;
        }
    }

    public static enum ExecutableExtensions implements CompiledFiletypeExtension
    {
        BAT,
        EXE,
        MSI,
        JAR,
        VBS,
        APK,
        APP,
        BIN,
        RUN,
        PS1,
        CMD;

        private final Pattern pattern;
        private static Pattern allPattern;

        @Override
        public Pattern getPattern() {
            return this.pattern;
        }

        @Override
        public ExtensionsFilterInterface getSource() {
            return this;
        }

        private ExecutableExtensions() {
            this.pattern = Pattern.compile(this.name(), 34);
        }

        private ExecutableExtensions(String id) {
            this.pattern = Pattern.compile(id, 34);
        }

        @Override
        public String getDesc() {
            return _GUI.T.FilterRuleDialog_createTypeFilter_mime_executable();
        }

        @Override
        public String getIconID() {
            return "desktop";
        }

        @Override
        public Pattern compiledAllPattern() {
            if (allPattern == null) {
                allPattern = CompiledFiletypeFilter.compileAllPattern(ExecutableExtensions.values());
            }
            return allPattern;
        }

        @Override
        public boolean isSameExtensionGroup(ExtensionsFilterInterface extension) {
            return extension != null && extension instanceof ExecutableExtensions;
        }

        @Override
        public boolean isValidExtension(String extension) {
            return CompiledFiletypeFilter.isValidExtension(extension, this);
        }

        @Override
        public ExtensionsFilterInterface[] listSameGroup() {
            return ExecutableExtensions.values();
        }

        @Override
        public int matchesMimeType(String mimeType) {
            return 0;
        }

        @Override
        public String getExtensionFromMimeType(String mimeType) {
            return CompiledFiletypeFilter.getExtensionFromMimeType(mimeType, this);
        }

        @Override
        public boolean matchesMagic(InputStream inputStream) throws IOException {
            return false;
        }
    }

    public static enum HashExtensions implements CompiledFiletypeExtension
    {
        SFV,
        MD5,
        SHA,
        SHA256,
        SHA512,
        PAR2("(vol\\d+\\.par2|vol\\d+\\+\\d+\\.par2|par2)"),
        PAR("(p\\d+|par)");

        private final Pattern pattern;
        private static Pattern allPattern;

        @Override
        public Pattern getPattern() {
            return this.pattern;
        }

        @Override
        public ExtensionsFilterInterface getSource() {
            return this;
        }

        private HashExtensions() {
            this.pattern = Pattern.compile(this.name(), 34);
        }

        private HashExtensions(String id) {
            this.pattern = Pattern.compile(id, 34);
        }

        @Override
        public String getDesc() {
            return _GUI.T.FilterRuleDialog_createTypeFilter_mime_checksums();
        }

        @Override
        public String getIconID() {
            return "hashsum";
        }

        @Override
        public boolean isValidExtension(String extension) {
            return CompiledFiletypeFilter.isValidExtension(extension, this);
        }

        @Override
        public Pattern compiledAllPattern() {
            if (allPattern == null) {
                allPattern = CompiledFiletypeFilter.compileAllPattern(HashExtensions.values());
            }
            return allPattern;
        }

        @Override
        public boolean isSameExtensionGroup(ExtensionsFilterInterface extension) {
            return extension != null && extension instanceof HashExtensions;
        }

        @Override
        public ExtensionsFilterInterface[] listSameGroup() {
            return HashExtensions.values();
        }

        @Override
        public int matchesMimeType(String mimeType) {
            return 0;
        }

        @Override
        public String getExtensionFromMimeType(String mimeType) {
            return CompiledFiletypeFilter.getExtensionFromMimeType(mimeType, this);
        }

        @Override
        public boolean matchesMagic(InputStream inputStream) throws IOException {
            return false;
        }
    }

    public static interface ExtensionsFilterInterface {
        public Pattern compiledAllPattern();

        public String getDesc();

        public String getIconID();

        public Pattern getPattern();

        public String name();

        public boolean isSameExtensionGroup(ExtensionsFilterInterface var1);

        public ExtensionsFilterInterface[] listSameGroup();

        public ExtensionsFilterInterface getSource();
    }

    public static interface CompiledFiletypeExtension
    extends ExtensionsFilterInterface {
        public int matchesMimeType(String var1);

        public String getExtensionFromMimeType(String var1);

        public boolean isValidExtension(String var1);

        @Override
        public String name();

        public boolean matchesMagic(InputStream var1) throws IOException;
    }
}

