/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.controlling.filter;

import java.util.regex.Pattern;
import org.appwork.storage.Storable;
import org.appwork.storage.StorableAllowPrivateAccessModifier;
import org.jdownloader.controlling.filter.RegexFilter;

public class CompiledRegexFilter
extends RegexFilter
implements Storable {
    private final Pattern pattern;
    private Boolean dynamicTags = null;

    @StorableAllowPrivateAccessModifier
    private CompiledRegexFilter() {
        this.pattern = null;
    }

    public CompiledRegexFilter(RegexFilter filter) {
        super(filter.enabled, filter.getMatchType(), filter.getRegex(), filter.isUseRegex());
        this.pattern = this.buildPattern();
    }

    public Pattern _getPattern() {
        return this.pattern;
    }

    protected Boolean _getDynamicTags() {
        return this.dynamicTags;
    }

    protected void _setDynamicTags(Boolean dynamicTags) {
        this.dynamicTags = dynamicTags;
    }

    public boolean matches(String string) {
        return this.matches(this._getPattern(), string);
    }

    public boolean matches(Pattern pattern, String string) {
        boolean ret;
        switch (this.getMatchType()) {
            case CONTAINS: {
                ret = pattern.matcher(string).find();
                break;
            }
            case EQUALS: {
                ret = pattern.matcher(string).matches();
                break;
            }
            case CONTAINS_NOT: {
                ret = !pattern.matcher(string).find();
                break;
            }
            case EQUALS_NOT: {
                ret = !pattern.matcher(string).matches();
                break;
            }
            default: {
                ret = false;
            }
        }
        return ret;
    }
}

