/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.controlling.filter;

import java.util.ArrayList;
import jd.controlling.linkcrawler.CrawledLink;
import jd.gui.swing.jdgui.views.settings.panels.linkgrabberfilter.editdialog.ConditionFilter;
import jd.gui.swing.jdgui.views.settings.panels.linkgrabberfilter.editdialog.OnlineStatusFilter;
import jd.gui.swing.jdgui.views.settings.panels.linkgrabberfilter.editdialog.OriginFilter;
import jd.gui.swing.jdgui.views.settings.panels.linkgrabberfilter.editdialog.PluginStatusFilter;
import org.appwork.storage.Storable;
import org.appwork.utils.Files;
import org.appwork.utils.formatter.SizeFormatter;
import org.jdownloader.controlling.filter.BooleanFilter;
import org.jdownloader.controlling.filter.FilesizeFilter;
import org.jdownloader.controlling.filter.FiletypeFilter;
import org.jdownloader.controlling.filter.RegexFilter;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.myjdownloader.client.json.AbstractJsonData;

public abstract class FilterRule
extends AbstractJsonData
implements Storable {
    private FilesizeFilter filesizeFilter;
    private RegexFilter hosterURLFilter;
    private RegexFilter sourceURLFilter;
    private OnlineStatusFilter onlineStatusFilter;
    private OriginFilter originFilter;
    private ConditionFilter conditionFilter;
    private boolean broken = false;
    private BooleanFilter matchesAlwaysFilter;
    private String iconKey;
    private String testUrl;
    private long created = System.currentTimeMillis();
    private PluginStatusFilter pluginStatusFilter;
    private String id;
    private boolean staticRule = false;
    private FiletypeFilter filetypeFilter;
    private RegexFilter filenameFilter;
    private RegexFilter packagenameFilter;
    private boolean enabled;
    private String name;

    public ConditionFilter getConditionFilter() {
        if (this.conditionFilter == null) {
            return new ConditionFilter();
        }
        return this.conditionFilter;
    }

    public boolean _isBroken() {
        return this.broken;
    }

    public void _setBroken(boolean broken) {
        this.broken = broken;
    }

    public void setConditionFilter(ConditionFilter conditionFilter) {
        this.conditionFilter = conditionFilter;
    }

    public OriginFilter getOriginFilter() {
        if (this.originFilter == null) {
            this.originFilter = new OriginFilter();
        }
        return this.originFilter;
    }

    public void setOriginFilter(OriginFilter originFilter) {
        this.originFilter = originFilter;
    }

    public long getCreated() {
        return this.created;
    }

    public void setCreated(long created) {
        this.created = created;
    }

    public String getTestUrl() {
        return this.testUrl;
    }

    public void setTestUrl(String testUrl) {
        this.testUrl = testUrl;
    }

    public String getIconKey() {
        return this.iconKey;
    }

    public void setIconKey(String iconKey) {
        this.iconKey = iconKey;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public boolean isStaticRule() {
        return this.staticRule;
    }

    public void setStaticRule(boolean removeAllowed) {
        this.staticRule = removeAllowed;
    }

    public BooleanFilter getMatchAlwaysFilter() {
        if (this.matchesAlwaysFilter == null) {
            this.matchesAlwaysFilter = new BooleanFilter(false);
        }
        return this.matchesAlwaysFilter;
    }

    public void setMatchAlwaysFilter(BooleanFilter match) {
        this.matchesAlwaysFilter = match;
    }

    public FilesizeFilter getFilesizeFilter() {
        if (this.filesizeFilter == null) {
            this.filesizeFilter = new FilesizeFilter();
        }
        return this.filesizeFilter;
    }

    public void setFilesizeFilter(FilesizeFilter size) {
        this.filesizeFilter = size;
    }

    public boolean _isValid() {
        return this.getPackagenameFilter().isEnabled() || this.getMatchAlwaysFilter().isEnabled() || this.getFilenameFilter().isEnabled() || this.getFilesizeFilter().isEnabled() || this.getFiletypeFilter().isEnabled() || this.getHosterURLFilter().isEnabled() || this.getSourceURLFilter().isEnabled() || this.getOriginFilter().isEnabled() || this.getConditionFilter().isEnabled() || this.getOnlineStatusFilter().isEnabled() || this.getPluginStatusFilter().isEnabled();
    }

    public String toString(CrawledLink link) {
        StringBuilder sb = new StringBuilder();
        ArrayList<String> cond = new ArrayList<String>();
        if (this.getMatchAlwaysFilter().isEnabled()) {
            cond.add(this.getMatchAlwaysFilter().toString());
        } else {
            if (this.getOnlineStatusFilter().isEnabled()) {
                cond.add(this.onlineStatusFilter.toString());
            }
            if (this.getOriginFilter().isEnabled()) {
                cond.add(this.originFilter.toString());
            }
            if (this.getConditionFilter().isEnabled()) {
                cond.add(this.conditionFilter.toString());
            }
            if (this.getPluginStatusFilter().isEnabled()) {
                cond.add(this.pluginStatusFilter.toString());
            }
            if (this.getFilenameFilter().isEnabled()) {
                if (link != null && link.getName() != null) {
                    cond.add(_GUI.T.FilterRule_toString_name2(link.getName(), this.filenameFilter.toString()));
                } else {
                    cond.add(_GUI.T.FilterRule_toString_name(this.filenameFilter.toString()));
                }
            }
            if (this.getPackagenameFilter().isEnabled()) {
                if (link != null && link.getParentNode() != null && link.getParentNode().getName() != null) {
                    cond.add(_GUI.T.FilterRule_toString_package2(link.getParentNode().getName(), this.packagenameFilter.toString()));
                } else {
                    cond.add(_GUI.T.FilterRule_toString_packagename(this.packagenameFilter.toString()));
                }
            }
            if (this.getFilesizeFilter().isEnabled()) {
                if (link != null && link.getSize() > 0L) {
                    cond.add(_GUI.T.FilterRule_toString_size2(SizeFormatter.formatBytes((long)link.getSize()), this.filesizeFilter.toString()));
                } else {
                    cond.add(_GUI.T.FilterRule_toString_size(this.filesizeFilter.toString()));
                }
            }
            if (this.getFiletypeFilter().isEnabled()) {
                if (link != null && link.getName() != null && Files.getExtension((String)link.getName()) != null) {
                    String ext = Files.getExtension((String)link.getName());
                    cond.add(_GUI.T.FilterRule_toString_type2(ext, this.filetypeFilter.toString()));
                } else {
                    cond.add(_GUI.T.FilterRule_toString_type(this.filetypeFilter.toString()));
                }
            }
            if (this.getHosterURLFilter().isEnabled()) {
                if (link != null) {
                    cond.add(_GUI.T.FilterRule_toString_hoster2(link.getURL(), this.hosterURLFilter.toString()));
                } else {
                    cond.add(_GUI.T.FilterRule_toString_hoster(this.hosterURLFilter.toString()));
                }
            }
            if (this.getSourceURLFilter().isEnabled()) {
                cond.add(_GUI.T.FilterRule_toString_source(this.sourceURLFilter.toString()));
            }
        }
        for (int i = 0; i < cond.size(); ++i) {
            if (i > 0) {
                if (i < cond.size() - 1) {
                    sb.append(_GUI.T.FilterRule_toString_comma3((String)cond.get(i)));
                    continue;
                }
                sb.append(" " + _GUI.T.FilterRule_toString_and2((String)cond.get(i)).trim());
                continue;
            }
            sb.append((String)cond.get(i));
        }
        return sb.toString();
    }

    public String toString() {
        return this.toString(null);
    }

    public RegexFilter getHosterURLFilter() {
        if (this.hosterURLFilter == null) {
            this.hosterURLFilter = new RegexFilter();
        }
        return this.hosterURLFilter;
    }

    public void setHosterURLFilter(RegexFilter hoster) {
        this.hosterURLFilter = hoster;
    }

    public RegexFilter getSourceURLFilter() {
        if (this.sourceURLFilter == null) {
            this.sourceURLFilter = new RegexFilter();
        }
        return this.sourceURLFilter;
    }

    public void setSourceURLFilter(RegexFilter source) {
        this.sourceURLFilter = source;
    }

    public FiletypeFilter getFiletypeFilter() {
        if (this.filetypeFilter == null) {
            this.filetypeFilter = new FiletypeFilter();
        }
        return this.filetypeFilter;
    }

    public void setFiletypeFilter(FiletypeFilter type) {
        this.filetypeFilter = type;
    }

    public void setOnlineStatusFilter(OnlineStatusFilter onlineStatusFilter) {
        this.onlineStatusFilter = onlineStatusFilter;
    }

    public OnlineStatusFilter getOnlineStatusFilter() {
        if (this.onlineStatusFilter == null) {
            this.onlineStatusFilter = new OnlineStatusFilter();
        }
        return this.onlineStatusFilter;
    }

    public void setPluginStatusFilter(PluginStatusFilter pluginStatusFilter) {
        this.pluginStatusFilter = pluginStatusFilter;
    }

    public PluginStatusFilter getPluginStatusFilter() {
        if (this.pluginStatusFilter == null) {
            this.pluginStatusFilter = new PluginStatusFilter();
        }
        return this.pluginStatusFilter;
    }

    public RegexFilter getFilenameFilter() {
        if (this.filenameFilter == null) {
            this.filenameFilter = new RegexFilter();
        }
        return this.filenameFilter;
    }

    public void setFilenameFilter(RegexFilter filename) {
        this.filenameFilter = filename;
    }

    public RegexFilter getPackagenameFilter() {
        if (this.packagenameFilter == null) {
            this.packagenameFilter = new RegexFilter();
        }
        return this.packagenameFilter;
    }

    public void setPackagenameFilter(RegexFilter packagenameFilter) {
        this.packagenameFilter = packagenameFilter;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isEnabled() {
        return this.enabled && this._isValid();
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

