/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.controlling.filter;

import java.util.regex.Pattern;
import org.appwork.storage.Storable;
import org.jdownloader.controlling.filter.Filter;
import org.jdownloader.controlling.filter.LinkgrabberFilterRuleWrapper;
import org.jdownloader.controlling.filter.RuleWrapper;
import org.jdownloader.gui.translate._GUI;

public class RegexFilter
extends Filter
implements Storable {
    private MatchType matchType = MatchType.CONTAINS;
    private String regex;
    private boolean useRegex;

    public RegexFilter() {
    }

    public String toString() {
        switch (this.getMatchType()) {
            case CONTAINS: {
                return _GUI.T.RegexFilter_toString_contains(this.regex);
            }
            case CONTAINS_NOT: {
                return _GUI.T.RegexFilter_toString_contains_not(this.regex);
            }
            case EQUALS: {
                return _GUI.T.RegexFilter_toString_matches(this.regex);
            }
        }
        return _GUI.T.RegexFilter_toString_matches_not(this.regex);
    }

    public MatchType getMatchType() {
        return this.matchType;
    }

    public void setMatchType(MatchType matchType) {
        this.matchType = matchType;
    }

    public String getRegex() {
        return this.regex;
    }

    public void setRegex(String regex) {
        this.regex = regex;
    }

    public RegexFilter(boolean enabled, MatchType matchType, String text, boolean regex2) {
        this.enabled = enabled;
        this.matchType = matchType;
        this.regex = text;
        this.useRegex = regex2;
    }

    public boolean isUseRegex() {
        return this.useRegex;
    }

    public void setUseRegex(boolean useRegex) {
        this.useRegex = useRegex;
    }

    public Pattern buildPattern() {
        return this.buildPattern(this.getRegex());
    }

    public Pattern buildPattern(String regex) {
        switch (this.getMatchType()) {
            case CONTAINS: 
            case CONTAINS_NOT: {
                return LinkgrabberFilterRuleWrapper.createPattern(regex, this.isUseRegex(), RuleWrapper.AUTO_PATTERN_MODE.FINDS);
            }
            case EQUALS: 
            case EQUALS_NOT: {
                return LinkgrabberFilterRuleWrapper.createPattern(regex, this.isUseRegex(), RuleWrapper.AUTO_PATTERN_MODE.MATCHES);
            }
        }
        return LinkgrabberFilterRuleWrapper.createPattern(regex, this.isUseRegex(), RuleWrapper.AUTO_PATTERN_MODE.WILDCARD);
    }

    public int calcPlaceholderCount() {
        if (this.isEnabled()) {
            try {
                return this.buildPattern().matcher("").groupCount();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return 0;
    }

    public static enum MatchType {
        CONTAINS,
        EQUALS,
        CONTAINS_NOT,
        EQUALS_NOT;

    }
}

