/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.controlling.hosterrule;

import java.util.ArrayList;
import java.util.List;
import jd.plugins.Account;
import org.appwork.storage.Storable;
import org.appwork.storage.StorableAllowPrivateAccessModifier;
import org.jdownloader.controlling.hosterrule.AccountGroup;
import org.jdownloader.controlling.hosterrule.AccountReference;
import org.jdownloader.controlling.hosterrule.AccountReferenceStorable;

public class AccountGroupStorable
implements Storable {
    private ArrayList<AccountReferenceStorable> children;
    private AccountGroup.Rules rule = AccountGroup.Rules.RANDOM;
    private String name;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getRule() {
        return this.rule.name();
    }

    public void setRule(String rule) {
        try {
            this.rule = AccountGroup.Rules.valueOf(rule);
        }
        catch (Throwable e) {
            this.rule = AccountGroup.Rules.ORDER;
        }
    }

    @StorableAllowPrivateAccessModifier
    private AccountGroupStorable() {
    }

    public AccountGroupStorable(AccountGroup ag) {
        this.rule = ag.getRule();
        this.children = new ArrayList();
        this.name = ag.getName();
        for (AccountReference acc : ag.getChildren()) {
            this.children.add(new AccountReferenceStorable(acc));
        }
    }

    public ArrayList<AccountReferenceStorable> getChildren() {
        return this.children;
    }

    public void setChildren(ArrayList<AccountReferenceStorable> children) {
        this.children = children;
    }

    public AccountGroup restore(String hoster, List<Account> availableAccounts) {
        if (availableAccounts == null) {
            return null;
        }
        ArrayList<AccountReference> childsP = new ArrayList<AccountReference>(this.children.size());
        block0: for (AccountReferenceStorable ars : this.children) {
            AccountReference restored = ars.restore(hoster, availableAccounts);
            if (restored == null) continue;
            for (AccountReference child : childsP) {
                if (child.getID() != restored.getID()) continue;
                continue block0;
            }
            childsP.add(restored);
        }
        if (childsP.size() == 0) {
            return null;
        }
        AccountGroup ret = new AccountGroup(childsP);
        ret.setRule(this.rule);
        ret.setName(this.getName());
        return ret;
    }
}

