/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.controlling.hosterrule;

import java.util.List;
import jd.plugins.Account;
import org.appwork.storage.Storable;
import org.appwork.storage.StorableAllowPrivateAccessModifier;
import org.appwork.utils.StringUtils;
import org.appwork.utils.UniqueAlltimeID;
import org.jdownloader.controlling.hosterrule.AccountReference;
import org.jdownloader.controlling.hosterrule.FreeAccountReference;

public class AccountReferenceStorable
implements Storable {
    private long id = -1L;
    private String ref = null;
    private long refId = UniqueAlltimeID.next();
    private boolean enabled = false;

    public long getRefId() {
        return this.refId;
    }

    public void setRefId(long refId) {
        this.refId = refId;
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @StorableAllowPrivateAccessModifier
    private AccountReferenceStorable() {
    }

    public AccountReferenceStorable(AccountReference acc) {
        this.id = acc.getID();
        this.ref = acc.getRef(this.getRefId());
        this.enabled = acc.isEnabled();
    }

    public AccountReference restore(String hoster, List<Account> availableAccounts) {
        AccountReference ret = null;
        if (this.getId() == 0L) {
            ret = new FreeAccountReference(hoster);
        } else if (availableAccounts != null) {
            for (Account acc : availableAccounts) {
                if (acc.getId().getID() != this.getId()) continue;
                ret = new AccountReference(acc);
                break;
            }
            if (ret == null && this.getRef() != null) {
                for (Account acc : availableAccounts) {
                    AccountReference accountReference = new AccountReference(acc);
                    if (!StringUtils.equals((String)this.getRef(), (String)accountReference.getRef(this.getRefId()))) continue;
                    ret = accountReference;
                    break;
                }
            }
        }
        if (ret != null) {
            ret.setEnabled(this.isEnabled());
            return ret;
        }
        return null;
    }
}

