/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.crosssystem.windows;

import com.sun.jna.Function;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Guid;
import com.sun.jna.platform.win32.Ole32;
import com.sun.jna.platform.win32.Ole32Util;
import com.sun.jna.platform.win32.User32;
import com.sun.jna.platform.win32.W32Errors;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.PointerByReference;
import com.sun.jna.win32.StdCallLibrary;
import com.sun.jna.win32.W32APIOptions;
import java.awt.Component;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import javax.swing.JFrame;
import org.appwork.utils.logging2.LogInterface;
import org.appwork.utils.logging2.extmanager.Log;
import org.jdownloader.crosssystem.windows.apache.sanselan.BinaryOutputStream;
import org.jdownloader.crosssystem.windows.apache.sanselan.ImageWriteException;

public class Win7TaskBar {
    private static final LogInterface LOG = Log.DF;
    private static final int TaskBarList_Methods = 21;
    private static final int TaskBarList_SetProgressValue = 9;
    private static final int TaskBarList_SetProgressState = 10;
    private static final int TaskBarList_SetOverlayIcon = 18;
    private static final WinDef.DWORD ICO_VERSION = new WinDef.DWORD(196608L);
    private static final WinDef.DWORD DWORD_ZERO;
    private static final WinDef.DWORD TBPF_NOPROGRESS;
    private static final WinDef.DWORD TBPF_NORMAL;
    private static final WinDef.DWORD TBPF_ERROR;
    private static final WinDef.ULONGLONG TOTAL_PROGRESS;
    private static Pointer myInterfacePointer;
    private static Function mySetProgressValue;
    private static Function mySetProgressState;
    private static Function mySetOverlayIcon;
    private static final boolean initialized;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeTransparentIcoImageWithSanselan(BufferedImage src, OutputStream os) throws ImageWriteException, IOException {
        boolean assertt = 2 == src.getType() || 6 == src.getType();
        int bitCount = 32;
        BinaryOutputStream bos = new BinaryOutputStream(os, 73);
        try {
            int t_scanline_size;
            int scanline_size = (bitCount * src.getWidth() + 7) / 8;
            if (scanline_size % 4 != 0) {
                scanline_size += 4 - scanline_size % 4;
            }
            if ((t_scanline_size = (src.getWidth() + 7) / 8) % 4 != 0) {
                t_scanline_size += 4 - t_scanline_size % 4;
            }
            int imageSize = 40 + src.getHeight() * scanline_size + src.getHeight() * t_scanline_size;
            bos.write2Bytes(0);
            bos.write2Bytes(1);
            bos.write2Bytes(1);
            int iconDirEntryWidth = src.getWidth();
            int iconDirEntryHeight = src.getHeight();
            if (iconDirEntryWidth > 255 || iconDirEntryHeight > 255) {
                iconDirEntryWidth = 0;
                iconDirEntryHeight = 0;
            }
            bos.write(iconDirEntryWidth);
            bos.write(iconDirEntryHeight);
            bos.write(0);
            bos.write(0);
            bos.write2Bytes(1);
            bos.write2Bytes(bitCount);
            bos.write4Bytes(imageSize);
            bos.write4Bytes(22);
            bos.write4Bytes(40);
            bos.write4Bytes(src.getWidth());
            bos.write4Bytes(2 * src.getHeight());
            bos.write2Bytes(1);
            bos.write2Bytes(bitCount);
            bos.write4Bytes(0);
            bos.write4Bytes(0);
            bos.write4Bytes(0);
            bos.write4Bytes(0);
            bos.write4Bytes(0);
            bos.write4Bytes(0);
            int bit_cache = 0;
            int bits_in_cache = 0;
            int row_padding = scanline_size - (bitCount * src.getWidth() + 7) / 8;
            for (int y = src.getHeight() - 1; y >= 0; --y) {
                int x;
                for (x = 0; x < src.getWidth(); ++x) {
                    int argb = src.getRGB(x, y);
                    bos.write(0xFF & argb);
                    bos.write(0xFF & argb >> 8);
                    bos.write(0xFF & argb >> 16);
                    bos.write(0xFF & argb >> 24);
                }
                for (x = 0; x < row_padding; ++x) {
                    bos.write(0);
                }
            }
            int t_row_padding = t_scanline_size - (src.getWidth() + 7) / 8;
            for (int y = src.getHeight() - 1; y >= 0; --y) {
                int x;
                for (x = 0; x < src.getWidth(); ++x) {
                    int argb = src.getRGB(x, y);
                    int alpha = 0xFF & argb >> 24;
                    bit_cache <<= 1;
                    if (alpha == 0) {
                        bit_cache |= 1;
                    }
                    if (++bits_in_cache < 8) continue;
                    bos.write(0xFF & bit_cache);
                    bit_cache = 0;
                    bits_in_cache = 0;
                }
                if (bits_in_cache > 0) {
                    bos.write(0xFF & (bit_cache <<= 8 - bits_in_cache));
                    bit_cache = 0;
                    bits_in_cache = 0;
                }
                for (x = 0; x < t_row_padding; ++x) {
                    bos.write(0);
                }
            }
        }
        finally {
            try {
                bos.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static boolean initialize() {
        try {
            Ole32 ole32 = Ole32.INSTANCE;
            ole32.CoInitializeEx(Pointer.NULL, 0);
            Guid.GUID CLSID_TaskbarList = Ole32Util.getGUIDFromString((String)"{56FDF344-FD6D-11d0-958A-006097C9A090}");
            Guid.GUID IID_ITaskbarList3 = Ole32Util.getGUIDFromString((String)"{EA1AFB91-9E28-4B86-90E9-9E9F8A5EEFAF}");
            PointerByReference p = new PointerByReference();
            WinNT.HRESULT hr = ole32.CoCreateInstance(CLSID_TaskbarList, Pointer.NULL, 23, IID_ITaskbarList3, p);
            if (!W32Errors.S_OK.equals((Object)hr)) {
                LOG.info("Win7TaskBar CoCreateInstance(IID_ITaskbarList3) hResult: " + hr);
                return false;
            }
            myInterfacePointer = p.getValue();
            Pointer vTablePointer = myInterfacePointer.getPointer(0L);
            Pointer[] vTable = new Pointer[21];
            vTablePointer.read(0L, vTable, 0, vTable.length);
            mySetProgressValue = Function.getFunction((Pointer)vTable[9], (int)63);
            mySetProgressState = Function.getFunction((Pointer)vTable[10], (int)63);
            mySetOverlayIcon = Function.getFunction((Pointer)vTable[18], (int)63);
            return true;
        }
        catch (Throwable e) {
            LOG.log(e);
            return false;
        }
    }

    public static void setProgress(JFrame frame, double value, boolean isOk) {
        WinDef.HWND handle;
        if (Win7TaskBar.isEnabled() && (handle = Win7TaskBar.getHandle(frame)) != null) {
            mySetProgressState.invokeInt(new Object[]{myInterfacePointer, handle, isOk ? TBPF_NORMAL : TBPF_ERROR});
            mySetProgressValue.invokeInt(new Object[]{myInterfacePointer, handle, new WinDef.ULONGLONG((long)(value * 100.0)), TOTAL_PROGRESS});
        }
    }

    private static boolean isEnabled() {
        return initialized;
    }

    public static void hideProgress(JFrame frame) {
        WinDef.HWND handle;
        if (Win7TaskBar.isEnabled() && (handle = Win7TaskBar.getHandle(frame)) != null) {
            mySetProgressState.invokeInt(new Object[]{myInterfacePointer, handle, TBPF_NOPROGRESS});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setOverlayIcon(JFrame frame, Object icon, boolean dispose) {
        if (Win7TaskBar.isEnabled()) {
            if (icon == null) {
                icon = Pointer.NULL;
            }
            WinDef.HWND handle = Win7TaskBar.getHandle(frame);
            try {
                if (handle != null) {
                    mySetOverlayIcon.invokeInt(new Object[]{myInterfacePointer, handle, icon, Pointer.NULL});
                }
            }
            finally {
                if (dispose) {
                    User32.INSTANCE.DestroyIcon((WinDef.HICON)icon);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object createIcon(byte[] ico) {
        if (!Win7TaskBar.isEnabled()) {
            return new Object();
        }
        MyMemory memory = new MyMemory(ico.length);
        try {
            memory.write(0L, ico, 0, ico.length);
            int nSize = 100;
            int offset = User32Ex.INSTANCE.LookupIconIdFromDirectoryEx(memory, true, nSize, nSize, 0);
            if (offset != 0) {
                WinDef.HICON hICON = User32Ex.INSTANCE.CreateIconFromResourceEx(memory.share(offset), DWORD_ZERO, true, ICO_VERSION, nSize, nSize, 0);
                return hICON;
            }
            Object var4_5 = null;
            return var4_5;
        }
        finally {
            memory.dispose();
        }
    }

    public static void attention(JFrame frame, boolean critical) {
        WinDef.HWND handle;
        if (Win7TaskBar.isEnabled() && (handle = Win7TaskBar.getHandle(frame)) != null) {
            User32Ex.INSTANCE.FlashWindow(handle, true);
        }
    }

    private static WinDef.HWND getHandle(JFrame frame) {
        try {
            WinDef.HWND hwnd = frame != null ? new WinDef.HWND(Native.getComponentPointer((Component)frame)) : null;
            return hwnd;
        }
        catch (Throwable e) {
            LOG.log(e);
            return null;
        }
    }

    static {
        TBPF_NOPROGRESS = DWORD_ZERO = new WinDef.DWORD(0L);
        TBPF_NORMAL = new WinDef.DWORD(2L);
        TBPF_ERROR = new WinDef.DWORD(4L);
        TOTAL_PROGRESS = new WinDef.ULONGLONG(100L);
        initialized = Win7TaskBar.initialize();
    }

    private static class MyMemory
    extends Memory {
        private MyMemory(long size) {
            super(size);
        }

        public synchronized void dispose() {
            super.dispose();
        }
    }

    public static interface User32Ex
    extends StdCallLibrary {
        public static final User32Ex INSTANCE = (User32Ex)Native.load((String)"user32", User32Ex.class, (Map)W32APIOptions.DEFAULT_OPTIONS);

        public int LookupIconIdFromDirectoryEx(Memory var1, boolean var2, int var3, int var4, int var5);

        public WinDef.HICON CreateIconFromResourceEx(Pointer var1, WinDef.DWORD var2, boolean var3, WinDef.DWORD var4, int var5, int var6, int var7);

        public boolean FlashWindow(WinDef.HWND var1, boolean var2);
    }
}

