/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.crosssystem.windows;

import java.awt.BasicStroke;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.util.EventListener;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JFrame;
import jd.SecondLevelLaunch;
import jd.controlling.downloadcontroller.DownloadController;
import jd.controlling.downloadcontroller.DownloadLinkCandidate;
import jd.controlling.downloadcontroller.DownloadLinkCandidateResult;
import jd.controlling.downloadcontroller.DownloadWatchDog;
import jd.controlling.downloadcontroller.DownloadWatchDogProperty;
import jd.controlling.downloadcontroller.SingleDownloadController;
import jd.controlling.downloadcontroller.event.DownloadWatchdogListener;
import jd.gui.swing.jdgui.JDGui;
import jd.gui.swing.jdgui.JDownloaderMainFrame;
import org.appwork.storage.config.ValidationException;
import org.appwork.storage.config.events.GenericConfigEventListener;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.utils.ImageProvider.ImageProvider;
import org.appwork.utils.logging2.extmanager.Log;
import org.appwork.utils.os.CrossSystem;
import org.jdownloader.controlling.AggregatedNumbers;
import org.jdownloader.crosssystem.windows.Win7TaskBar;
import org.jdownloader.settings.GraphicalUserInterfaceSettings;
import org.jdownloader.settings.staticreferences.CFG_GUI;

public class WindowsApplicationAdapter {
    private static final WindowsApplicationAdapter INSTANCE = new WindowsApplicationAdapter();
    private final AtomicReference<Thread> thread = new AtomicReference<Object>(null);

    public static WindowsApplicationAdapter getInstance() {
        return INSTANCE;
    }

    private WindowsApplicationAdapter() {
        this.initWin7PlusTaskbarExtension();
    }

    private void initWin7PlusTaskbarExtension() {
        if (CrossSystem.getOS().isMinimum(CrossSystem.OperatingSystem.WINDOWS_7)) {
            SecondLevelLaunch.INIT_COMPLETE.executeWhenReached(new Runnable(){

                @Override
                public void run() {
                    CFG_GUI.WINDOWS_TASKBAR_PROGRESS_DISPLAY.getEventSender().addListener((EventListener)new GenericConfigEventListener<Enum>(){

                        public void onConfigValidatorError(KeyHandler<Enum> keyHandler, Enum invalidValue, ValidationException validateException) {
                        }

                        public void onConfigValueModified(KeyHandler<Enum> keyHandler, Enum newValue) {
                            if (GraphicalUserInterfaceSettings.WindowsTaskBarProgressDisplay.NOTHING.equals(newValue)) {
                                WindowsApplicationAdapter.this.stopDockUpdater();
                            } else {
                                WindowsApplicationAdapter.this.startDockUpdater();
                            }
                        }
                    });
                    DownloadWatchdogListener listener = new DownloadWatchdogListener(){

                        @Override
                        public void onDownloadWatchdogStateIsStopping() {
                        }

                        @Override
                        public void onDownloadWatchdogStateIsStopped() {
                        }

                        @Override
                        public void onDownloadWatchdogStateIsRunning() {
                            WindowsApplicationAdapter.this.startDockUpdater();
                        }

                        @Override
                        public void onDownloadWatchdogStateIsPause() {
                            WindowsApplicationAdapter.this.startDockUpdater();
                        }

                        @Override
                        public void onDownloadWatchdogStateIsIdle() {
                        }

                        @Override
                        public void onDownloadWatchdogDataUpdate() {
                        }

                        @Override
                        public void onDownloadControllerStart(SingleDownloadController downloadController, DownloadLinkCandidate candidate) {
                        }

                        @Override
                        public void onDownloadControllerStopped(SingleDownloadController downloadController, DownloadLinkCandidate candidate, DownloadLinkCandidateResult result) {
                        }

                        @Override
                        public void onDownloadWatchDogPropertyChange(DownloadWatchDogProperty propertyChange) {
                        }
                    };
                    DownloadWatchDog.getInstance().getEventSender().addListener(listener);
                    DownloadWatchDog.getInstance().notifyCurrentState(listener);
                }
            });
        }
    }

    private void startDockUpdater() {
        if (CFG_GUI.CFG.getWindowsTaskbarProgressDisplay() != GraphicalUserInterfaceSettings.WindowsTaskBarProgressDisplay.NOTHING) {
            Thread thread = new Thread("WindowsTaskbarProgress"){
                {
                    this.setDaemon(true);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    double lastPercent = -1.0;
                    try {
                        JDownloaderMainFrame mainFrame = JDGui.getInstance().getMainFrame();
                        while (WindowsApplicationAdapter.this.thread.get() == Thread.currentThread() && DownloadWatchDog.getInstance().isRunning()) {
                            double percent;
                            AggregatedNumbers aggn = new AggregatedNumbers(DownloadController.getInstance().getSelectionInfo());
                            long totalBytes = aggn.getEnabledUnfinishedTotalBytes();
                            if (totalBytes > 0L) {
                                long loadedBytes = Math.max(0L, aggn.getEnabledUnfinishedLoadedBytes());
                                percent = (double)loadedBytes / (double)totalBytes;
                            } else {
                                percent = 0.0;
                            }
                            if (lastPercent != percent) {
                                lastPercent = percent;
                                if (CFG_GUI.CFG.getWindowsTaskbarProgressDisplay() == GraphicalUserInterfaceSettings.WindowsTaskBarProgressDisplay.TOTAL_PROGRESS_AND_CONNECTIONS) {
                                    BufferedImage image = WindowsApplicationAdapter.this.createImage(DownloadWatchDog.getInstance().getActiveDownloads());
                                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                                    Win7TaskBar.writeTransparentIcoImageWithSanselan(image, baos);
                                    Object icon = Win7TaskBar.createIcon(baos.toByteArray());
                                    if (icon != null) {
                                        Win7TaskBar.setOverlayIcon((JFrame)mainFrame, icon, true);
                                    }
                                }
                                Win7TaskBar.setProgress((JFrame)mainFrame, lastPercent, true);
                            }
                            Thread.sleep(1000L);
                        }
                    }
                    catch (Throwable er) {
                        Log.log((Throwable)er);
                    }
                    finally {
                        if (WindowsApplicationAdapter.this.thread.compareAndSet(Thread.currentThread(), null)) {
                            WindowsApplicationAdapter.this.reset();
                        }
                    }
                }
            };
            this.thread.set(thread);
            thread.start();
        }
    }

    protected BufferedImage createImage(int speed) {
        int stringwidth;
        String speedString = Integer.toString(speed);
        Color fg = Color.WHITE;
        Color bg = Color.GREEN.darker();
        Font font = new Font(ImageProvider.getDrawFontName(), 1, 24);
        Canvas c = new Canvas();
        FontMetrics fm = c.getFontMetrics(font);
        int w = stringwidth = Math.max(fm.getAscent(), fm.stringWidth(speedString)) + 6;
        int h = stringwidth;
        BufferedImage image = new BufferedImage(w, h, 2);
        Graphics2D g = image.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setFont(font);
        g.setColor(bg);
        g.fillOval(0, 0, w, h);
        g.setColor(Color.WHITE);
        g.setStroke(new BasicStroke(2.0f));
        g.drawOval(0, 0, w - 1, h - 1);
        g.setColor(fg);
        Rectangle2D bounds = g.getFontMetrics().getStringBounds(speedString, g);
        g.drawString(speedString, (int)((double)w - bounds.getWidth()) / 2, (int)(-bounds.getY() + ((double)h - bounds.getHeight()) / 2.0));
        g.dispose();
        return image;
    }

    private void stopDockUpdater() {
        this.thread.set(null);
    }

    private void reset() {
        try {
            Win7TaskBar.setOverlayIcon((JFrame)JDGui.getInstance().getMainFrame(), null, true);
            Win7TaskBar.hideProgress((JFrame)JDGui.getInstance().getMainFrame());
        }
        catch (Throwable er) {
            Log.log((Throwable)er);
        }
    }
}

