/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.downloader.hds;

import java.awt.Color;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import jd.controlling.downloadcontroller.DiskSpaceReservation;
import jd.controlling.downloadcontroller.ExceptionRunnable;
import jd.controlling.downloadcontroller.FileIsLockedException;
import jd.controlling.downloadcontroller.ManagedThrottledConnectionHandler;
import jd.http.Browser;
import jd.http.URLConnectionAdapter;
import jd.plugins.DownloadLink;
import jd.plugins.PluginException;
import jd.plugins.download.DownloadInterface;
import jd.plugins.download.DownloadLinkDownloadable;
import jd.plugins.download.Downloadable;
import org.appwork.exceptions.WTFException;
import org.appwork.utils.JDK8BufferHelper;
import org.appwork.utils.Regex;
import org.appwork.utils.logging2.LogInterface;
import org.appwork.utils.logging2.LogSource;
import org.appwork.utils.net.throttledconnection.MeteredThrottledInputStream;
import org.appwork.utils.net.throttledconnection.ThrottledConnection;
import org.appwork.utils.speedmeter.AverageSpeedMeter;
import org.appwork.utils.speedmeter.SpeedMeterInterface;
import org.jdownloader.downloader.hds.F4vInputStream;
import org.jdownloader.plugins.DownloadPluginProgress;
import org.jdownloader.plugins.SkipReason;
import org.jdownloader.plugins.SkipReasonException;
import org.jdownloader.translate._JDT;

public class HDSDownloader
extends DownloadInterface {
    private static final int PACKAGE_AUDIO = 8;
    private static final int PACKAGE_VIDEO = 9;
    private static final int PACKAGE_SCRIPT = 18;
    private static final int CODEC_ID_AAC = 10;
    private static final int CODEC_ID_AVC = 7;
    private static final int AVC_SEQUENCE_HEADER = 0;
    private static final int AVC_NALU = 1;
    private static final int AVC_SEQUENCE_END = 2;
    private static final int FRAME_TYPE_INFO = 5;
    private static final int FLV_PACKET_HEADER_SIZE = 11;
    private static final byte[] FLV_HEADER = new byte[]{70, 76, 86, 1, 5, 0, 0, 0, 9, 0, 0, 0, 0};
    private DataInputStream stream;
    private boolean finished;
    private boolean aacHeaderWritten = false;
    private boolean avcHeaderWritten = false;
    private final Browser sourceBrowser;
    private final String fragmentBaseURL;
    private final AtomicInteger fragmentIndex = new AtomicInteger(1);
    private ByteBuffer buffer;
    private final AtomicLong bytesWritten = new AtomicLong(0L);
    private final DownloadLinkDownloadable downloadable;
    private long startTimeStamp = -1L;
    private final LogInterface logger;
    private URLConnectionAdapter currentConnection;
    private final ManagedThrottledConnectionHandler connectionHandler;
    private File outputCompleteFile;
    private File outputPartFile;
    private FileOutputStream outStream;
    private PluginException caughtPluginException;
    private long estimatedDurationSecs = -1L;
    private final AtomicLong lastTimeStampMs = new AtomicLong(-1L);
    private final DownloadLink link;
    public static final String RESUME_FRAGMENT = "RESUME_FRAGMENT";
    private MeteredThrottledInputStream inputStream = null;
    private final AtomicBoolean abort = new AtomicBoolean(false);
    private final AtomicBoolean terminated = new AtomicBoolean(false);

    public HDSDownloader(DownloadLink link, Browser browser, String fragmentBaseURL) {
        this.sourceBrowser = browser;
        this.fragmentBaseURL = fragmentBaseURL;
        this.connectionHandler = new ManagedThrottledConnectionHandler();
        this.link = link;
        this.downloadable = new DownloadLinkDownloadable(link);
        this.downloadable.setDownloadInterface(this);
        this.downloadable.setResumeable(true);
        this.logger = this.downloadable.getLogger();
    }

    public void setEstimatedDuration(long estimatedDurationMs) {
        this.estimatedDurationSecs = estimatedDurationMs / 1000L;
        if (this.estimatedDurationSecs <= 0L) {
            this.estimatedDurationSecs = -1L;
        }
    }

    protected void terminate() {
        if (!this.terminated.getAndSet(true) && !this.externalDownloadStop()) {
            this.logger.severe("A critical Downloaderror occured. Terminate...");
        }
    }

    public void run() throws IOException, PluginException {
        this.buffer = ByteBuffer.allocate(524288);
        try {
            String resumeInfo = this.link.getStringProperty(RESUME_FRAGMENT, null);
            if (resumeInfo != null) {
                String resumeFragment = new Regex(resumeInfo, "(\\d+):").getMatch(0);
                String resumePosition = new Regex(resumeInfo, ":(\\d+)").getMatch(0);
                if (resumeFragment != null && resumePosition != null) {
                    long position = Long.parseLong(resumePosition);
                    int fragment = Integer.parseInt(resumeFragment);
                    if (this.outputPartFile.length() >= position && position > 0L) {
                        this.outStream.getChannel().position(position);
                        this.bytesWritten.set(position);
                        this.fragmentIndex.set(fragment);
                    }
                }
            }
            if (this.bytesWritten.get() == 0L) {
                this.outStream.getChannel().position(0L);
                this.aacHeaderWritten = false;
                this.avcHeaderWritten = false;
                this.fragmentIndex.set(1);
                this.outStream.write(FLV_HEADER);
            } else {
                this.aacHeaderWritten = true;
                this.avcHeaderWritten = true;
            }
            while (true) {
                if (this.abort.get() || this.finished) {
                    return;
                }
                ByteBuffer buffertoWrite = this.readAndWrite();
                if (buffertoWrite == null) continue;
                JDK8BufferHelper.flip((Buffer)buffertoWrite);
                this.outStream.write(buffertoWrite.array(), 0, buffertoWrite.remaining());
            }
        }
        finally {
            this.closeOutputChannel();
        }
    }

    private ByteBuffer readAndWrite() throws IOException, PluginException {
        int type;
        block13: while (true) {
            if (this.abort.get()) {
                return null;
            }
            type = this.refreshFragmentStream();
            if (this.finished) {
                return null;
            }
            int reserved = (type & 0xC0) >>> 6;
            int filter = (type & 0x20) >>> 5;
            if (filter > 0) {
                throw new PluginException(2048, "Preprocessor (Encryption?) is not supported " + (type & 0x1F) + "(" + type + ")", 86400000L);
            }
            type &= 0x1F;
            JDK8BufferHelper.clear((Buffer)this.buffer);
            int dataSize = this.readInt24();
            int time = this.readInt24() | this.stream.readUnsignedByte() << 24;
            this.lastTimeStampMs.set(time);
            int streamId = this.readInt24();
            int payloadToRead = dataSize + 11;
            payloadToRead -= this.write(type);
            payloadToRead -= this.writeInt24(dataSize);
            payloadToRead -= this.writeInt24(time & 0xFFFFFF);
            payloadToRead -= this.write(time >>> 24);
            payloadToRead -= this.writeInt24(streamId);
            switch (type) {
                case 8: {
                    int frameInfo = this.stream.readUnsignedByte();
                    payloadToRead -= this.write(frameInfo);
                    int codecId = (frameInfo & 0xF0) >>> 4;
                    int soundRate = (frameInfo & 0xC) >>> 2;
                    int soundSize = (frameInfo & 2) >>> 1;
                    int SoundType = frameInfo & 1;
                    switch (codecId) {
                        case 10: {
                            int aacType = this.stream.readUnsignedByte();
                            payloadToRead -= this.write(aacType);
                            if (aacType == 0) {
                                if (this.aacHeaderWritten) {
                                    this.skipBytes(dataSize - 2 + 4);
                                    continue block13;
                                }
                                this.aacHeaderWritten = true;
                            }
                            this.handlePayload(dataSize, payloadToRead);
                            return this.buffer;
                        }
                    }
                    throw new IOException("Unsupported Audio Tag: " + codecId);
                }
                case 9: {
                    int frameInfo = this.stream.readUnsignedByte();
                    payloadToRead -= this.write(frameInfo);
                    int frameType = (frameInfo & 0xF0) >>> 4;
                    if (frameType == 5) {
                        this.skipBytes(dataSize - 1 + 4);
                        continue block13;
                    }
                    int codecId = frameInfo & 0xF;
                    switch (codecId) {
                        case 7: {
                            int avcType = this.stream.readUnsignedByte();
                            payloadToRead -= this.write(avcType);
                            if (avcType == 0) {
                                if (this.avcHeaderWritten) {
                                    this.skipBytes(dataSize - 2 + 4);
                                    continue block13;
                                }
                                this.avcHeaderWritten = true;
                            }
                            this.handlePayload(dataSize, payloadToRead);
                            return this.buffer;
                        }
                    }
                    throw new IOException("Unsupported Video Tag: " + codecId);
                }
                case 10: 
                case 11: {
                    throw new IOException("Akamai DRM not supported");
                }
                case 18: {
                    this.skipBytes(dataSize + 4);
                    continue block13;
                }
                case 40: 
                case 41: {
                    throw new IOException("FlashAccess DRM not supported");
                }
            }
            break;
        }
        throw new IOException("Unknown packet type: 0x" + Integer.toHexString(type));
    }

    public void handlePayload(int dataSize, int payloadToRead) throws IOException {
        this.ensureBufferCapacity(payloadToRead);
        this.stream.readFully(this.buffer.array(), this.buffer.position(), payloadToRead);
        JDK8BufferHelper.position((Buffer)this.buffer, (int)(this.buffer.position() + payloadToRead));
        this.skipBytes(4);
        this.writeInt32(dataSize + 11);
    }

    public void ensureBufferCapacity(int payloadToRead) {
        if (payloadToRead > this.buffer.capacity() - this.buffer.position()) {
            ByteBuffer newBuffer = ByteBuffer.allocate(this.buffer.capacity() * 2);
            JDK8BufferHelper.flip((Buffer)this.buffer);
            newBuffer.put(this.buffer);
            this.buffer = newBuffer;
        }
    }

    public int refreshFragmentStream() throws IOException, PluginException {
        int type;
        while (this.stream == null || (type = this.stream.read()) == -1) {
            InputStream stream = this.nextFragment();
            if (stream == null) {
                this.finished = true;
                return -1;
            }
            this.stream = new DataInputStream(stream);
        }
        return type;
    }

    private void writeInt32(int i) throws IOException {
        this.writeBytes((byte)(i >>> 24), (byte)(i >>> 16), (byte)(i >>> 8), (byte)i);
    }

    protected String buildFragmentURL(int fragmentIndex) {
        return this.fragmentBaseURL + "Seg1-Frag" + fragmentIndex;
    }

    protected void updateFileSizeEstimation() {
        long secs;
        if (this.estimatedDurationSecs > 0L && this.lastTimeStampMs.get() > 1000L && (secs = this.lastTimeStampMs.get() / 1000L) > 0L) {
            long sizePerSec = this.bytesWritten.get() / secs;
            this.downloadable.setDownloadTotalBytes(Math.max(sizePerSec * this.estimatedDurationSecs, this.bytesWritten.get()));
        }
    }

    protected URLConnectionAdapter openConnection(Browser br, int fragmentIndex) throws IOException, PluginException {
        return br.openGetConnection(this.buildFragmentURL(fragmentIndex));
    }

    protected boolean startNextFragment(int fragmentIndex) {
        long lastTimeStampMs = this.lastTimeStampMs.get();
        if (this.estimatedDurationSecs > 0L && lastTimeStampMs > 0L) {
            boolean finished = lastTimeStampMs >= this.estimatedDurationSecs * 1000L;
            this.logger.info("nextFragment=" + fragmentIndex + "\tprogress=" + lastTimeStampMs / 1000L + "/" + this.estimatedDurationSecs + "(s)\tfinished=" + finished);
            if (finished) {
                return false;
            }
        }
        return true;
    }

    protected Boolean isDownloadComplete() {
        long lastTimeStampMs = this.lastTimeStampMs.get();
        if (this.estimatedDurationSecs > 0L && lastTimeStampMs > 0L) {
            return lastTimeStampMs >= this.estimatedDurationSecs * 1000L;
        }
        return null;
    }

    private InputStream nextFragment() throws IOException, PluginException {
        if (this.currentConnection != null) {
            this.currentConnection.disconnect();
            if (this.bytesWritten.get() > 0L && this.fragmentIndex.get() > 1) {
                this.link.setProperty(RESUME_FRAGMENT, this.fragmentIndex.get() - 1 + ":" + this.bytesWritten.get());
            }
        }
        this.updateFileSizeEstimation();
        int nextFragmentIndex = this.fragmentIndex.getAndIncrement();
        if (!this.startNextFragment(nextFragmentIndex)) {
            return null;
        }
        Browser brc = this.sourceBrowser.cloneBrowser();
        this.currentConnection = this.onNextFragment(this.openConnection(brc, nextFragmentIndex), nextFragmentIndex);
        if (this.currentConnection.getResponseCode() == 200) {
            if (this.inputStream == null) {
                this.inputStream = new MeteredThrottledInputStream((InputStream)new F4vInputStream(this.currentConnection), (SpeedMeterInterface)new AverageSpeedMeter(10));
                this.connectionHandler.addThrottledConnection((ThrottledConnection)this.inputStream);
            } else {
                this.inputStream.setInputStream((InputStream)new F4vInputStream(this.currentConnection));
            }
            return this.inputStream;
        }
        this.currentConnection.disconnect();
        int probeFragmentIndex = this.fragmentIndex.get() + 1;
        URLConnectionAdapter missingFrameCheck = this.onNextProbeFragment(this.openConnection(brc, probeFragmentIndex), probeFragmentIndex);
        missingFrameCheck.disconnect();
        if (missingFrameCheck.getResponseCode() == 200) {
            throw new PluginException(0x400000);
        }
        return null;
    }

    protected URLConnectionAdapter onNextFragment(URLConnectionAdapter connection, int fragmentIndex) throws IOException, PluginException {
        return connection;
    }

    protected URLConnectionAdapter onNextProbeFragment(URLConnectionAdapter connection, int fragmentIndex) throws IOException, PluginException {
        return connection;
    }

    private int readInt24() throws IOException {
        int ch3;
        int ch2;
        int ch1 = this.stream.read();
        if ((ch1 | (ch2 = this.stream.read()) | (ch3 = this.stream.read())) < 0) {
            throw new EOFException();
        }
        return ch1 << 16 | ch2 << 8 | ch3;
    }

    private int writeInt24(int i) throws IOException {
        return this.writeBytes((byte)(i >>> 16), (byte)(i >>> 8), (byte)i);
    }

    private int write(int i) throws IOException {
        return this.writeBytes((byte)i);
    }

    private int writeBytes(byte ... bytes) throws IOException {
        this.buffer.put(bytes);
        return bytes.length;
    }

    private void skipBytes(int num) throws IOException {
        if (this.stream.skipBytes(num) != num) {
            throw new EOFException();
        }
    }

    public long getBytesLoaded() {
        return this.bytesWritten.get();
    }

    @Override
    public ManagedThrottledConnectionHandler getManagedConnetionHandler() {
        return this.connectionHandler;
    }

    @Override
    public URLConnectionAdapter connect(Browser br) throws Exception {
        throw new WTFException("Not needed");
    }

    @Override
    public long getTotalLinkBytesLoadedLive() {
        return this.getBytesLoaded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean startDownload() throws Exception {
        boolean bl;
        try {
            DownloadPluginProgress downloadPluginProgress = null;
            this.downloadable.setConnectionHandler(this.getManagedConnetionHandler());
            final DiskSpaceReservation reservation = this.downloadable.createDiskSpaceReservation();
            try {
                if (!this.downloadable.checkIfWeCanWrite(new ExceptionRunnable(){

                    @Override
                    public void run() throws Exception {
                        HDSDownloader.this.downloadable.checkAndReserve(reservation);
                        HDSDownloader.this.createOutputChannel();
                        try {
                            HDSDownloader.this.downloadable.lockFiles(HDSDownloader.this.outputCompleteFile, HDSDownloader.this.outputPartFile);
                        }
                        catch (FileIsLockedException e) {
                            HDSDownloader.this.downloadable.unlockFiles(HDSDownloader.this.outputCompleteFile, HDSDownloader.this.outputPartFile);
                            throw new PluginException(8192, null, e);
                        }
                    }
                }, null)) {
                    throw new SkipReasonException(SkipReason.INVALID_DESTINATION);
                }
                this.startTimeStamp = System.currentTimeMillis();
                downloadPluginProgress = new DownloadPluginProgress(this.downloadable, this, Color.GREEN.darker());
                this.downloadable.addPluginProgress(downloadPluginProgress);
                this.downloadable.setAvailable(DownloadLink.AvailableStatus.TRUE);
                this.run();
            }
            catch (Throwable throwable) {
                try {
                    this.downloadable.free(reservation);
                }
                catch (Throwable e) {
                    LogSource.exception((LogInterface)this.logger, (Throwable)e);
                }
                try {
                    long startTimeStamp = this.getStartTimeStamp();
                    if (startTimeStamp > 0L) {
                        this.downloadable.addDownloadTime(System.currentTimeMillis() - this.getStartTimeStamp());
                    }
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                this.downloadable.removePluginProgress(downloadPluginProgress);
                throw throwable;
            }
            try {
                this.downloadable.free(reservation);
            }
            catch (Throwable e) {
                LogSource.exception((LogInterface)this.logger, (Throwable)e);
            }
            try {
                long startTimeStamp = this.getStartTimeStamp();
                if (startTimeStamp > 0L) {
                    this.downloadable.addDownloadTime(System.currentTimeMillis() - this.getStartTimeStamp());
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.downloadable.removePluginProgress(downloadPluginProgress);
            this.onDownloadReady();
            bl = this.handleErrors();
        }
        catch (Throwable throwable) {
            this.downloadable.unlockFiles(this.outputCompleteFile, this.outputPartFile);
            this.cleanupDownladInterface();
            throw throwable;
        }
        this.downloadable.unlockFiles(this.outputCompleteFile, this.outputPartFile);
        this.cleanupDownladInterface();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void error(PluginException pluginException) {
        HDSDownloader hDSDownloader = this;
        synchronized (hDSDownloader) {
            if (this.externalDownloadStop()) {
                return;
            }
            LogSource.exception((LogInterface)this.logger, (Throwable)pluginException);
            if (this.caughtPluginException == null) {
                this.caughtPluginException = pluginException;
            }
        }
        this.terminate();
    }

    protected void onDownloadReady() throws Exception {
        this.cleanupDownladInterface();
        if (!this.handleErrors()) {
            return;
        }
        boolean renameOkay = this.downloadable.rename(this.outputPartFile, this.outputCompleteFile);
        if (!renameOkay) {
            this.error(new PluginException(16384, _JDT.T.system_download_errors_couldnotrename(), 2L));
        }
    }

    protected void cleanupDownladInterface() {
        try {
            this.downloadable.removeConnectionHandler(this.getManagedConnetionHandler());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (this.currentConnection != null) {
                this.currentConnection.disconnect();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.closeOutputChannel();
    }

    private void closeOutputChannel() {
        try {
            FileOutputStream loutputPartFileRaf = this.outStream;
            if (loutputPartFileRaf != null) {
                this.logger.info("Close File. Let AV programs run");
                ((OutputStream)loutputPartFileRaf).close();
            }
        }
        catch (Throwable e) {
            LogSource.exception((LogInterface)this.logger, (Throwable)e);
        }
        finally {
            this.outStream = null;
        }
    }

    private boolean handleErrors() throws PluginException {
        if (this.externalDownloadStop()) {
            return false;
        }
        if (this.caughtPluginException != null) {
            throw this.caughtPluginException;
        }
        Boolean isDownloadComplete = this.isDownloadComplete();
        if (Boolean.FALSE.equals(isDownloadComplete)) {
            throw new PluginException(512);
        }
        if (this.outputPartFile.exists()) {
            this.downloadable.setLinkStatus(2);
            this.downloadable.setDownloadBytesLoaded(this.outputPartFile.length());
            this.downloadable.setVerifiedFileSize(this.outputPartFile.length());
            return true;
        }
        if (this.outputCompleteFile.exists()) {
            this.downloadable.setLinkStatus(2);
            this.downloadable.setDownloadBytesLoaded(this.outputCompleteFile.length());
            this.downloadable.setVerifiedFileSize(this.outputCompleteFile.length());
            return true;
        }
        throw new PluginException(0x400000);
    }

    private void createOutputChannel() throws SkipReasonException {
        try {
            String fileOutput = this.downloadable.getFileOutput();
            this.outputCompleteFile = new File(fileOutput);
            this.outputPartFile = new File(this.downloadable.getFileOutputPart());
            this.outStream = new FileOutputStream(this.outputPartFile, true){

                @Override
                public synchronized void write(byte[] b, int off, int len) throws IOException {
                    super.write(b, off, len);
                    long size = HDSDownloader.this.bytesWritten.addAndGet(len);
                    HDSDownloader.this.downloadable.setDownloadBytesLoaded(size);
                }
            };
        }
        catch (Exception e) {
            LogSource.exception((LogInterface)this.logger, (Throwable)e);
            throw new SkipReasonException(SkipReason.INVALID_DESTINATION, e);
        }
    }

    @Override
    public URLConnectionAdapter getConnection() {
        return this.currentConnection;
    }

    @Override
    public void stopDownload() {
        if (!this.abort.getAndSet(true)) {
            this.logger.info("externalStop recieved");
            this.terminate();
        }
    }

    @Override
    public boolean externalDownloadStop() {
        return this.abort.get();
    }

    @Override
    public long getStartTimeStamp() {
        return this.startTimeStamp;
    }

    @Override
    public void close() {
        if (this.currentConnection != null) {
            this.currentConnection.disconnect();
        }
    }

    @Override
    public Downloadable getDownloadable() {
        return this.downloadable;
    }

    @Override
    public boolean isResumedDownload() {
        return false;
    }
}

