/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.downloader.hls;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.appwork.utils.UniqueAlltimeID;
import org.jdownloader.downloader.hls.M3U8Playlist;

public class HLSContent {
    protected long id = UniqueAlltimeID.next();
    protected final M3U8Playlist main;
    protected final List<M3U8Playlist> audioTracks = new ArrayList<M3U8Playlist>();

    public long getId() {
        return this.id;
    }

    public M3U8Playlist getMain() {
        return this.main;
    }

    public List<M3U8Playlist> getAudioTracks() {
        return this.audioTracks;
    }

    public HLSContent(M3U8Playlist main) {
        this.main = main;
    }

    public void addAudioTrack(M3U8Playlist audioTrack) {
        this.audioTracks.add(audioTrack);
    }

    public List<M3U8Playlist> list() {
        ArrayList<M3U8Playlist> ret = new ArrayList<M3U8Playlist>();
        ret.add(this.getMain());
        ret.addAll(this.getAudioTracks());
        return Collections.unmodifiableList(ret);
    }

    public M3U8Playlist get(int index) {
        if (index == 0) {
            return this.getMain();
        }
        List<M3U8Playlist> audioTracks = this.getAudioTracks();
        if (index - 1 < audioTracks.size()) {
            return audioTracks.get(index - 1);
        }
        return null;
    }

    public int size() {
        return 1 + this.getAudioTracks().size();
    }
}

