/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.downloader.hls;

import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.spec.SecretKeySpec;
import jd.controlling.downloadcontroller.DiskSpaceReservation;
import jd.controlling.downloadcontroller.ExceptionRunnable;
import jd.controlling.downloadcontroller.FileIsLockedException;
import jd.controlling.downloadcontroller.ManagedThrottledConnectionHandler;
import jd.http.Browser;
import jd.http.Request;
import jd.http.URLConnectionAdapter;
import jd.nutils.Formatter;
import jd.plugins.DownloadLink;
import jd.plugins.Plugin;
import jd.plugins.PluginException;
import jd.plugins.download.DownloadInterface;
import jd.plugins.download.DownloadLinkDownloadable;
import jd.plugins.download.Downloadable;
import jd.plugins.download.raf.FileBytesMap;
import org.appwork.exceptions.WTFException;
import org.appwork.net.protocol.http.HTTPConstants;
import org.appwork.net.protocol.http.ResponseCodeInterface;
import org.appwork.scheduler.DelayedRunnable;
import org.appwork.storage.SimpleMapper;
import org.appwork.storage.TypeRef;
import org.appwork.storage.config.JsonConfig;
import org.appwork.utils.Application;
import org.appwork.utils.DebugMode;
import org.appwork.utils.Files;
import org.appwork.utils.IO;
import org.appwork.utils.Regex;
import org.appwork.utils.StringUtils;
import org.appwork.utils.UniqueAlltimeID;
import org.appwork.utils.encoding.URLEncode;
import org.appwork.utils.formatter.SizeFormatter;
import org.appwork.utils.logging2.LogInterface;
import org.appwork.utils.logging2.LogSource;
import org.appwork.utils.net.HTTPHeader;
import org.appwork.utils.net.LimitedInputStream;
import org.appwork.utils.net.URLHelper;
import org.appwork.utils.net.httpconnection.HTTPConnectionUtils;
import org.appwork.utils.net.httpserver.HttpServer;
import org.appwork.utils.net.httpserver.handler.HttpRequestHandler;
import org.appwork.utils.net.httpserver.requests.GetRequest;
import org.appwork.utils.net.httpserver.requests.HttpRequest;
import org.appwork.utils.net.httpserver.requests.PostRequest;
import org.appwork.utils.net.httpserver.responses.HttpResponse;
import org.appwork.utils.net.throttledconnection.MeteredThrottledInputStream;
import org.appwork.utils.net.throttledconnection.ThrottledConnection;
import org.appwork.utils.net.throttledconnection.ThrottledConnectionHandler;
import org.appwork.utils.os.CrossSystem;
import org.jdownloader.controlling.ffmpeg.AbstractFFmpegBinary;
import org.jdownloader.controlling.ffmpeg.FFMpegException;
import org.jdownloader.controlling.ffmpeg.FFMpegProgress;
import org.jdownloader.controlling.ffmpeg.FFmpeg;
import org.jdownloader.controlling.ffmpeg.FFmpegMetaData;
import org.jdownloader.controlling.ffmpeg.FFmpegSetup;
import org.jdownloader.controlling.ffmpeg.FFprobe;
import org.jdownloader.controlling.ffmpeg.json.Stream;
import org.jdownloader.controlling.ffmpeg.json.StreamInfo;
import org.jdownloader.controlling.filter.CompiledFiletypeFilter;
import org.jdownloader.downloader.hls.HLSContent;
import org.jdownloader.downloader.hls.M3U8Playlist;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.gui.views.downloads.columns.ETAColumn;
import org.jdownloader.logging.LogController;
import org.jdownloader.plugins.DownloadPluginProgress;
import org.jdownloader.plugins.SkipReason;
import org.jdownloader.plugins.SkipReasonException;
import org.jdownloader.settings.GeneralSettings;
import org.jdownloader.translate._JDT;

public class HLSDownloader
extends DownloadInterface {
    private final AtomicLong bytesWritten = new AtomicLong(0L);
    private DownloadLinkDownloadable downloadable;
    private DownloadLink link;
    private long startTimeStamp = -1L;
    private final LogInterface logger = this.initLogger();
    private URLConnectionAdapter currentConnection;
    private ManagedThrottledConnectionHandler connectionHandler;
    private File outputCompleteFile;
    private PluginException caughtPluginException;
    private String persistentParameters;
    private Browser sourceBrowser;
    private final AtomicLong processID = new AtomicLong(-1L);
    private final List<HLSContent> hlsContentList = new ArrayList<HLSContent>();
    private final List<PartFile> outputPartFiles = new ArrayList<PartFile>();
    private volatile Map<String, File> fileMap = new HashMap<String, File>();
    private final HashMap<String, SecretKeySpec> aes128Keys = new HashMap();
    private final WeakHashMap<M3U8Playlist.M3U8Segment, M3U8SEGMENTSTATE> m3u8SegmentsStates = new WeakHashMap();
    private final Map<Thread, HttpServerThread> runningServers = new WeakHashMap<Thread, HttpServerThread>();
    private final Map<M3U8Playlist.M3U8Segment, Map<String, Object>> segmentRetryMap = new HashMap<M3U8Playlist.M3U8Segment, Map<String, Object>>();
    private volatile Object cachedStreamInfo = null;
    protected static final String QUERY_M3U8_ID = "m3u8_id";
    protected static final String QUERY_M3U8_INDEX = "m3u8_index";
    protected static final String QUERY_M3U8_SEGMENT = "m3u8_seg";
    private final AtomicBoolean abort = new AtomicBoolean(false);
    private final AtomicBoolean terminated = new AtomicBoolean(false);
    private boolean acceptDownloadStopAsValidEnd = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpServerThread getRunningServer(String id) {
        Map<Thread, HttpServerThread> map = this.runningServers;
        synchronized (map) {
            for (HttpServerThread serverThread : this.runningServers.values()) {
                if (!StringUtils.equals((String)id, (String)serverThread.id)) continue;
                return serverThread;
            }
        }
        return null;
    }

    public CONCATSOURCE getConcatSource() {
        return CONCATSOURCE.HTTP;
    }

    protected long getProcessID() {
        return this.processID.get();
    }

    protected void init(final DownloadLink link, Browser br, String m3u8URL, String persistantParameters, List<M3U8Playlist> list) throws Exception {
        this.setPersistentParameters(persistantParameters);
        m3u8URL = Request.getLocation((String)m3u8URL, (Request)br.getRequest());
        this.sourceBrowser = br.cloneBrowser();
        this.link = link;
        this.connectionHandler = new ManagedThrottledConnectionHandler(){

            @Override
            public void addThrottledConnection(ThrottledConnection con) {
                long transfered = con.transfered();
                if (transfered > 0L) {
                    this.traffic.addAndGet(-transfered);
                    if (this.connections.addIfAbsent(con)) {
                        con.setHandler((ThrottledConnectionHandler)this);
                    } else {
                        this.traffic.addAndGet(transfered);
                    }
                } else {
                    super.addThrottledConnection(con);
                }
            }
        };
        this.downloadable = new DownloadLinkDownloadable(link){

            @Override
            public boolean isResumable() {
                return link.getBooleanProperty("RESUME", true);
            }

            @Override
            public void setResumeable(boolean value) {
                link.setProperty("RESUME", value);
                super.setResumeable(value);
            }
        };
        this.legacy_InitHLSContent(list, this.getRequestBrowser(), m3u8URL);
        List<M3U8Playlist> mainM3U8PlayLists = this.getPlayLists();
        if (mainM3U8PlayLists == null || mainM3U8PlayLists.size() == 0) {
            throw new PluginException(32);
        }
    }

    @Deprecated
    protected void legacy_InitHLSContent(List<M3U8Playlist> m3u8Playlists, Browser br, String m3u8URL) throws Exception {
        if (m3u8Playlists == null || m3u8Playlists.size() == 0) {
            m3u8Playlists = this.legacy_LoadM3U8Playlists(br, m3u8URL);
        }
        if (m3u8Playlists != null && m3u8Playlists.size() > 0) {
            for (M3U8Playlist m3u8Playlist : m3u8Playlists) {
                this.hlsContentList.add(new HLSContent(m3u8Playlist));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    protected List<M3U8Playlist> legacy_LoadM3U8Playlists(Browser br, String m3u8URL) throws Exception {
        int was = br.getLoadLimit();
        br.setLoadLimit(Integer.MAX_VALUE);
        try {
            List<M3U8Playlist> ret = M3U8Playlist.loadM3U8(this.buildDownloadUrl(m3u8URL), br);
            this.currentConnection = br.getHttpConnection();
            List<M3U8Playlist> list = ret;
            return list;
        }
        finally {
            br.setLoadLimit(was);
        }
    }

    @Deprecated
    public HLSDownloader(DownloadLink link, Browser br, String m3uUrl, String persistentParameters) throws Exception {
        this.init(link, br, m3uUrl, persistentParameters, null);
    }

    @Deprecated
    public HLSDownloader(DownloadLink link, Browser br, String m3uUrl) throws Exception {
        this.init(link, br, m3uUrl, null, null);
    }

    @Deprecated
    public HLSDownloader(DownloadLink link, Browser br, String m3uUrl, List<M3U8Playlist> list) throws Exception {
        this.init(link, br, m3uUrl, null, list);
    }

    public HLSDownloader(final DownloadLink link, Browser br, List<HLSContent> list) throws Exception {
        this.sourceBrowser = br.cloneBrowser();
        this.link = link;
        this.connectionHandler = new ManagedThrottledConnectionHandler(){

            @Override
            public void addThrottledConnection(ThrottledConnection con) {
                long transfered = con.transfered();
                if (transfered > 0L) {
                    this.traffic.addAndGet(-transfered);
                    if (this.connections.addIfAbsent(con)) {
                        con.setHandler((ThrottledConnectionHandler)this);
                    } else {
                        this.traffic.addAndGet(transfered);
                    }
                } else {
                    super.addThrottledConnection(con);
                }
            }
        };
        this.downloadable = new DownloadLinkDownloadable(link){

            @Override
            public boolean isResumable() {
                return link.getBooleanProperty("RESUME", true);
            }

            @Override
            public void setResumeable(boolean value) {
                link.setProperty("RESUME", value);
                super.setResumeable(value);
            }
        };
        if (list == null || list.size() == 0) {
            throw new PluginException(32);
        }
        this.hlsContentList.addAll(list);
    }

    @Deprecated
    protected void setPersistentParameters(String persistentParameters) {
        String parameter;
        this.persistentParameters = StringUtils.isEmpty((String)persistentParameters) ? null : ((parameter = persistentParameters.trim()).startsWith("?") || parameter.startsWith("&") ? parameter.substring(1) : parameter);
    }

    protected String buildDownloadUrl(String url) {
        String persistentParameters = this.persistentParameters;
        if (persistentParameters == null) {
            return url;
        }
        try {
            return URLHelper.parseLocation((URL)new URL(url), (String)("&" + persistentParameters));
        }
        catch (MalformedURLException e) {
            if (url.contains("?")) {
                return url + "&" + persistentParameters;
            }
            return url + "?" + persistentParameters;
        }
    }

    public long getEstimatedSize() {
        return M3U8Playlist.getEstimatedSize(this.getPlayLists());
    }

    public boolean isEncrypted() {
        return !this.isEncryptionSupported(this.getEncryptionMethod());
    }

    public M3U8Playlist.M3U8Segment.X_KEY_METHOD getEncryptionMethod() {
        for (HLSContent hlsContent : this.hlsContentList) {
            for (M3U8Playlist playList : hlsContent.list()) {
                M3U8Playlist.M3U8Segment.X_KEY_METHOD encryptionMethod = playList.getEncryptionMethod();
                if (M3U8Playlist.M3U8Segment.X_KEY_METHOD.NONE.equals((Object)encryptionMethod)) continue;
                return encryptionMethod;
            }
        }
        return M3U8Playlist.M3U8Segment.X_KEY_METHOD.NONE;
    }

    private boolean isEncryptionSupported(M3U8Playlist.M3U8Segment.X_KEY_METHOD method) {
        switch (method) {
            case AES_128: {
                return DebugMode.TRUE_IN_IDE_ELSE_FALSE;
            }
            default: {
                return false;
            }
            case NONE: 
        }
        return true;
    }

    protected boolean isSupported(M3U8Playlist m3u8) {
        if (m3u8 != null && !this.isEncryptionSupported(m3u8.getEncryptionMethod())) {
            return false;
        }
        return !this.isEncrypted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String probeFormat(String extension) throws Exception {
        String threadID = "probeFormat";
        if (this.getRunningServer("probeFormat") != null) {
            return null;
        }
        final AtomicReference<HttpServer> finalServer = new AtomicReference<HttpServer>();
        FFmpeg ffmpeg = new FFmpeg(){

            @Override
            public LogInterface getLogger() {
                return HLSDownloader.this.logger;
            }

            @Override
            protected void initPipe(String m3u8url) throws IOException {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String runCommand(FFMpegProgress progress, List<String> commandLine) throws IOException, InterruptedException, FFMpegException {
                Object object = HLSDownloader.this.runningServers;
                synchronized (object) {
                    if (HLSDownloader.this.getRunningServer("probeFormat") != null) {
                        throw new WTFException();
                    }
                    HLSDownloader.this.runningServers.put(Thread.currentThread(), new HttpServerThread("probeFormat", (HttpServer)finalServer.get()));
                }
                try {
                    object = super.runCommand(progress, commandLine);
                    return object;
                }
                finally {
                    Map map = HLSDownloader.this.runningServers;
                    synchronized (map) {
                        HLSDownloader.this.runningServers.remove(Thread.currentThread());
                    }
                }
            }
        };
        if (!ffmpeg.isAvailable()) {
            this.logger.info("FFMpeg is not available");
            return null;
        }
        if (!ffmpeg.isCompatible()) {
            this.logger.info("FFMpeg is incompatible");
            return null;
        }
        AtomicInteger requestsInProcess = new AtomicInteger(0);
        HttpServer server = null;
        long pid = this.newPID();
        try {
            server = this.initPipe(ffmpeg, requestsInProcess);
            finalServer.set(server);
            ArrayList<String> queryDefaultFormat = new ArrayList<String>();
            queryDefaultFormat.add(ffmpeg.getFullPath());
            File dummy = Application.getTempResource((String)("ffmpeg_dummy-" + UniqueAlltimeID.next() + "." + extension));
            queryDefaultFormat.add(dummy.getAbsolutePath());
            queryDefaultFormat.add("-y");
            try {
                ffmpeg.runCommand(null, queryDefaultFormat);
                throw new FFMpegException("WTF");
            }
            catch (FFMpegException e) {
                block27: {
                    String string;
                    block28: {
                        String res = e.getStdErr();
                        String format = new Regex(res, "Output \\#0\\, ([^\\,]+)").getMatch(0);
                        if (format != null) {
                            String string2 = format;
                            return string2;
                        }
                        if (!StringUtils.contains((String)res, (String)"Unable to find a suitable output format")) break block27;
                        string = null;
                        try {
                            if (server == null) break block28;
                            try {
                                server.stop();
                            }
                            finally {
                                this.waitForProcessingRequests(requestsInProcess);
                            }
                        }
                        finally {
                            this.stopPID(pid);
                        }
                    }
                    return string;
                }
                throw new PluginException(0x400000, null, -1L, e);
            }
        }
        finally {
            block29: {
                try {
                    if (server == null) break block29;
                    try {
                        server.stop();
                    }
                    finally {
                        this.waitForProcessingRequests(requestsInProcess);
                    }
                }
                finally {
                    this.stopPID(pid);
                }
            }
        }
    }

    protected String toString(AbstractFFmpegBinary ffmpeg, HttpRequest request, M3U8Playlist m3u8) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("#EXTM3U\r\n");
        sb.append("#EXT-X-VERSION:3\r\n");
        sb.append("#EXT-X-MEDIA-SEQUENCE:0\r\n");
        if (m3u8.getTargetDuration() > 0L) {
            sb.append("#EXT-X-TARGETDURATION:");
            sb.append(m3u8.getTargetDuration());
            sb.append("\r\n");
        }
        long processID = this.getProcessID();
        for (int index = 0; index < m3u8.size(); ++index) {
            M3U8Playlist.M3U8Segment segment = m3u8.getSegment(index);
            if (segment.isEXT_X_MAP()) {
                sb.append("#EXT-X-MAP:URI=");
                sb.append("\"");
                sb.append("download." + this.getSegmentExtension(ffmpeg, segment));
                sb.append("?id=").append(processID);
                sb.append("&").append(QUERY_M3U8_ID).append("=").append(request.getParameterbyKey(QUERY_M3U8_ID));
                sb.append("&").append(QUERY_M3U8_INDEX).append("=").append(request.getParameterbyKey(QUERY_M3U8_INDEX));
                sb.append("&").append(QUERY_M3U8_SEGMENT).append("=").append(index);
                sb.append("\"");
            } else {
                sb.append("#EXTINF:" + M3U8Playlist.M3U8Segment.toExtInfDuration(segment.getDuration()));
                sb.append("\r\n");
                sb.append("download." + this.getSegmentExtension(ffmpeg, segment));
                sb.append("?id=").append(processID);
                sb.append("&").append(QUERY_M3U8_ID).append("=").append(request.getParameterbyKey(QUERY_M3U8_ID));
                sb.append("&").append(QUERY_M3U8_INDEX).append("=").append(request.getParameterbyKey(QUERY_M3U8_INDEX));
                sb.append("&").append(QUERY_M3U8_SEGMENT).append("=").append(index);
            }
            sb.append("\r\n");
        }
        sb.append("#EXT-X-ENDLIST\r\n");
        return sb.toString();
    }

    protected LogInterface initLogger() {
        Plugin plg = Plugin.getCurrentActivePlugin();
        LogInterface log = null;
        if (plg != null) {
            log = plg.getLogger();
        }
        if (log == null) {
            log = LogController.CL();
        }
        return log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void terminate() {
        if (!this.terminated.getAndSet(true)) {
            Map<Thread, HttpServerThread> map = this.runningServers;
            synchronized (map) {
                for (Map.Entry<Thread, HttpServerThread> runningServer : this.runningServers.entrySet()) {
                    Thread thread = runningServer.getKey();
                    HttpServerThread serverThread = runningServer.getValue();
                    serverThread.stop();
                    this.logger.log((Throwable)new Exception("Interrupt " + serverThread.id + " ffmpegThread:" + thread));
                    if (thread == null) continue;
                    thread.interrupt();
                }
            }
            if (!this.externalDownloadStop()) {
                this.logger.log((Throwable)new Exception("A critical Downloaderror occured. Terminate..."));
            }
        }
    }

    public StreamInfo getProbe() throws Exception {
        return this.getProbe(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StreamInfo getProbe(int index) throws Exception {
        String threadID = "probe";
        if (this.getRunningServer("probe") != null) {
            return null;
        }
        final AtomicReference<HttpServer> finalServer = new AtomicReference<HttpServer>();
        final HLSContent content = this.hlsContentList.get(index);
        FFprobe ffprobe = new FFprobe(){

            @Override
            public LogInterface getLogger() {
                return HLSDownloader.this.logger;
            }

            @Override
            protected void initPipe(String m3u8url) throws IOException {
            }

            @Override
            protected List<String> buildStreamInfoCommandLine(List<String> commandLine, String url) {
                HttpServer server = (HttpServer)finalServer.get();
                commandLine.add(this.getFullPath());
                commandLine.add("-loglevel");
                commandLine.add("48");
                commandLine.add("-show_format");
                commandLine.add("-show_streams");
                commandLine.add("-analyzeduration");
                commandLine.add("15000000");
                commandLine.add("-of");
                commandLine.add("json");
                long processID = HLSDownloader.this.getProcessID();
                for (int index = 0; index < content.size(); ++index) {
                    commandLine.add("-i");
                    commandLine.add("http://" + server.getServerAddress() + "/m3u8.m3u8?id=" + processID + "&" + HLSDownloader.QUERY_M3U8_ID + "=" + content.getId() + "&" + HLSDownloader.QUERY_M3U8_INDEX + "=" + index);
                }
                return commandLine;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String runCommand(FFMpegProgress progress, List<String> commandLine) throws IOException, InterruptedException, FFMpegException {
                Object object = HLSDownloader.this.runningServers;
                synchronized (object) {
                    if (HLSDownloader.this.getRunningServer("probe") != null) {
                        throw new WTFException();
                    }
                    HLSDownloader.this.runningServers.put(Thread.currentThread(), new HttpServerThread("probe", (HttpServer)finalServer.get()));
                }
                try {
                    object = super.runCommand(progress, commandLine);
                    return object;
                }
                finally {
                    Map map = HLSDownloader.this.runningServers;
                    synchronized (map) {
                        HLSDownloader.this.runningServers.remove(Thread.currentThread());
                    }
                }
            }
        };
        if (!ffprobe.isAvailable()) {
            this.logger.info("FFProbe is not available");
            return null;
        }
        if (!ffprobe.isCompatible()) {
            this.logger.info("FFProbe is incompatible");
            return null;
        }
        AtomicInteger requestsInProcess = new AtomicInteger(0);
        HttpServer server = null;
        long pid = this.newPID();
        try {
            server = this.initPipe(ffprobe, requestsInProcess);
            finalServer.set(server);
            StreamInfo streamInfo = ffprobe.getStreamInfo((String)null);
            return streamInfo;
        }
        finally {
            block16: {
                try {
                    if (server == null) break block16;
                    try {
                        server.stop();
                    }
                    finally {
                        this.waitForProcessingRequests(requestsInProcess);
                    }
                }
                finally {
                    this.stopPID(pid);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForProcessingRequests(AtomicInteger requestsInProcess) throws InterruptedException {
        while (true) {
            AtomicInteger atomicInteger = requestsInProcess;
            synchronized (atomicInteger) {
                if (requestsInProcess.get() == 0) {
                    break;
                }
                requestsInProcess.wait(50L);
            }
        }
    }

    protected boolean stopPID(long pid) {
        return this.processID.compareAndSet(pid, -1L);
    }

    protected long newPID() {
        long newPid = new org.jdownloader.controlling.UniqueAlltimeID().getID();
        if (this.processID.compareAndSet(-1L, newPid)) {
            return newPid;
        }
        return -1L;
    }

    protected String guessFFmpegFormat(StreamInfo streamInfo) {
        if (streamInfo != null && streamInfo.getStreams() != null) {
            for (Stream s : streamInfo.getStreams()) {
                if (!"video".equalsIgnoreCase(s.getCodec_type())) continue;
                return "mp4";
            }
            for (Stream s : streamInfo.getStreams()) {
                if (!"audio".equalsIgnoreCase(s.getCodec_type())) continue;
                if ("aac".equalsIgnoreCase(s.getCodec_name())) {
                    return "aac";
                }
                if (!"opus".equalsIgnoreCase(s.getCodec_name())) continue;
                return "opus";
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected String getFFmpegFormat(AbstractFFmpegBinary ffmpeg) throws Exception {
        String format;
        String name = this.link.getForcedFileName();
        if (StringUtils.isEmpty((String)name)) {
            name = this.link.getFinalFileName();
            if (StringUtils.isEmpty((String)name)) {
                name = this.link.getRawName();
            }
            if (StringUtils.isEmpty((String)name)) {
                String url = this.link.getContentUrlOrPatternMatcher();
                name = Plugin.extractFileNameFromURL(url);
            }
        }
        if ((format = ffmpeg.getDefaultFormatByFileName(name)) != null) return format;
        StreamInfo streamInfo = null;
        if (this.cachedStreamInfo == null) {
            streamInfo = this.getProbe();
            if (streamInfo != null) {
                this.cachedStreamInfo = streamInfo;
            }
        } else if (this.cachedStreamInfo instanceof StreamInfo) {
            streamInfo = (StreamInfo)this.cachedStreamInfo;
        }
        if ((format = this.guessFFmpegFormat(streamInfo)) != null) return format;
        String extension = Files.getExtension((String)name);
        if (extension == null) {
            throw new PluginException(0x400000);
        }
        String extensionID = extension.toLowerCase(Locale.ENGLISH);
        FFmpegSetup config = (FFmpegSetup)JsonConfig.create(FFmpegSetup.class);
        Class<HLSDownloader> clazz = HLSDownloader.class;
        // MONITORENTER : org.jdownloader.downloader.hls.HLSDownloader.class
        Map<String, String> map = config.getExtensionToFormatMap();
        map = map == null ? new ConcurrentHashMap<String, String>() : new ConcurrentHashMap<String, String>(map);
        // MONITOREXIT : clazz
        format = map.get(extensionID);
        if (format == null) {
            format = StringUtils.valueOrEmpty((String)this.probeFormat(extension));
            map.put(extensionID, format);
            clazz = HLSDownloader.class;
            // MONITORENTER : org.jdownloader.downloader.hls.HLSDownloader.class
            config.setExtensionToFormatMap(map);
            // MONITOREXIT : clazz
        }
        if (!StringUtils.isEmpty((String)format)) return format;
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runConcat() throws IOException, SkipReasonException, PluginException {
        block33: {
            try {
                final AtomicReference<HttpServer> finalServer = new AtomicReference<HttpServer>();
                FFmpeg ffmpeg = new FFmpeg(){

                    @Override
                    public LogInterface getLogger() {
                        return HLSDownloader.this.logger;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public String runCommand(FFMpegProgress progress, List<String> commandLine) throws IOException, InterruptedException, FFMpegException {
                        Object object = HLSDownloader.this.runningServers;
                        synchronized (object) {
                            String threadID = "concat";
                            if (HLSDownloader.this.getRunningServer("concat") != null) {
                                throw new WTFException();
                            }
                            HLSDownloader.this.runningServers.put(Thread.currentThread(), new HttpServerThread("concat", (HttpServer)finalServer.get()));
                        }
                        try {
                            object = super.runCommand(progress, commandLine);
                            return object;
                        }
                        finally {
                            Map map = HLSDownloader.this.runningServers;
                            synchronized (map) {
                                HLSDownloader.this.runningServers.remove(Thread.currentThread());
                            }
                        }
                    }

                    @Override
                    protected void parseLine(boolean isStdout, String line) {
                    }
                };
                AtomicInteger requestsInProcess = new AtomicInteger(0);
                HttpServer server = null;
                long pid = this.newPID();
                try {
                    server = this.initPipe(ffmpeg, requestsInProcess);
                    finalServer.set(server);
                    final AtomicReference<File> outputFile = new AtomicReference<File>();
                    FFMpegProgress progress = new FFMpegProgress(){
                        final long total;
                        {
                            long total = 0L;
                            for (PartFile partFile : HLSDownloader.this.outputPartFiles) {
                                total += partFile.file.length();
                            }
                            this.total = total;
                        }

                        @Override
                        public void setTotal(long total) {
                        }

                        @Override
                        public void updateValues(long current, long total) {
                        }

                        @Override
                        public long getCurrent() {
                            File file = (File)outputFile.get();
                            if (file != null) {
                                return file.length();
                            }
                            return 0L;
                        }

                        @Override
                        public long getTotal() {
                            return this.total;
                        }

                        @Override
                        public String getMessage(Object requestor) {
                            if (requestor instanceof ETAColumn) {
                                long eta = this.getETA();
                                if (eta > 0L) {
                                    return Formatter.formatSeconds((long)eta);
                                }
                                return null;
                            }
                            return this.getDetaultMessage();
                        }

                        @Override
                        public long getETA() {
                            long runtime = System.currentTimeMillis() - this.startedTimestamp;
                            if (runtime > 0L) {
                                double speed = (double)this.getCurrent() / (double)runtime;
                                if (speed > 0.0) {
                                    return (long)((double)(this.getTotal() - this.getCurrent()) / speed);
                                }
                                return -1L;
                            }
                            return -1L;
                        }

                        @Override
                        protected String getDetaultMessage() {
                            return _GUI.T.FFMpegProgress_getMessage_concat();
                        }
                    };
                    progress.setProgressSource(this);
                    boolean deleteOutput = true;
                    String concatFormat = CrossSystem.isWindows() && this.hlsContentList.size() > 1 ? this.getFFmpegFormat(ffmpeg) : null;
                    if (CONCATSOURCE.HTTP.equals((Object)this.getConcatSource())) {
                        HashMap<String, File> fileMap = new HashMap<String, File>();
                        for (PartFile partFile : this.outputPartFiles) {
                            fileMap.put(org.jdownloader.controlling.UniqueAlltimeID.create(), partFile.file);
                        }
                        this.fileMap = fileMap;
                    }
                    try {
                        this.downloadable.addPluginProgress(progress);
                        try {
                            outputFile.set(this.outputCompleteFile);
                            ffmpeg.runCommand(null, this.buildConcatCommandLine(server, concatFormat, ffmpeg, this.outputCompleteFile.getAbsolutePath()));
                            deleteOutput = false;
                        }
                        catch (FFMpegException e) {
                            if (FFMpegException.ERROR.PATH_LENGTH.equals((Object)e.getError())) {
                                File tmpOut = new File(this.outputCompleteFile.getParent(), "ffmpeg_out" + org.jdownloader.controlling.UniqueAlltimeID.create());
                                this.logger.info("Try workaround:" + (Object)((Object)e.getError()) + "|Tmp:" + tmpOut + "|Dest:" + this.outputCompleteFile);
                                boolean deleteTmp = true;
                                try {
                                    outputFile.set(tmpOut);
                                    ffmpeg.runCommand(null, this.buildConcatCommandLine(server, concatFormat, ffmpeg, tmpOut.getAbsolutePath()));
                                    ffmpeg.moveFile(tmpOut, this.outputCompleteFile);
                                    deleteTmp = false;
                                    deleteOutput = false;
                                    break block33;
                                }
                                finally {
                                    if (deleteTmp && !tmpOut.delete() && tmpOut.exists()) {
                                        tmpOut.deleteOnExit();
                                    }
                                }
                            }
                            throw e;
                        }
                    }
                    finally {
                        this.downloadable.removePluginProgress(progress);
                        if (deleteOutput) {
                            this.outputCompleteFile.delete();
                        } else {
                            for (PartFile partFile : this.outputPartFiles) {
                                partFile.concatFlag.set(true);
                                partFile.file.delete();
                            }
                        }
                    }
                }
                finally {
                    block34: {
                        try {
                            if (server == null) break block34;
                            try {
                                server.stop();
                            }
                            finally {
                                this.waitForProcessingRequests(requestsInProcess);
                            }
                        }
                        finally {
                            this.stopPID(pid);
                        }
                    }
                }
            }
            catch (FFMpegException e) {
                if (FFMpegException.ERROR.PATH_LENGTH.equals((Object)e.getError())) {
                    throw new SkipReasonException(SkipReason.INVALID_DESTINATION, e);
                }
                if (FFMpegException.ERROR.DISK_FULL.equals((Object)e.getError())) {
                    throw new SkipReasonException(SkipReason.DISK_FULL, e);
                }
                throw new PluginException(0x400000, e.getMessage(), -1L, e);
            }
            catch (Exception e) {
                this.logger.log((Throwable)e);
                throw new PluginException(0x400000, e.getMessage(), -1L, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void runDownload() throws Exception {
        block37: {
            Object finalServer;
            this.link.setDownloadSize(-1L);
            try {
                finalServer = new AtomicReference<HttpServer>();
                AtomicLong lastBitrate = new AtomicLong(-1L);
                AtomicLong lastBytesWritten = new AtomicLong(0L);
                AtomicLong lastTime = new AtomicLong(0L);
                AtomicLong completeTime = new AtomicLong(0L);
                List<M3U8Playlist> mainM3U8Playlists = this.getPlayLists();
                long estimatedDuration = M3U8Playlist.getEstimatedDuration(mainM3U8Playlists) / 1000L;
                FFmpeg ffmpeg = new FFmpeg((AtomicReference)finalServer, lastBitrate, estimatedDuration, mainM3U8Playlists, lastBytesWritten, lastTime, completeTime){
                    final /* synthetic */ AtomicReference val$finalServer;
                    final /* synthetic */ AtomicLong val$lastBitrate;
                    final /* synthetic */ long val$estimatedDuration;
                    final /* synthetic */ List val$mainM3U8Playlists;
                    final /* synthetic */ AtomicLong val$lastBytesWritten;
                    final /* synthetic */ AtomicLong val$lastTime;
                    final /* synthetic */ AtomicLong val$completeTime;
                    {
                        this.val$finalServer = atomicReference;
                        this.val$lastBitrate = atomicLong;
                        this.val$estimatedDuration = l;
                        this.val$mainM3U8Playlists = list;
                        this.val$lastBytesWritten = atomicLong2;
                        this.val$lastTime = atomicLong3;
                        this.val$completeTime = atomicLong4;
                    }

                    @Override
                    protected int exitProcess(Process process, String stdout, String stderr) throws IllegalThreadStateException {
                        try {
                            return process.exitValue();
                        }
                        catch (IllegalThreadStateException e) {
                            if (stderr != null && stderr.matches("(?s).*video:\\d+\\w*\\s*audio:\\d+\\w*\\s*subtitle:\\d+\\w*.+")) {
                                return 0;
                            }
                            throw e;
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public String runCommand(FFMpegProgress progress, List<String> commandLine) throws IOException, InterruptedException, FFMpegException {
                        Object object = HLSDownloader.this.runningServers;
                        synchronized (object) {
                            String threadID = "download";
                            if (HLSDownloader.this.getRunningServer("download") != null) {
                                throw new WTFException();
                            }
                            HLSDownloader.this.runningServers.put(Thread.currentThread(), new HttpServerThread("download", (HttpServer)this.val$finalServer.get()));
                        }
                        try {
                            object = super.runCommand(progress, commandLine);
                            return object;
                        }
                        finally {
                            Map map = HLSDownloader.this.runningServers;
                            synchronized (map) {
                                HLSDownloader.this.runningServers.remove(Thread.currentThread());
                            }
                        }
                    }

                    @Override
                    public LogInterface getLogger() {
                        return HLSDownloader.this.logger;
                    }

                    @Override
                    protected long getLastUpdateTimestampTimeout() {
                        return 2L * super.getLastUpdateTimestampTimeout();
                    }

                    @Override
                    protected void parseLine(boolean isStdout, String line) {
                        try {
                            String trimmedLine = line.trim();
                            if (!trimmedLine.startsWith("Duration:")) {
                                if (trimmedLine.startsWith("Stream #")) {
                                    String bitrateString = new Regex(line, "(\\d+) kb\\/s").getMatch(0);
                                    if (bitrateString != null) {
                                        if (this.val$lastBitrate.get() == -1L) {
                                            this.val$lastBitrate.set(Integer.parseInt(bitrateString));
                                        } else {
                                            this.val$lastBitrate.addAndGet(Integer.parseInt(bitrateString));
                                        }
                                        long bitrate = this.val$lastBitrate.get();
                                        if (this.val$estimatedDuration > 0L && bitrate > 0L) {
                                            long estimatedSize = this.val$estimatedDuration * bitrate * 1024L / 8L;
                                            HLSDownloader.this.downloadable.setDownloadTotalBytes(Math.max(M3U8Playlist.getEstimatedSize(this.val$mainM3U8Playlists), estimatedSize));
                                        }
                                    }
                                } else if (trimmedLine.startsWith("Output #0")) {
                                    long bitrate = this.val$lastBitrate.get();
                                    if (this.val$estimatedDuration > 0L && bitrate > 0L) {
                                        long estimatedSize = this.val$estimatedDuration * bitrate * 1024L / 8L;
                                        HLSDownloader.this.downloadable.setDownloadTotalBytes(Math.max(M3U8Playlist.getEstimatedSize(this.val$mainM3U8Playlists), estimatedSize));
                                    }
                                } else if (trimmedLine.startsWith("frame=") || trimmedLine.startsWith("size=")) {
                                    long estimatedSize;
                                    String sizeString = new Regex(line, "size=\\s*(\\S+)\\s+").getMatch(0);
                                    long size = SizeFormatter.getSize((String)sizeString);
                                    long currentBytesWritten = this.val$lastBytesWritten.get() + size;
                                    HLSDownloader.this.bytesWritten.set(currentBytesWritten);
                                    HLSDownloader.this.downloadable.setDownloadBytesLoaded(currentBytesWritten);
                                    String timeString = new Regex(line, "time=\\s*(\\S+)\\s+").getMatch(0);
                                    long time = 9.formatStringToMilliseconds(timeString) / 1000L;
                                    this.val$lastTime.set(time);
                                    if ((time += this.val$completeTime.get()) > 0L && this.val$estimatedDuration > 0L) {
                                        long rate = currentBytesWritten / time;
                                        estimatedSize = this.val$estimatedDuration * rate;
                                    } else {
                                        estimatedSize = currentBytesWritten;
                                    }
                                    HLSDownloader.this.downloadable.setDownloadTotalBytes(Math.max(M3U8Playlist.getEstimatedSize(this.val$mainM3U8Playlists), estimatedSize));
                                }
                            }
                        }
                        catch (Throwable e) {
                            HLSDownloader.this.logger.log(e);
                        }
                    }
                };
                String downloadFormat = CrossSystem.isWindows() && mainM3U8Playlists.size() > 1 ? "mpegts" : this.getFFmpegFormat(ffmpeg);
                AtomicInteger requestsInProcess = new AtomicInteger(0);
                HttpServer server = null;
                long pid = this.newPID();
                try {
                    server = this.initPipe(ffmpeg, requestsInProcess);
                    ((AtomicReference)finalServer).set(server);
                    for (int index = 0; index < this.hlsContentList.size(); ++index) {
                        HLSContent hlsContent = this.hlsContentList.get(index);
                        PartFile partFile = this.outputPartFiles.get(index);
                        File destination = partFile.file;
                        try {
                            completeTime.addAndGet(lastTime.get());
                            lastBitrate.set(-1L);
                            lastBytesWritten.set(this.bytesWritten.get());
                            while (true) {
                                try {
                                    ffmpeg.runCommand(null, this.buildDownloadCommandLine(server, hlsContent, downloadFormat, ffmpeg, destination.getAbsolutePath()));
                                }
                                catch (FFMpegException e) {
                                    if (FFMpegException.ERROR.UNKNOWN.equals((Object)e.getError()) && StringUtils.containsIgnoreCase((String)e.getStdErr(), (String)"Codec 'mp3'") && Boolean.TRUE.equals(this.putRetryMapValue(null, "aac_adtstoasc", Boolean.FALSE))) {
                                        this.logger.log((Throwable)e);
                                        continue;
                                    }
                                    throw e;
                                }
                                break;
                            }
                            partFile.downloadFlag.set(true);
                            continue;
                        }
                        catch (FFMpegException e) {
                            if (!FFMpegException.ERROR.PATH_LENGTH.equals((Object)e.getError())) {
                                throw e;
                            }
                            File tmpOut = new File(destination.getParent(), "ffmpeg_out" + org.jdownloader.controlling.UniqueAlltimeID.create());
                            this.logger.info("Try workaround:" + (Object)((Object)e.getError()) + "|Tmp:" + tmpOut + "|Dest:" + destination);
                            boolean deleteTmp = true;
                            try {
                                ffmpeg.runCommand(null, this.buildDownloadCommandLine(server, hlsContent, downloadFormat, ffmpeg, tmpOut.getAbsolutePath()));
                                ffmpeg.moveFile(destination, tmpOut);
                                partFile.downloadFlag.set(true);
                                deleteTmp = false;
                                continue;
                            }
                            finally {
                                if (deleteTmp && !tmpOut.delete() && tmpOut.exists()) {
                                    tmpOut.deleteOnExit();
                                }
                            }
                        }
                    }
                }
                finally {
                    block36: {
                        try {
                            if (server == null) break block36;
                            try {
                                server.stop();
                            }
                            finally {
                                this.waitForProcessingRequests(requestsInProcess);
                            }
                        }
                        finally {
                            this.stopPID(pid);
                        }
                    }
                }
                if (this.connectionHandler == null) break block37;
                finalServer = this.connectionHandler.getConnections().iterator();
            }
            catch (FFMpegException e) {
                try {
                    if (FFMpegException.ERROR.PATH_LENGTH.equals((Object)e.getError())) {
                        throw new SkipReasonException(SkipReason.INVALID_DESTINATION, e);
                    }
                    if (FFMpegException.ERROR.DISK_FULL.equals((Object)e.getError())) {
                        throw new SkipReasonException(SkipReason.DISK_FULL, e);
                    }
                    throw new PluginException(0x400000, e.getMessage(), -1L, e);
                    catch (Exception e2) {
                        this.logger.log((Throwable)e2);
                        throw e2;
                    }
                }
                catch (Throwable throwable) {
                    if (this.connectionHandler != null) {
                        for (ThrottledConnection con : this.connectionHandler.getConnections()) {
                            this.connectionHandler.removeThrottledConnection(con);
                        }
                    }
                    throw throwable;
                }
            }
            while (finalServer.hasNext()) {
                ThrottledConnection con = (ThrottledConnection)finalServer.next();
                this.connectionHandler.removeThrottledConnection(con);
            }
        }
    }

    protected boolean isMapMetaDataEnabled() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getRetryMapValue(M3U8Playlist.M3U8Segment segment, String key) {
        Map<String, Object> retryMap = this.getRetryMap(segment, false);
        if (retryMap == null) {
            return null;
        }
        Map<String, Object> map = retryMap;
        synchronized (map) {
            return retryMap.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, Object> getRetryMap(M3U8Playlist.M3U8Segment segment, boolean createMapFlag) {
        Map<M3U8Playlist.M3U8Segment, Map<String, Object>> map = this.segmentRetryMap;
        synchronized (map) {
            Map<String, Object> ret = this.segmentRetryMap.get(segment);
            if (ret != null || !createMapFlag) {
                return ret;
            }
            ret = new HashMap<String, Object>();
            this.segmentRetryMap.put(segment, ret);
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object putRetryMapValue(M3U8Playlist.M3U8Segment segment, String key, Object value) {
        Map<String, Object> retryMap;
        Map<String, Object> map = retryMap = this.getRetryMap(segment, true);
        synchronized (map) {
            if (value == null) {
                return retryMap.remove(key);
            }
            return retryMap.put(key, value);
        }
    }

    protected boolean requiresAdtstoAsc(M3U8Playlist.M3U8Segment segment, String format, FFmpeg ffmpeg) {
        boolean ret = ffmpeg.requiresAdtstoAsc(format);
        if (ret && Boolean.FALSE.equals(this.getRetryMapValue(segment, "aac_adtstoasc"))) {
            ret = false;
        }
        return ret;
    }

    protected ArrayList<String> buildConcatCommandLine(HttpServer server, String format, FFmpeg ffmpeg, String out) {
        FFmpegMetaData ffMpegMetaData;
        ArrayList<String> l = new ArrayList<String>();
        l.add(ffmpeg.getFullPath());
        CONCATSOURCE concatSource = this.getConcatSource();
        if (CrossSystem.isWindows() && CONCATSOURCE.FILE.equals((Object)concatSource)) {
            l.add("-i");
            StringBuilder sb = new StringBuilder();
            sb.append("concat:");
            boolean seperator = false;
            for (PartFile outputPartFile : this.outputPartFiles) {
                if (seperator) {
                    sb.append("|");
                } else {
                    seperator = true;
                }
                sb.append("\\\\?\\" + outputPartFile.file.getAbsolutePath());
            }
            l.add(sb.toString());
        } else {
            l.add("-f");
            l.add("concat");
            l.add("-safe");
            l.add("0");
            l.add("-protocol_whitelist");
            switch (concatSource) {
                case FILE: {
                    l.add("file,http,tcp");
                    break;
                }
                case HTTP: {
                    l.add("http,tcp");
                }
            }
            l.add("-i");
            l.add("http://" + server.getServerAddress() + "/concat?id=" + this.getProcessID());
        }
        if (this.isMapMetaDataEnabled() && (ffMpegMetaData = this.getFFmpegMetaData()) != null && !ffMpegMetaData.isEmpty()) {
            l.add("-i");
            l.add("http://" + server.getServerAddress() + "/meta?id=" + this.getProcessID());
            l.add("-map_metadata");
            l.add("1");
        }
        l.add("-c");
        l.add("copy");
        this.applyBitStreamFilter(l, format, ffmpeg);
        if (CrossSystem.isWindows() && out.length() > 259) {
            l.add("\\\\?\\" + out);
        } else {
            l.add(out);
        }
        l.add("-y");
        return l;
    }

    protected ArrayList<String> buildDownloadCommandLine(HttpServer server, HLSContent content, String format, FFmpeg ffmpeg, String out) {
        FFmpegMetaData ffMpegMetaData;
        ArrayList<String> l = new ArrayList<String>();
        l.add(ffmpeg.getFullPath());
        l.add("-analyzeduration");
        l.add("15000000");
        long processID = this.getProcessID();
        for (int index = 0; index < content.size(); ++index) {
            l.add("-i");
            l.add("http://" + server.getServerAddress() + "/m3u8.m3u8?id=" + processID + "&" + QUERY_M3U8_ID + "=" + content.getId() + "&" + QUERY_M3U8_INDEX + "=" + index);
        }
        if (this.isMapMetaDataEnabled() && (ffMpegMetaData = this.getFFmpegMetaData()) != null && !ffMpegMetaData.isEmpty()) {
            l.add("-i");
            l.add("http://" + server.getServerAddress() + "/meta?id=" + processID);
            l.add("-map_metadata");
            l.add("1");
        }
        this.applyBitStreamFilter(l, format, ffmpeg);
        l.add("-c:v");
        l.add("copy");
        l.add("-c:a");
        l.add("copy");
        l.add("-f");
        l.add(format);
        if (CrossSystem.isWindows() && out.length() > 259) {
            l.add("\\\\?\\" + out);
        } else {
            l.add(out);
        }
        l.add("-y");
        return l;
    }

    protected void applyBitStreamFilter(List<String> cmdLine, String format, FFmpeg ffmpeg) {
        if (format != null && "mpegts".equals(format)) {
            cmdLine.add("-bsf:v");
            cmdLine.add("h264_mp4toannexb");
        }
        if (format != null && this.requiresAdtstoAsc(null, format, ffmpeg)) {
            cmdLine.add("-bsf:a");
            cmdLine.add("aac_adtstoasc");
            this.putRetryMapValue(null, "aac_adtstoasc", Boolean.TRUE);
        }
    }

    protected FFmpegMetaData getFFmpegMetaData() {
        return null;
    }

    protected Browser getRequestBrowser() {
        Browser ret = this.sourceBrowser.cloneBrowser();
        ret.setConnectTimeout(30000);
        ret.setReadTimeout(30000);
        ret.setFollowRedirects(true);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleFileRequest(File file, GetRequest request, HttpResponse response) throws FileNotFoundException, IOException {
        FileInputStream fis = new FileInputStream(file);
        try {
            FileInputStream is;
            long fileSize = file.length();
            response.getResponseHeaders().add(new HTTPHeader("Content-Disposition", "attachment;filename*=UTF-8''" + URLEncoder.encode(file.getName(), "UTF-8")));
            response.getResponseHeaders().add(new HTTPHeader("Accept-Ranges", "bytes"));
            String requestRange = request.getRequestHeaders().getValue("Range");
            long from = 0L;
            long to = fileSize - 1L;
            boolean gotValidRange = false;
            if (requestRange != null) {
                long rangeStart;
                long[] range = HTTPConnectionUtils.parseRequestRange((String)requestRange);
                if (range[0] != -1L && range[1] == -1L) {
                    rangeStart = range[0];
                    if (rangeStart < fileSize - 1L) {
                        from = rangeStart;
                        to = fileSize - 1L;
                        gotValidRange = true;
                    }
                } else if (range[0] != -1L && range[1] == -1L) {
                    rangeStart = range[0];
                    long rangeEnd = range[1];
                    if (rangeStart < fileSize - 1L && rangeEnd > rangeStart && rangeEnd <= fileSize - 1L) {
                        from = rangeStart;
                        to = rangeEnd;
                        gotValidRange = true;
                    }
                }
            }
            if (gotValidRange) {
                long length = 1L + to - from;
                response.setResponseCode((ResponseCodeInterface)HTTPConstants.ResponseCode.SUCCESS_PARTIAL_CONTENT);
                response.getResponseHeaders().add(new HTTPHeader("Content-Length", Long.toString(length)));
                response.getResponseHeaders().add(new HTTPHeader("Content-Range", "bytes " + from + "-" + to + "/" + fileSize));
                fis.getChannel().position(from);
                is = new LimitedInputStream((InputStream)fis, length);
            } else {
                response.setResponseCode((ResponseCodeInterface)HTTPConstants.ResponseCode.SUCCESS_OK);
                response.getResponseHeaders().add(new HTTPHeader("Content-Length", Long.toString(fileSize)));
                is = fis;
            }
            IO.readStreamToOutputStream((int)-1, (InputStream)is, (OutputStream)response.getOutputStream(true), (boolean)false);
        }
        finally {
            fis.close();
        }
    }

    protected HttpServer startHttpServer() throws IOException {
        HttpServer server = new HttpServer(0);
        server.setLocalhostOnly(true);
        server.start();
        return server;
    }

    protected String getSegmentExtension(AbstractFFmpegBinary ffmpeg, M3U8Playlist.M3U8Segment segment) throws Exception {
        String extension;
        CompiledFiletypeFilter.CompiledFiletypeExtension fileType;
        String format = this.getFFmpegFormat(ffmpeg);
        if (format != null) {
            if (format.matches("(?i)^opus$")) {
                return "opus";
            }
            if (format.matches("(?i)^ogg$")) {
                return "ogg";
            }
            if (format.matches("(?i)^flac$")) {
                return "flac";
            }
            if (format.matches("(?i)^mp3$")) {
                return "mp3";
            }
            if (format.matches("(?i)^(mp4|aac|mpegts|h264)$")) {
                return "ts";
            }
        }
        if (CompiledFiletypeFilter.AudioExtensions.AAC.isSameExtensionGroup(fileType = CompiledFiletypeFilter.getExtensionsFilterInterface(extension = Files.getExtension((String)new URL(segment.getUrl()).getPath(), (boolean)true))) || CompiledFiletypeFilter.VideoExtensions.MP4.isSameExtensionGroup(fileType)) {
            return extension;
        }
        return "ts";
    }

    protected boolean isSegmentDownload(GetRequest request) throws IOException {
        String requestedPath = request.getRequestedPath();
        if (requestedPath == null) {
            return false;
        }
        if (requestedPath.matches("^/download(\\.(opus|ogg|flac|mp3|ts))?$")) {
            return true;
        }
        M3U8Playlist.M3U8Segment segment = this.getSegment((HttpRequest)request);
        if (segment == null) {
            return false;
        }
        String extension = Files.getExtension((String)new URL(segment.getUrl()).getPath(), (boolean)true);
        CompiledFiletypeFilter.CompiledFiletypeExtension fileType = CompiledFiletypeFilter.getExtensionsFilterInterface(extension);
        return (CompiledFiletypeFilter.AudioExtensions.AAC.isSameExtensionGroup(fileType) || CompiledFiletypeFilter.VideoExtensions.MP4.isSameExtensionGroup(fileType)) && requestedPath.matches("^/download\\." + Pattern.quote(extension) + "$");
    }

    private HttpServer initPipe(final AbstractFFmpegBinary ffmpeg, final AtomicInteger requestsInProcess) throws IOException {
        final LinkedList connectedMeteredThrottledInputStream = new LinkedList();
        final DelayedRunnable delayedCleanup = new DelayedRunnable(5000L){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void delayedrun() {
                LinkedList linkedList = connectedMeteredThrottledInputStream;
                synchronized (linkedList) {
                    MeteredThrottledInputStream is;
                    while ((is = (MeteredThrottledInputStream)connectedMeteredThrottledInputStream.pollLast()) != null) {
                        if (HLSDownloader.this.connectionHandler == null) continue;
                        HLSDownloader.this.connectionHandler.removeThrottledConnection((ThrottledConnection)is);
                    }
                }
            }
        };
        final HttpServer finalServer = this.startHttpServer();
        finalServer.registerRequestHandler(new HttpRequestHandler(){
            final byte[] readBuf = new byte[512];

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean onPostRequest(PostRequest request, HttpResponse response) {
                requestsInProcess.incrementAndGet();
                try {
                    HLSDownloader.this.logger.info(request.toString());
                    if (!this.validateID((HttpRequest)request)) {
                        boolean bl = false;
                        return bl;
                    }
                    if ("/progress".equals(request.getRequestedPath())) {
                        while (request.getInputStream().read(this.readBuf) != -1) {
                        }
                        response.setResponseCode((ResponseCodeInterface)HTTPConstants.ResponseCode.SUCCESS_OK);
                        boolean bl = true;
                        return bl;
                    }
                }
                catch (Exception e) {
                    HLSDownloader.this.logger.log((Throwable)e);
                }
                finally {
                    AtomicInteger atomicInteger = requestsInProcess;
                    synchronized (atomicInteger) {
                        requestsInProcess.decrementAndGet();
                        requestsInProcess.notifyAll();
                    }
                }
                return false;
            }

            private final boolean validateID(HttpRequest request) throws IOException {
                String id = request.getParameterbyKey("id");
                if (id == null) {
                    return false;
                }
                return HLSDownloader.this.getProcessID() == Long.parseLong(request.getParameterbyKey("id"));
            }

            private final Map<String, Object> parseRetryMap(HttpRequest request) throws Exception {
                String value = request.getParameterbyKey("retryMap");
                if (value == null) {
                    return null;
                }
                return (Map)((DownloadLinkDownloadable)HLSDownloader.this.getDownloadable()).getPlugin().restoreFromString(value, TypeRef.MAP);
            }

            private final String retry(HttpRequest request, int responseCode, int maxRetry) throws Exception {
                Number retryCount;
                Map<String, Object> retryMap = this.parseRetryMap(request);
                if (retryMap == null) {
                    retryMap = new HashMap<String, Object>();
                }
                if ((retryCount = (retryCount = (Number)retryMap.get(String.valueOf(responseCode))) == null ? Integer.valueOf(1) : Integer.valueOf(retryCount.intValue() + 1)).intValue() > maxRetry) {
                    throw new IOException("retry(" + retryCount + ") limit(" + maxRetry + ") reached for responseCode=" + responseCode);
                }
                retryMap.put(String.valueOf(responseCode), retryCount);
                String ret = request.getRequestedURL();
                String retryMapString = URLEncode.encodeURIComponent((String)new SimpleMapper().setPrettyPrintEnabled(false).objectToString(retryMap));
                ret = !ret.contains("retryMap=") ? ret + "&retryMap=" + retryMapString : ret.replaceFirst("(retryMap=.*?)(&|$)", "retryMap=" + Matcher.quoteReplacement(retryMapString));
                return ret;
            }

            private final boolean handleRetry(HttpRequest request, HttpResponse response, URLConnectionAdapter connection) throws Exception {
                if (connection.getResponseCode() == 429) {
                    String location = this.retry(request, 429, 2);
                    Thread.sleep(1000L);
                    response.setResponseCode((ResponseCodeInterface)HTTPConstants.ResponseCode.get((int)302));
                    response.getResponseHeaders().add(new HTTPHeader("Location", location));
                    return true;
                }
                return false;
            }

            /*
             * Exception decompiling
             */
            public boolean onGetRequest(GetRequest request, HttpResponse response) {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [28[TRYBLOCK]], but top level block is 167[FORLOOP]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        });
        return finalServer;
    }

    @Deprecated
    public List<M3U8Playlist> getPlayLists() {
        ArrayList<M3U8Playlist> ret = new ArrayList<M3U8Playlist>();
        for (HLSContent hlsContent : this.hlsContentList) {
            ret.add(hlsContent.getMain());
        }
        return ret;
    }

    protected HLSContent getHLSContent(HttpRequest request) throws IOException {
        String id = request.getParameterbyKey(QUERY_M3U8_ID);
        if (id == null || !id.matches("^\\d+$")) {
            return null;
        }
        return this.getHLSContent(Long.parseLong(id));
    }

    protected M3U8Playlist getPlayList(HttpRequest request) throws IOException {
        HLSContent hlsContent = this.getHLSContent(request);
        if (hlsContent == null) {
            return null;
        }
        String index = request.getParameterbyKey(QUERY_M3U8_INDEX);
        if (index == null || !index.matches("^\\d+$")) {
            return null;
        }
        return hlsContent.get(Integer.parseInt(index));
    }

    protected M3U8Playlist.M3U8Segment getSegment(HttpRequest request) throws IOException {
        M3U8Playlist playList = this.getPlayList(request);
        if (playList == null) {
            return null;
        }
        String segment = request.getParameterbyKey(QUERY_M3U8_SEGMENT);
        if (segment == null || !segment.matches("^\\d+$")) {
            return null;
        }
        return playList.getSegment(Integer.parseInt(segment));
    }

    protected String getSegmentID(HttpRequest request) throws IOException {
        return "m3u8Id=" + request.getParameterbyKey(QUERY_M3U8_ID) + "|m3u8Index=" + request.getParameterbyKey(QUERY_M3U8_INDEX) + "|m3u8Segment=" + request.getParameterbyKey(QUERY_M3U8_SEGMENT);
    }

    protected HLSContent getHLSContent(long id) {
        for (HLSContent hlsContent : this.hlsContentList) {
            if (hlsContent.getId() != id) continue;
            return hlsContent;
        }
        return null;
    }

    protected boolean onSegmentReadException(URLConnectionAdapter connection, IOException e, FileBytesMap fileBytesMap, int retry, LogSource logger) throws Exception {
        try {
            Thread.sleep(250 + retry * 250);
            return true;
        }
        catch (InterruptedException ie) {
            if (logger != null) {
                logger.log((Throwable)ie);
            }
            return false;
        }
    }

    protected boolean onSegmentConnectException(URLConnectionAdapter connection, IOException e, FileBytesMap fileBytesMap, int retry, Map<String, Object> retryMap, LogSource logger) throws Exception {
        try {
            if (connection != null) {
                switch (connection.getResponseCode()) {
                    case 502: 
                    case 503: 
                    case 504: 
                    case 999: {
                        Thread.sleep(250 + retry * 100);
                        return true;
                    }
                }
                return false;
            }
            Thread.sleep(250 + retry * 100);
            return true;
        }
        catch (InterruptedException ie) {
            if (logger != null) {
                logger.log((Throwable)ie);
            }
            return false;
        }
    }

    public long getBytesLoaded() {
        return this.bytesWritten.get();
    }

    @Override
    public ManagedThrottledConnectionHandler getManagedConnetionHandler() {
        return this.connectionHandler;
    }

    @Override
    public URLConnectionAdapter connect(Browser br) throws Exception {
        throw new WTFException("Not needed");
    }

    @Override
    public long getTotalLinkBytesLoadedLive() {
        return this.getBytesLoaded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean startDownload() throws Exception {
        if (this.isEncrypted()) {
            throw new PluginException(131072, "Encrypted HLS(" + (Object)((Object)this.getEncryptionMethod()) + ") is not supported!");
        }
        final ArrayList requiredFiles = new ArrayList();
        try {
            DiskSpaceReservation reservation;
            DownloadPluginProgress downloadPluginProgress;
            block18: {
                this.downloadable.setDownloadInterface(this);
                downloadPluginProgress = null;
                this.downloadable.setConnectionHandler(this.getManagedConnetionHandler());
                reservation = this.downloadable.createDiskSpaceReservation();
                try {
                    if (!this.downloadable.checkIfWeCanWrite(new ExceptionRunnable(){

                        @Override
                        public void run() throws Exception {
                            HLSDownloader.this.downloadable.checkAndReserve(reservation);
                            requiredFiles.addAll(HLSDownloader.this.createOutputChannel());
                            try {
                                HLSDownloader.this.downloadable.lockFiles(requiredFiles.toArray(new File[0]));
                            }
                            catch (FileIsLockedException e) {
                                HLSDownloader.this.downloadable.unlockFiles(requiredFiles.toArray(new File[0]));
                                throw new PluginException(8192, null, e);
                            }
                        }
                    }, null)) {
                        throw new SkipReasonException(SkipReason.INVALID_DESTINATION);
                    }
                    this.startTimeStamp = System.currentTimeMillis();
                    downloadPluginProgress = new DownloadPluginProgress(this.downloadable, this, Color.GREEN.darker());
                    this.downloadable.addPluginProgress(downloadPluginProgress);
                    this.downloadable.setAvailable(DownloadLink.AvailableStatus.TRUE);
                    this.runDownload();
                    if (this.outputPartFiles.size() <= 1) break block18;
                    for (PartFile partFile : this.outputPartFiles) {
                        if (this.isPartFileComplete(partFile)) continue;
                        this.logger.severe("PartFile:" + partFile.file + " not complete");
                        throw new PluginException(512, "PartFile:" + partFile.file + " not complete");
                    }
                    this.runConcat();
                }
                catch (Throwable throwable) {
                    try {
                        this.downloadable.free(reservation);
                    }
                    catch (Throwable e) {
                        LogSource.exception((LogInterface)this.logger, (Throwable)e);
                    }
                    try {
                        long startTimeStamp = this.getStartTimeStamp();
                        if (startTimeStamp > 0L) {
                            this.downloadable.addDownloadTime(System.currentTimeMillis() - this.getStartTimeStamp());
                        }
                    }
                    catch (Throwable throwable2) {
                        // empty catch block
                    }
                    this.downloadable.removePluginProgress(downloadPluginProgress);
                    throw throwable;
                }
            }
            try {
                this.downloadable.free(reservation);
            }
            catch (Throwable e) {
                LogSource.exception((LogInterface)this.logger, (Throwable)e);
            }
            try {
                long startTimeStamp = this.getStartTimeStamp();
                if (startTimeStamp > 0L) {
                    this.downloadable.addDownloadTime(System.currentTimeMillis() - this.getStartTimeStamp());
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.downloadable.removePluginProgress(downloadPluginProgress);
            boolean bl = this.onDownloadReady();
            return bl;
        }
        finally {
            this.downloadable.unlockFiles(requiredFiles.toArray(new File[0]));
            this.cleanupDownladInterface();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void error(PluginException pluginException) {
        HLSDownloader hLSDownloader = this;
        synchronized (hLSDownloader) {
            if (this.externalDownloadStop()) {
                return;
            }
            LogSource.exception((LogInterface)this.logger, (Throwable)pluginException);
            if (this.caughtPluginException == null) {
                this.caughtPluginException = pluginException;
            }
        }
        this.terminate();
    }

    protected boolean onDownloadReady() throws Exception {
        boolean renameOkay;
        this.cleanupDownladInterface();
        if (!this.handleErrors()) {
            return false;
        }
        if (this.outputPartFiles.size() == 1 && !(renameOkay = this.downloadable.rename(this.outputPartFiles.get(0).file, this.outputCompleteFile))) {
            this.error(new PluginException(16384, _JDT.T.system_download_errors_couldnotrename(), 2L));
        }
        return true;
    }

    protected void cleanupDownladInterface() {
        try {
            this.downloadable.removeConnectionHandler(this.getManagedConnetionHandler());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            URLConnectionAdapter currentConnection = this.getConnection();
            if (currentConnection != null) {
                currentConnection.disconnect();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected boolean isM3U8SegmentLoaded(M3U8Playlist.M3U8Segment segment) {
        if (segment != null && segment.getLoaded() >= 0L) {
            long size;
            long loaded = segment.getLoaded();
            double done = (double)(loaded * 100L / (size = Math.max(loaded, segment.getSize()))) / 100.0;
            return done > 0.9;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected M3U8SEGMENTSTATE getM3U8SegmentState(M3U8Playlist.M3U8Segment segment) {
        WeakHashMap<M3U8Playlist.M3U8Segment, M3U8SEGMENTSTATE> weakHashMap = this.m3u8SegmentsStates;
        synchronized (weakHashMap) {
            M3U8SEGMENTSTATE ret = this.m3u8SegmentsStates.get(segment);
            return ret;
        }
    }

    private boolean handleErrors() throws PluginException {
        if (this.externalDownloadStop() && !this.isAcceptDownloadStopAsValidEnd()) {
            return false;
        }
        if (this.caughtPluginException != null) {
            throw this.caughtPluginException;
        }
        if (!this.isAcceptDownloadStopAsValidEnd()) {
            for (HLSContent hlsContent : this.hlsContentList) {
                for (M3U8Playlist m3u8Playlist : hlsContent.list()) {
                    for (int index = 0; index < m3u8Playlist.size(); ++index) {
                        M3U8Playlist.M3U8Segment segment = m3u8Playlist.getSegment(index);
                        if (this.isM3U8SegmentLoaded(segment)) continue;
                        this.logger.severe("Segment(" + index + "/" + m3u8Playlist.size() + "):" + segment.getUrl() + "|Loaded:" + segment.getLoaded() + "|Size:" + segment.getSize());
                        throw new PluginException(2048, "Segment:" + index + " not loaded");
                    }
                }
            }
        }
        for (PartFile partFile : this.outputPartFiles) {
            if (this.isPartFileComplete(partFile)) continue;
            this.logger.severe("PartFile:" + partFile.file + " not complete: exists:" + partFile.file.isFile() + "|size:" + partFile.file.length());
            throw new PluginException(512, "PartFile:" + partFile.file + " not complete");
        }
        if (this.outputPartFiles.size() == 1 && this.isPartFileComplete(this.outputPartFiles.get(0))) {
            this.finalizeDownload(this.outputPartFiles.get(0).file);
            return true;
        }
        if (this.isOutputFileComplete(0, this.outputCompleteFile)) {
            this.finalizeDownload(this.outputCompleteFile);
            return true;
        }
        throw new PluginException(0x400000);
    }

    protected void finalizeDownload(File file) {
        long fileSize = file.length();
        this.downloadable.setLinkStatus(2);
        this.downloadable.setDownloadBytesLoaded(fileSize);
        this.downloadable.setVerifiedFileSize(fileSize);
        if (((GeneralSettings)JsonConfig.create(GeneralSettings.class)).isUseOriginalLastModified()) {
            Long lastModifiedDate = null;
            long lastModifiedTimestampDownloadLink = this.downloadable.getLastModifiedTimestamp();
            if (lastModifiedTimestampDownloadLink != -1L) {
                lastModifiedDate = lastModifiedTimestampDownloadLink;
            }
            if (lastModifiedDate != null) {
                file.setLastModified(lastModifiedDate);
            }
        }
    }

    protected boolean isPartFileComplete(PartFile partFile) {
        return partFile.concatFlag.get() || partFile.downloadFlag.get() && this.isOutputFileComplete(partFile.index, partFile.file);
    }

    protected boolean isOutputFileComplete(int index, File file) {
        return file.isFile() && file.length() > 1024L;
    }

    private List<File> createOutputChannel() throws SkipReasonException {
        try {
            ArrayList<File> requiredFiles = new ArrayList<File>();
            String fileOutput = this.downloadable.getFileOutput();
            this.outputCompleteFile = new File(fileOutput);
            requiredFiles.add(this.outputCompleteFile);
            this.outputPartFiles.clear();
            for (int index = 0; index < this.hlsContentList.size(); ++index) {
                File file = this.hlsContentList.size() > 1 ? new File(this.downloadable.getFileOutputPart() + index + ".part") : new File(this.downloadable.getFileOutputPart() + ".part");
                PartFile partFile = new PartFile(index, file);
                this.outputPartFiles.add(partFile);
                requiredFiles.add(partFile.file);
            }
            return requiredFiles;
        }
        catch (Exception e) {
            LogSource.exception((LogInterface)this.logger, (Throwable)e);
            throw new SkipReasonException(SkipReason.INVALID_DESTINATION, e);
        }
    }

    @Override
    public URLConnectionAdapter getConnection() {
        return this.currentConnection;
    }

    protected boolean checkAbortDownloadCondition(M3U8Playlist playList, M3U8Playlist.M3U8Segment segment) {
        if (this.externalDownloadStop()) {
            return true;
        }
        int index = playList.indexOf(segment);
        if (index != -1) {
            HashSet<M3U8Playlist.M3U8Segment> failed = new HashSet<M3U8Playlist.M3U8Segment>();
            for (int checkPreviousSegmentIndex = index - 1; checkPreviousSegmentIndex >= 0; --checkPreviousSegmentIndex) {
                M3U8Playlist.M3U8Segment check = playList.getSegment(checkPreviousSegmentIndex);
                if (this.getM3U8SegmentState(check) == null || this.isM3U8SegmentLoaded(check)) continue;
                failed.add(check);
                if (failed.size() <= 5) continue;
                this.logger.info("Too many failed segments:" + failed);
                this.terminate();
                return true;
            }
        }
        return false;
    }

    @Override
    public void stopDownload() {
        if (!this.abort.getAndSet(true)) {
            this.logger.info("externalStop recieved");
            this.terminate();
        }
    }

    @Override
    public boolean externalDownloadStop() {
        return this.abort.get();
    }

    @Override
    public long getStartTimeStamp() {
        return this.startTimeStamp;
    }

    @Override
    public void close() {
        URLConnectionAdapter currentConnection = this.getConnection();
        if (currentConnection != null) {
            currentConnection.disconnect();
        }
    }

    @Override
    public Downloadable getDownloadable() {
        return this.downloadable;
    }

    @Override
    public boolean isResumedDownload() {
        return false;
    }

    public void setAcceptDownloadStopAsValidEnd(boolean b) {
        this.acceptDownloadStopAsValidEnd = b;
    }

    public boolean isAcceptDownloadStopAsValidEnd() {
        return this.acceptDownloadStopAsValidEnd;
    }

    static /* synthetic */ Map access$1300(HLSDownloader x0) {
        return x0.fileMap;
    }

    static /* synthetic */ WeakHashMap access$1400(HLSDownloader x0) {
        return x0.m3u8SegmentsStates;
    }

    static /* synthetic */ HashMap access$1500(HLSDownloader x0) {
        return x0.aes128Keys;
    }

    public static enum M3U8SEGMENTSTATE {
        NOT_LOADED,
        UNKNOWN,
        ONLINE,
        FAILED;

    }

    private class HttpServerThread {
        private final String id;
        private final HttpServer server;

        private HttpServerThread(String id, HttpServer server) {
            this.id = id;
            this.server = server;
        }

        private void stop() {
            this.server.stop();
        }
    }

    public static enum CONCATSOURCE {
        HTTP,
        FILE;

    }

    private class PartFile {
        private final File file;
        private final int index;
        private final AtomicBoolean downloadFlag = new AtomicBoolean(false);
        private final AtomicBoolean concatFlag = new AtomicBoolean(false);

        private PartFile(int index, File file) {
            this.index = index;
            this.file = file;
        }
    }
}

