/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.downloader.segment;

import java.io.IOException;
import jd.http.Browser;
import jd.http.Request;
import jd.http.URLConnectionAdapter;
import jd.http.requests.GetRequest;
import jd.plugins.download.raf.ChunkRange;
import org.appwork.utils.net.HTTPHeader;

public class Segment {
    protected final String url;
    private final ChunkRange chunkRange;

    public boolean isLoaded() {
        return this.chunkRange.isValidLoaded();
    }

    public String getUrl() {
        return this.url;
    }

    public Segment(String url) {
        this(url, null, null);
    }

    public Segment(String url, Long range_from, Long range_to) {
        this.url = url;
        this.chunkRange = range_from != null ? new ChunkRange(range_from, range_to) : new ChunkRange();
    }

    public ChunkRange getChunkRange() {
        return this.chunkRange;
    }

    protected Request createRequest() throws IOException {
        GetRequest ret = new GetRequest(this.getUrl());
        ret.getHeaders().put(new HTTPHeader("Accept-Encoding", "identity", false));
        ChunkRange chunkRange = this.getChunkRange();
        if (chunkRange != null && chunkRange.isRangeRequested()) {
            String requestedRange = chunkRange.getRangeHeaderContent(false);
            ret.getHeaders().put(new HTTPHeader("Range", requestedRange, false));
        }
        return ret;
    }

    protected URLConnectionAdapter open(Browser br, Request request) throws IOException {
        br.setRequest(null);
        URLConnectionAdapter ret = br.openRequestConnection(request);
        return ret;
    }

    protected boolean isConnectionValid(URLConnectionAdapter con) throws IOException {
        return con.getResponseCode() == 200 || con.getResponseCode() == 206;
    }

    protected Boolean retrySegmentConnection(Browser br, Segment segment, int segmentRetryCounter) {
        return null;
    }

    public String toString() {
        ChunkRange chunkRange = this.getChunkRange();
        return "URL:" + this.getUrl() + "|" + chunkRange;
    }
}

