/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.downloader.segment;

import java.awt.Color;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import jd.controlling.downloadcontroller.DiskSpaceReservation;
import jd.controlling.downloadcontroller.ExceptionRunnable;
import jd.controlling.downloadcontroller.FileIsLockedException;
import jd.controlling.downloadcontroller.ManagedThrottledConnectionHandler;
import jd.http.Browser;
import jd.http.Request;
import jd.http.URLConnectionAdapter;
import jd.plugins.DownloadLink;
import jd.plugins.PluginException;
import jd.plugins.PluginForHost;
import jd.plugins.download.DownloadInterface;
import jd.plugins.download.DownloadLinkDownloadable;
import jd.plugins.download.Downloadable;
import jd.plugins.download.raf.HTTPDownloader;
import org.appwork.exceptions.WTFException;
import org.appwork.storage.config.JsonConfig;
import org.appwork.utils.formatter.TimeFormatter;
import org.appwork.utils.logging2.LogInterface;
import org.appwork.utils.logging2.LogSource;
import org.appwork.utils.net.NullInputStream;
import org.appwork.utils.net.URLHelper;
import org.appwork.utils.net.httpconnection.HTTPConnection;
import org.appwork.utils.net.httpconnection.HTTPConnectionUtils;
import org.appwork.utils.net.throttledconnection.MeteredThrottledInputStream;
import org.appwork.utils.net.throttledconnection.ThrottledConnection;
import org.appwork.utils.speedmeter.AverageSpeedMeter;
import org.appwork.utils.speedmeter.SpeedMeterInterface;
import org.jdownloader.downloader.segment.Segment;
import org.jdownloader.plugins.DownloadPluginProgress;
import org.jdownloader.plugins.SkipReason;
import org.jdownloader.plugins.SkipReasonException;
import org.jdownloader.settings.GeneralSettings;
import org.jdownloader.translate._JDT;

public class SegmentDownloader
extends DownloadInterface {
    protected volatile long bytesWritten = 0L;
    private final Downloadable downloadable;
    private final DownloadLink link;
    private long startTimeStamp = -1L;
    private final LogInterface logger;
    private volatile URLConnectionAdapter currentConnection;
    private final ManagedThrottledConnectionHandler connectionHandler = new ManagedThrottledConnectionHandler();
    private File outputCompleteFile;
    private File outputFinalCompleteFile;
    private File outputPartFile;
    private PluginException caughtPluginException;
    protected final Browser obr;
    protected final List<Segment> segments = new ArrayList<Segment>();
    protected Long lastModified = null;
    private final AtomicBoolean abort = new AtomicBoolean(false);
    private final AtomicBoolean terminated = new AtomicBoolean(false);

    @Deprecated
    public static List<Segment> buildSegments(URL baseURL, String[] segments) {
        ArrayList<Segment> ret = new ArrayList<Segment>();
        for (String segment : segments) {
            ret.add(new Segment(URLHelper.parseLocation((URL)baseURL, (String)segment)));
        }
        return ret;
    }

    @Deprecated
    public SegmentDownloader(PluginForHost plugin, DownloadLink link, Downloadable dashDownloadable, Browser br, URL baseURL, String[] segments) {
        this(plugin, link, dashDownloadable, br, SegmentDownloader.buildSegments(baseURL, segments));
    }

    public SegmentDownloader(PluginForHost plugin, DownloadLink link, Downloadable dashDownloadable, Browser br2, List<Segment> segments) {
        this.obr = br2.cloneBrowser();
        this.link = link;
        this.logger = plugin.getLogger();
        this.segments.addAll(segments);
        this.downloadable = dashDownloadable == null ? new DownloadLinkDownloadable(link){

            @Override
            public boolean isResumable() {
                return false;
            }
        } : dashDownloadable;
        this.downloadable.setDownloadInterface(this);
    }

    protected void terminate() {
        if (!this.terminated.getAndSet(true) && !this.externalDownloadStop()) {
            this.logger.severe("A critical Downloaderror occured. Terminate...");
        }
    }

    private void close(Closeable closable) {
        try {
            if (closable != null) {
                closable.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected boolean retrySegmentConnection(Browser br, Segment segment, int segmentRetryCounter) throws InterruptedException, PluginException {
        Boolean retry = segment.retrySegmentConnection(br, segment, segmentRetryCounter);
        if (retry != null) {
            return retry;
        }
        URLConnectionAdapter con = br.getHttpConnection();
        return !this.externalDownloadStop() && segmentRetryCounter == 0 && (con.getResponseCode() == 404 || con.getResponseCode() == 502);
    }

    protected boolean isSegmentConnectionValid(Segment segment, URLConnectionAdapter con) throws IOException, PluginException {
        return segment.isConnectionValid(con);
    }

    protected URLConnectionAdapter openSegmentConnection(Segment segment) throws IOException, PluginException, InterruptedException {
        int segmentRetryCounter = 0;
        while (!this.externalDownloadStop()) {
            Request request;
            Browser br = this.obr.cloneBrowser();
            URLConnectionAdapter ret = segment.open(br, request = this.createSegmentRequest(segment));
            if (!this.isSegmentConnectionValid(segment, ret)) {
                br.followConnection(true);
                if (this.retrySegmentConnection(br, segment, segmentRetryCounter)) {
                    ++segmentRetryCounter;
                    continue;
                }
                throw new IOException("Invalid responseCode:" + ret.getResponseCode() + "|RetryCounter:" + segmentRetryCounter + "|Segment:" + segment.getUrl());
            }
            return ret;
        }
        throw new PluginException(4, "externalDownloadStop");
    }

    protected InputStream getInputStream(Segment segment, URLConnectionAdapter connection) throws IOException, PluginException {
        return connection.getInputStream();
    }

    protected int writeSegment(Segment segment, URLConnectionAdapter con, RandomAccessFile outputStream, byte[] buf, int index, int len) throws IOException {
        outputStream.write(buf, index, len);
        segment.getChunkRange().incLoaded(len);
        return len;
    }

    protected int readSegment(Segment segment, URLConnectionAdapter con, InputStream is, byte[] buf) throws IOException {
        return is.read(buf);
    }

    protected void onSegmentClose(RandomAccessFile outputStream, Segment segment, URLConnectionAdapter con) throws IOException {
    }

    protected long onSegmentStart(RandomAccessFile outputStream, Segment segment, URLConnectionAdapter con) throws IOException {
        long[] range = HTTPConnectionUtils.parseRequestRange((HTTPConnection)con);
        if (range != null && range[0] != -1L) {
            outputStream.seek(range[0]);
            this.bytesWritten = range[0];
        }
        return this.bytesWritten;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws Exception {
        RandomAccessFile outputStream;
        this.link.setDownloadSize(-1L);
        boolean isResumedDownload = this.isResumedDownload();
        try {
            outputStream = new RandomAccessFile(this.outputPartFile, "rw");
        }
        catch (IOException e) {
            throw new SkipReasonException(SkipReason.INVALID_DESTINATION, e);
        }
        MeteredThrottledInputStream meteredThrottledInputStream = new MeteredThrottledInputStream((InputStream)new NullInputStream(), (SpeedMeterInterface)new AverageSpeedMeter(10));
        boolean localIO = false;
        try {
            if (!isResumedDownload) {
                outputStream.getChannel().truncate(0L);
            }
            String cust = this.link.getCustomExtension();
            this.link.setCustomExtension(null);
            this.link.setCustomExtension(cust);
            byte[] readWriteBuffer = new byte[524288];
            if (this.connectionHandler != null) {
                this.connectionHandler.addThrottledConnection((ThrottledConnection)meteredThrottledInputStream);
            }
            block18: for (Segment segment : this.segments) {
                if (this.externalDownloadStop()) continue;
                try {
                    Date last;
                    this.currentConnection = this.openSegmentConnection(segment);
                    if (this.lastModified == null && (last = TimeFormatter.parseDateString((String)this.currentConnection.getHeaderField("Last-Modified"))) != null) {
                        this.lastModified = last.getTime();
                    }
                    segment.getChunkRange().setValidLoaded(true);
                    meteredThrottledInputStream.setInputStream(this.getInputStream(segment, this.currentConnection));
                    this.bytesWritten = this.onSegmentStart(outputStream, segment, this.currentConnection);
                    while (!this.externalDownloadStop()) {
                        int read = this.readSegment(segment, this.currentConnection, (InputStream)meteredThrottledInputStream, readWriteBuffer);
                        if (read > 0) {
                            localIO = true;
                            this.bytesWritten += (long)this.writeSegment(segment, this.currentConnection, outputStream, readWriteBuffer, 0, read);
                            localIO = false;
                            this.downloadable.setDownloadBytesLoaded(this.bytesWritten);
                            continue;
                        }
                        if (read != -1) continue;
                        continue block18;
                    }
                }
                finally {
                    URLConnectionAdapter lCurrentConnection = this.currentConnection;
                    this.currentConnection = null;
                    if (lCurrentConnection == null) continue;
                    try {
                        this.onSegmentClose(outputStream, segment, lCurrentConnection);
                    }
                    finally {
                        lCurrentConnection.disconnect();
                    }
                }
            }
        }
        catch (IOException e) {
            if (localIO) {
                throw new SkipReasonException(SkipReason.DISK_FULL);
            }
            throw e;
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (PluginException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new PluginException(0x400000, e.getMessage(), -1L, e);
        }
        finally {
            this.close(outputStream);
            if (this.connectionHandler != null && meteredThrottledInputStream != null) {
                this.connectionHandler.removeThrottledConnection((ThrottledConnection)meteredThrottledInputStream);
            }
        }
    }

    protected Request createSegmentRequest(Segment seg) throws IOException {
        Request ret = seg.createRequest();
        return ret;
    }

    public long getBytesLoaded() {
        return this.bytesWritten;
    }

    @Override
    public ManagedThrottledConnectionHandler getManagedConnetionHandler() {
        return this.connectionHandler;
    }

    @Override
    public URLConnectionAdapter connect(Browser br) throws Exception {
        throw new WTFException("Not needed");
    }

    @Override
    public long getTotalLinkBytesLoadedLive() {
        return this.getBytesLoaded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public boolean startDownload() throws Exception {
        String fileOutput = this.downloadable.getFileOutput();
        String finalFileOutput = this.downloadable.getFinalFileOutput();
        this.outputFinalCompleteFile = this.outputCompleteFile = new File(fileOutput);
        if (!fileOutput.equals(finalFileOutput)) {
            this.outputFinalCompleteFile = new File(finalFileOutput);
        }
        this.outputPartFile = new File(this.downloadable.getFileOutputPart());
        DownloadPluginProgress downloadPluginProgress = null;
        this.downloadable.setConnectionHandler(this.getManagedConnetionHandler());
        final DiskSpaceReservation reservation = this.downloadable.createDiskSpaceReservation();
        if (!this.downloadable.checkIfWeCanWrite(new ExceptionRunnable(){

            @Override
            public void run() throws Exception {
                SegmentDownloader.this.downloadable.checkAndReserve(reservation);
                SegmentDownloader.this.createOutputChannel();
                try {
                    SegmentDownloader.this.downloadable.lockFiles(SegmentDownloader.this.outputCompleteFile, SegmentDownloader.this.outputFinalCompleteFile, SegmentDownloader.this.outputPartFile);
                }
                catch (FileIsLockedException e) {
                    SegmentDownloader.this.downloadable.unlockFiles(SegmentDownloader.this.outputCompleteFile, SegmentDownloader.this.outputFinalCompleteFile, SegmentDownloader.this.outputPartFile);
                    throw new PluginException(8192, null, e);
                }
            }
        }, null)) {
            throw new SkipReasonException(SkipReason.INVALID_DESTINATION);
        }
        this.startTimeStamp = System.currentTimeMillis();
        downloadPluginProgress = new DownloadPluginProgress(this.downloadable, this, Color.GREEN.darker());
        this.downloadable.addPluginProgress(downloadPluginProgress);
        this.downloadable.setAvailable(DownloadLink.AvailableStatus.TRUE);
        this.run();
        boolean bl = this.onDownloadReady();
        try {
            this.downloadable.free(reservation);
        }
        catch (Throwable e) {
            this.logger.log(e);
        }
        try {
            long startTimeStamp = this.getStartTimeStamp();
            if (startTimeStamp > 0L) {
                this.downloadable.addDownloadTime(System.currentTimeMillis() - this.getStartTimeStamp());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.downloadable.removePluginProgress(downloadPluginProgress);
        this.downloadable.unlockFiles(this.outputCompleteFile, this.outputFinalCompleteFile, this.outputPartFile);
        this.cleanupDownladInterface();
        return bl;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        this.downloadable.free(reservation);
                    }
                    catch (Throwable e) {
                        this.logger.log(e);
                    }
                    try {
                        long startTimeStamp = this.getStartTimeStamp();
                        if (startTimeStamp > 0L) {
                            this.downloadable.addDownloadTime(System.currentTimeMillis() - this.getStartTimeStamp());
                        }
                    }
                    catch (Throwable throwable2) {
                        // empty catch block
                    }
                    this.downloadable.removePluginProgress(downloadPluginProgress);
                    throw throwable;
                }
                catch (Throwable throwable3) {
                    this.downloadable.unlockFiles(this.outputCompleteFile, this.outputFinalCompleteFile, this.outputPartFile);
                    this.cleanupDownladInterface();
                    throw throwable3;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void error(PluginException pluginException) {
        SegmentDownloader segmentDownloader = this;
        synchronized (segmentDownloader) {
            if (this.externalDownloadStop()) {
                return;
            }
            this.logger.log((Throwable)pluginException);
            if (this.caughtPluginException == null) {
                this.caughtPluginException = pluginException;
            }
        }
        this.terminate();
    }

    protected boolean onDownloadReady() throws Exception {
        this.cleanupDownladInterface();
        if (!this.handleErrors(this.outputPartFile)) {
            return false;
        }
        boolean renameOkay = this.finalizeDownload(this.outputPartFile, this.outputCompleteFile, this.lastModified);
        if (!renameOkay) {
            this.error(new PluginException(16384, _JDT.T.system_download_errors_couldnotrename(), 2L));
            return false;
        }
        return true;
    }

    protected boolean finalizeDownload(File outputPartFile, File outputCompleteFile, Long lastModified) throws Exception {
        if (!this.downloadable.rename(outputPartFile, outputCompleteFile)) {
            return false;
        }
        try {
            boolean useOriginalLastModified = ((GeneralSettings)JsonConfig.create(GeneralSettings.class)).isUseOriginalLastModified();
            if (useOriginalLastModified) {
                Date lastModifiedDate = HTTPDownloader.getLastModifiedDate(this.getDownloadable(), null);
                if (lastModifiedDate != null) {
                    outputCompleteFile.setLastModified(lastModifiedDate.getTime());
                    return true;
                }
                if (lastModified != null && lastModified != -1L) {
                    outputCompleteFile.setLastModified(lastModified);
                    return true;
                }
            }
            outputCompleteFile.setLastModified(System.currentTimeMillis());
        }
        catch (Throwable ignore) {
            LogSource.exception((LogInterface)this.logger, (Throwable)ignore);
        }
        return true;
    }

    protected void cleanupDownladInterface() {
    }

    protected void checkComplete(List<Segment> segments, long fileSize) throws PluginException {
        for (Segment segment : segments) {
            if (segment.isLoaded()) continue;
            throw new PluginException(2048, "Segment:" + segment.getUrl() + " not loaded");
        }
        if (this.downloadable.getVerifiedFileSize() > 0L && this.downloadable.getVerifiedFileSize() != fileSize) {
            throw new PluginException(512, "Verified:" + this.downloadable.getVerifiedFileSize() + " != Filesize:" + fileSize);
        }
    }

    protected boolean handleErrors(File file) throws PluginException {
        if (this.externalDownloadStop()) {
            return false;
        }
        if (this.caughtPluginException == null) {
            if (!file.isFile()) {
                throw new PluginException(0x400000);
            }
            long fileSize = file.length();
            this.checkComplete(this.segments, fileSize);
            this.downloadable.setDownloadBytesLoaded(fileSize);
            this.downloadable.setVerifiedFileSize(fileSize);
            this.downloadable.setLinkStatus(2);
            return true;
        }
        throw this.caughtPluginException;
    }

    private void createOutputChannel() throws SkipReasonException {
        try {
            String fileOutput = this.downloadable.getFileOutput();
            this.logger.info("createOutputChannel for " + fileOutput);
            String finalFileOutput = this.downloadable.getFinalFileOutput();
            this.outputFinalCompleteFile = this.outputCompleteFile = new File(fileOutput);
            if (!fileOutput.equals(finalFileOutput)) {
                this.outputFinalCompleteFile = new File(finalFileOutput);
            }
        }
        catch (Exception e) {
            this.logger.log((Throwable)e);
            throw new SkipReasonException(SkipReason.INVALID_DESTINATION, e);
        }
    }

    @Override
    public URLConnectionAdapter getConnection() {
        return this.currentConnection;
    }

    @Override
    public void stopDownload() {
        URLConnectionAdapter lCurrentConnection;
        if (!this.abort.getAndSet(true)) {
            this.logger.info("externalStop recieved");
            this.terminate();
        }
        if ((lCurrentConnection = this.currentConnection) != null) {
            lCurrentConnection.disconnect();
        }
    }

    @Override
    public boolean externalDownloadStop() {
        return this.abort.get();
    }

    @Override
    public long getStartTimeStamp() {
        return this.startTimeStamp;
    }

    @Override
    public void close() {
        URLConnectionAdapter lCurrentConnection = this.currentConnection;
        if (lCurrentConnection != null) {
            lCurrentConnection.disconnect();
        }
    }

    @Override
    public Downloadable getDownloadable() {
        return this.downloadable;
    }

    @Override
    public boolean isResumedDownload() {
        return false;
    }
}

