/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.downloader.text;

import java.awt.Color;
import java.io.File;
import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;
import jd.controlling.downloadcontroller.DiskSpaceReservation;
import jd.controlling.downloadcontroller.ExceptionRunnable;
import jd.controlling.downloadcontroller.FileIsLockedException;
import jd.controlling.downloadcontroller.ManagedThrottledConnectionHandler;
import jd.http.Browser;
import jd.http.URLConnectionAdapter;
import jd.plugins.DownloadLink;
import jd.plugins.PluginException;
import jd.plugins.PluginForHost;
import jd.plugins.download.DownloadInterface;
import jd.plugins.download.DownloadLinkDownloadable;
import jd.plugins.download.Downloadable;
import jd.plugins.download.raf.HTTPDownloader;
import org.appwork.exceptions.WTFException;
import org.appwork.storage.config.JsonConfig;
import org.appwork.utils.IO;
import org.appwork.utils.logging2.LogInterface;
import org.appwork.utils.logging2.LogSource;
import org.jdownloader.plugins.DownloadPluginProgress;
import org.jdownloader.plugins.SkipReason;
import org.jdownloader.plugins.SkipReasonException;
import org.jdownloader.settings.GeneralSettings;

public class TextDownloader
extends DownloadInterface {
    protected volatile long bytesWritten = 0L;
    private final Downloadable downloadable;
    private File outputCompleteFile;
    private File outputFinalCompleteFile;
    private String textToWrite = null;
    private ManagedThrottledConnectionHandler connectionHandler = new ManagedThrottledConnectionHandler();
    private long startTimeStamp = -1L;
    private final AtomicBoolean abort = new AtomicBoolean(false);

    public boolean isResumable() {
        return false;
    }

    public TextDownloader(PluginForHost plugin, DownloadLink link, String text) {
        if (plugin == null || link == null) {
            throw new IllegalArgumentException();
        }
        if (text == null) {
            throw new IllegalArgumentException("text can't be null");
        }
        this.downloadable = new DownloadLinkDownloadable(link);
        this.downloadable.setDownloadInterface(this);
        this.textToWrite = text;
    }

    public long getBytesLoaded() {
        return this.bytesWritten;
    }

    @Override
    public ManagedThrottledConnectionHandler getManagedConnetionHandler() {
        return this.connectionHandler;
    }

    @Override
    public URLConnectionAdapter connect(Browser br) throws Exception {
        throw new WTFException("Not needed");
    }

    @Override
    public long getTotalLinkBytesLoadedLive() {
        return this.getBytesLoaded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean startDownload() throws Exception {
        try {
            boolean bl;
            try {
                this.downloadable.validateLastChallengeResponse();
            }
            catch (Throwable e) {
                LogSource.exception((LogInterface)this.downloadable.getLogger(), (Throwable)e);
            }
            this.downloadable.getLogger().finer("Start Download");
            try {
                String textToWrite = this.textToWrite;
                if (textToWrite == null) {
                    throw new PluginException(0x400000);
                }
                DownloadPluginProgress downloadPluginProgress = null;
                this.downloadable.setConnectionHandler(this.getManagedConnetionHandler());
                final DiskSpaceReservation reservation = this.downloadable.createDiskSpaceReservation();
                try {
                    if (!this.downloadable.checkIfWeCanWrite(new ExceptionRunnable(){

                        @Override
                        public void run() throws Exception {
                            TextDownloader.this.downloadable.checkAndReserve(reservation);
                            TextDownloader.this.createOutputChannel();
                            try {
                                TextDownloader.this.downloadable.lockFiles(TextDownloader.this.outputCompleteFile, TextDownloader.this.outputFinalCompleteFile);
                            }
                            catch (FileIsLockedException e) {
                                TextDownloader.this.downloadable.unlockFiles(TextDownloader.this.outputCompleteFile, TextDownloader.this.outputFinalCompleteFile);
                                throw new PluginException(8192, null, e);
                            }
                        }
                    }, null)) {
                        throw new SkipReasonException(SkipReason.INVALID_DESTINATION);
                    }
                    this.startTimeStamp = System.currentTimeMillis();
                    downloadPluginProgress = new DownloadPluginProgress(this.downloadable, this, Color.GREEN.darker());
                    this.downloadable.addPluginProgress(downloadPluginProgress);
                    this.downloadable.setAvailable(DownloadLink.AvailableStatus.TRUE);
                    IO.writeToFile((File)this.outputFinalCompleteFile, (byte[])textToWrite.getBytes("UTF-8"), (IO.SYNC)IO.SYNC.META_AND_DATA);
                    this.bytesWritten = this.outputFinalCompleteFile.length();
                    this.downloadable.setVerifiedFileSize(this.bytesWritten);
                    this.downloadable.setDownloadBytesLoaded(this.bytesWritten);
                    this.finalizeDownload(this.outputCompleteFile);
                    this.downloadable.setLinkStatus(2);
                }
                catch (Throwable throwable) {
                    try {
                        this.downloadable.free(reservation);
                    }
                    catch (Throwable e) {
                        LogSource.exception((LogInterface)this.downloadable.getLogger(), (Throwable)e);
                    }
                    try {
                        long startTimeStamp = this.getStartTimeStamp();
                        if (startTimeStamp > 0L) {
                            this.downloadable.addDownloadTime(System.currentTimeMillis() - this.getStartTimeStamp());
                        }
                    }
                    catch (Throwable throwable2) {
                        // empty catch block
                    }
                    this.downloadable.removePluginProgress(downloadPluginProgress);
                    throw throwable;
                }
                try {
                    this.downloadable.free(reservation);
                }
                catch (Throwable e) {
                    LogSource.exception((LogInterface)this.downloadable.getLogger(), (Throwable)e);
                }
                try {
                    long startTimeStamp = this.getStartTimeStamp();
                    if (startTimeStamp > 0L) {
                        this.downloadable.addDownloadTime(System.currentTimeMillis() - this.getStartTimeStamp());
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.downloadable.removePluginProgress(downloadPluginProgress);
                bl = true;
            }
            catch (Throwable throwable) {
                try {
                    this.cleanupDownladInterface();
                }
                catch (Throwable throwable3) {
                    this.downloadable.unlockFiles(this.outputCompleteFile, this.outputFinalCompleteFile);
                    throw throwable3;
                }
                this.downloadable.unlockFiles(this.outputCompleteFile, this.outputFinalCompleteFile);
                throw throwable;
            }
            try {
                this.cleanupDownladInterface();
            }
            catch (Throwable throwable) {
                this.downloadable.unlockFiles(this.outputCompleteFile, this.outputFinalCompleteFile);
                throw throwable;
            }
            this.downloadable.unlockFiles(this.outputCompleteFile, this.outputFinalCompleteFile);
            return bl;
        }
        finally {
            this.cleanupDownladInterface();
        }
    }

    protected boolean finalizeDownload(File outputCompleteFile) throws Exception {
        try {
            Date lastModified = HTTPDownloader.getLastModifiedDate(this.getDownloadable(), null);
            if (lastModified != null && ((GeneralSettings)JsonConfig.create(GeneralSettings.class)).isUseOriginalLastModified()) {
                outputCompleteFile.setLastModified(lastModified.getTime());
            } else {
                outputCompleteFile.setLastModified(System.currentTimeMillis());
            }
        }
        catch (Throwable ignore) {
            LogSource.exception((LogInterface)this.downloadable.getLogger(), (Throwable)ignore);
        }
        return true;
    }

    protected void cleanupDownladInterface() {
        this.textToWrite = null;
    }

    private void createOutputChannel() throws SkipReasonException {
        try {
            String fileOutput = this.downloadable.getFileOutput();
            this.downloadable.getLogger().info("createOutputChannel for " + fileOutput);
            String finalFileOutput = this.downloadable.getFinalFileOutput();
            this.outputFinalCompleteFile = this.outputCompleteFile = new File(fileOutput);
            if (!fileOutput.equals(finalFileOutput)) {
                this.outputFinalCompleteFile = new File(finalFileOutput);
            }
        }
        catch (Exception e) {
            this.downloadable.getLogger().log((Throwable)e);
            throw new SkipReasonException(SkipReason.INVALID_DESTINATION, e);
        }
    }

    @Override
    public URLConnectionAdapter getConnection() {
        return null;
    }

    @Override
    public void stopDownload() {
        if (!this.abort.getAndSet(true)) {
            this.downloadable.getLogger().info("externalStop recieved");
        }
    }

    @Override
    public boolean externalDownloadStop() {
        return this.abort.get();
    }

    @Override
    public long getStartTimeStamp() {
        return this.startTimeStamp;
    }

    @Override
    public void close() {
    }

    @Override
    public Downloadable getDownloadable() {
        return this.downloadable;
    }

    @Override
    public boolean isResumedDownload() {
        return false;
    }
}

