/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.extensions;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipInputStream;
import jd.SecondLevelLaunch;
import jd.gui.swing.jdgui.JDGui;
import jd.gui.swing.jdgui.WarnLevel;
import org.appwork.exceptions.WTFException;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.TypeRef;
import org.appwork.uio.CloseReason;
import org.appwork.uio.ConfirmDialogInterface;
import org.appwork.uio.UIOManager;
import org.appwork.utils.Application;
import org.appwork.utils.DebugMode;
import org.appwork.utils.Exceptions;
import org.appwork.utils.IO;
import org.appwork.utils.StringUtils;
import org.appwork.utils.event.DefaultEvent;
import org.appwork.utils.io.J7FileList;
import org.appwork.utils.logging2.LogSource;
import org.appwork.utils.logging2.extmanager.LoggerFactory;
import org.appwork.utils.os.CrossSystem;
import org.appwork.utils.swing.dialog.ConfirmDialog;
import org.appwork.utils.swing.dialog.Dialog;
import org.jdownloader.controlling.FileCreationManager;
import org.jdownloader.controlling.contextmenu.ActionData;
import org.jdownloader.controlling.contextmenu.ContextMenuManager;
import org.jdownloader.controlling.contextmenu.MenuContainerRoot;
import org.jdownloader.controlling.contextmenu.MenuExtenderHandler;
import org.jdownloader.controlling.contextmenu.MenuItemData;
import org.jdownloader.extensions.AbstractExtension;
import org.jdownloader.extensions.ExtensionControllerEvent;
import org.jdownloader.extensions.ExtensionControllerEventSender;
import org.jdownloader.extensions.ExtensionNotLoadedException;
import org.jdownloader.extensions.ExtensionQuickToggleAction;
import org.jdownloader.extensions.LazyExtension;
import org.jdownloader.extensions.OptionalExtension;
import org.jdownloader.extensions.StartException;
import org.jdownloader.extensions.StopException;
import org.jdownloader.gui.mainmenu.MenuManagerMainmenu;
import org.jdownloader.gui.mainmenu.container.ExtensionsMenuContainer;
import org.jdownloader.gui.mainmenu.container.OptionalContainer;
import org.jdownloader.gui.toolbar.MenuManagerMainToolbar;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.logging.LogController;
import org.jdownloader.translate._JDT;
import org.jdownloader.updatev2.UpdateController;

public class ExtensionController
implements MenuExtenderHandler {
    private static final String TMP_INVALIDEXTENSIONS = "invalidextensions";
    private static final ExtensionController INSTANCE = new ExtensionController();
    private volatile List<LazyExtension> list = new ArrayList<LazyExtension>();
    private static final Map<String, String> MAPPING = new HashMap<String, String>();
    private final ExtensionControllerEventSender eventSender;
    private final LogSource logger;
    private boolean cacheInvalidated = false;
    private volatile List<OptionalExtension> optionalExtensions = new ArrayList<OptionalExtension>();

    public static ExtensionController getInstance() {
        return INSTANCE;
    }

    private ExtensionController() {
        this.eventSender = new ExtensionControllerEventSender();
        this.logger = LogController.getInstance().getLogger(ExtensionController.class.getName());
    }

    private File getCache() {
        return Application.getTempResource((String)"extensioncache/extensionInfos.json");
    }

    public ExtensionControllerEventSender getEventSender() {
        return this.eventSender;
    }

    public boolean isCacheInvalidated() {
        return this.cacheInvalidated;
    }

    public void invalidateCache() {
        this.cacheInvalidated = true;
    }

    protected void validateCache() {
        this.cacheInvalidated = false;
        FileCreationManager.getInstance().delete(Application.getTempResource((String)TMP_INVALIDEXTENSIONS), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        ExtensionController extensionController = this;
        synchronized (extensionController) {
            List<Object> ret;
            block20: {
                ret = new ArrayList();
                long t = System.currentTimeMillis();
                try {
                    if (this.isCacheInvalidated()) {
                        try {
                            ret = this.load();
                        }
                        catch (Throwable e) {
                            this.logger.severe("@ExtensionController: update failed!");
                            LoggerFactory.getDefaultLogger().log(e);
                        }
                        break block20;
                    }
                    try {
                        ret = this.loadFromCache();
                    }
                    catch (Throwable e) {
                        this.logger.severe("@ExtensionController: cache failed!");
                        LoggerFactory.getDefaultLogger().log(e);
                    }
                    if (ret.size() == 0) {
                        try {
                            ret = this.load();
                        }
                        catch (Throwable e) {
                            this.logger.severe("@ExtensionController: update failed!");
                            LoggerFactory.getDefaultLogger().log(e);
                        }
                    }
                }
                finally {
                    this.logger.info("@ExtensionController: init in" + (System.currentTimeMillis() - t) + "ms :" + ret.size());
                    for (LazyExtension lazyExtension : ret) {
                        this.logger.info("@ExtensionController:" + lazyExtension.getName());
                    }
                }
            }
            if (ret.size() == 0) {
                this.logger.severe("@ExtensionController: WTF, no extensions!");
            }
            try {
                Collections.sort(ret, new Comparator<LazyExtension>(){

                    @Override
                    public int compare(LazyExtension o1, LazyExtension o2) {
                        return o1.getName().compareTo(o2.getName());
                    }
                });
            }
            catch (Throwable e) {
                LoggerFactory.getDefaultLogger().log(e);
            }
            if (!Application.isHeadless()) {
                MenuManagerMainmenu.getInstance().registerExtender(this);
                MenuManagerMainToolbar.getInstance().registerExtender(this);
            }
            this.list = Collections.unmodifiableList(ret);
            this.optionalExtensions = this.initOptionalExtensions(this.list);
            if (!Application.isHeadless()) {
                SecondLevelLaunch.GUI_COMPLETE.executeWhenReached(new Runnable(){

                    @Override
                    public void run() {
                        List llist = ExtensionController.this.list;
                        for (LazyExtension plg : llist) {
                            if (plg._getExtension() == null || plg._getExtension().getGUI() == null) continue;
                            plg._getExtension().getGUI().restore();
                        }
                    }
                });
            }
        }
        this.getEventSender().fireEvent((DefaultEvent)new ExtensionControllerEvent(this, ExtensionControllerEvent.Type.UPDATED, new Object[0]));
    }

    private String getClassname(String extensionID) {
        return MAPPING.get(StringUtils.toLowerCaseOrNull((String)extensionID));
    }

    private List<OptionalExtension> initOptionalExtensions(List<LazyExtension> lazyExtensions) {
        UpdateController updateController;
        ArrayList<OptionalExtension> optionalExtensions = new ArrayList<OptionalExtension>();
        HashMap<String, LazyExtension> lazyExtensionsMap = new HashMap<String, LazyExtension>();
        for (LazyExtension lazyExtension : lazyExtensions) {
            lazyExtensionsMap.put(lazyExtension.getClassname(), lazyExtension);
        }
        optionalExtensions.add(new OptionalExtension("eventscripter", "event", _GUI.T.ExtensionController_initUninstalledExtensions_EventScripterExtension(), _GUI.T.ExtensionController_initUninstalledExtensions_EventScripterExtension_description(), (LazyExtension)lazyExtensionsMap.get(this.getClassname("eventscripter"))));
        optionalExtensions.add(new OptionalExtension("folderwatch", "folder_add", _GUI.T.ExtensionController_initUninstalledExtensions_FolderWatchExtension(), _GUI.T.ExtensionController_initUninstalledExtensions_FolderWatchExtension_description(), (LazyExtension)lazyExtensionsMap.get(this.getClassname("folderwatch"))));
        optionalExtensions.add(new OptionalExtension("scheduler", "wait", _GUI.T.ExtensionController_initUninstalledExtensions_SchedulerExtension(), _GUI.T.ExtensionController_initUninstalledExtensions_SchedulerExtension_description(), (LazyExtension)lazyExtensionsMap.get(this.getClassname("scheduler"))));
        optionalExtensions.add(new OptionalExtension("shutdown", "logout", _GUI.T.ExtensionController_initUninstalledExtensions_ShutdownExtension(), _GUI.T.ExtensionController_initUninstalledExtensions_ShutdownExtension_description(), (LazyExtension)lazyExtensionsMap.get(this.getClassname("shutdown"))));
        if (CrossSystem.isWindows() || CrossSystem.isMac() || DebugMode.TRUE_IN_IDE_ELSE_FALSE) {
            optionalExtensions.add(new OptionalExtension("antishutdown", "settings", _GUI.T.ExtensionController_initUninstalledExtensions_AntiShutdownExtension(), _GUI.T.ExtensionController_initUninstalledExtensions_AntiShutdownExtension_description(), (LazyExtension)lazyExtensionsMap.get(this.getClassname("antishutdown"))));
        }
        if (!Application.isHeadless()) {
            optionalExtensions.add(new OptionalExtension("infobar", "info", _GUI.T.ExtensionController_initUninstalledExtensions_INFOBAR(), _GUI.T.ExtensionController_initUninstalledExtensions_INFOBAR_description(), (LazyExtension)lazyExtensionsMap.get(this.getClassname("infobar"))));
            optionalExtensions.add(new OptionalExtension("chat", "chat", _GUI.T.ExtensionController_initUninstalledExtensions_JDChat(), _GUI.T.ExtensionController_initUninstalledExtensions_JDChat_description(), (LazyExtension)lazyExtensionsMap.get(this.getClassname("chat"))));
            optionalExtensions.add(new OptionalExtension("translator", "language", _GUI.T.ExtensionController_initUninstalledExtensions_TranslatorExtension(), _GUI.T.ExtensionController_initUninstalledExtensions_TranslatorExtension_description(), (LazyExtension)lazyExtensionsMap.get(this.getClassname("translator"))));
        }
        if ((updateController = UpdateController.getInstance()).isHandlerSet()) {
            try {
                ArrayList<String> list = new ArrayList<String>();
                for (OptionalExtension optionalExtension : optionalExtensions) {
                    if (optionalExtension.isInstalled() || !updateController.isExtensionInstalled(optionalExtension.getExtensionID())) continue;
                    list.add(optionalExtension.getExtensionID());
                }
                UpdateController.getInstance().runExtensionsFullUpdate(list);
            }
            catch (Throwable e) {
                this.logger.log(e);
            }
        }
        return Collections.unmodifiableList(optionalExtensions);
    }

    private List<LazyExtension> loadFromCache() throws InstantiationException, IllegalAccessException, ClassNotFoundException, StartException {
        List cache = (List)JSonStorage.restoreFrom((File)this.getCache(), (boolean)true, null, (TypeRef)new TypeRef<ArrayList<LazyExtension>>(){}, new ArrayList());
        ArrayList<LazyExtension> lst = new ArrayList<LazyExtension>(cache);
        for (LazyExtension l : lst) {
            if (l.getJarPath() == null || !new File(l.getJarPath()).exists()) {
                throw new InstantiationException("Jar Path " + l.getJarPath() + " is invalid");
            }
            l.validateCache();
            if (!l._isEnabled()) continue;
            l.init();
        }
        return lst;
    }

    private synchronized List<LazyExtension> load() {
        List<LazyExtension> ret = Application.isJared(ExtensionController.class) ? this.loadJared() : this.loadUnpacked();
        try {
            IO.secureWrite((File)this.getCache(), (byte[])JSonStorage.serializeToJsonByteArray(ret));
        }
        catch (IOException e) {
            throw new WTFException((Throwable)e);
        }
        this.validateCache();
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<LazyExtension> loadJared() {
        ArrayList<LazyExtension> ret = new ArrayList<LazyExtension>();
        Object[] addons = null;
        if (Application.getJavaVersion() >= Application.JAVA17) {
            try {
                addons = J7FileList.findFiles((Pattern)Pattern.compile("^.*\\.jar$", 2), (File)Application.getResource((String)"extensions"), (boolean)true).toArray(new File[0]);
            }
            catch (IOException e) {
                this.logger.log((Throwable)e);
            }
        }
        if (addons == null || addons.length == 0) {
            addons = Application.getResource((String)"extensions").listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".jar");
                }
            });
        }
        if (addons != null) {
            this.logger.info("Extensions:" + Arrays.toString(addons));
            HashSet<Object> dupes = new HashSet<Object>();
            HashSet<URL> urlDupes = new HashSet<URL>();
            block40: for (Object jar : addons) {
                try {
                    URL url;
                    URLClassLoader cl = new URLClassLoader(new URL[]{((File)jar).toURI().toURL()}, this.getClass().getClassLoader());
                    String resource = AbstractExtension.class.getPackage().getName().replace('.', '/');
                    Enumeration<URL> urls = cl.getResources(resource);
                    Pattern pattern = Pattern.compile(Pattern.quote(AbstractExtension.class.getPackage().getName().replace('.', '/')) + "/(\\w+)/(\\w+Extension)\\.class");
                    boolean atLeastOneSourceFound = false;
                    while (urls.hasMoreElements()) {
                        File jarFile;
                        atLeastOneSourceFound = true;
                        url = urls.nextElement();
                        if (!urlDupes.add(url) || !"jar".equalsIgnoreCase(url.getProtocol()) || !dupes.add(jarFile = new File(new URL(url.getPath().substring(0, url.getPath().lastIndexOf(33))).toURI()))) continue;
                        FileInputStream fis = null;
                        ZipInputStream jis = null;
                        try {
                            JarEntry e;
                            fis = new FileInputStream(jarFile);
                            jis = new JarInputStream(fis);
                            while ((e = ((JarInputStream)jis).getNextJarEntry()) != null) {
                                try {
                                    Matcher matcher = pattern.matcher(e.getName());
                                    if (!matcher.find()) continue;
                                    String pkg = matcher.group(1);
                                    String clazzName = matcher.group(2);
                                    Class<AbstractExtension<?, ?>> clazz = new URLClassLoader(new URL[]{((File)jar).toURI().toURL()}, this.getClass().getClassLoader()).loadClass(AbstractExtension.class.getPackage().getName() + "." + pkg + "." + clazzName);
                                    if (!AbstractExtension.class.isAssignableFrom(clazz)) continue;
                                    this.initModule(clazz, ret, jarFile);
                                    continue block40;
                                }
                                catch (Throwable e1) {
                                    LoggerFactory.getDefaultLogger().log(e1);
                                }
                            }
                        }
                        finally {
                            try {
                                jis.close();
                            }
                            catch (Throwable throwable) {}
                            try {
                                fis.close();
                            }
                            catch (Throwable throwable) {}
                        }
                    }
                    if (atLeastOneSourceFound) continue;
                    this.logger.severe("Seems Like " + jar + " was built without directory option. This slows down the loading process!");
                    JarFile jf = new JarFile((File)jar);
                    Enumeration<JarEntry> entries = jf.entries();
                    while (entries.hasMoreElements()) {
                        URI uri;
                        JarEntry s = entries.nextElement();
                        if (s.getName().startsWith(resource) && urlDupes.add(url = new URL((uri = ((File)jar).toURI()).toString() + "!" + s.getName())) && dupes.add(jar)) {
                            FileInputStream fis = null;
                            ZipInputStream jis = null;
                            try {
                                JarEntry e;
                                fis = new FileInputStream((File)jar);
                                jis = new JarInputStream(fis);
                                while ((e = ((JarInputStream)jis).getNextJarEntry()) != null) {
                                    try {
                                        Matcher matcher = pattern.matcher(e.getName());
                                        if (!matcher.find()) continue;
                                        String pkg = matcher.group(1);
                                        String clazzName = matcher.group(2);
                                        URLClassLoader classloader = new URLClassLoader(new URL[]{((File)jar).toURI().toURL()}, this.getClass().getClassLoader());
                                        Class<AbstractExtension<?, ?>> clazz = classloader.loadClass(AbstractExtension.class.getPackage().getName() + "." + pkg + "." + clazzName);
                                        if (!AbstractExtension.class.isAssignableFrom(clazz)) continue;
                                        this.initModule(clazz, ret, (File)jar);
                                        continue block40;
                                    }
                                    catch (Throwable e1) {
                                        LoggerFactory.getDefaultLogger().log(e1);
                                    }
                                }
                            }
                            finally {
                                try {
                                    jis.close();
                                }
                                catch (Throwable throwable) {}
                                try {
                                    fis.close();
                                }
                                catch (Throwable throwable) {}
                            }
                        }
                        System.out.println(s);
                    }
                }
                catch (Throwable e) {
                    LoggerFactory.getDefaultLogger().log(e);
                }
            }
        }
        return ret;
    }

    private List<LazyExtension> loadUnpacked() {
        File root;
        ArrayList<LazyExtension> retl = new ArrayList<LazyExtension>();
        URL ret = this.getClass().getResource("/");
        if ("file".equalsIgnoreCase(ret.getProtocol())) {
            try {
                root = new File(ret.toURI());
            }
            catch (URISyntaxException e) {
                LoggerFactory.getDefaultLogger().log((Throwable)e);
                this.logger.finer("Did not load unpacked Extensions from " + ret);
                return retl;
            }
        } else {
            this.logger.finer("Did not load unpacked Extensions from " + ret);
            return retl;
        }
        root = new File(root, AbstractExtension.class.getPackage().getName().replace('.', '/'));
        if (!root.exists()) {
            root = new File(root.getAbsolutePath().replace("JDownloaderUpdater", "JDownloader"));
        }
        this.logger.finer("Load Extensions from: " + root.getAbsolutePath());
        File[] folders = root.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        });
        if (folders != null) {
            ClassLoader cl = this.getClass().getClassLoader();
            block7: for (File f : folders) {
                File[] modules = null;
                if (Application.getJavaVersion() >= Application.JAVA17) {
                    try {
                        modules = J7FileList.findFiles((Pattern)Pattern.compile("^.*Extension\\.class$", 2), (File)f, (boolean)true).toArray(new File[0]);
                    }
                    catch (IOException e) {
                        this.logger.log((Throwable)e);
                    }
                }
                if (modules == null) {
                    modules = f.listFiles(new FilenameFilter(){

                        @Override
                        public boolean accept(File dir, String name) {
                            return name.endsWith("Extension.class");
                        }
                    });
                }
                boolean loaded = false;
                if (modules == null) continue;
                for (File module : modules) {
                    try {
                        Class<AbstractExtension<?, ?>> cls = cl.loadClass(AbstractExtension.class.getPackage().getName() + "." + module.getParentFile().getName() + "." + module.getName().substring(0, module.getName().length() - 6));
                        if (!AbstractExtension.class.isAssignableFrom(cls)) continue;
                        this.initModule(cls, retl, f);
                        loaded = true;
                        continue block7;
                    }
                    catch (IllegalArgumentException e) {
                        this.logger.warning("Did not init Extension " + module + " : " + e.getMessage());
                    }
                    catch (Throwable e) {
                        LoggerFactory.getDefaultLogger().log(e);
                        UIOManager.I().showConfirmDialog(0, e.getMessage(), Exceptions.getStackTrace((Throwable)e));
                    }
                }
                if (loaded) continue;
                this.logger.warning("Could not load any Extension Module from " + f);
            }
        }
        return retl;
    }

    private List<LazyExtension> initModule(Class<AbstractExtension<?, ?>> cls, List<LazyExtension> list, File jarFile) throws InstantiationException, IllegalAccessException, StartException, IOException, ClassNotFoundException {
        long t = System.currentTimeMillis();
        if (list == null) {
            list = new ArrayList<LazyExtension>();
        }
        String id = cls.getName().substring(27);
        this.logger.fine("Load Extension: " + id);
        LazyExtension extension = LazyExtension.create(id, cls);
        if (!extension.isHeadlessRunnable() && Application.isHeadless()) {
            this.logger.info("Ignored Extension (Headless): " + id + " Load Duration:" + (System.currentTimeMillis() - t) + "ms");
            return list;
        }
        extension.setJarPath(jarFile.getAbsolutePath());
        extension._setPluginClass(cls);
        if (extension._isEnabled()) {
            extension.init();
        }
        list.add(extension);
        this.logger.info("Loaded Extension: " + id + " Load Duration:" + (System.currentTimeMillis() - t) + "ms");
        return list;
    }

    public boolean isExtensionActive(Class<? extends AbstractExtension<?, ?>> class1) {
        List<LazyExtension> llist = this.list;
        for (LazyExtension l : llist) {
            if (!class1.getName().equals(l.getClassname()) || l._getExtension() == null || !l._getExtension().isEnabled()) continue;
            return true;
        }
        return false;
    }

    public List<LazyExtension> getExtensions() {
        return this.list;
    }

    public List<AbstractExtension<?, ?>> getEnabledExtensions() {
        ArrayList ret = new ArrayList();
        List<LazyExtension> list = this.getExtensions();
        for (LazyExtension aew : list) {
            if (aew._getExtension() == null || !aew._getExtension().isEnabled()) continue;
            ret.add(aew._getExtension());
        }
        return ret;
    }

    public <T extends AbstractExtension<?, ?>> LazyExtension getExtension(Class<T> class1) {
        List<LazyExtension> list = this.getExtensions();
        for (LazyExtension l : list) {
            if (!class1.getName().equals(l.getClassname())) continue;
            return l;
        }
        return null;
    }

    public <T extends AbstractExtension<?, ?>> LazyExtension getExtension(String classname) {
        List<LazyExtension> list = this.getExtensions();
        for (LazyExtension l : list) {
            if (!classname.equals(l.getClassname())) continue;
            return l;
        }
        if ((classname = this.getClassname(classname)) != null) {
            for (LazyExtension l : list) {
                if (!classname.equals(l.getClassname())) continue;
                return l;
            }
        }
        return null;
    }

    public void invalidateCacheIfRequired() {
        if (Application.getTempResource((String)TMP_INVALIDEXTENSIONS).exists()) {
            this.invalidateCache();
        }
    }

    public Class<?> loadClass(String className) throws ClassNotFoundException, ExtensionNotLoadedException {
        if (this.list == null || this.list.size() == 0) {
            throw new ExtensionNotLoadedException(className);
        }
        ClassNotFoundException exc = null;
        for (AbstractExtension<?, ?> ae : this.getEnabledExtensions()) {
            if (!className.startsWith(ae.getClass().getPackage().getName())) continue;
            try {
                return Class.forName(className, true, ae.getClass().getClassLoader());
            }
            catch (ClassNotFoundException e) {
                exc = e;
            }
        }
        if (exc != null) {
            throw exc;
        }
        for (LazyExtension le : this.getExtensions()) {
            String packageName = le.getClassname();
            if (!className.startsWith(packageName = packageName.substring(0, packageName.lastIndexOf(".")))) continue;
            throw new ExtensionNotLoadedException(le.getClassname() + " - " + className);
        }
        throw new ClassNotFoundException(className);
    }

    @Override
    public MenuItemData updateMenuModel(ContextMenuManager manager, MenuContainerRoot mr) {
        ArrayList<LazyExtension> pluginsOptional = new ArrayList<LazyExtension>(this.getExtensions());
        Collections.sort(pluginsOptional, new Comparator<LazyExtension>(){

            @Override
            public int compare(LazyExtension o1, LazyExtension o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        if (manager instanceof MenuManagerMainToolbar) {
            return this.updateMainToolbar(pluginsOptional, mr);
        }
        if (manager instanceof MenuManagerMainmenu) {
            return this.updateMainMenu(pluginsOptional, mr);
        }
        return null;
    }

    private MenuItemData updateMainMenu(List<LazyExtension> pluginsOptional, MenuContainerRoot mr) {
        MenuContainerRoot root = new MenuContainerRoot();
        root._setOwner(MenuManagerMainmenu.getInstance());
        ExtensionsMenuContainer container = new ExtensionsMenuContainer();
        OptionalContainer opt = new OptionalContainer(false);
        root.add(container);
        root.add(opt);
        for (LazyExtension wrapper : pluginsOptional) {
            try {
                if (!wrapper.isQuickToggle()) continue;
                MenuItemData m = new MenuItemData(new ActionData(ExtensionQuickToggleAction.class, wrapper.getClassname()));
                container.add(m);
            }
            catch (Exception e) {
                this.logger.log((Throwable)e);
            }
        }
        return root;
    }

    private MenuItemData updateMainToolbar(List<LazyExtension> pluginsOptional, MenuContainerRoot mr) {
        OptionalContainer opt = new OptionalContainer(false);
        ExtensionsMenuContainer container = new ExtensionsMenuContainer();
        opt.add(container);
        for (LazyExtension wrapper : pluginsOptional) {
            try {
                if (!wrapper.isQuickToggle()) continue;
                MenuItemData m = new MenuItemData(new ActionData(ExtensionQuickToggleAction.class, wrapper.getClassname()));
                container.add(m);
            }
            catch (Exception e) {
                this.logger.log((Throwable)e);
            }
        }
        return opt;
    }

    public void setEnabled(LazyExtension object, boolean value) {
        block14: {
            if (value) {
                try {
                    object._setEnabled(true);
                    if (!(object instanceof LazyExtension)) break block14;
                    if (object._getExtension().getGUI() != null && object._getExtension().isGuiOptional()) {
                        if (JDGui.bugme((WarnLevel)WarnLevel.NORMAL)) {
                            ConfirmDialogInterface io = new ConfirmDialog(36, object.getName(), _JDT.T.gui_settings_extensions_show_now(object.getName())).show();
                            if (io.getCloseReason() == CloseReason.OK) {
                                object._getExtension().getGUI().setActive(true);
                                object._getExtension().getGUI().toFront();
                            }
                        } else {
                            object._getExtension().getGUI().setActive(true);
                            object._getExtension().getGUI().toFront();
                        }
                    } else if (!object._getExtension().isGuiOptional()) {
                        object._getExtension().getGUI().setActive(true);
                        object._getExtension().getGUI().toFront();
                    }
                }
                catch (StartException e1) {
                    Dialog.getInstance().showExceptionDialog(_JDT.T.dialog_title_exception(), e1.getMessage(), (Throwable)e1);
                }
                catch (StopException e1) {
                    e1.printStackTrace();
                }
            } else {
                try {
                    object._setEnabled(false);
                }
                catch (StartException e1) {
                    e1.printStackTrace();
                }
                catch (StopException e1) {
                    Dialog.getInstance().showExceptionDialog(_JDT.T.dialog_title_exception(), e1.getMessage(), (Throwable)e1);
                }
            }
        }
    }

    public List<OptionalExtension> getOptionalExtensions() {
        return this.optionalExtensions;
    }

    static {
        MAPPING.put("eventscripter", "org.jdownloader.extensions.eventscripter.EventScripterExtension");
        MAPPING.put("folderwatch", "org.jdownloader.extensions.folderwatchV2.FolderWatchExtension");
        MAPPING.put("scheduler", "org.jdownloader.extensions.schedulerV2.SchedulerExtension");
        MAPPING.put("shutdown", "org.jdownloader.extensions.shutdown.ShutdownExtension");
        MAPPING.put("antishutdown", "org.jdownloader.extensions.antistandby.AntiStandbyExtension");
        MAPPING.put("infobar", "org.jdownloader.extensions.infobar.InfoBarExtension");
        MAPPING.put("chat", "org.jdownloader.extensions.chat.ChatExtension");
        MAPPING.put("translator", "org.jdownloader.extensions.translator.TranslatorExtension");
    }
}

