/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.jdtrayicon;

import java.awt.Color;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowStateListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.EventListener;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import jd.SecondLevelLaunch;
import jd.gui.swing.jdgui.JDGui;
import jd.gui.swing.jdgui.MainFrameClosingHandler;
import jd.gui.swing.jdgui.views.settings.sidebar.CheckBoxedEntry;
import jd.plugins.AddonPanel;
import org.appwork.loggingv3.LogV3;
import org.appwork.shutdown.ShutdownRequest;
import org.appwork.storage.config.ValidationException;
import org.appwork.storage.config.events.GenericConfigEventListener;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.swing.trayicon.AbstractTray;
import org.appwork.swing.trayicon.TrayMouseListener;
import org.appwork.utils.Application;
import org.appwork.utils.IO;
import org.appwork.utils.ImageProvider.ImageProvider;
import org.appwork.utils.StringUtils;
import org.appwork.utils.Time;
import org.appwork.utils.images.IconIO;
import org.appwork.utils.logging2.extmanager.LoggerFactory;
import org.appwork.utils.os.CrossSystem;
import org.appwork.utils.os.DesktopSupportLinux;
import org.appwork.utils.swing.EDTHelper;
import org.appwork.utils.swing.EDTRunner;
import org.appwork.utils.swing.SwingUtils;
import org.appwork.utils.swing.dialog.AbstractDialog;
import org.appwork.utils.swing.dialog.ConfirmDialog;
import org.appwork.utils.swing.dialog.Dialog;
import org.appwork.utils.swing.dialog.DialogNoAnswerException;
import org.appwork.utils.swing.windowmanager.WindowManager;
import org.jdownloader.actions.AppAction;
import org.jdownloader.extensions.AbstractExtension;
import org.jdownloader.extensions.ExtensionConfigPanel;
import org.jdownloader.extensions.StartException;
import org.jdownloader.extensions.StopException;
import org.jdownloader.gui.jdtrayicon.CFG_TRAY_CONFIG;
import org.jdownloader.gui.jdtrayicon.OnCloseAction;
import org.jdownloader.gui.jdtrayicon.TrayConfig;
import org.jdownloader.gui.jdtrayicon.TrayConfigPanel;
import org.jdownloader.gui.jdtrayicon.TrayIconPopup;
import org.jdownloader.gui.jdtrayicon.TrayIconTooltip;
import org.jdownloader.gui.jdtrayicon.TrayMouseAdapter;
import org.jdownloader.gui.jdtrayicon.translate.TrayiconTranslation;
import org.jdownloader.gui.jdtrayicon.translate._TRAY;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.images.NewTheme;
import org.jdownloader.logging.LogController;
import org.jdownloader.settings.staticreferences.CFG_GUI;
import org.jdownloader.updatev2.RestartController;
import org.jdownloader.updatev2.SmartRlyExitRequest;

public class TrayExtension
extends AbstractExtension<TrayConfig, TrayiconTranslation>
implements TrayMouseListener,
WindowStateListener,
ActionListener,
MainFrameClosingHandler,
CheckBoxedEntry,
GenericConfigEventListener<Boolean> {
    private volatile TrayIconPopup trayIconPopup;
    private volatile TrayIcon trayIcon;
    private JFrame guiFrame;
    private volatile TrayIconTooltip trayIconTooltip = null;
    private TrayMouseAdapter ma;
    private ExtensionConfigPanel<TrayExtension> configPanel;
    private long lastCloseRequest;
    private boolean asking;

    @Override
    public boolean isHeadlessRunnable() {
        return false;
    }

    @Override
    protected void stop() throws StopException {
        this.removeTrayIcon();
        if (this.guiFrame != null) {
            JDGui.getInstance().setClosingHandler(null);
            this.guiFrame.removeWindowStateListener(this);
            JDGui.getInstance().setWindowToTray(false);
            this.guiFrame.setAlwaysOnTop(false);
            this.guiFrame = null;
        }
    }

    @Override
    public String getIconKey() {
        return "minimize";
    }

    @Override
    public String getName() {
        return ((TrayiconTranslation)this.T).getName();
    }

    @Override
    protected void start() throws StartException {
        if (Application.getJavaVersion() < Application.JAVA16) {
            LogController.CL(TrayExtension.class).severe("Error initializing SystemTray: Tray is supported since Java 1.6. your Version: " + Application.getJavaVersion());
            throw new StartException("Tray is supported since Java 1.6. your Version: " + Application.getJavaVersion());
        }
        if (!SystemTray.isSupported()) {
            LogController.CL(TrayExtension.class).severe("Error initializing SystemTray: Tray isn't supported jet");
            if (CrossSystem.isUnix()) {
                LogController.CL().severe("Make sure your Notification Area is enabled!");
            }
            throw new StartException("Tray isn't supported!");
        }
        SecondLevelLaunch.GUI_COMPLETE.executeWhenReached(new Runnable(){

            @Override
            public void run() {
                new EDTRunner(){

                    protected void runInEDT() {
                        try {
                            if (JDGui.getInstance() != null) {
                                TrayExtension.this.initGUI(true);
                                LogController.CL(TrayExtension.class).info("Systemtray OK");
                            }
                        }
                        catch (Exception e) {
                            LogController.CL(TrayExtension.class).log((Throwable)e);
                        }
                    }
                };
            }
        });
    }

    @Override
    public String getDescription() {
        return _TRAY.T.jd_plugins_optional_jdtrayicon_jdlighttray_description();
    }

    @Override
    public AddonPanel<TrayExtension> getGUI() {
        return null;
    }

    @Override
    public boolean isDefaultEnabled() {
        return true;
    }

    @Override
    public ExtensionConfigPanel<TrayExtension> getConfigPanel() {
        return this.configPanel;
    }

    @Override
    public boolean hasConfigPanel() {
        return true;
    }

    public TrayExtension() {
        this.setTitle(_TRAY.T.jd_plugins_optional_jdtrayicon_jdlighttray());
    }

    public static int readEnableBalloonTips() throws UnsupportedEncodingException, IOException {
        String iconResult = IO.readInputStreamToString((InputStream)Runtime.getRuntime().exec("reg query \"HKEY_CURRENT_USER\\Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Advanced\" /v \"EnableBalloonTips\"").getInputStream());
        Matcher matcher = Pattern.compile("EnableBalloonTips\\s+REG_DWORD\\s+0x(.*)").matcher(iconResult);
        matcher.find();
        String value = matcher.group(1);
        return Integer.parseInt(value, 16);
    }

    public static void writeEnableBalloonTips(int foregroundLockTimeout) {
        try {
            Process p = Runtime.getRuntime().exec("reg add \"HKEY_CURRENT_USER\\Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Advanced\" /v \"EnableBalloonTips\" /t REG_DWORD /d 0x" + Integer.toHexString(foregroundLockTimeout) + " /f");
            IO.readInputStreamToString((InputStream)p.getInputStream());
            int exitCode = p.exitValue();
            if (exitCode != 0) {
                throw new IOException("Reg add execution failed");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void initGUI(final boolean startup) {
        SecondLevelLaunch.GUI_COMPLETE.executeWhenReached(new Runnable(){

            @Override
            public void run() {
                new EDTRunner(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    protected void runInEDT() {
                        try {
                            TrayExtension.this.removeTrayIcon();
                            SystemTray systemTray = SystemTray.getSystemTray();
                            int trayIconWidth = (int)systemTray.getTrayIconSize().getWidth();
                            int trayIconHeight = (int)systemTray.getTrayIconSize().getHeight();
                            if (CrossSystem.isWindows()) {
                                try {
                                    AffineTransform tx = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getDefaultTransform();
                                    trayIconHeight = (int)((double)trayIconHeight * tx.getScaleY());
                                    trayIconWidth = (int)((double)trayIconWidth * tx.getScaleX());
                                }
                                catch (Exception e) {
                                    LogV3.log((Throwable)e);
                                }
                            }
                            Image img = ((TrayConfig)TrayExtension.this.getSettings()).isGreyIconEnabled() ? ImageProvider.convertToGrayScale((Image)NewTheme.I().getImage("logo/jd_logo_128_128", trayIconWidth, trayIconHeight)) : NewTheme.I().getImage("logo/jd_logo_128_128", trayIconWidth, trayIconHeight);
                            LogController.CL(TrayExtension.class).info("TrayIconSize:" + trayIconWidth + "x" + trayIconHeight + "->IconSize:" + img.getWidth(null) + "x" + img.getHeight(null));
                            if (((TrayConfig)TrayExtension.this.getSettings()).isGnomeTrayIconTransparentEnabled() && CrossSystem.isUnix()) {
                                DesktopSupportLinux desktop = new DesktopSupportLinux();
                                try {
                                    if ((desktop.isGnomeDesktop() || desktop.isXFCEDesktop()) && !desktop.isWayland()) {
                                        ((TrayConfig)TrayExtension.this.getSettings()).setGnomeTrayIconTransparentEnabled(false);
                                        ((TrayConfig)TrayExtension.this.getSettings())._getStorageHandler().write();
                                        LogController.CL(TrayExtension.class).info("Apply LinuxTrayIcon workaround");
                                        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
                                        GraphicsDevice[] screens = ge.getScreenDevices();
                                        GraphicsDevice taskBarDevice = null;
                                        Rectangle taskBarRectangle = null;
                                        for (GraphicsDevice screen : screens) {
                                            GraphicsConfiguration screenConfiguration = screen.getDefaultConfiguration();
                                            Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(screenConfiguration);
                                            if (!(insets.bottom > 0 | insets.top > 0 | insets.right > 0 | insets.left > 0)) continue;
                                            taskBarDevice = screen;
                                            Rectangle bounds = screenConfiguration.getBounds();
                                            if (insets.top <= 0) break;
                                            taskBarRectangle = new Rectangle(bounds.x, bounds.y, 2, img.getHeight(null));
                                            break;
                                        }
                                        if (taskBarDevice != null && taskBarRectangle != null) {
                                            Robot robo = new Robot(taskBarDevice);
                                            BufferedImage buffered = IconIO.toBufferedImage((Image)img);
                                            BufferedImage screenCapture = robo.createScreenCapture(taskBarRectangle);
                                            for (int y = 0; y < buffered.getHeight(null); ++y) {
                                                Color pixel = new Color(screenCapture.getRGB(1, y));
                                                for (int x = 0; x < buffered.getWidth(null); ++x) {
                                                    int rgb = buffered.getRGB(x, y);
                                                    Color tmp = new Color(rgb);
                                                    float alpha = (float)(rgb >> 24 & 0xFF) / 255.0f;
                                                    int cr = (int)(alpha * (float)tmp.getRed() + (1.0f - alpha) * (float)pixel.getRed());
                                                    int cg = (int)(alpha * (float)tmp.getGreen() + (1.0f - alpha) * (float)pixel.getGreen());
                                                    int cb = (int)(alpha * (float)tmp.getBlue() + (1.0f - alpha) * (float)pixel.getBlue());
                                                    buffered.setRGB(x, y, new Color(cr, cg, cb).getRGB());
                                                }
                                            }
                                            img = buffered;
                                        }
                                    }
                                }
                                catch (Throwable e) {
                                    LogController.CL().log(e);
                                }
                                finally {
                                    ((TrayConfig)TrayExtension.this.getSettings()).setGnomeTrayIconTransparentEnabled(true);
                                }
                            }
                            TrayExtension.this.trayIcon = new TrayIcon(img, "JDownloader");
                            TrayExtension.this.trayIcon.setImageAutoSize(true);
                            TrayExtension.this.trayIcon.addActionListener(TrayExtension.this);
                            final TrayMouseAdapter ma = new TrayMouseAdapter(TrayExtension.this, TrayExtension.this.trayIcon);
                            TrayExtension.this.ma = ma;
                            LogController.CL(TrayExtension.class).info("JDLightTrayIcon Init complete");
                            if (TrayExtension.this.guiFrame == null) {
                                TrayExtension.this.guiFrame = (JFrame)JDGui.getInstance().getMainFrame();
                                if (TrayExtension.this.guiFrame != null) {
                                    JDGui.getInstance().setClosingHandler((MainFrameClosingHandler)TrayExtension.this);
                                    TrayExtension.this.guiFrame.addComponentListener(new ComponentListener(){

                                        @Override
                                        public void componentShown(ComponentEvent e) {
                                            if (((TrayConfig)TrayExtension.this.getSettings()).isTrayOnlyVisibleIfWindowIsHiddenEnabled()) {
                                                new EDTRunner(){

                                                    protected void runInEDT() {
                                                        TrayExtension.this.removeTrayIcon();
                                                    }
                                                };
                                            }
                                        }

                                        @Override
                                        public void componentResized(ComponentEvent e) {
                                        }

                                        @Override
                                        public void componentMoved(ComponentEvent e) {
                                        }

                                        @Override
                                        public void componentHidden(ComponentEvent e) {
                                            if (((TrayConfig)TrayExtension.this.getSettings()).isTrayOnlyVisibleIfWindowIsHiddenEnabled()) {
                                                new EDTRunner(){

                                                    protected void runInEDT() {
                                                        TrayExtension.this.initGUI(false);
                                                    }
                                                };
                                            }
                                        }
                                    });
                                    TrayExtension.this.guiFrame.removeWindowStateListener(TrayExtension.this);
                                    TrayExtension.this.guiFrame.addWindowStateListener(TrayExtension.this);
                                    if (startup) {
                                        if (((TrayConfig)TrayExtension.this.getSettings()).isStartMinimizedEnabled()) {
                                            JDGui.getInstance().setWindowToTray(true);
                                        }
                                        CFG_TRAY_CONFIG.TRAY_ONLY_VISIBLE_IF_WINDOW_IS_HIDDEN_ENABLED.getEventSender().addListener((EventListener)TrayExtension.this, true);
                                    }
                                }
                            }
                            if (!((TrayConfig)TrayExtension.this.getSettings()).isTrayOnlyVisibleIfWindowIsHiddenEnabled() || !TrayExtension.this.guiFrame.isVisible()) {
                                systemTray.add(TrayExtension.this.trayIcon);
                                SwingUtils.invokeLater((Runnable)new Runnable(){

                                    @Override
                                    public void run() {
                                        ma.startListener();
                                    }
                                }, (int)0);
                            }
                        }
                        catch (Throwable e) {
                            LogController.CL().log(e);
                            try {
                                TrayExtension.this.setEnabled(false);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            return;
                        }
                    }
                };
            }
        });
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
        this.hideTrayIconToolTip();
    }

    private void hideTrayIconToolTip() {
        TrayIconTooltip ltrayIconTooltip = this.trayIconTooltip;
        this.trayIconTooltip = null;
        if (ltrayIconTooltip != null) {
            ltrayIconTooltip.hideTooltip();
        }
    }

    public void mousePressed(MouseEvent e) {
        this.hideTrayIconToolTip();
        if (e.getSource() instanceof TrayIcon) {
            if (!CrossSystem.isMac()) {
                if (e.getClickCount() >= (((TrayConfig)this.getSettings()).isToogleWindowStatusWithSingleClickEnabled() ? 1 : 2) && !SwingUtilities.isRightMouseButton(e)) {
                    JDGui.getInstance().setWindowToTray(this.guiFrame.isVisible());
                } else {
                    TrayIconPopup trayIconPopup = this.trayIconPopup;
                    if (trayIconPopup != null && trayIconPopup.isShowing()) {
                        trayIconPopup.dispose();
                        this.trayIconPopup = null;
                    } else if (SwingUtilities.isRightMouseButton(e)) {
                        if (!this.checkPassword()) {
                            return;
                        }
                        if (trayIconPopup == null) {
                            this.trayIconPopup = trayIconPopup = new TrayIconPopup(this);
                        }
                        Point location = AbstractTray.calculateLocation((Container)((Object)trayIconPopup), (org.appwork.swing.trayicon.TrayMouseAdapter)this.ma, (MouseEvent)e);
                        trayIconPopup.setLocation(location);
                        WindowManager.getInstance().setVisible((Window)((Object)trayIconPopup), true, WindowManager.FrameState.OS_DEFAULT);
                        trayIconPopup.startAutoHide();
                    }
                }
            } else if (e.getClickCount() >= (((TrayConfig)this.getSettings()).isToogleWindowStatusWithSingleClickEnabled() ? 1 : 2) && !SwingUtilities.isLeftMouseButton(e)) {
                JDGui.getInstance().setWindowToTray(this.guiFrame.isVisible() & this.guiFrame.getState() != 1);
            } else if (SwingUtilities.isLeftMouseButton(e)) {
                TrayIconPopup trayIconPopup = this.trayIconPopup;
                if (trayIconPopup != null && trayIconPopup.isShowing()) {
                    trayIconPopup.dispose();
                    this.trayIconPopup = null;
                } else if (SwingUtilities.isLeftMouseButton(e)) {
                    if (!this.checkPassword()) {
                        return;
                    }
                    if (trayIconPopup == null) {
                        this.trayIconPopup = trayIconPopup = new TrayIconPopup(this);
                    }
                    Point location = AbstractTray.calculateLocation((Container)((Object)trayIconPopup), (org.appwork.swing.trayicon.TrayMouseAdapter)this.ma, (MouseEvent)e);
                    trayIconPopup.setLocation(location);
                    WindowManager.getInstance().setVisible((Window)((Object)trayIconPopup), true, WindowManager.FrameState.OS_DEFAULT);
                    trayIconPopup.startAutoHide();
                }
            }
        }
    }

    private boolean checkPassword() {
        if (JDGui.getInstance().getMainFrame().isVisible()) {
            return true;
        }
        if (!CFG_GUI.PASSWORD_PROTECTION_ENABLED.isEnabled()) {
            return true;
        }
        if (StringUtils.isEmpty((String)CFG_GUI.PASSWORD.getValue())) {
            return true;
        }
        try {
            String password = Dialog.getInstance().showInputDialog(512, _GUI.T.JDGui_setVisible_password_(), _GUI.T.JDGui_setVisible_password_msg(), null, (Icon)new AbstractIcon("lock", 32), null, null);
            if (!CFG_GUI.PASSWORD.getValue().equals(password)) {
                Dialog.getInstance().showMessageDialog(_GUI.T.JDGui_setVisible_password_wrong());
                return false;
            }
        }
        catch (DialogNoAnswerException e) {
            return false;
        }
        return true;
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mouseStay(MouseEvent e) {
        if (!((TrayConfig)this.getSettings()).isToolTipEnabled()) {
            return;
        }
        TrayIconPopup trayIconPopup = this.trayIconPopup;
        if (trayIconPopup != null && trayIconPopup.isVisible()) {
            return;
        }
        TrayIconTooltip trayIconTooltip = this.trayIconTooltip;
        if (trayIconTooltip == null) {
            this.trayIconTooltip = trayIconTooltip = new TrayIconTooltip();
        }
        Rectangle bounds = ((TrayMouseAdapter)((Object)e.getSource())).getUnscaledBounds();
        Point target = new Point(bounds.x, bounds.y);
        target = SwingUtils.convertToScaled((Point)target, (GraphicsDevice)SwingUtils.getScreenByBounds((Rectangle)bounds));
        trayIconTooltip.showTooltip(target);
    }

    private void removeTrayIcon() {
        try {
            TrayIcon trayIcon = this.trayIcon;
            if (trayIcon != null) {
                trayIcon.removeActionListener(this);
                TrayMouseAdapter ma = this.ma;
                this.ma = null;
                if (ma != null) {
                    ma.stopListener();
                }
                SystemTray.getSystemTray().remove(trayIcon);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
        JFrame guiFrame = this.guiFrame;
        if (guiFrame != null) {
            guiFrame.setAlwaysOnTop(false);
        }
    }

    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowStateChanged(WindowEvent evt) {
        int oldState = evt.getOldState();
        int newState = evt.getNewState();
        if (Time.systemIndependentCurrentJVMTimeMillis() - this.lastCloseRequest < 1000L || this.asking) {
            return;
        }
        if ((oldState & 1) == 0 && (newState & 1) != 0) {
            switch (((TrayConfig)this.getSettings()).getOnMinimizeAction()) {
                case TO_TASKBAR: {
                    return;
                }
                case TO_TRAY: {
                    JDGui.getInstance().setWindowToTray(true);
                }
            }
        } else if ((oldState & 1) == 0 || (newState & 1) == 0) {
            // empty if block
        }
    }

    @Override
    protected void initExtension() throws StartException {
        this.configPanel = (ExtensionConfigPanel)((Object)new EDTHelper<TrayConfigPanel>(){

            public TrayConfigPanel edtRun() {
                return new TrayConfigPanel(TrayExtension.this);
            }
        }.getReturnValue());
    }

    @Override
    public void handleCommand(String command, String ... parameters) {
    }

    private OnCloseAction windowClosedTray(WindowEvent e) {
        if (CrossSystem.isMac()) {
            return this.windowClosedTrayForMac(e);
        }
        final OnCloseAction[] ret = new OnCloseAction[]{null};
        final ConfirmDialog d = new ConfirmDialog(1568, ((TrayiconTranslation)this.T).JDGui_windowClosing_try_title(), ((TrayiconTranslation)this.T).JDGui_windowClosing_try_msg_2(), (Icon)new AbstractIcon("exit", 32), ((TrayiconTranslation)this.T).JDGui_windowClosing_try_asnwer_close(), null);
        try {
            d.setLeftActions(new AbstractAction[]{new AppAction(){
                {
                    this.setName(((TrayiconTranslation)TrayExtension.this.T).JDGui_windowClosing_try_answer_totaskbar());
                }

                public void actionPerformed(ActionEvent e1) {
                    ret[0] = OnCloseAction.TO_TASKBAR;
                    d.dispose();
                }
            }, new AppAction(){
                {
                    this.setName(((TrayiconTranslation)TrayExtension.this.T).JDGui_windowClosing_try_answer_tray());
                    this.setEnabled(SystemTray.isSupported());
                }

                public void actionPerformed(ActionEvent e1) {
                    ret[0] = OnCloseAction.TO_TRAY;
                    d.dispose();
                }
            }});
            Dialog.I().showDialog((AbstractDialog)d);
            if (ret[0] == null) {
                ret[0] = OnCloseAction.EXIT;
            }
        }
        catch (DialogNoAnswerException e1) {
            e.setSource(null);
            e1.printStackTrace();
            ret[0] = OnCloseAction.ASK;
        }
        if (d.isDontShowAgainSelected()) {
            ((TrayConfig)this.getSettings()).setOnCloseAction(ret[0]);
        }
        return ret[0];
    }

    private OnCloseAction windowClosedTrayForMac(WindowEvent e) {
        final OnCloseAction[] ret = new OnCloseAction[]{null};
        final ConfirmDialog d = new ConfirmDialog(1568, ((TrayiconTranslation)this.T).JDGui_windowClosing_try_title(), ((TrayiconTranslation)this.T).JDGui_windowClosing_try_msg_2(), (Icon)new AbstractIcon("exit", 32), ((TrayiconTranslation)this.T).JDGui_windowClosing_try_asnwer_close(), null);
        try {
            d.setLeftActions(new AbstractAction[]{new AppAction(){
                {
                    this.setName(((TrayiconTranslation)TrayExtension.this.T).JDGui_windowClosing_try_answer_totaskbar());
                }

                public void actionPerformed(ActionEvent e1) {
                    ret[0] = OnCloseAction.TO_TASKBAR;
                    d.dispose();
                }
            }, new AppAction(){
                {
                    this.setName(((TrayiconTranslation)TrayExtension.this.T).JDGui_windowClosing_try_answer_tray());
                    this.setEnabled(SystemTray.isSupported());
                }

                public void actionPerformed(ActionEvent e1) {
                    ret[0] = OnCloseAction.TO_TRAY;
                    d.dispose();
                }
            }});
            Dialog.I().showDialog((AbstractDialog)d);
            if (ret[0] == null) {
                ret[0] = OnCloseAction.EXIT;
            }
        }
        catch (DialogNoAnswerException e1) {
            e.setSource(null);
            e1.printStackTrace();
            ret[0] = OnCloseAction.ASK;
        }
        if (d.isDontShowAgainSelected()) {
            ((TrayConfig)this.getSettings()).setOnCloseAction(ret[0]);
        }
        return ret[0];
    }

    public void windowClosing(WindowEvent e) {
        AtomicBoolean asked = new AtomicBoolean(false);
        try {
            this.lastCloseRequest = Time.systemIndependentCurrentJVMTimeMillis();
            if (this.isEnabled()) {
                block1 : switch (((TrayConfig)this.getSettings()).getOnCloseAction()) {
                    case ASK: {
                        asked.set(true);
                        switch (this.windowClosedTray(e)) {
                            case ASK: {
                                return;
                            }
                            case EXIT: {
                                break block1;
                            }
                            case TO_TASKBAR: {
                                WindowManager.getInstance().setExtendedState((Frame)JDGui.getInstance().getMainFrame(), WindowManager.WindowExtendedState.ICONIFIED);
                                return;
                            }
                            case TO_TRAY: {
                                if (!SystemTray.isSupported()) break;
                                JDGui.getInstance().setWindowToTray(true);
                                return;
                            }
                        }
                    }
                    case EXIT: {
                        break;
                    }
                    case TO_TASKBAR: {
                        WindowManager.getInstance().setExtendedState((Frame)JDGui.getInstance().getMainFrame(), WindowManager.WindowExtendedState.ICONIFIED);
                        return;
                    }
                    case TO_TRAY: {
                        if (!SystemTray.isSupported()) break;
                        JDGui.getInstance().setWindowToTray(true);
                        return;
                    }
                }
            }
        }
        catch (Throwable e1) {
            LoggerFactory.getDefaultLogger().log(e1);
        }
        RestartController.getInstance().exitAsynch((ShutdownRequest)new SmartRlyExitRequest(asked.get()));
    }

    public Icon _getIcon(int size) {
        return NewTheme.I().getIcon(this.getIconKey(), size);
    }

    public boolean _isEnabled() {
        return this.isEnabled();
    }

    public void _setEnabled(boolean b) throws StartException, StopException {
        this.setEnabled(b);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    public boolean isActive() {
        TrayIconPopup trayIconPopup = this.trayIconPopup;
        return trayIconPopup != null && trayIconPopup.hasBeenRecentlyActive();
    }

    public void onConfigValidatorError(KeyHandler<Boolean> keyHandler, Boolean invalidValue, ValidationException validateException) {
    }

    public void onConfigValueModified(KeyHandler<Boolean> keyHandler, Boolean newValue) {
        new EDTRunner(){

            protected void runInEDT() {
                TrayExtension.this.removeTrayIcon();
                TrayExtension.this.initGUI(false);
            }
        };
    }
}

