/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.jdtrayicon;

import java.awt.Color;
import java.awt.Image;
import java.awt.TrayIcon;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.appwork.storage.config.ValidationException;
import org.appwork.storage.config.events.GenericConfigEventListener;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.swing.trayicon.TrayMouseListener;
import org.appwork.utils.images.IconIO;
import org.appwork.utils.swing.EDTRunner;
import org.jdownloader.gui.jdtrayicon.CFG_TRAY_CONFIG;
import org.jdownloader.gui.jdtrayicon.TrayExtension;
import org.jdownloader.images.BadgeIcon;
import org.jdownloader.images.NewTheme;
import org.jdownloader.settings.staticreferences.CFG_GUI;

public class TrayMouseAdapter
extends org.appwork.swing.trayicon.TrayMouseAdapter {
    private final TrayIcon trayIcon;
    private final Image image;
    private final GenericConfigEventListener<Boolean> clipboardToggle;
    private final AtomicBoolean listenerFlag = new AtomicBoolean(false);

    public TrayMouseAdapter(TrayExtension lightTray, TrayIcon trayIcon) {
        super((TrayMouseListener)lightTray, trayIcon);
        this.trayIcon = trayIcon;
        this.image = trayIcon.getImage();
        this.clipboardToggle = new GenericConfigEventListener<Boolean>(){

            public void onConfigValueModified(KeyHandler<Boolean> keyHandler, Boolean newValue) {
                TrayMouseAdapter.this.trayIcon.setImage(TrayMouseAdapter.this.getCurrentTrayIconImage());
            }

            public void onConfigValidatorError(KeyHandler<Boolean> keyHandler, Boolean invalidValue, ValidationException validateException) {
            }
        };
    }

    public void startListener() {
        CFG_GUI.CLIPBOARD_MONITORED.getEventSender().addListener(this.clipboardToggle, false);
        CFG_TRAY_CONFIG.TRAY_ICON_CLIPBOARD_INDICATOR.getEventSender().addListener(this.clipboardToggle, false);
        new EDTRunner(){

            protected void runInEDT() {
                if (TrayMouseAdapter.this.listenerFlag.compareAndSet(false, true)) {
                    TrayMouseAdapter.this.trayIcon.addMouseListener((MouseListener)((Object)TrayMouseAdapter.this));
                    TrayMouseAdapter.this.trayIcon.addMouseMotionListener((MouseMotionListener)((Object)TrayMouseAdapter.this));
                    TrayMouseAdapter.this.trayIcon.setImage(TrayMouseAdapter.this.getCurrentTrayIconImage());
                }
            }
        };
    }

    protected Image getCurrentTrayIconImage() {
        if (CFG_GUI.CLIPBOARD_MONITORED.isEnabled() || !CFG_TRAY_CONFIG.TRAY_ICON_CLIPBOARD_INDICATOR.isEnabled()) {
            return this.image;
        }
        return IconIO.toImage((Icon)((Object)new BadgeIcon(new ImageIcon(this.image), NewTheme.I().getCheckBoxImage("clipboard", false, Math.max(8, this.image.getHeight(null) / 2), new Color(0xFF9393)), 4, 2)));
    }

    public void stopListener() {
        CFG_GUI.CLIPBOARD_MONITORED.getEventSender().removeListener(this.clipboardToggle);
        CFG_TRAY_CONFIG.TRAY_ICON_CLIPBOARD_INDICATOR.getEventSender().removeListener(this.clipboardToggle);
        new EDTRunner(){

            protected void runInEDT() {
                if (TrayMouseAdapter.this.listenerFlag.compareAndSet(true, false)) {
                    TrayMouseAdapter.this.trayIcon.removeMouseListener((MouseListener)((Object)TrayMouseAdapter.this));
                    TrayMouseAdapter.this.trayIcon.removeMouseMotionListener((MouseMotionListener)((Object)TrayMouseAdapter.this));
                    TrayMouseAdapter.this.trayIcon.setImage(TrayMouseAdapter.this.getCurrentTrayIconImage());
                }
            }
        };
    }

    public void mouseExited(MouseEvent e) {
        super.mouseExited(e);
        this.abortMouseLocationObserver();
    }

    public void abortMouseLocationObserver() {
        Thread localmouseLocationObserver = this.mouseLocationObserver;
        this.mouseLocationObserver = null;
        if (localmouseLocationObserver != null) {
            localmouseLocationObserver.interrupt();
        }
    }

    public void mousePressed(MouseEvent e) {
        super.mousePressed(e);
        this.abortMouseLocationObserver();
    }
}

